/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.SymbolNode;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyType;

final class FindersHelper {
    private static final String ATTRIBUTE_SEPARATOR_BASE = "_and";
    private static final String ATTRIBUTE_SEPARATOR = "_and_";
    private static final String FIND = "find";
    private static final String ALL = "all";
    private static final String[] STANDARD_FINDERS = new String[]{"all", "find"};
    private static final int THRESHOLD = 40;
    private static final int MAX_ITEMS = (int)Math.pow(40.0, 2.0);
    private final Collection<FinderType> prefixes;
    private final Collection<String> columns;
    private final String[] existingColumns;
    private final int maxDepth;

    private FindersHelper(Collection<FinderType> prefixes, List<String> existingColumns, Collection<String> columns) {
        this.prefixes = prefixes;
        this.columns = columns;
        this.existingColumns = existingColumns.toArray(new String[existingColumns.size()]);
        int size = columns.size();
        this.maxDepth = size > 40 ? 0 : 1;
    }

    static List<String> extractColumns(String method) {
        for (FinderType finder : FinderType.values()) {
            String prefix = finder.getPrefix();
            int prefixIdx = method.indexOf(prefix);
            if (prefixIdx == -1) continue;
            String woPrefix = method.substring(prefix.length());
            if (woPrefix.isEmpty()) {
                return Collections.emptyList();
            }
            if (woPrefix.endsWith(ATTRIBUTE_SEPARATOR_BASE)) {
                woPrefix = woPrefix.substring(0, woPrefix.length() - ATTRIBUTE_SEPARATOR_BASE.length());
            }
            return Arrays.asList(woPrefix.split(ATTRIBUTE_SEPARATOR));
        }
        return Collections.emptyList();
    }

    static List<FinderMethod> getFinderSignatures(String prefix, Collection<String> columns) {
        HashSet<String> columnsCopy = new HashSet<String>(columns);
        List<String> existingColumns = FindersHelper.extractColumns(prefix);
        if (!existingColumns.isEmpty()) {
            columnsCopy.removeAll(existingColumns);
        }
        FindersHelper helper = new FindersHelper(FindersHelper.matchingFinderPrefixes(prefix), existingColumns, columnsCopy);
        return helper.computeSignatures();
    }

    private static List<FinderType> matchingFinderPrefixes(String methodPrefix) {
        ArrayList<FinderType> result = new ArrayList<FinderType>(5);
        for (FinderType finder : FinderType.values()) {
            String finderPrefix = finder.getPrefix();
            if (methodPrefix.length() >= finderPrefix.length()) {
                if (!finderPrefix.startsWith(methodPrefix.substring(0, finderPrefix.length()))) continue;
                result.add(finder);
                continue;
            }
            if (!finderPrefix.startsWith(methodPrefix)) continue;
            result.add(finder);
        }
        return result;
    }

    private List<FinderMethod> computeSignatures() {
        HashSet<String> combinations = new HashSet<String>();
        String rootPrefix = this.concatenate(this.existingColumns);
        for (String baseColumn : this.columns) {
            String root = rootPrefix.isEmpty() ? baseColumn : this.concatenate(rootPrefix, baseColumn);
            combinations.add(root);
            HashSet<String> copy = new HashSet<String>(this.columns);
            copy.remove(baseColumn);
            this.addCombinations(root, copy, combinations, 0);
        }
        ArrayList<FinderMethod> result = new ArrayList<FinderMethod>(combinations.size());
        for (FinderType prefix : this.prefixes) {
            Iterator it = combinations.iterator();
            while (it.hasNext()) {
                result.add(new FinderMethod(prefix, (String)it.next()));
            }
        }
        Collections.sort(result);
        return result;
    }

    private void addCombinations(String root, Set<String> others, Set<String> result, int depth) {
        if (depth >= this.maxDepth || result.size() >= MAX_ITEMS) {
            return;
        }
        for (String o : others) {
            String base = this.concatenate(root, o);
            result.add(base);
            HashSet<String> rest = new HashSet<String>(others);
            rest.remove(o);
            this.addCombinations(base, rest, result, depth + 1);
        }
    }

    private String concatenate(String ... columns) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < columns.length; ++i) {
            String col = columns[i];
            result.append(col);
            if (i + 1 >= columns.length) continue;
            result.append(ATTRIBUTE_SEPARATOR);
        }
        return result.toString();
    }

    static int nextAttributeLocation(String finderMethodName, int fromIndex) {
        return finderMethodName.indexOf(ATTRIBUTE_SEPARATOR, fromIndex);
    }

    static String subToNextAttribute(String finderMethodName, int attributeSeparatorIndex) {
        return finderMethodName.substring(0, attributeSeparatorIndex + ATTRIBUTE_SEPARATOR.length() - 1);
    }

    static boolean isFinderMethod(String name) {
        return FindersHelper.isFinderMethod(name, true);
    }

    static boolean isFinderMethod(String name, boolean includeStandardFinders) {
        for (FinderType finderType : FinderType.values()) {
            if (!name.startsWith(finderType.getPrefix())) continue;
            return true;
        }
        if (includeStandardFinders) {
            for (String string : STANDARD_FINDERS) {
                if (!name.equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    static RubyType pickFinderType(Node call, String method, RubyType model) {
        boolean multiple = false;
        boolean foundMatching = false;
        for (FinderType finder : FinderType.values()) {
            if (!method.startsWith(finder.getPrefix())) continue;
            foundMatching = true;
            multiple = finder.isMultiple();
            break;
        }
        if (!foundMatching && method.equals(FIND)) {
            ArrayList<Node> nodes = new ArrayList<Node>();
            AstUtilities.addNodesByType(call, new NodeType[]{NodeType.SYMBOLNODE}, nodes);
            boolean foundAll = false;
            for (Node n : nodes) {
                SymbolNode symbol = (SymbolNode)n;
                if (!ALL.equals(symbol.getName())) continue;
                foundAll = true;
                break;
            }
            multiple = foundAll;
            foundMatching = true;
        } else if (!foundMatching && method.equals(ALL)) {
            multiple = true;
            foundMatching = true;
        } else if (!foundMatching) {
            multiple = false;
        }
        if (multiple) {
            return RubyType.ARRAY;
        }
        return model;
    }

    static class FinderMethod
    implements Comparable<FinderMethod> {
        private final FinderType finder;
        private final String attributes;

        public FinderMethod(FinderType prefix, String attributes) {
            this.finder = prefix;
            this.attributes = attributes;
        }

        public String getName() {
            return this.finder.getPrefix() + this.attributes;
        }

        public String getSignature() {
            StringBuilder result = new StringBuilder(this.finder.getPrefix() + this.attributes + "(");
            String[] params = this.attributes.split(FindersHelper.ATTRIBUTE_SEPARATOR);
            for (int i = 0; i < params.length; ++i) {
                String param = params[i];
                result.append(param);
                if (i >= params.length - 1) continue;
                result.append(", ");
            }
            if (this.finder.hasOptions()) {
                result.append(", *options");
            }
            result.append(")");
            return result.toString();
        }

        public String getColumn() {
            int andIndex = this.attributes.indexOf(FindersHelper.ATTRIBUTE_SEPARATOR);
            if (andIndex == -1) {
                return this.attributes;
            }
            return this.attributes.substring(0, andIndex);
        }

        @Override
        public int compareTo(FinderMethod o) {
            return this.getName().compareTo(o.getName());
        }

        public String toString() {
            return FinderMethod.class.getSimpleName() + "[name: " + this.getName() + "]";
        }
    }

    private static enum FinderType {
        FIND_BY("find_by_"){

            @Override
            boolean isMultiple() {
                return false;
            }
        }
        ,
        FIND_ALL_BY("find_all_by_"){

            @Override
            boolean isMultiple() {
                return true;
            }
        }
        ,
        FIND_LAST_BY("find_last_by_"){

            @Override
            boolean isMultiple() {
                return false;
            }
        }
        ,
        SCOPED_BY("scoped_by_"){

            @Override
            boolean isMultiple() {
                return true;
            }

            @Override
            boolean hasOptions() {
                return false;
            }
        };

        private final String prefix;

        private FinderType(String prefix) {
            this.prefix = prefix;
        }

        abstract boolean isMultiple();

        String getPrefix() {
            return this.prefix;
        }

        boolean hasOptions() {
            return true;
        }
    }
}

