/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.web.wizards.FilterMappingData;
import org.netbeans.modules.web.wizards.ServletData;

class AnnotationGenerator {
    private static final String TRUE = "true";
    private static final String CLASS_ANNOTATION = "classAnnotation";
    private static final String INCL_INIT_PARAMS = "includeInitParams";
    private static final String INCL_DISPATCHER = "includeDispatcher";

    private AnnotationGenerator() {
    }

    static String webServlet(ServletData servletData, Map<String, String> map) {
        String string = AnnotationGenerator.generInitParams(servletData.getInitParams());
        if (string != null) {
            map.put(INCL_INIT_PARAMS, TRUE);
        }
        String string2 = "@WebServlet(" + AnnotationGenerator.join(AnnotationGenerator.generServletName(servletData.getName()), AnnotationGenerator.generUrlPatterns(servletData.getUrlMappings()), string) + ")";
        map.put(CLASS_ANNOTATION, string2);
        return string2;
    }

    private static String generServletName(String string) {
        return string == null || string.length() < 1 ? null : "name=\"" + string + "\"";
    }

    private static String generUrlPatterns(String[] stringArray) {
        if (stringArray == null || stringArray.length <= 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            arrayList.add(string);
        }
        return AnnotationGenerator.list("urlPatterns", arrayList);
    }

    private static String generInitParams(String[][] stringArray) {
        if (stringArray == null || stringArray.length <= 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String[] stringArray2 : stringArray) {
            arrayList.add("@WebInitParam(name=\"" + stringArray2[0] + "\", value=\"" + stringArray2[1] + "\")");
        }
        return AnnotationGenerator.list2("initParams", arrayList);
    }

    static String webFilter(ServletData servletData, Map<String, String> map) {
        String string = AnnotationGenerator.generInitParams(servletData.getInitParams());
        if (string != null) {
            map.put(INCL_INIT_PARAMS, TRUE);
        }
        String string2 = "@WebFilter(" + AnnotationGenerator.join(AnnotationGenerator.generFilterName(servletData.getName()), AnnotationGenerator.generMappings(servletData.getName(), servletData.getFilterMappings(), map), string) + ")";
        map.put(CLASS_ANNOTATION, string2);
        return string2;
    }

    private static String generFilterName(String string) {
        return string == null || string.length() < 1 ? null : "filterName=\"" + string + "\"";
    }

    private static String generMappings(String string, List<FilterMappingData> list, Map<String, String> map) {
        FilterMappingData filterMappingData;
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Iterator<FilterMappingData> iterator = list.iterator();
        while (iterator.hasNext()) {
            filterMappingData = iterator.next();
            if (!filterMappingData.getName().equals(string)) continue;
            if (filterMappingData.getType() == FilterMappingData.Type.URL) {
                arrayList.add(filterMappingData.getPattern());
            } else if (filterMappingData.getType() == FilterMappingData.Type.SERVLET) {
                arrayList2.add(filterMappingData.getPattern());
            }
            for (FilterMappingData.Dispatcher dispatcher : filterMappingData.getDispatcher()) {
                if (dispatcher == FilterMappingData.Dispatcher.BLANK) continue;
                hashSet.add(dispatcher.toString());
            }
        }
        Iterator<FilterMappingData> iterator2 = iterator = hashSet.isEmpty() ? null : "dispatcherTypes={" + AnnotationGenerator.join(hashSet, "DispatcherType.", "") + "}";
        if (iterator != null) {
            map.put(INCL_DISPATCHER, TRUE);
        }
        filterMappingData = arrayList.isEmpty() ? null : AnnotationGenerator.list("urlPatterns", arrayList);
        FilterMappingData.Dispatcher[] dispatcherArray = arrayList2.isEmpty() ? null : AnnotationGenerator.list("servletNames", arrayList2);
        return AnnotationGenerator.join(new String[]{filterMappingData, dispatcherArray, iterator});
    }

    static String webListener() {
        return "@WebListener()";
    }

    private static String join(String ... stringArray) {
        boolean bl = true;
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            if (string == null || string.length() < 1) continue;
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string);
            bl = false;
        }
        return stringBuilder.toString();
    }

    private static String join(Collection<String> collection, String string, String string2) {
        boolean bl = true;
        StringBuilder stringBuilder = new StringBuilder();
        for (String string3 : collection) {
            if (string3 == null || string3.length() < 1) continue;
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string);
            stringBuilder.append(string3);
            stringBuilder.append(string2);
            bl = false;
        }
        return stringBuilder.toString();
    }

    private static String list(String string, List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append("={");
        stringBuilder.append(AnnotationGenerator.join(list, "\"", "\""));
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private static String list2(String string, List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append("={");
        stringBuilder.append(AnnotationGenerator.join(list, "", ""));
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

