/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.AnnotationValueHandler;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.ArrayValueHandler;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.DefaultProvider;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.ParseResult;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.ValueProvider;
import org.openide.util.Parameters;

public final class AnnotationParser {
    private static final Set<Class<?>> PRIMITIVE_WRAPPERS = new HashSet();
    private final Map<String, ValueProvider> providers = new HashMap<String, ValueProvider>();
    private final AnnotationModelHelper helper;

    public static DefaultProvider defaultValue(Object object) {
        return new DefaultProviderImpl(object);
    }

    public static AnnotationParser create(AnnotationModelHelper annotationModelHelper) {
        Parameters.notNull((CharSequence)"helper", (Object)annotationModelHelper);
        return new AnnotationParser(annotationModelHelper);
    }

    private AnnotationParser(AnnotationModelHelper annotationModelHelper) {
        this.helper = annotationModelHelper;
    }

    public <T> void expectPrimitive(String string, Class<T> clazz, DefaultProvider defaultProvider) {
        Parameters.notNull((CharSequence)"name", (Object)string);
        Parameters.notNull((CharSequence)"type", clazz);
        if (!PRIMITIVE_WRAPPERS.contains(clazz)) {
            throw new IllegalArgumentException(clazz + " is not a primitive wrapper class");
        }
        this.addProvider(string, new PrimitiveValueProvider(clazz, defaultProvider));
    }

    public void expectString(String string, DefaultProvider defaultProvider) {
        Parameters.notNull((CharSequence)"name", (Object)string);
        this.addProvider(string, new PrimitiveValueProvider(String.class, defaultProvider));
    }

    public void expectClass(String string, DefaultProvider defaultProvider) {
        Parameters.notNull((CharSequence)"name", (Object)string);
        this.addProvider(string, new ClassValueProvider(defaultProvider));
    }

    public void expectEnumConstant(String string, TypeMirror typeMirror, DefaultProvider defaultProvider) {
        Parameters.notNull((CharSequence)"name", (Object)string);
        Parameters.notNull((CharSequence)"enumType", (Object)typeMirror);
        this.addProvider(string, new EnumConstantValueProvider(typeMirror, defaultProvider));
    }

    public void expectAnnotation(String string, TypeMirror typeMirror, AnnotationValueHandler annotationValueHandler, DefaultProvider defaultProvider) {
        Parameters.notNull((CharSequence)"name", (Object)string);
        Parameters.notNull((CharSequence)"annotationType", (Object)typeMirror);
        Parameters.notNull((CharSequence)"handler", (Object)annotationValueHandler);
        this.addProvider(string, new AnnotationValueProvider(typeMirror, annotationValueHandler, defaultProvider));
    }

    public void expectPrimitiveArray(String string, Class<?> clazz, ArrayValueHandler arrayValueHandler, DefaultProvider defaultProvider) {
        Parameters.notNull((CharSequence)"name", (Object)string);
        Parameters.notNull((CharSequence)"type", clazz);
        Parameters.notNull((CharSequence)"handler", (Object)arrayValueHandler);
        this.addProvider(string, new PrimitiveArrayValueProvider(clazz, arrayValueHandler, defaultProvider));
    }

    public void expectStringArray(String string, ArrayValueHandler arrayValueHandler, DefaultProvider defaultProvider) {
        Parameters.notNull((CharSequence)"name", (Object)string);
        Parameters.notNull((CharSequence)"handler", (Object)arrayValueHandler);
        this.addProvider(string, new PrimitiveArrayValueProvider(String.class, arrayValueHandler, defaultProvider));
    }

    public void expectClassArray(String string, ArrayValueHandler arrayValueHandler, DefaultProvider defaultProvider) {
        Parameters.notNull((CharSequence)"name", (Object)string);
        Parameters.notNull((CharSequence)"handler", (Object)arrayValueHandler);
        this.addProvider(string, new ClassArrayValueProvider(arrayValueHandler, defaultProvider));
    }

    public void expectEnumConstantArray(String string, TypeMirror typeMirror, ArrayValueHandler arrayValueHandler, DefaultProvider defaultProvider) {
        Parameters.notNull((CharSequence)"name", (Object)string);
        Parameters.notNull((CharSequence)"enumType", (Object)typeMirror);
        Parameters.notNull((CharSequence)"handler", (Object)arrayValueHandler);
        this.addProvider(string, new EnumConstantArrayValueProvider(typeMirror, arrayValueHandler, defaultProvider));
    }

    public void expectAnnotationArray(String string, TypeMirror typeMirror, ArrayValueHandler arrayValueHandler, DefaultProvider defaultProvider) {
        Parameters.notNull((CharSequence)"name", (Object)string);
        Parameters.notNull((CharSequence)"annotationType", (Object)typeMirror);
        Parameters.notNull((CharSequence)"handler", (Object)arrayValueHandler);
        this.addProvider(string, new AnnotationArrayValueProvider(typeMirror, arrayValueHandler, defaultProvider));
    }

    public void expect(String string, ValueProvider valueProvider) {
        Parameters.notNull((CharSequence)"name", (Object)string);
        this.addProvider(string, valueProvider);
    }

    public ParseResult parse(AnnotationMirror annotationMirror) {
        Object object;
        Object object2;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (annotationMirror != null) {
            for (Map.Entry<Object, Object> entry : annotationMirror.getElementValues().entrySet()) {
                Object object3;
                object2 = (ExecutableElement)entry.getKey();
                object = object2.getSimpleName().toString();
                ValueProvider valueProvider = this.providers.get(object);
                if (valueProvider == null || (object3 = valueProvider.getValue((AnnotationValue)entry.getValue())) == null) continue;
                hashMap.put((String)object, object3);
            }
        }
        for (Map.Entry<Object, Object> entry : this.providers.entrySet()) {
            object2 = (String)entry.getKey();
            if (hashMap.containsKey(object2) || (object = ((ValueProvider)entry.getValue()).getDefaultValue()) == null) continue;
            hashMap.put((String)object2, object);
        }
        return new ParseResult(hashMap);
    }

    private void addProvider(String string, ValueProvider valueProvider) {
        if (this.providers.containsKey(string)) {
            throw new IllegalArgumentException("There is already a provider for element name '" + string + "'");
        }
        this.providers.put(string, valueProvider);
    }

    static {
        PRIMITIVE_WRAPPERS.add(Boolean.class);
        PRIMITIVE_WRAPPERS.add(Byte.class);
        PRIMITIVE_WRAPPERS.add(Short.class);
        PRIMITIVE_WRAPPERS.add(Integer.class);
        PRIMITIVE_WRAPPERS.add(Long.class);
        PRIMITIVE_WRAPPERS.add(Character.class);
        PRIMITIVE_WRAPPERS.add(Float.class);
        PRIMITIVE_WRAPPERS.add(Double.class);
    }

    private final class AnnotationArrayValueProvider
    extends TypeCheckingArrayValueProvider {
        public AnnotationArrayValueProvider(TypeMirror typeMirror, ArrayValueHandler arrayValueHandler, DefaultProvider defaultProvider) {
            super(typeMirror, arrayValueHandler, defaultProvider);
        }

        @Override
        protected boolean checkMembers(List<AnnotationValue> list) {
            for (AnnotationValue annotationValue : list) {
                Object object = annotationValue.getValue();
                if (!(object instanceof AnnotationMirror)) {
                    return false;
                }
                AnnotationMirror annotationMirror = (AnnotationMirror)object;
                if (this.isSameAsTypeToCheck(annotationMirror.getAnnotationType())) continue;
                return false;
            }
            return true;
        }
    }

    private final class EnumConstantArrayValueProvider
    extends TypeCheckingArrayValueProvider {
        public EnumConstantArrayValueProvider(TypeMirror typeMirror, ArrayValueHandler arrayValueHandler, DefaultProvider defaultProvider) {
            super(typeMirror, arrayValueHandler, defaultProvider);
        }

        @Override
        protected boolean checkMembers(List<AnnotationValue> list) {
            for (AnnotationValue annotationValue : list) {
                Object object = annotationValue.getValue();
                if (!(object instanceof VariableElement)) {
                    return false;
                }
                VariableElement variableElement = (VariableElement)object;
                TypeMirror typeMirror = variableElement.getEnclosingElement().asType();
                if (this.isSameAsTypeToCheck(typeMirror)) continue;
                return false;
            }
            return true;
        }
    }

    private final class ClassArrayValueProvider
    extends DefaultArrayValueProvider {
        public ClassArrayValueProvider(ArrayValueHandler arrayValueHandler, DefaultProvider defaultProvider) {
            super(arrayValueHandler, defaultProvider);
        }

        @Override
        protected boolean checkMembers(List<AnnotationValue> list) {
            for (AnnotationValue annotationValue : list) {
                Object object = annotationValue.getValue();
                if (!(object instanceof TypeMirror)) {
                    return false;
                }
                TypeMirror typeMirror = (TypeMirror)object;
                if (TypeKind.DECLARED.equals((Object)typeMirror.getKind())) continue;
                return false;
            }
            return true;
        }
    }

    private final class PrimitiveArrayValueProvider
    extends DefaultArrayValueProvider {
        private final Class<?> type;

        public PrimitiveArrayValueProvider(Class<?> clazz, ArrayValueHandler arrayValueHandler, DefaultProvider defaultProvider) {
            super(arrayValueHandler, defaultProvider);
            this.type = clazz;
        }

        @Override
        protected boolean checkMembers(List<AnnotationValue> list) {
            for (AnnotationValue annotationValue : list) {
                Object object = annotationValue.getValue();
                if (this.type.isInstance(object)) continue;
                return false;
            }
            return true;
        }
    }

    private final class AnnotationValueProvider
    extends TypeCheckingValueProvider {
        private final AnnotationValueHandler handler;

        public AnnotationValueProvider(TypeMirror typeMirror, AnnotationValueHandler annotationValueHandler, DefaultProvider defaultProvider) {
            super(typeMirror, defaultProvider);
            this.handler = annotationValueHandler;
        }

        @Override
        public Object getValue(AnnotationValue annotationValue) {
            Object object;
            AnnotationMirror annotationMirror;
            Object object2 = annotationValue.getValue();
            if (object2 instanceof AnnotationMirror && this.isSameAsTypeToCheck((annotationMirror = (AnnotationMirror)object2).getAnnotationType()) && (object = this.handler.handleAnnotation(annotationMirror)) != null) {
                return object;
            }
            return this.getDefaultValue();
        }
    }

    private final class EnumConstantValueProvider
    extends TypeCheckingValueProvider {
        public EnumConstantValueProvider(TypeMirror typeMirror, DefaultProvider defaultProvider) {
            super(typeMirror, defaultProvider);
        }

        @Override
        public Object getValue(AnnotationValue annotationValue) {
            VariableElement variableElement;
            TypeMirror typeMirror;
            Object object = annotationValue.getValue();
            if (object instanceof VariableElement && this.isSameAsTypeToCheck(typeMirror = (variableElement = (VariableElement)object).getEnclosingElement().asType())) {
                return variableElement.getSimpleName().toString();
            }
            return this.getDefaultValue();
        }
    }

    private final class ClassValueProvider
    extends DefaultValueProvider {
        public ClassValueProvider(DefaultProvider defaultProvider) {
            super(defaultProvider);
        }

        @Override
        public Object getValue(AnnotationValue annotationValue) {
            TypeMirror typeMirror;
            Object object = annotationValue.getValue();
            if (object instanceof TypeMirror && TypeKind.DECLARED.equals((Object)(typeMirror = (TypeMirror)object).getKind())) {
                return ((TypeElement)((DeclaredType)object).asElement()).getQualifiedName().toString();
            }
            return this.getDefaultValue();
        }
    }

    private class PrimitiveValueProvider
    extends DefaultValueProvider {
        private final Class<?> type;

        public PrimitiveValueProvider(Class<?> clazz, DefaultProvider defaultProvider) {
            super(defaultProvider);
            this.type = clazz;
        }

        @Override
        public Object getValue(AnnotationValue annotationValue) {
            Object object = annotationValue.getValue();
            if (this.type.isInstance(object)) {
                return object;
            }
            return this.getDefaultValue();
        }
    }

    private abstract class TypeCheckingArrayValueProvider
    extends TypeCheckingValueProvider {
        private final ArrayValueHandler handler;

        public TypeCheckingArrayValueProvider(TypeMirror typeMirror, ArrayValueHandler arrayValueHandler, DefaultProvider defaultProvider) {
            super(typeMirror, defaultProvider);
            this.handler = arrayValueHandler;
        }

        @Override
        public Object getValue(AnnotationValue annotationValue) {
            Object object;
            List list;
            Object object2 = annotationValue.getValue();
            if (object2 instanceof List && this.checkMembers(list = (List)object2) && (object = this.handler.handleArray(list)) != null) {
                return object;
            }
            return this.getDefaultValue();
        }

        protected abstract boolean checkMembers(List<AnnotationValue> var1);
    }

    private abstract class DefaultArrayValueProvider
    extends DefaultValueProvider {
        private final ArrayValueHandler handler;

        public DefaultArrayValueProvider(ArrayValueHandler arrayValueHandler, DefaultProvider defaultProvider) {
            super(defaultProvider);
            this.handler = arrayValueHandler;
        }

        @Override
        public Object getValue(AnnotationValue annotationValue) {
            Object object;
            List list;
            Object object2 = annotationValue.getValue();
            if (object2 instanceof List && this.checkMembers(list = (List)object2) && (object = this.handler.handleArray(list)) != null) {
                return object;
            }
            return this.getDefaultValue();
        }

        protected abstract boolean checkMembers(List<AnnotationValue> var1);
    }

    private abstract class TypeCheckingValueProvider
    extends DefaultValueProvider {
        private final TypeMirror typeToCheck;

        public TypeCheckingValueProvider(TypeMirror typeMirror, DefaultProvider defaultProvider) {
            super(defaultProvider);
            this.typeToCheck = typeMirror;
        }

        protected boolean isSameAsTypeToCheck(TypeMirror typeMirror) {
            return AnnotationParser.this.helper.getCompilationController().getTypes().isSameType(this.typeToCheck, typeMirror);
        }
    }

    private abstract class DefaultValueProvider
    implements ValueProvider {
        private final DefaultProvider defaultProvider;

        public DefaultValueProvider(DefaultProvider defaultProvider) {
            this.defaultProvider = defaultProvider;
        }

        @Override
        public Object getDefaultValue() {
            return this.defaultProvider != null ? this.defaultProvider.getDefaultValue() : null;
        }
    }

    private static final class DefaultProviderImpl
    implements DefaultProvider {
        private final Object defaultValue;

        public DefaultProviderImpl(Object object) {
            this.defaultValue = object;
        }

        @Override
        public Object getDefaultValue() {
            return this.defaultValue;
        }
    }
}

