/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib.drawing;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.View;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.editor.AtomicLockEvent;
import org.netbeans.editor.AtomicLockListener;
import org.netbeans.editor.BaseCaret;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.view.spi.LockView;
import org.netbeans.modules.editor.lib.drawing.ColoringAccessor;
import org.netbeans.modules.editor.lib.drawing.DrawContext;
import org.netbeans.modules.editor.lib.drawing.DrawEngineLineView;
import org.netbeans.modules.editor.lib.drawing.DrawLayer;
import org.netbeans.modules.editor.lib.drawing.DrawLayerList;
import org.netbeans.modules.editor.lib.drawing.DrawMark;
import org.netbeans.modules.editor.lib.drawing.EditorUiAccessor;
import org.netbeans.modules.editor.lib2.highlighting.HighlightingManager;
import org.netbeans.modules.editor.lib2.highlighting.HighlightingSpiPackageAccessor;
import org.netbeans.modules.editor.lib2.highlighting.HighlightsLayerAccessor;
import org.netbeans.modules.editor.lib2.highlighting.HighlightsLayerFilter;
import org.netbeans.modules.editor.lib2.highlighting.HighlightsSequenceEx;
import org.netbeans.spi.editor.highlighting.HighlightsChangeEvent;
import org.netbeans.spi.editor.highlighting.HighlightsChangeListener;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.netbeans.spi.editor.highlighting.HighlightsLayer;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.ZOrder;
import org.openide.util.WeakListeners;

public final class HighlightingDrawLayer
extends DrawLayer.AbstractLayer
implements HighlightsChangeListener,
AtomicLockListener {
    private static final Logger LOG = Logger.getLogger(HighlightingDrawLayer.class.getName());
    private static final String LAYER_A_NAME = "org-netbeans-lib-editor-nview-HighlightingDrawLayer/A";
    private static final String LAYER_B_NAME = "org-netbeans-lib-editor-nview-HighlightingDrawLayer/B";
    private static final String LAYER_C_NAME = "org-netbeans-lib-editor-nview-HighlightingDrawLayer/C";
    private static final String LAYER_D_NAME = "org-netbeans-lib-editor-nview-HighlightingDrawLayer/D";
    private static final HighlightsLayerFilter FILTER_A = new HighlightsLayerFilter(){

        public List<? extends HighlightsLayer> filterLayers(List<? extends HighlightsLayer> layers) {
            ArrayList<HighlightsLayer> filteredLayers = new ArrayList<HighlightsLayer>();
            boolean add = false;
            for (HighlightsLayer highlightsLayer : layers) {
                HighlightsLayerAccessor layerAccessor = HighlightingSpiPackageAccessor.get().getHighlightsLayerAccessor(highlightsLayer);
                if ("org.netbeans.modules.editor.lib2.highlighting.CaretRowHighlighting".equals(layerAccessor.getLayerTypeId())) {
                    add = true;
                    continue;
                }
                if (!add) continue;
                filteredLayers.add(highlightsLayer);
            }
            return filteredLayers;
        }
    };
    private static final HighlightsLayerFilter FILTER_B = new HighlightsLayerFilter(){

        public List<? extends HighlightsLayer> filterLayers(List<? extends HighlightsLayer> layers) {
            ArrayList<HighlightsLayer> filteredLayers = new ArrayList<HighlightsLayer>();
            int syntaxRack = HighlightingSpiPackageAccessor.get().getZOrderRack(ZOrder.SYNTAX_RACK);
            for (HighlightsLayer highlightsLayer : layers) {
                HighlightsLayerAccessor layerAccessor = HighlightingSpiPackageAccessor.get().getHighlightsLayerAccessor(highlightsLayer);
                if (HighlightingSpiPackageAccessor.get().getZOrderRack(layerAccessor.getZOrder()) > syntaxRack) {
                    filteredLayers.add(highlightsLayer);
                }
                if (!"org.netbeans.modules.editor.lib2.highlighting.CaretRowHighlighting".equals(layerAccessor.getLayerTypeId())) continue;
                break;
            }
            return filteredLayers;
        }
    };
    private static final HighlightsLayerFilter FILTER_C = new HighlightsLayerFilter(){

        public List<? extends HighlightsLayer> filterLayers(List<? extends HighlightsLayer> layers) {
            ArrayList<HighlightsLayer> filteredLayers = new ArrayList<HighlightsLayer>();
            int syntaxRack = HighlightingSpiPackageAccessor.get().getZOrderRack(ZOrder.SYNTAX_RACK);
            for (HighlightsLayer highlightsLayer : layers) {
                HighlightsLayerAccessor layerAccessor = HighlightingSpiPackageAccessor.get().getHighlightsLayerAccessor(highlightsLayer);
                if (HighlightingSpiPackageAccessor.get().getZOrderRack(layerAccessor.getZOrder()) < syntaxRack) continue;
                if (HighlightingSpiPackageAccessor.get().getZOrderRack(layerAccessor.getZOrder()) != syntaxRack) break;
                filteredLayers.add(highlightsLayer);
            }
            return filteredLayers;
        }
    };
    private static final HighlightsLayerFilter FILTER_D = new HighlightsLayerFilter(){

        public List<? extends HighlightsLayer> filterLayers(List<? extends HighlightsLayer> layers) {
            ArrayList<HighlightsLayer> filteredLayers = new ArrayList<HighlightsLayer>();
            int syntaxRack = HighlightingSpiPackageAccessor.get().getZOrderRack(ZOrder.SYNTAX_RACK);
            for (HighlightsLayer highlightsLayer : layers) {
                HighlightsLayerAccessor layerAccessor = HighlightingSpiPackageAccessor.get().getHighlightsLayerAccessor(highlightsLayer);
                if (HighlightingSpiPackageAccessor.get().getZOrderRack(layerAccessor.getZOrder()) == syntaxRack) break;
                filteredLayers.add(highlightsLayer);
            }
            return filteredLayers;
        }
    };
    private final HighlightsLayerFilter filter;
    private WeakReference<JTextComponent> paneRef = null;
    private HighlightsContainer highlights = null;
    private HighlightsSequence sequence = null;
    private int sequenceEnd = -1;
    private AttributeSet lastAttributeSet = null;
    private AttributeSet lastEOLAttribs = null;
    private AttributeSet lastELAttribs = null;
    private boolean theLittleSpitAtTheBeginningOfAnEmptyLineDrawn = false;
    private int lastLineIndex;
    private boolean atomicLockListeningResolved;
    private boolean inAtomicLock;
    private Position damageStartPos;
    private Position damageEndPos;

    public static void hookUp(EditorUI eui) {
        DrawLayer layerD;
        DrawLayer layerC;
        DrawLayer layerB;
        DrawLayerList dll = EditorUiAccessor.get().getDrawLayerList(eui);
        JTextComponent jtc = eui.getComponent();
        DrawLayer layerA = dll.findLayer(LAYER_A_NAME);
        if (layerA == null) {
            layerA = new HighlightingDrawLayer(LAYER_A_NAME, FILTER_A);
            dll.add(layerA, 10000);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Successfully registered layerA in " + HighlightingDrawLayer.simpleToString(jtc));
            }
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("LayerA is already registered in " + HighlightingDrawLayer.simpleToString(jtc));
        }
        if ((layerB = dll.findLayer(LAYER_B_NAME)) == null) {
            layerB = new HighlightingDrawLayer(LAYER_B_NAME, FILTER_B);
            dll.add(layerB, 2050);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Successfully registered layerB in " + HighlightingDrawLayer.simpleToString(jtc));
            }
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("LayerB is already registered in " + HighlightingDrawLayer.simpleToString(jtc));
        }
        if ((layerC = dll.findLayer(LAYER_C_NAME)) == null) {
            layerC = new HighlightingDrawLayer(LAYER_C_NAME, FILTER_C);
            dll.add(layerC, 1000);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Successfully registered layerC in " + HighlightingDrawLayer.simpleToString(jtc));
            }
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("LayerC is already registered in " + HighlightingDrawLayer.simpleToString(jtc));
        }
        if ((layerD = dll.findLayer(LAYER_D_NAME)) == null) {
            layerD = new HighlightingDrawLayer(LAYER_D_NAME, FILTER_D);
            dll.add(layerD, 500);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Successfully registered layerD in " + HighlightingDrawLayer.simpleToString(jtc));
            }
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("LayerD is already registered in " + HighlightingDrawLayer.simpleToString(jtc));
        }
    }

    private HighlightingDrawLayer(String name, HighlightsLayerFilter filter) {
        super(name);
        this.filter = filter;
    }

    @Override
    public void init(DrawContext ctx) {
        super.init(ctx);
        if (this.highlights == null) {
            JTextComponent pane = ctx.getEditorUI().getComponent();
            if (pane == null) {
                BaseDocument doc = ctx.getEditorUI().getDocument();
                if (doc == null) {
                    return;
                }
                String mimeType = (String)doc.getProperty("mimeType");
                assert (mimeType != null) : "Document's mime type can't be null: " + doc;
                JEditorPane fakePane = new JEditorPane();
                fakePane.setDocument(doc);
                fakePane.putClientProperty("HighlightsLayerIncludes", new String[]{"^.*NonLexerSyntaxHighlighting$", "^.*SyntaxHighlighting$"});
                pane = fakePane;
            }
            this.paneRef = new WeakReference<JTextComponent>(pane);
            HighlightingManager hm = HighlightingManager.getInstance();
            this.highlights = hm.getHighlights(pane, this.filter);
            this.highlights.addHighlightsChangeListener((HighlightsChangeListener)this);
            if (LOG.isLoggable(Level.FINE)) {
                if (this.filter == FILTER_A) {
                    LOG.fine("CHC@" + Integer.toHexString(System.identityHashCode(this.highlights)) + " is for FILTER_A");
                } else if (this.filter == FILTER_B) {
                    LOG.fine("CHC@" + Integer.toHexString(System.identityHashCode(this.highlights)) + " is for FILTER_B");
                } else if (this.filter == FILTER_C) {
                    LOG.fine("CHC@" + Integer.toHexString(System.identityHashCode(this.highlights)) + " is for FILTER_C");
                }
            }
        }
        this.lastAttributeSet = null;
        this.lastEOLAttribs = null;
        this.lastELAttribs = null;
        this.theLittleSpitAtTheBeginningOfAnEmptyLineDrawn = false;
        if (!this.atomicLockListeningResolved) {
            this.atomicLockListeningResolved = true;
            BaseDocument doc = ctx.getEditorUI().getDocument();
            doc.addAtomicLockListener((AtomicLockListener)WeakListeners.create(AtomicLockListener.class, (EventListener)this, (Object)doc));
        }
    }

    @Override
    public boolean isActive(DrawContext ctx, DrawMark mark) {
        if (this.highlights != null) {
            return this.processOffset(ctx, false);
        }
        return false;
    }

    @Override
    public void updateContext(DrawContext ctx) {
        if (this.highlights != null) {
            ColoringAccessor accessor = ColoringAccessor.get();
            if (ctx.isEOL() && ctx.isBOL()) {
                if (this.extendsEmptyLine() && !this.theLittleSpitAtTheBeginningOfAnEmptyLineDrawn) {
                    this.theLittleSpitAtTheBeginningOfAnEmptyLineDrawn = true;
                    Coloring coloring = Coloring.fromAttributeSet(this.lastELAttribs);
                    accessor.apply(coloring, ctx);
                } else if (this.extendsEOL()) {
                    Coloring coloring = Coloring.fromAttributeSet(this.lastEOLAttribs);
                    accessor.apply(coloring, ctx);
                }
            } else if (ctx.isEOL()) {
                if (this.extendsEOL()) {
                    Coloring coloring = Coloring.fromAttributeSet(this.lastEOLAttribs);
                    accessor.apply(coloring, ctx);
                }
            } else {
                this.processOffset(ctx, true);
            }
        }
    }

    @Override
    public boolean extendsEOL() {
        boolean b;
        if (this.lastEOLAttribs == null && this.lastAttributeSet != null) {
            List<AttributeSet> allSets = (List<AttributeSet>)this.lastAttributeSet.getAttribute("dismantled-structure");
            AttributeSet[] arr = this.filter(allSets != null ? allSets : Collections.singletonList(this.lastAttributeSet));
            this.lastEOLAttribs = arr[0];
            this.lastELAttribs = arr[1];
        }
        boolean bl = b = this.lastEOLAttribs != null && this.lastEOLAttribs != SimpleAttributeSet.EMPTY;
        if (LOG.isLoggable(Level.FINE) && this.filter == FILTER_A) {
            LOG.fine(HighlightingDrawLayer.simpleToString(this) + ".extendsEOL = " + b);
        }
        return b;
    }

    @Override
    public boolean extendsEmptyLine() {
        boolean b;
        if (this.lastELAttribs == null && this.lastAttributeSet != null) {
            List<AttributeSet> allSets = (List<AttributeSet>)this.lastAttributeSet.getAttribute("dismantled-structure");
            AttributeSet[] arr = this.filter(allSets != null ? allSets : Collections.singletonList(this.lastAttributeSet));
            this.lastEOLAttribs = arr[0];
            this.lastELAttribs = arr[1];
        }
        boolean bl = b = this.lastELAttribs != null && this.lastELAttribs != SimpleAttributeSet.EMPTY;
        if (LOG.isLoggable(Level.FINE) && this.filter == FILTER_A) {
            LOG.fine(HighlightingDrawLayer.simpleToString(this) + ".extendsEmptyLine = " + b);
        }
        return b;
    }

    public void highlightChanged(HighlightsChangeEvent event) {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("BRIDGE-LAYER: changed area [" + event.getStartOffset() + ", " + event.getEndOffset() + "]");
        }
        if (event.getStartOffset() == event.getEndOffset()) {
            return;
        }
        if (this.inAtomicLock) {
            Document doc;
            JTextComponent pane = (JTextComponent)this.paneRef.get();
            if (pane != null && (doc = pane.getDocument()) != null) {
                int startOffset = Math.max(0, Math.min(event.getStartOffset(), doc.getLength()));
                int endOffset = Math.max(startOffset, Math.min(event.getEndOffset(), doc.getLength()));
                try {
                    if (this.damageStartPos == null) {
                        this.damageStartPos = doc.createPosition(startOffset);
                    }
                    if (this.damageEndPos == null) {
                        this.damageEndPos = doc.createPosition(endOffset);
                    }
                    if (startOffset < this.damageStartPos.getOffset()) {
                        this.damageStartPos = doc.createPosition(startOffset);
                    }
                    if (endOffset > this.damageEndPos.getOffset()) {
                        this.damageEndPos = doc.createPosition(endOffset);
                    }
                }
                catch (BadLocationException e) {
                    LOG.log(Level.WARNING, "Cannot set damaged range", e);
                    this.damageStartPos = null;
                    this.damageEndPos = null;
                }
            }
            if (LOG.isLoggable(Level.FINE) && this.damageStartPos != null && this.damageEndPos != null) {
                LOG.fine("highlightsChangeEvent: [" + event.getStartOffset() + ", " + event.getEndOffset() + "], toDAMAGE: [" + this.damageStartPos.getOffset() + ", " + this.damageEndPos.getOffset() + "]\n");
            }
            return;
        }
        this.invokeDamageRange(event.getStartOffset(), event.getEndOffset());
    }

    private void invokeDamageRange(final int startOffset, final int endOffset) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block11: {
                    Document d;
                    HighlightingDrawLayer.this.setNextActivityChangeOffset(0);
                    JTextComponent pane = (JTextComponent)HighlightingDrawLayer.this.paneRef.get();
                    if (pane != null && (d = pane.getDocument()) instanceof AbstractDocument) {
                        AbstractDocument doc = (AbstractDocument)d;
                        doc.readLock();
                        try {
                            int rangeStart;
                            int rangeEnd = Math.min(endOffset, pane.getDocument().getLength() + 1);
                            int n = rangeStart = startOffset >= rangeEnd ? 0 : startOffset;
                            if (rangeStart >= rangeEnd) break block11;
                            try {
                                if (LOG.isLoggable(Level.FINE)) {
                                    LOG.fine("DamageRange: [" + rangeStart + ", " + rangeEnd + "]\n");
                                }
                                pane.getUI().damageRange(pane, rangeStart, rangeEnd);
                            }
                            catch (Exception e) {
                                LOG.log(Level.INFO, "Can't update view: range = [" + rangeStart + ", " + rangeEnd + "]", e);
                            }
                            try {
                                if (HighlightingDrawLayer.this.filter == FILTER_C) {
                                    HighlightingDrawLayer.this.notifyViews(pane.getUI().getRootView(pane), rangeStart, rangeEnd);
                                }
                            }
                            catch (Exception e) {
                                LOG.log(Level.INFO, "Can't reset line views: range = [" + rangeStart + ", " + rangeEnd + "]", e);
                            }
                            Caret caret = pane.getCaret();
                            if (caret instanceof BaseCaret) {
                                ((BaseCaret)caret).changedUpdate(null);
                            }
                        }
                        finally {
                            doc.readUnlock();
                        }
                    }
                }
            }
        });
    }

    @Override
    public void atomicLock(AtomicLockEvent evt) {
        this.inAtomicLock = true;
    }

    @Override
    public void atomicUnlock(AtomicLockEvent evt) {
        this.inAtomicLock = false;
        if (this.damageStartPos != null && this.damageEndPos != null) {
            this.invokeDamageRange(this.damageStartPos.getOffset(), this.damageEndPos.getOffset());
        }
        this.damageStartPos = null;
        this.damageEndPos = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyViews(View view, int startOffset, int endOffset) {
        while (view != null) {
            int idx = view.getViewIndex(startOffset, Position.Bias.Forward);
            if (idx != -1) {
                View v = view.getView(idx);
                if (v instanceof DrawEngineLineView) break;
                view = v;
                continue;
            }
            view = null;
        }
        if (view != null) {
            LockView lockView = LockView.get(view);
            lockView.lock();
            try {
                int firstViewIdx = view.getViewIndex(startOffset, Position.Bias.Forward);
                int lastViewIdx = view.getViewIndex(endOffset, Position.Bias.Forward);
                for (int i = firstViewIdx; i <= lastViewIdx; ++i) {
                    View v = view.getView(i);
                    if (!(v instanceof DrawEngineLineView)) continue;
                    ((DrawEngineLineView)v).highlightsChanged(Math.max(startOffset, v.getStartOffset()), Math.min(endOffset, v.getEndOffset()));
                }
            }
            finally {
                lockView.unlock();
            }
        }
    }

    private int findLineEndOffset(Document doc, int offset) {
        int lineIndex = this.lastLineIndex;
        Element lineRootElement = doc.getDefaultRootElement();
        if (lineIndex < lineRootElement.getElementCount()) {
            Element lineElement = lineRootElement.getElement(lineIndex);
            int eo = lineElement.getEndOffset();
            if (offset < eo) {
                if (offset >= lineElement.getStartOffset()) {
                    return eo;
                }
            } else if (lineIndex + 1 < lineRootElement.getElementCount() && offset < (eo = (lineElement = lineRootElement.getElement(lineIndex + 1)).getEndOffset()) && offset >= lineElement.getStartOffset()) {
                this.lastLineIndex = lineIndex + 1;
                return eo;
            }
        }
        this.lastLineIndex = lineIndex = lineRootElement.getElementIndex(offset);
        return lineRootElement.getElement(lineIndex).getEndOffset();
    }

    private boolean processOffset(DrawContext ctx, boolean applyAttributes) {
        int currentOffset;
        BaseDocument doc = ctx.getEditorUI().getDocument();
        int endOffset = this.findLineEndOffset(doc, currentOffset = ctx.getFragmentOffset());
        if (endOffset >= doc.getLength()) {
            endOffset = Integer.MAX_VALUE;
        }
        boolean hasHighlight = false;
        if (this.sequence != null) {
            if (this.sequence instanceof HighlightsSequenceEx && !((HighlightsSequenceEx)this.sequence).isStale()) {
                if (currentOffset >= this.sequence.getStartOffset() && currentOffset < this.sequenceEnd) {
                    hasHighlight = true;
                    while (currentOffset >= this.sequence.getEndOffset()) {
                        if (this.sequence.moveNext()) continue;
                        this.sequence = null;
                        break;
                    }
                } else {
                    this.sequence = null;
                }
            } else {
                this.sequence = null;
            }
        }
        if (this.sequence == null) {
            this.sequenceEnd = endOffset;
            this.sequence = this.highlights.getHighlights(currentOffset, endOffset);
            hasHighlight = this.sequence.moveNext();
        }
        if (hasHighlight) {
            if (this.sequence.getStartOffset() <= currentOffset) {
                if (applyAttributes) {
                    Coloring coloring = Coloring.fromAttributeSet(this.sequence.getAttributes());
                    ColoringAccessor.get().apply(coloring, ctx);
                }
                this.lastAttributeSet = this.sequence.getAttributes();
                this.setNextActivityChangeOffset(this.sequence.getEndOffset());
            } else {
                this.setNextActivityChangeOffset(this.sequence.getStartOffset());
            }
            return true;
        }
        this.sequence = null;
        return false;
    }

    private AttributeSet[] filter(List<AttributeSet> sets) {
        ArrayList<AttributeSet> eolSets = new ArrayList<AttributeSet>();
        ArrayList<AttributeSet> elSets = new ArrayList<AttributeSet>();
        for (AttributeSet set : sets) {
            Object value = set.getAttribute(HighlightsContainer.ATTR_EXTENDS_EOL);
            if (value instanceof Boolean && ((Boolean)value).booleanValue()) {
                eolSets.add(set);
            }
            if (!((value = set.getAttribute(HighlightsContainer.ATTR_EXTENDS_EMPTY_LINE)) instanceof Boolean) || !((Boolean)value).booleanValue()) continue;
            elSets.add(set);
        }
        AttributeSet eolAttribs = eolSets.size() > 1 ? AttributesUtilities.createComposite((AttributeSet[])eolSets.toArray(new AttributeSet[eolSets.size()])) : (eolSets.size() == 1 ? (AttributeSet)eolSets.get(0) : SimpleAttributeSet.EMPTY);
        AttributeSet elAttribs = elSets.size() > 1 ? AttributesUtilities.createComposite((AttributeSet[])elSets.toArray(new AttributeSet[elSets.size()])) : (elSets.size() == 1 ? (AttributeSet)elSets.get(0) : SimpleAttributeSet.EMPTY);
        return new AttributeSet[]{eolAttribs, elAttribs};
    }

    private static String simpleToString(Object o) {
        return o == null ? "null" : o.getClass() + "@" + Integer.toHexString(System.identityHashCode(o));
    }
}

