/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.registry;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.spi.debugger.ui.AttachType;
import org.netbeans.spi.debugger.ui.BreakpointType;
import org.netbeans.spi.debugger.ui.ColumnModelRegistration;
import org.netbeans.spi.viewmodel.ColumnModel;
import org.openide.filesystems.annotations.LayerGeneratingProcessor;
import org.openide.filesystems.annotations.LayerGenerationException;

@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class DebuggerProcessor
extends LayerGeneratingProcessor {
    public static final String SERVICE_NAME = "serviceName";

    public Set<String> getSupportedAnnotationTypes() {
        return new HashSet<String>(Arrays.asList(AttachType.Registration.class.getCanonicalName(), BreakpointType.Registration.class.getCanonicalName(), ColumnModelRegistration.class.getCanonicalName()));
    }

    protected boolean handleProcess(Set<? extends TypeElement> annotations, RoundEnvironment env) throws LayerGenerationException {
        String displayName;
        Annotation reg;
        if (env.processingOver()) {
            return false;
        }
        int cnt = 0;
        for (Element element : env.getElementsAnnotatedWith(AttachType.Registration.class)) {
            reg = element.getAnnotation(AttachType.Registration.class);
            displayName = reg.displayName();
            int position = reg.position();
            this.handleProviderRegistrationDisplayName(element, AttachType.class, displayName, null, position);
            ++cnt;
        }
        for (Element element : env.getElementsAnnotatedWith(BreakpointType.Registration.class)) {
            reg = element.getAnnotation(BreakpointType.Registration.class);
            displayName = reg.displayName();
            String path = reg.path();
            int position = reg.position();
            this.handleProviderRegistrationDisplayName(element, BreakpointType.class, displayName, path, position);
            ++cnt;
        }
        for (Element element : env.getElementsAnnotatedWith(ColumnModelRegistration.class)) {
            reg = element.getAnnotation(ColumnModelRegistration.class);
            String path = reg.path();
            int position = reg.position();
            this.handleProviderRegistration(element, ColumnModel.class, path, position);
            ++cnt;
        }
        return cnt == annotations.size();
    }

    private void handleProviderRegistration(Element e, Class providerClass, String path, int position) throws IllegalArgumentException, LayerGenerationException {
        String className = this.instantiableClassOrMethod(e);
        if (!this.isClassOf(e, providerClass)) {
            throw new IllegalArgumentException("Annotated element " + e + " is not an instance of " + providerClass);
        }
        path = path != null && path.length() > 0 ? "Debugger/" + path : "Debugger";
        this.layer(new Element[]{e}).instanceFile(path, null, providerClass).stringvalue(SERVICE_NAME, className).stringvalue("serviceClass", providerClass.getName()).stringvalue("instanceOf", providerClass.getName()).methodvalue("instanceCreate", "org.netbeans.modules.debugger.ui.registry." + providerClass.getSimpleName() + "ContextAware", "createService").position(position).write();
    }

    private void handleProviderRegistrationDisplayName(Element e, Class providerClass, String displayName, String path, int position) throws IllegalArgumentException, LayerGenerationException {
        String className = this.instantiableClassOrMethod(e);
        if (!this.isClassOf(e, providerClass)) {
            throw new IllegalArgumentException("Annotated element " + e + " is not an instance of " + providerClass);
        }
        path = path != null && path.length() > 0 ? "Debugger/" + path : "Debugger";
        this.layer(new Element[]{e}).instanceFile(path, null, providerClass).stringvalue(SERVICE_NAME, className).stringvalue("serviceClass", providerClass.getName()).stringvalue("instanceOf", providerClass.getName()).bundlevalue("displayName", displayName).methodvalue("instanceCreate", providerClass.getName() + "$ContextAware", "createService").position(position).write();
    }

    private boolean isClassOf(Element e, Class providerClass) {
        switch (e.getKind()) {
            case CLASS: {
                TypeElement te = (TypeElement)e;
                TypeMirror superType = te.getSuperclass();
                if (superType.getKind().equals((Object)TypeKind.NONE)) {
                    return false;
                }
                e = ((DeclaredType)superType).asElement();
                String clazz = this.processingEnv.getElementUtils().getBinaryName((TypeElement)e).toString();
                if (clazz.equals(providerClass.getName())) {
                    return true;
                }
                return this.isClassOf(e, providerClass);
            }
            case METHOD: {
                TypeMirror retType = ((ExecutableElement)e).getReturnType();
                if (retType.getKind().equals((Object)TypeKind.NONE)) {
                    return false;
                }
                e = ((DeclaredType)retType).asElement();
                String clazz = this.processingEnv.getElementUtils().getBinaryName((TypeElement)e).toString();
                if (clazz.equals(providerClass.getName())) {
                    return true;
                }
                return this.isClassOf(e, providerClass);
            }
        }
        throw new IllegalArgumentException("Annotated element is not loadable as an instance: " + e);
    }

    private String instantiableClassOrMethod(Element e) throws IllegalArgumentException, LayerGenerationException {
        switch (e.getKind()) {
            case CLASS: {
                String clazz = this.processingEnv.getElementUtils().getBinaryName((TypeElement)e).toString();
                if (e.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                    throw new LayerGenerationException(clazz + " must not be abstract", e);
                }
                boolean hasDefaultCtor = false;
                for (ExecutableElement constructor : ElementFilter.constructorsIn(e.getEnclosedElements())) {
                    if (!constructor.getParameters().isEmpty()) continue;
                    hasDefaultCtor = true;
                    break;
                }
                if (!hasDefaultCtor) {
                    throw new LayerGenerationException(clazz + " must have a no-argument constructor", e);
                }
                return clazz;
            }
            case METHOD: {
                ExecutableElement ee = (ExecutableElement)e;
                String methodName = ee.getSimpleName().toString();
                String clazz = this.processingEnv.getElementUtils().getBinaryName((TypeElement)ee.getEnclosingElement()).toString();
                if (!e.getModifiers().contains((Object)Modifier.STATIC)) {
                    throw new LayerGenerationException(ee + " must be static", e);
                }
                if (ee.getParameters().size() > 0) {
                    throw new LayerGenerationException(ee + " must not have any parameters", e);
                }
                return clazz + "." + methodName + "()";
            }
        }
        throw new IllegalArgumentException("Annotated element is not loadable as an instance: " + e);
    }
}

