/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu;

import java.util.logging.Logger;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.results.RuntimeCCTNode;
import org.netbeans.lib.profiler.results.cpu.CPUCCTProvider;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainer;
import org.netbeans.lib.profiler.results.cpu.FlatProfileProvider;
import org.netbeans.lib.profiler.results.cpu.cct.CCTFlattener;
import org.netbeans.lib.profiler.results.cpu.cct.CCTResultsFilter;
import org.netbeans.lib.profiler.results.cpu.cct.CompositeCPUCCTWalker;
import org.netbeans.lib.profiler.results.cpu.cct.TimeCollector;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.RuntimeCPUCCTNode;

public class FlatProfileBuilder
implements FlatProfileProvider,
CPUCCTProvider.Listener {
    private static final Logger LOGGER = Logger.getLogger(FlatProfileBuilder.class.getName());
    private CCTFlattener flattener;
    private FlatProfileContainer lastFlatProfile = null;
    private ProfilerClient client;
    private RuntimeCPUCCTNode appNode;
    private TimeCollector collector = null;
    private CCTResultsFilter filter = null;

    public void setContext(ProfilerClient client, TimeCollector collector, CCTResultsFilter filter) {
        if (this.client != null) {
            this.collector = null;
            this.filter = null;
            this.client.registerFlatProfileProvider(null);
        }
        if (client != null) {
            this.collector = collector;
            this.filter = filter;
            this.flattener = new CCTFlattener(client, filter);
            client.registerFlatProfileProvider(this);
        } else {
            this.flattener = null;
        }
        this.client = client;
        this.appNode = null;
    }

    @Override
    public synchronized void cctEstablished(RuntimeCCTNode appRootNode, boolean empty) {
        if (empty) {
            return;
        }
        this.appNode = appRootNode instanceof RuntimeCPUCCTNode ? (RuntimeCPUCCTNode)appRootNode : null;
    }

    @Override
    public synchronized void cctReset() {
        this.appNode = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized FlatProfileContainer createFlatProfile() {
        if (this.appNode == null) {
            return null;
        }
        this.client.getStatus().beginTrans(false);
        try {
            CompositeCPUCCTWalker walker = new CompositeCPUCCTWalker();
            int index = 0;
            if (this.filter != null) {
                walker.add(index++, this.filter);
            }
            walker.add(index++, this.flattener);
            if (this.collector != null) {
                walker.add(index++, this.collector);
            }
            walker.walk(this.appNode);
            this.lastFlatProfile = this.flattener.getFlatProfile();
        }
        finally {
            this.client.getStatus().endTrans();
        }
        return this.lastFlatProfile;
    }
}

