/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.global;

public class TransactionalSupport {
    static final boolean DEBUG = System.getProperty(TransactionalSupport.class.getName()) != null;
    private final Object transactionLock = new Object();
    private final ThreadLocal interruptedFlag = new ThreadLocal();
    private final ThreadLocal lockRead = new ThreadLocal();
    private final ThreadLocal lockWrite = new ThreadLocal();
    private boolean lockedExclusively = false;
    private boolean lockedShared = false;
    private int sharedLockCount = 0;

    public void beginTrans(boolean mutable) {
        this.beginTrans(mutable, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beginTrans(boolean mutable, boolean failEarly) {
        if (DEBUG) {
            System.out.println("DEBUG: [" + Thread.currentThread().getName() + "] Starting transaction: mutable = " + mutable + ", failEarly = " + failEarly);
        }
        Object object = this.transactionLock;
        synchronized (object) {
            boolean result = false;
            do {
                if ((result = mutable ? this.lockExclusively() : this.lockShared()) || failEarly) continue;
                if (DEBUG) {
                    System.out.println("DEBUG: [" + Thread.currentThread().getName() + "] Couldn't start transaction. Going to wait for some time");
                }
                boolean interrupted = false;
                do {
                    interrupted = false;
                    try {
                        this.transactionLock.wait();
                    }
                    catch (InterruptedException e) {
                        this.interruptedFlag.set(new Object());
                        interrupted = true;
                        Thread.interrupted();
                    }
                } while (interrupted);
            } while (!result && !failEarly);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endTrans() {
        Object object = this.transactionLock;
        synchronized (object) {
            int counter;
            Integer roCounter = (Integer)this.lockRead.get();
            Integer rwCounter = (Integer)this.lockWrite.get();
            if (roCounter == null) {
                this.unlockShared();
            } else {
                if (DEBUG) {
                    System.out.println("DEBUG: [" + Thread.currentThread().getName() + "] Releasing ownership for a shared lock");
                }
                if ((counter = roCounter.intValue()) > 1) {
                    this.lockRead.set(new Integer(counter - 1));
                } else {
                    this.lockRead.set(null);
                    this.unlockShared();
                }
            }
            if (rwCounter == null) {
                if (DEBUG) {
                    System.out.println("DEBUG: [" + Thread.currentThread().getName() + "] Unlocking an exclusive lock");
                }
                this.lockedExclusively = false;
            } else {
                if (DEBUG) {
                    System.out.println("DEBUG: [" + Thread.currentThread().getName() + "] Releasing ownership for an exclusive lock");
                }
                if ((counter = rwCounter.intValue()) > 1) {
                    this.lockWrite.set(new Integer(counter - 1));
                } else {
                    this.lockWrite.set(null);
                    if (DEBUG) {
                        System.out.println("DEBUG: [" + Thread.currentThread().getName() + "] Unlocking an exclusive lock");
                    }
                    this.lockedExclusively = false;
                }
            }
            this.transactionLock.notifyAll();
        }
        this.rethrowInterrupt();
    }

    private boolean lockExclusively() {
        if (this.lockedShared) {
            return this.promoteToExclusive();
        }
        if (this.lockedExclusively) {
            return this.relockExclusively();
        }
        if (DEBUG) {
            System.out.println("DEBUG: [" + Thread.currentThread().getName() + "] Grabbing an exclusive lock for transaction");
        }
        this.lockedExclusively = true;
        this.lockWrite.set(new Integer(1));
        return true;
    }

    private boolean lockShared() {
        if (this.lockedExclusively) {
            return this.relockExclusively();
        }
        if (DEBUG) {
            System.out.println("DEBUG: [" + Thread.currentThread().getName() + "] Grabbing shared lock for transaction");
        }
        this.lockedShared = true;
        Integer counter = (Integer)this.lockRead.get();
        if (counter == null) {
            this.lockRead.set(new Integer(1));
            ++this.sharedLockCount;
        } else {
            this.lockRead.set(new Integer(counter + 1));
        }
        boolean result = true;
        return result;
    }

    private boolean promoteToExclusive() {
        boolean result;
        if (this.sharedLockCount > 1) {
            System.err.println("WARNING: [" + Thread.currentThread().getName() + "] Cant promote a shared lock held by " + this.sharedLockCount + " threads!");
            return false;
        }
        Integer counter = (Integer)this.lockRead.get();
        if (counter != null) {
            if (DEBUG) {
                System.out.println("DEBUG: [" + Thread.currentThread().getName() + "] Promoting a previously owned shared lock to the exclusive one");
            }
            this.lockedShared = false;
            this.sharedLockCount = 0;
            this.lockedExclusively = true;
            this.lockWrite.set(new Integer(counter + 1));
            this.lockRead.set(null);
            result = true;
        } else {
            if (DEBUG) {
                System.out.println("DEBUG: [" + Thread.currentThread().getName() + "] Failed to promote a previously owned shared lock");
            }
            result = false;
        }
        return result;
    }

    private boolean relockExclusively() {
        boolean result;
        Integer counter = (Integer)this.lockWrite.get();
        if (counter != null) {
            if (DEBUG) {
                System.out.println("DEBUG: [" + Thread.currentThread().getName() + "] Relocking a previously owned exclusive lock");
            }
            this.lockWrite.set(new Integer(counter + 1));
            result = true;
        } else {
            if (DEBUG) {
                System.out.println("DEBUG: [" + Thread.currentThread().getName() + "] Failed to relock an exclusive lock. Not an owner.");
            }
            result = false;
        }
        return result;
    }

    private void rethrowInterrupt() {
        if (this.interruptedFlag.get() != null) {
            Thread.currentThread().interrupt();
            this.interruptedFlag.set(null);
        }
    }

    private void unlockShared() {
        if (DEBUG) {
            System.out.println("DEBUG: [" + Thread.currentThread().getName() + "] Unlocking a shared lock");
        }
        this.lockedShared = false;
        if (this.sharedLockCount > 0) {
            --this.sharedLockCount;
        }
    }
}

