/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.classfile;

import java.io.IOException;
import java.lang.reflect.Modifier;
import org.netbeans.lib.profiler.classfile.BaseClassInfo;
import org.netbeans.lib.profiler.classfile.ClassFileParser;
import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.instrumentation.JavaClassConstants;

public abstract class ClassInfo
extends BaseClassInfo
implements JavaClassConstants,
CommonConstants {
    String packageName;
    String superName;
    char[] cpoolRefsToClassIdx;
    String[] cpoolRefsToClassName;
    String[][] cpoolRefsToMethodClassNameAndSig;
    char[] cpoolRefsToMethodIdx;
    int[] exceptionTableStartOffsets;
    String[] interfaces;
    char[] lineNumberTablesLengths;
    int[] lineNumberTablesOffsets;
    char[] methodAccessFlags;
    char[] methodBytecodesLengths;
    int[] methodBytecodesOffsets;
    int[] methodInfoLengths;
    int[] methodInfoOffsets;
    String[] methodNames;
    String[] methodSignatures;
    String[] nestedClassNames;
    char accessFlags;
    int attrsStartOfs;
    int cpoolStartOfs;
    int fieldsStartOfs;
    int intermediateDataStartOfs;
    int methodsStartOfs;
    int origCPoolCount;
    short lineNumberTablesInitStatus;
    private LineNumberTables lineNumberTables;

    protected ClassInfo(String className, int loaderId) {
        super(className, loaderId);
        this.packageName = ClassInfo.getPackageName(this.name);
    }

    ClassInfo(byte[] buf) throws ClassFormatError {
        super("", 0);
        try {
            new ClassFileParser().parseClassFile(buf, this);
        }
        catch (ClassFileParser.ClassFileReadException ex) {
            throw new ClassFormatError(ex.getMessage());
        }
        this.packageName = ClassInfo.getPackageName(this.name);
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.accessFlags);
    }

    public int getExceptionTableStartOffsetInMethodInfo(int i) {
        return this.exceptionTableStartOffsets[i];
    }

    public boolean isInterface() {
        return Modifier.isInterface(this.accessFlags);
    }

    public String[] getInterfaceNames() {
        return this.interfaces;
    }

    public LineNumberTables getLineNumberTables() {
        if (this.lineNumberTables == null) {
            this.initLineNumberTables();
        }
        return this.lineNumberTables;
    }

    public boolean isMethodAbstract(int i) {
        return Modifier.isAbstract(this.methodAccessFlags[i]);
    }

    public byte[] getMethodBytecode(int i) {
        try {
            byte[] classFile = this.getClassFileBytes();
            byte[] res = new byte[this.methodBytecodesLengths[i]];
            System.arraycopy(classFile, this.methodInfoOffsets[i] + this.methodBytecodesOffsets[i], res, 0, this.methodBytecodesLengths[i]);
            return res;
        }
        catch (IOException ex1) {
            return null;
        }
        catch (ClassNotFoundException ex2) {
            return null;
        }
    }

    public int getMethodBytecodeOffsetInMethodInfo(int i) {
        return this.methodBytecodesOffsets[i];
    }

    public int getMethodBytecodesLength(int i) {
        return this.methodBytecodesLengths[i];
    }

    public boolean isMethodFinal(int i) {
        return Modifier.isFinal(this.methodAccessFlags[i]);
    }

    public int getMethodIndex(String name, String sig) {
        for (int i = 0; i < this.methodNames.length; ++i) {
            if (this.methodNames[i] != name || this.methodSignatures[i] != sig) continue;
            return i;
        }
        return -1;
    }

    public byte[] getMethodInfo(int i) {
        try {
            byte[] classFile = this.getClassFileBytes();
            byte[] res = new byte[this.methodInfoLengths[i]];
            System.arraycopy(classFile, this.methodInfoOffsets[i], res, 0, this.methodInfoLengths[i]);
            return res;
        }
        catch (IOException ex1) {
            return null;
        }
        catch (ClassNotFoundException ex2) {
            return null;
        }
    }

    public int getMethodInfoLength(int i) {
        return this.methodInfoLengths[i];
    }

    public String getMethodName(int i) {
        return this.methodNames[i];
    }

    public String[] getMethodNames() {
        return this.methodNames;
    }

    public boolean isMethodNative(int i) {
        return Modifier.isNative(this.methodAccessFlags[i]);
    }

    public boolean isMethodPrivate(int i) {
        return Modifier.isPrivate(this.methodAccessFlags[i]);
    }

    public boolean isMethodProtected(int i) {
        return Modifier.isProtected(this.methodAccessFlags[i]);
    }

    public boolean isMethodPublic(int i) {
        return Modifier.isPublic(this.methodAccessFlags[i]);
    }

    public String getMethodSignature(int i) {
        return this.methodSignatures[i];
    }

    public String[] getMethodSignatures() {
        return this.methodSignatures;
    }

    public boolean isMethodStatic(int i) {
        return Modifier.isStatic(this.methodAccessFlags[i]);
    }

    public int[] getMinAndMaxLinesForMethod(int methodIdx) {
        if (this.lineNumberTables == null) {
            this.initLineNumberTables();
        }
        return this.lineNumberTables.getMinAndMaxLinesForMethod(methodIdx);
    }

    public String[] getNestedClassNames() {
        return this.nestedClassNames;
    }

    public int getOrigAttrsStartOfs() {
        return this.attrsStartOfs;
    }

    public int getOrigCPoolCount() {
        return this.origCPoolCount;
    }

    public int getOrigCPoolStartOfs() {
        return this.cpoolStartOfs;
    }

    public int getOrigFieldsStartOfs() {
        return this.fieldsStartOfs;
    }

    public int getOrigIntermediateDataStartOfs() {
        return this.intermediateDataStartOfs;
    }

    public int getOrigMethodsStartOfs() {
        return this.methodsStartOfs;
    }

    public String getRefClassName(int refClassIdx) {
        for (int i = 0; i < this.cpoolRefsToClassIdx.length; ++i) {
            if (this.cpoolRefsToClassIdx[i] != refClassIdx) continue;
            return this.cpoolRefsToClassName[i];
        }
        return null;
    }

    public String[] getRefMethodsClassNameAndSig(int refMethodIdx) {
        for (int i = 0; i < this.cpoolRefsToMethodIdx.length; ++i) {
            if (this.cpoolRefsToMethodIdx[i] != refMethodIdx) continue;
            return this.cpoolRefsToMethodClassNameAndSig[i];
        }
        return null;
    }

    public String getSuperclassName() {
        return this.superName;
    }

    public int bciForMethodAndLineNo(int methodIdx, int lineNo) {
        if (this.lineNumberTables == null) {
            this.initLineNumberTables();
        }
        return this.lineNumberTables.bciForLineNo(methodIdx, lineNo);
    }

    public int checkIfAtGoTo(int methodIdx, int bci) {
        byte[] codeBytes = this.getMethodBytecode(methodIdx);
        int codeAtBCI = codeBytes[bci] & 0xFF;
        if (codeAtBCI != 167 && codeAtBCI != 200) {
            return bci;
        }
        return ClassInfo.findPreviousBCI(codeBytes, bci);
    }

    public boolean containsMethod(String name, String sig) {
        return this.getMethodIndex(name, sig) != -1;
    }

    public static int findPreviousBCI(byte[] codeBytes, int bci) {
        int prev_offset = 0;
        int offset = 0;
        block4: while (offset < bci) {
            prev_offset = offset;
            int opcode = codeBytes[offset] & 0xFF;
            if (opcode == 196) {
                opcode = codeBytes[offset + 1] & 0xFF;
                if (opcode >= 21 && opcode <= 25 || opcode >= 54 && opcode <= 58 || opcode == 169) {
                    offset += 4;
                    continue;
                }
                if (opcode == 132) {
                    offset += 6;
                    continue;
                }
                ++offset;
                continue;
            }
            switch (opcode) {
                case 170: {
                    int tbl = offset + 1 + 3 & 0xFFFFFFFC;
                    long default_skip = ClassInfo.intAt(codeBytes, tbl, 0);
                    long low = ClassInfo.intAt(codeBytes, tbl, 1);
                    long high = ClassInfo.intAt(codeBytes, tbl, 2);
                    offset = (tbl += 12) + (int)(high - low + 1L << 2);
                    continue block4;
                }
                case 171: {
                    int tbl = offset + 1 + 3 & 0xFFFFFFFC;
                    long default_skip = ClassInfo.intAt(codeBytes, tbl, 0);
                    int npairs = (int)ClassInfo.intAt(codeBytes, tbl, 1);
                    int nints = npairs * 2;
                    offset = (tbl += 8) + (nints << 2);
                    continue block4;
                }
            }
            offset += opc_length[opcode];
        }
        return prev_offset;
    }

    public int lineNoForMethodAndBci(int methodIdx, int bci) {
        if (this.lineNumberTables == null) {
            this.initLineNumberTables();
        }
        return this.lineNumberTables.lineNoForBci(methodIdx, bci);
    }

    public int[] methodIdxAndBestBCIForLineNo(int lineNo) {
        int bestBCI;
        int i;
        if (this.lineNumberTablesInitStatus == 0) {
            this.initLineNumberTables();
        }
        if (this.lineNumberTablesInitStatus == -1) {
            return new int[]{-2, -2};
        }
        int nMethods = this.methodNames.length;
        for (i = 0; i < nMethods; ++i) {
            if (this.methodNames[i] == "<init>" || this.methodNames[i] == "<clinit>" || (bestBCI = this.lineNumberTables.bciForLineNo(i, lineNo)) == -1) continue;
            return new int[]{i, bestBCI};
        }
        for (i = 0; i < nMethods; ++i) {
            if (this.methodNames[i] != "<init>" && this.methodNames[i] != "<clinit>" || (bestBCI = this.lineNumberTables.bciForLineNo(i, lineNo)) == -1) continue;
            return new int[]{i, bestBCI};
        }
        return new int[]{-1, -1};
    }

    public int overridesVirtualMethod(ClassInfo superClass, int superMethodIdx) {
        int idx = this.getMethodIndex(superClass.methodNames[superMethodIdx], superClass.methodSignatures[superMethodIdx]);
        if (idx == -1) {
            return -1;
        }
        if (superClass.isMethodPublic(superMethodIdx) || superClass.isMethodProtected(superMethodIdx)) {
            return idx;
        }
        if (superClass.packageName == this.packageName) {
            return idx;
        }
        return -1;
    }

    protected abstract byte[] getClassFileBytes() throws IOException, ClassNotFoundException;

    protected static String getPackageName(String clazzName) {
        int ldi = clazzName.lastIndexOf(47);
        if (ldi == -1) {
            return "";
        }
        return clazzName.substring(0, ldi).intern();
    }

    private static final long intAt(byte[] codeBytes, int tbl, int entry) {
        int base = tbl + (entry << 2);
        return codeBytes[base] << 24 | (codeBytes[base + 1] & 0xFF) << 16 | (codeBytes[base + 2] & 0xFF) << 8 | codeBytes[base + 3] & 0xFF;
    }

    private void initLineNumberTables() {
        byte[] classBuf = null;
        try {
            classBuf = this.getClassFileBytes();
        }
        catch (IOException ex1) {
        }
        catch (ClassNotFoundException ex2) {
            // empty catch block
        }
        int nMethods = this.methodNames.length;
        char[][] startPCs = new char[nMethods][];
        char[][] lineNumbers = new char[nMethods][];
        boolean lineNumberTablesExist = false;
        for (int i = 0; i < nMethods; ++i) {
            int ofs = this.methodInfoOffsets[i] + this.lineNumberTablesOffsets[i];
            if (ofs == -1) continue;
            lineNumberTablesExist = true;
            int tableLen = this.lineNumberTablesLengths[i];
            startPCs[i] = new char[tableLen];
            char[] startPC = startPCs[i];
            lineNumbers[i] = new char[tableLen];
            char[] lineNumber = lineNumbers[i];
            for (int j = 0; j < tableLen; ++j) {
                startPC[j] = (char)(((classBuf[ofs++] & 0xFF) << 8) + (classBuf[ofs++] & 0xFF));
                lineNumber[j] = (char)(((classBuf[ofs++] & 0xFF) << 8) + (classBuf[ofs++] & 0xFF));
            }
        }
        this.lineNumberTables = new LineNumberTables();
        this.lineNumberTables.startPCs = startPCs;
        this.lineNumberTables.lineNumbers = lineNumbers;
        this.lineNumberTablesInitStatus = lineNumberTablesExist ? (short)1 : (short)-1;
    }

    public static class LineNumberTables {
        char[][] lineNumbers;
        char[][] startPCs;

        public char[][] getStartPCs() {
            return this.startPCs;
        }

        int[] getMinAndMaxLinesForMethod(int methodIdx) {
            int[] lines = new int[2];
            if (this.startPCs[methodIdx] == null) {
                lines[1] = -1;
                lines[0] = -1;
                return lines;
            }
            lines[0] = 10000000;
            lines[1] = -10000000;
            char[] lns = this.lineNumbers[methodIdx];
            for (int i = 0; i < lns.length; ++i) {
                if (lns[i] < lines[0]) {
                    lines[0] = lns[i];
                }
                if (lns[i] <= lines[1]) continue;
                lines[1] = lns[i];
            }
            return lines;
        }

        int bciForLineNo(int methodIdx, int lineNo) {
            char c;
            char[] spcs = this.startPCs[methodIdx];
            if (spcs == null) {
                return -1;
            }
            int tableLen = spcs.length;
            char[] lns = this.lineNumbers[methodIdx];
            int minLine = 100000000;
            int bestLine = 100000000;
            int maxLine = 0;
            int curLine = -1;
            int n = 100000000;
            for (int i = 0; i < tableLen; ++i) {
                char c2;
                curLine = lns[i];
                if (curLine > maxLine) {
                    maxLine = curLine;
                }
                if (curLine < minLine) {
                    minLine = curLine;
                }
                if (curLine == lineNo) {
                    c = spcs[i];
                    break;
                }
                if (curLine <= lineNo || curLine > bestLine || spcs[i] >= c2) continue;
                c2 = spcs[i];
                bestLine = curLine;
            }
            if (curLine == lineNo || lineNo >= minLine && lineNo <= maxLine) {
                return c;
            }
            return -1;
        }

        int lineNoForBci(int methodIdx, int bci) {
            char[] spcs = this.startPCs[methodIdx];
            if (spcs == null) {
                return -1;
            }
            int tableLen = spcs.length;
            char[] lns = this.lineNumbers[methodIdx];
            int bestLine = -1;
            for (int i = 0; i < tableLen && spcs[i] <= bci; ++i) {
                bestLine = lns[i];
            }
            return bestLine;
        }
    }
}

