/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.jip.attrs;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.jip.Attribute;
import org.objectweb.asm.jip.ByteVector;
import org.objectweb.asm.jip.ClassReader;
import org.objectweb.asm.jip.ClassWriter;
import org.objectweb.asm.jip.Label;
import org.objectweb.asm.jip.attrs.StackMapFrame;
import org.objectweb.asm.jip.attrs.StackMapType;

public class StackMapAttribute
extends Attribute {
    static final int MAX_SIZE = 65535;
    public List frames = new ArrayList();

    public StackMapAttribute() {
        super("StackMap");
    }

    public StackMapAttribute(List list) {
        this();
        this.frames = list;
    }

    public List getFrames() {
        return this.frames;
    }

    public StackMapFrame getFrame(Label label) {
        for (int i = 0; i < this.frames.size(); ++i) {
            StackMapFrame stackMapFrame = (StackMapFrame)this.frames.get(i);
            if (stackMapFrame.label != label) continue;
            return stackMapFrame;
        }
        return null;
    }

    @Override
    public boolean isUnknown() {
        return false;
    }

    @Override
    public boolean isCodeAttribute() {
        return true;
    }

    @Override
    protected Attribute read(ClassReader classReader, int n, int n2, char[] cArray, int n3, Label[] labelArray) {
        StackMapAttribute stackMapAttribute = new StackMapAttribute();
        boolean bl = classReader.readInt(n3 + 4) > 65535;
        boolean bl2 = classReader.readUnsignedShort(n3 + 2) > 65535;
        boolean bl3 = classReader.readUnsignedShort(n3) > 65535;
        int n4 = 0;
        if (bl) {
            n4 = classReader.readInt(n);
            n += 4;
        } else {
            n4 = classReader.readUnsignedShort(n);
            n += 2;
        }
        for (int i = 0; i < n4; ++i) {
            int n5;
            if (bl) {
                n5 = classReader.readInt(n);
                n += 4;
            } else {
                n5 = classReader.readUnsignedShort(n);
                n += 2;
            }
            Label label = this.getLabel(n5, labelArray);
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            n = this.readTypeInfo(classReader, n, arrayList, labelArray, cArray, bl2, bl);
            n = this.readTypeInfo(classReader, n, arrayList2, labelArray, cArray, bl3, bl);
            stackMapAttribute.frames.add(new StackMapFrame(label, arrayList, arrayList2));
        }
        return stackMapAttribute;
    }

    private int readTypeInfo(ClassReader classReader, int n, List list, Label[] labelArray, char[] cArray, boolean bl, boolean bl2) {
        int n2 = 0;
        if (bl) {
            n2 = classReader.readInt(n);
            n += 4;
        } else {
            n2 = classReader.readUnsignedShort(n);
            n += 2;
        }
        block4: for (int i = 0; i < n2; ++i) {
            int n3 = classReader.readByte(n++);
            StackMapType stackMapType = StackMapType.getTypeInfo(n3);
            list.add(stackMapType);
            switch (n3) {
                case 7: {
                    stackMapType.setObject(classReader.readClass(n, cArray));
                    n += 2;
                    continue block4;
                }
                case 8: {
                    int n4;
                    if (bl2) {
                        n4 = classReader.readInt(n);
                        n += 4;
                    } else {
                        n4 = classReader.readUnsignedShort(n);
                        n += 2;
                    }
                    stackMapType.setLabel(this.getLabel(n4, labelArray));
                }
            }
        }
        return n;
    }

    private void writeTypeInfo(ByteVector byteVector, ClassWriter classWriter, List list, int n) {
        if (n > 65535) {
            byteVector.putInt(list.size());
        } else {
            byteVector.putShort(list.size());
        }
        block4: for (int i = 0; i < list.size(); ++i) {
            StackMapType stackMapType = (StackMapType)list.get(i);
            byteVector.putByte(stackMapType.getType());
            switch (stackMapType.getType()) {
                case 7: {
                    byteVector.putShort(classWriter.newClass(stackMapType.getObject()));
                    continue block4;
                }
                case 8: {
                    byteVector.putShort(stackMapType.getLabel().getOffset());
                }
            }
        }
    }

    private Label getLabel(int n, Label[] labelArray) {
        Label label = labelArray[n];
        if (label != null) {
            return label;
        }
        labelArray[n] = new Label();
        return labelArray[n];
    }

    @Override
    protected ByteVector write(ClassWriter classWriter, byte[] byArray, int n, int n2, int n3) {
        ByteVector byteVector = new ByteVector();
        if (byArray != null && byArray.length > 65535) {
            byteVector.putInt(this.frames.size());
        } else {
            byteVector.putShort(this.frames.size());
        }
        for (int i = 0; i < this.frames.size(); ++i) {
            this.writeFrame((StackMapFrame)this.frames.get(i), classWriter, n2, n3, byteVector);
        }
        return byteVector;
    }

    @Override
    protected Label[] getLabels() {
        HashSet hashSet = new HashSet();
        for (int i = 0; i < this.frames.size(); ++i) {
            this.getFrameLabels((StackMapFrame)this.frames.get(i), hashSet);
        }
        return hashSet.toArray(new Label[hashSet.size()]);
    }

    private void writeFrame(StackMapFrame stackMapFrame, ClassWriter classWriter, int n, int n2, ByteVector byteVector) {
        byteVector.putShort(stackMapFrame.label.getOffset());
        this.writeTypeInfo(byteVector, classWriter, stackMapFrame.locals, n2);
        this.writeTypeInfo(byteVector, classWriter, stackMapFrame.stack, n);
    }

    private void getFrameLabels(StackMapFrame stackMapFrame, Set set) {
        set.add(stackMapFrame.label);
        this.getTypeInfoLabels(set, stackMapFrame.locals);
        this.getTypeInfoLabels(set, stackMapFrame.stack);
    }

    private void getTypeInfoLabels(Set set, List list) {
        for (StackMapType stackMapType : list) {
            if (stackMapType.getType() != 8) continue;
            set.add(stackMapType.getLabel());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("StackMap[");
        for (int i = 0; i < this.frames.size(); ++i) {
            stringBuffer.append('\n').append('[').append(this.frames.get(i)).append(']');
        }
        stringBuffer.append("\n]");
        return stringBuffer.toString();
    }
}

