/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.project;

import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.spi.java.queries.JavadocForBinaryQueryImplementation;

public class JavadocForBinaryQueryImpl
implements JavadocForBinaryQueryImplementation {
    private static final Logger LOG = Logger.getLogger(JavadocForBinaryQueryImpl.class.getName());

    public JavadocForBinaryQuery.Result findJavadoc(URL binary) {
        boolean log = LOG.isLoggable(Level.FINE);
        Project project = FileOwnerQuery.getOwner((URI)URI.create(binary.toString()));
        if (project != null) {
            JavadocForBinaryQueryImplementation jfbqi = (JavadocForBinaryQueryImplementation)project.getLookup().lookup(JavadocForBinaryQueryImplementation.class);
            if (jfbqi != null) {
                JavadocForBinaryQuery.Result result = jfbqi.findJavadoc(binary);
                if (log) {
                    LOG.fine("Project " + project + " reported for " + binary + ": " + (result != null ? Arrays.asList(result.getRoots()) : null));
                }
                return result;
            }
            if (log) {
                LOG.fine("Project " + project + " did not have any JavadocForBinaryQueryImplementation");
            }
        } else if (log) {
            LOG.fine("No project found for " + binary + "; cannot find Javadoc");
        }
        return null;
    }
}

