/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.welcome.ui;

import java.util.HashSet;
import java.util.Set;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;

class InstallConfig {
    private boolean ergonomics = false;
    private boolean somePacksDisabled = false;
    private Set<String> enabledPackNames = new HashSet<String>(10);
    private Set<String> availablePackNames = new HashSet<String>(10);
    private static final String javaSEPackName = "org.netbeans.modules.java.kit";
    private static final String ergonomicsPackName = "org.netbeans.modules.ide.ergonomics";
    private static final String[] packNames = new String[]{"org.netbeans.modules.java.kit", "org.netbeans.modules.j2ee.kit", "org.netbeans.modules.mobility.kit", "org.netbeans.modules.ruby.kit", "org.netbeans.modules.cnd.kit", "org.netbeans.modules.php.kit", "org.netbeans.modules.groovy.kit"};
    private static InstallConfig theInstance;

    private InstallConfig() {
        for (ModuleInfo mi : Lookup.getDefault().lookupAll(ModuleInfo.class)) {
            boolean bl = this.ergonomics = this.ergonomics || this.isErgonomicsPack(mi);
            if (!this.isPack(mi)) continue;
            if (mi.isEnabled()) {
                this.enabledPackNames.add(mi.getCodeNameBase());
            } else {
                this.somePacksDisabled = true;
            }
            this.availablePackNames.add(mi.getCodeNameBase());
        }
    }

    public static InstallConfig getDefault() {
        if (null == theInstance) {
            theInstance = new InstallConfig();
        }
        return theInstance;
    }

    public boolean isErgonomicsEnabled() {
        return this.ergonomics;
    }

    public boolean somePacksDisabled() {
        return this.somePacksDisabled;
    }

    public void setSomePacksDisabled(boolean somePacksDisabled) {
        this.somePacksDisabled = somePacksDisabled;
    }

    private boolean isPack(ModuleInfo mi) {
        String moduleName = mi.getCodeNameBase();
        for (String pn : packNames) {
            if (!moduleName.startsWith(pn)) continue;
            return true;
        }
        return false;
    }

    private boolean isErgonomicsPack(ModuleInfo mi) {
        String moduleName = mi.getCodeNameBase();
        return moduleName.startsWith(ergonomicsPackName) && mi.isEnabled();
    }

    private boolean isPackEnabled(String prefName) {
        for (String name : this.enabledPackNames) {
            if (!name.contains(prefName)) continue;
            return true;
        }
        return false;
    }
}

