/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans.beaninfo;

import java.beans.PropertyVetoException;
import java.io.IOException;
import org.netbeans.api.editor.guards.GuardedSectionManager;
import org.netbeans.api.editor.guards.InteriorSection;
import org.netbeans.api.editor.guards.SimpleSection;
import org.netbeans.modules.beans.GenerateBeanException;
import org.netbeans.modules.beans.beaninfo.BIDataObject;
import org.netbeans.modules.beans.beaninfo.BIEditorSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

public final class BeanInfoSource {
    private static final String BEANINFO_NAME_EXT = "BeanInfo";
    private static final String DESCRIPTOR_SECTION = "BeanDescriptor";
    private static final String PROPERTIES_SECTION = "Properties";
    private static final String EVENTSETS_SECTION = "Events";
    private static final String ICONS_SECTION = "Icons";
    private static final String IDX_SECTION = "Idx";
    private static final String METHODS_SECTION = "Methods";
    private static final String SUPERCLASS_SECTION = "Superclass";
    private DataObject javaDataObject;
    private DataObject biDataObject = null;
    private BIEditorSupport javaEditor = null;

    public BeanInfoSource(FileObject javafile) throws GenerateBeanException {
        this.findBeanInfo(javafile);
    }

    boolean exists() {
        return this.biDataObject != null;
    }

    boolean isNbBeanInfo() {
        GuardedSectionManager guards = null;
        if (!this.exists() || this.javaEditor == null || null == (guards = this.javaEditor.getGuardedSectionManager())) {
            return false;
        }
        InteriorSection pis = guards.findInteriorSection(PROPERTIES_SECTION);
        InteriorSection eis = guards.findInteriorSection(EVENTSETS_SECTION);
        SimpleSection dss = guards.findSimpleSection(IDX_SECTION);
        return pis != null && eis != null && dss != null;
    }

    boolean hasIconInfo() {
        GuardedSectionManager guards = this.javaEditor.getGuardedSectionManager();
        if (guards == null) {
            return false;
        }
        SimpleSection iss = guards.findSimpleSection(ICONS_SECTION);
        return iss != null;
    }

    boolean isNbBeanInfoDescriptor() {
        GuardedSectionManager guards = null;
        if (!this.exists() || this.javaEditor == null || null == (guards = this.javaEditor.getGuardedSectionManager())) {
            return false;
        }
        InteriorSection dis = guards.findInteriorSection(DESCRIPTOR_SECTION);
        return dis != null;
    }

    boolean isNbSuperclass() {
        GuardedSectionManager guards = null;
        if (!this.exists() || this.javaEditor == null || null == (guards = this.javaEditor.getGuardedSectionManager())) {
            return false;
        }
        InteriorSection dis = guards.findInteriorSection(SUPERCLASS_SECTION);
        return dis != null;
    }

    void findBeanInfo(FileObject javafile) throws GenerateBeanException {
        this.javaEditor = null;
        try {
            this.javaDataObject = DataObject.find((FileObject)javafile);
            FileObject parent = javafile.getParent();
            FileObject bifile = parent.getFileObject(javafile.getName() + BEANINFO_NAME_EXT, "java");
            if (bifile != null) {
                this.biDataObject = DataObject.find((FileObject)bifile);
                this.javaEditor = (BIEditorSupport)((Object)this.biDataObject.getLookup().lookup(BIEditorSupport.class));
            }
        }
        catch (DataObjectNotFoundException ex) {
            throw new GenerateBeanException();
        }
    }

    void delete() throws IOException {
        this.biDataObject.delete();
    }

    void createFromTemplate(boolean iconBlock) {
        FileObject foTemplates = FileUtil.getConfigFile((String)"Templates");
        if (foTemplates == null) {
            return;
        }
        FileObject foClassTemplates = foTemplates.getFileObject("Beans");
        if (foClassTemplates == null) {
            return;
        }
        FileObject foBiTemplate = null;
        foBiTemplate = iconBlock ? foClassTemplates.getFileObject(BEANINFO_NAME_EXT, "java") : foClassTemplates.getFileObject("NoIconBeanInfo", "java");
        if (foBiTemplate == null) {
            return;
        }
        try {
            DataObject doBiTemplate = DataObject.find((FileObject)foBiTemplate);
            DataFolder folder = this.javaDataObject.getFolder();
            this.biDataObject = doBiTemplate.createFromTemplate(folder, this.javaDataObject.getName() + BEANINFO_NAME_EXT);
            if (!(this.biDataObject instanceof BIDataObject)) {
                try {
                    this.biDataObject.setValid(false);
                }
                catch (PropertyVetoException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                this.biDataObject = DataObject.find((FileObject)this.biDataObject.getPrimaryFile());
            }
            this.javaEditor = (BIEditorSupport)((Object)this.biDataObject.getLookup().lookup(BIEditorSupport.class));
        }
        catch (DataObjectNotFoundException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    DataObject getDataObject() {
        return this.biDataObject;
    }

    DataObject getSourceDataObject() {
        return this.javaDataObject;
    }

    void open() {
        this.javaEditor.open();
    }

    void setDescriptorSection(String header, String bottom) {
        this.setInteriorSection(DESCRIPTOR_SECTION, header, bottom);
    }

    String getDescriptorSection() {
        GuardedSectionManager guards = this.javaEditor.getGuardedSectionManager();
        InteriorSection is = guards.findInteriorSection(DESCRIPTOR_SECTION);
        if (is != null) {
            return is.getText();
        }
        return null;
    }

    void setPropertiesSection(String header, String bottom) {
        this.setInteriorSection(PROPERTIES_SECTION, header, bottom);
    }

    String getPropertiesSection() {
        return this.getInteriorSection(PROPERTIES_SECTION);
    }

    void setMethodsSection(String header, String bottom) {
        this.setInteriorSection(METHODS_SECTION, header, bottom);
    }

    String getMethodsSection() {
        return this.getInteriorSection(METHODS_SECTION);
    }

    void setEventSetsSection(String header, String bottom) {
        this.setInteriorSection(EVENTSETS_SECTION, header, bottom);
    }

    String getEventSetsSection() {
        return this.getInteriorSection(EVENTSETS_SECTION);
    }

    String getIconsSection() {
        return this.getSimpleSection(ICONS_SECTION);
    }

    void setIconsSection(String text) {
        this.setSimpleSection(ICONS_SECTION, text);
    }

    String getDefaultIdxSection() {
        return this.getSimpleSection(IDX_SECTION);
    }

    void setDefaultIdxSection(String text) {
        this.setSimpleSection(IDX_SECTION, text);
    }

    void setSuperclassSection(String header, String bottom) {
        this.setInteriorSection(SUPERCLASS_SECTION, header, bottom);
    }

    String getSuperclassSection() {
        return this.getInteriorSection(SUPERCLASS_SECTION);
    }

    private void setInteriorSection(String section, String header, String bottom) {
        GuardedSectionManager guards = this.javaEditor.getGuardedSectionManager();
        if (guards == null) {
            return;
        }
        InteriorSection is = guards.findInteriorSection(section);
        if (is != null) {
            is.setHeader(header);
            is.setFooter(bottom);
        }
    }

    private String getInteriorSection(String section) {
        GuardedSectionManager guards = this.javaEditor.getGuardedSectionManager();
        if (guards == null) {
            return null;
        }
        InteriorSection is = guards.findInteriorSection(section);
        return is == null ? null : is.getText();
    }

    private void setSimpleSection(String section, String text) {
        GuardedSectionManager guards = this.javaEditor.getGuardedSectionManager();
        if (guards == null) {
            return;
        }
        SimpleSection ss = guards.findSimpleSection(section);
        if (ss != null) {
            ss.setText(text);
        }
    }

    private String getSimpleSection(String section) {
        GuardedSectionManager guards = this.javaEditor.getGuardedSectionManager();
        if (guards == null) {
            return null;
        }
        SimpleSection ss = guards.findSimpleSection(section);
        return ss == null ? null : ss.getText();
    }
}

