/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.ejb;

import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.output.TestOutputObserver;
import org.netbeans.modules.maven.api.problem.ProblemReport;
import org.netbeans.modules.maven.api.problem.ProblemReporter;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.Dependency;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Repository;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class EjbTestOutputObserver
implements TestOutputObserver {
    private Pattern ejbContainerPattern = Pattern.compile("java.lang.ClassFormatError: Absent Code attribute in method that is not native or abstract in class file javax/ejb/embeddable/EJBContainer[\\s]*");

    public void processLine(String string, Project project) {
        ProblemReporter problemReporter;
        Matcher matcher = this.ejbContainerPattern.matcher(string);
        if (matcher.matches() && project != null && (problemReporter = (ProblemReporter)project.getLookup().lookup(ProblemReporter.class)) != null) {
            ProblemReport problemReport = new ProblemReport(0, NbBundle.getMessage(EjbTestOutputObserver.class, (String)"MSG_MissingEmbeddableContainer"), NbBundle.getMessage(EjbTestOutputObserver.class, (String)"MSG_MissingEmbeddableContainerDesc"), (Action)new ResolveEjbContainerAction(project));
            problemReporter.addReport(problemReport);
        }
    }

    private static class ResolveEjbContainerAction
    extends AbstractAction {
        private Project prj;

        private ResolveEjbContainerAction(Project project) {
            this.prj = project;
            this.putValue("Name", NbBundle.getMessage(EjbTestOutputObserver.class, (String)"LBL_AddEmbeddableContainer"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                boolean bl = this.addPomToTestScope(new URL("http://download.java.net/maven/glassfish/org/glassfish/extras/glassfish-embedded-all/3.0/glassfish-embedded-all-3.0.pom"));
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
            }
        }

        private boolean addPomToTestScope(final URL uRL) {
            final Boolean[] booleanArray = new Boolean[1];
            ModelOperation<POMModel> modelOperation = new ModelOperation<POMModel>(){

                public void performOperation(POMModel pOMModel) {
                    booleanArray[0] = ResolveEjbContainerAction.this.checkAndAddPom(uRL, pOMModel, "test", null, null);
                }
            };
            FileObject fileObject = this.prj.getProjectDirectory().getFileObject("pom.xml");
            Utilities.performPOMModelOperations((FileObject)fileObject, Collections.singletonList(modelOperation));
            if (booleanArray[0].booleanValue()) {
                ((NbMavenProject)this.prj.getLookup().lookup(NbMavenProject.class)).triggerDependencyDownload();
            }
            return booleanArray[0];
        }

        private boolean checkAndAddPom(URL uRL, POMModel pOMModel, String string, String string2, String string3) {
            Set set = RepositoryPreferences.getInstance().getKnownRepositoryUrls();
            ModelUtils.LibraryDescriptor libraryDescriptor = ModelUtils.checkLibrary((URL)uRL, (Set)set);
            if (libraryDescriptor != null) {
                Repository repository;
                NbMavenProject nbMavenProject;
                Dependency dependency = ModelUtils.checkModelDependency((POMModel)pOMModel, (String)libraryDescriptor.getGroupId(), (String)libraryDescriptor.getArtifactId(), (boolean)true);
                dependency.setVersion(libraryDescriptor.getVersion());
                if (string != null) {
                    dependency.setScope(string);
                }
                if (libraryDescriptor.getClassifier() != null) {
                    dependency.setClassifier(libraryDescriptor.getClassifier());
                }
                if ((nbMavenProject = (NbMavenProject)this.prj.getLookup().lookup(NbMavenProject.class)) != null && (repository = ModelUtils.addModelRepository((MavenProject)nbMavenProject.getMavenProject(), (POMModel)pOMModel, (String)libraryDescriptor.getRepoRoot())) != null) {
                    if (string2 == null) {
                        string2 = libraryDescriptor.getRepoRoot();
                    }
                    repository.setId(string2);
                    repository.setLayout(libraryDescriptor.getRepoType());
                    repository.setName(string3);
                }
                return true;
            }
            return false;
        }
    }
}

