/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.util;

import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.StepRequest;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.logging.Logger;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.IllegalThreadStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocatableWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MirrorWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.ClassPrepareEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.ClassUnloadEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.EventQueueWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.EventSetWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.LocatableEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.ThreadDeathEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.ThreadStartEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.StepRequestWrapper;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.openide.util.RequestProcessor;

public class Operator {
    private static Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.jdievents");
    public static final String SILENT_EVENT_PROPERTY = "silent";
    private Thread thread;
    private final Set<ThreadReference> methodInvokingThreads = new HashSet<ThreadReference>();
    private boolean stop;
    private boolean canInterrupt;
    private JPDADebuggerImpl debugger;
    private RequestProcessor eventHandler;
    private Map<ThreadReference, HandlerTask> eventHandlers = new HashMap<ThreadReference, HandlerTask>();
    private final List<EventSet> parallelEvents = new LinkedList<EventSet>();

    public Operator(VirtualMachine virtualMachine, final JPDADebuggerImpl jPDADebuggerImpl, Executor executor, Runnable runnable, ReadWriteLock readWriteLock) {
        EventQueue eventQueue;
        try {
            eventQueue = VirtualMachineWrapper.eventQueue(virtualMachine);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            eventQueue = null;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            eventQueue = null;
        }
        if (eventQueue == null) {
            throw new NullPointerException();
        }
        this.debugger = jPDADebuggerImpl;
        final Object[] objectArray = new Object[]{eventQueue, executor, runnable};
        this.thread = new Thread(new Runnable(){

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[TRYBLOCK]], but top level block is 8[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        }, "Debugger operator thread");
    }

    private static final ThreadReference getEventThread(Event event) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        ThreadReference threadReference = null;
        if (event instanceof LocatableEvent) {
            threadReference = LocatableEventWrapper.thread((LocatableEvent)event);
        } else if (event instanceof ClassPrepareEvent) {
            threadReference = ClassPrepareEventWrapper.thread((ClassPrepareEvent)event);
        } else if (event instanceof ThreadStartEvent) {
            threadReference = ThreadStartEventWrapper.thread((ThreadStartEvent)event);
        } else if (event instanceof ThreadDeathEvent) {
            threadReference = ThreadDeathEventWrapper.thread((ThreadDeathEvent)event);
        }
        return threadReference;
    }

    public void start() {
        this.thread.start();
    }

    public synchronized void register(EventRequest eventRequest, Executor executor) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        EventRequestWrapper.putProperty(eventRequest, "executor", executor);
    }

    public synchronized void unregister(EventRequest eventRequest) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        Executor executor = (Executor)EventRequestWrapper.getProperty(eventRequest, "executor");
        EventRequestWrapper.putProperty(eventRequest, "executor", null);
        if (executor != null) {
            executor.removed(eventRequest);
        }
        if (eventRequest instanceof StepRequest) {
            ThreadReference threadReference = StepRequestWrapper.thread((StepRequest)eventRequest);
            this.debugger.getThread(threadReference).setInStep(false, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Operator operator = this;
        synchronized (operator) {
            if (this.stop) {
                return;
            }
            this.stop = true;
            if (this.canInterrupt) {
                this.thread.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startEventHandlerThreadFor(final ThreadReference threadReference) {
        final Thread[] threadArray = this;
        synchronized (this) {
            if (this.eventHandler == null) {
                this.eventHandler = new RequestProcessor("Debugger Event Handler", 10);
            }
            RequestProcessor requestProcessor = this.eventHandler;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            threadArray = new Thread[]{null};
            RequestProcessor.Task task = requestProcessor.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                @Override
                public void run() {
                    Object object = threadArray;
                    synchronized (threadArray) {
                        threadArray[0] = Thread.currentThread();
                        threadArray.notifyAll();
                        // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
                        try {
                            object = VirtualMachineWrapper.eventQueue(MirrorWrapper.virtualMachine(threadReference));
                        }
                        catch (InternalExceptionWrapper internalExceptionWrapper) {
                            return;
                        }
                        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                            return;
                        }
                        while (true) {
                            try {
                                EventSet eventSet = EventQueueWrapper.remove((EventQueue)object);
                                HashSet hashSet = new HashSet();
                                if (Operator.this.testIgnoreEvent(eventSet, hashSet)) {
                                    eventSet.resume();
                                    continue;
                                }
                                List list = Operator.this.parallelEvents;
                                synchronized (list) {
                                    Operator.this.parallelEvents.add(eventSet);
                                    continue;
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                return;
                            }
                            catch (InternalExceptionWrapper internalExceptionWrapper) {
                                continue;
                            }
                            break;
                        }
                        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                            return;
                        }
                    }
                }
            }, 500);
            this.eventHandlers.put(threadReference, new HandlerTask(task, threadArray));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyMethodInvoking(ThreadReference threadReference) {
        if (Thread.currentThread() == this.thread) {
            this.startEventHandlerThreadFor(threadReference);
        }
        Set<ThreadReference> set = this.methodInvokingThreads;
        synchronized (set) {
            this.methodInvokingThreads.add(threadReference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyMethodInvokeDone(ThreadReference threadReference) {
        Object object;
        if (Thread.currentThread() == this.thread && (object = this.eventHandlers.remove(threadReference)) != null) {
            ((HandlerTask)object).cancel();
        }
        object = this.methodInvokingThreads;
        synchronized (object) {
            this.methodInvokingThreads.remove(threadReference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testIgnoreEvent(EventSet eventSet, Set<ThreadReference> set) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        int n;
        ThreadReference threadReference = null;
        for (Object object : eventSet) {
            if (!(object instanceof LocatableEvent)) continue;
            threadReference = LocatableEventWrapper.thread((LocatableEvent)object);
        }
        if (threadReference != null) {
            Set<ThreadReference> set2 = this.methodInvokingThreads;
            synchronized (set2) {
                if (this.methodInvokingThreads.contains(threadReference)) {
                    return true;
                }
            }
        }
        if ((n = EventSetWrapper.suspendPolicy(eventSet)) == 2) {
            Object object;
            object = this.methodInvokingThreads;
            synchronized (object) {
                for (ThreadReference threadReference2 : this.methodInvokingThreads) {
                    try {
                        ThreadReferenceWrapper.resume(threadReference2);
                        set.add(threadReference2);
                    }
                    catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                    }
                    catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {}
                }
            }
        }
        return false;
    }

    private void printEvent(Event event, Executor executor) {
        try {
            if (event instanceof ClassPrepareEvent) {
                logger.fine("JDI EVENT: ClassPrepareEvent " + ClassPrepareEventWrapper.referenceType((ClassPrepareEvent)event));
            } else if (event instanceof ClassUnloadEvent) {
                logger.fine("JDI EVENT: ClassUnloadEvent " + ClassUnloadEventWrapper.className((ClassUnloadEvent)event));
            } else if (event instanceof ThreadStartEvent) {
                try {
                    logger.fine("JDI EVENT: ThreadStartEvent " + ThreadStartEventWrapper.thread((ThreadStartEvent)event));
                }
                catch (Exception exception) {
                    logger.fine("JDI EVENT: ThreadStartEvent1 " + event);
                }
            } else if (event instanceof ThreadDeathEvent) {
                try {
                    logger.fine("JDI EVENT: ThreadDeathEvent " + ThreadDeathEventWrapper.thread((ThreadDeathEvent)event));
                }
                catch (Exception exception) {
                    logger.fine("JDI EVENT: ThreadDeathEvent1 " + event);
                }
            } else if (event instanceof MethodEntryEvent) {
                try {
                    logger.fine("JDI EVENT: MethodEntryEvent " + event);
                }
                catch (Exception exception) {
                    logger.fine("JDI EVENT: MethodEntryEvent " + event);
                }
            } else if (event instanceof BreakpointEvent) {
                logger.fine("JDI EVENT: BreakpointEvent " + LocatableEventWrapper.thread((BreakpointEvent)event) + " : " + LocatableWrapper.location((BreakpointEvent)event));
            } else if (event instanceof StepEvent) {
                logger.fine("JDI EVENT: StepEvent " + LocatableEventWrapper.thread((StepEvent)event) + " : " + LocatableWrapper.location((StepEvent)event));
            } else {
                logger.fine("JDI EVENT: " + event + " : " + executor);
            }
        }
        catch (Exception exception) {
            logger.fine(exception.getLocalizedMessage());
        }
    }

    static /* synthetic */ boolean access$100(Operator operator) {
        return operator.stop;
    }

    static /* synthetic */ boolean access$202(Operator operator, boolean bl) {
        operator.canInterrupt = bl;
        return operator.canInterrupt;
    }

    static /* synthetic */ Logger access$300() {
        return logger;
    }

    static /* synthetic */ ThreadReference access$400(Event event) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        return Operator.getEventThread(event);
    }

    static /* synthetic */ void access$600(Operator operator, Event event, Executor executor) {
        operator.printEvent(event, executor);
    }

    static /* synthetic */ boolean access$102(Operator operator, boolean bl) {
        operator.stop = bl;
        return operator.stop;
    }

    private static final class HandlerTask {
        private RequestProcessor.Task task;
        private Thread[] threadPtr;

        HandlerTask(RequestProcessor.Task task, Thread[] threadArray) {
            this.task = task;
            this.threadPtr = threadArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void cancel() {
            if (this.task.cancel()) return;
            Object object = this.threadPtr;
            synchronized (this.threadPtr) {
                if (this.threadPtr[0] == null) {
                    try {
                        this.threadPtr.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                object = this.threadPtr[0];
                if (object == null) return;
                ((Thread)object).interrupt();
                this.task.waitFinished();
                return;
            }
        }
    }
}

