/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.jdi;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.debugger.jpda.JDIExceptionReporter;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.IllegalArgumentExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.UnsupportedOperationExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class ObjectReferenceWrapper {
    private ObjectReferenceWrapper() {
    }

    public static void disableCollection(ObjectReference objectReference) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, UnsupportedOperationExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ObjectReference", "disableCollection", "JDI CALL: com.sun.jdi.ObjectReference({0}).disableCollection()", new Object[]{objectReference});
        }
        try {
            objectReference.disableCollection();
        }
        catch (InternalException internalException) {
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
        catch (ObjectCollectedException objectCollectedException) {
            throw new ObjectCollectedExceptionWrapper(objectCollectedException);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new UnsupportedOperationExceptionWrapper(unsupportedOperationException);
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ObjectReference", "disableCollection", JDIExceptionReporter.RET_VOID);
            }
        }
    }

    public static void enableCollection(ObjectReference objectReference) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, UnsupportedOperationExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ObjectReference", "enableCollection", "JDI CALL: com.sun.jdi.ObjectReference({0}).enableCollection()", new Object[]{objectReference});
        }
        try {
            objectReference.enableCollection();
        }
        catch (InternalException internalException) {
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
        catch (ObjectCollectedException objectCollectedException) {
            throw new ObjectCollectedExceptionWrapper(objectCollectedException);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new UnsupportedOperationExceptionWrapper(unsupportedOperationException);
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ObjectReference", "enableCollection", JDIExceptionReporter.RET_VOID);
            }
        }
    }

    public static int entryCount0(ObjectReference objectReference) throws IncompatibleThreadStateException {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ObjectReference", "entryCount", "JDI CALL: com.sun.jdi.ObjectReference({0}).entryCount()", new Object[]{objectReference});
        }
        Serializable serializable = null;
        try {
            int n = objectReference.entryCount();
            serializable = Integer.valueOf(n);
            int n2 = n;
            return n2;
        }
        catch (InternalException internalException) {
            serializable = internalException;
            JDIExceptionReporter.report(internalException);
            int n = 0;
            return n;
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            serializable = vMDisconnectedException;
            int n = 0;
            return n;
        }
        catch (ObjectCollectedException objectCollectedException) {
            serializable = objectCollectedException;
            int n = 0;
            return n;
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            serializable = incompatibleThreadStateException;
            throw incompatibleThreadStateException;
        }
        catch (Error error) {
            serializable = error;
            throw error;
        }
        catch (RuntimeException runtimeException) {
            serializable = runtimeException;
            throw runtimeException;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ObjectReference", "entryCount", serializable);
            }
        }
    }

    public static int entryCount(ObjectReference objectReference) throws IncompatibleThreadStateException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ObjectReference", "entryCount", "JDI CALL: com.sun.jdi.ObjectReference({0}).entryCount()", new Object[]{objectReference});
        }
        Serializable serializable = null;
        try {
            int n = objectReference.entryCount();
            serializable = Integer.valueOf(n);
            int n2 = n;
            return n2;
        }
        catch (InternalException internalException) {
            serializable = internalException;
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            serializable = vMDisconnectedException;
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
        catch (ObjectCollectedException objectCollectedException) {
            serializable = objectCollectedException;
            throw new ObjectCollectedExceptionWrapper(objectCollectedException);
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            serializable = incompatibleThreadStateException;
            throw incompatibleThreadStateException;
        }
        catch (Error error) {
            serializable = error;
            throw error;
        }
        catch (RuntimeException runtimeException) {
            serializable = runtimeException;
            throw runtimeException;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ObjectReference", "entryCount", serializable);
            }
        }
    }

    public static boolean equals0(ObjectReference objectReference, Object object) {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ObjectReference", "equals", "JDI CALL: com.sun.jdi.ObjectReference({0}).equals({1})", new Object[]{objectReference, object});
        }
        Serializable serializable = null;
        try {
            boolean bl = ((Object)objectReference).equals(object);
            serializable = Boolean.valueOf(bl);
            boolean bl2 = bl;
            return bl2;
        }
        catch (InternalException internalException) {
            serializable = internalException;
            JDIExceptionReporter.report(internalException);
            boolean bl = false;
            return bl;
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            serializable = vMDisconnectedException;
            boolean bl = false;
            return bl;
        }
        catch (ObjectCollectedException objectCollectedException) {
            serializable = objectCollectedException;
            boolean bl = false;
            return bl;
        }
        catch (Error error) {
            serializable = error;
            throw error;
        }
        catch (RuntimeException runtimeException) {
            serializable = runtimeException;
            throw runtimeException;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ObjectReference", "equals", serializable);
            }
        }
    }

    public static boolean equals(ObjectReference objectReference, Object object) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ObjectReference", "equals", "JDI CALL: com.sun.jdi.ObjectReference({0}).equals({1})", new Object[]{objectReference, object});
        }
        Serializable serializable = null;
        try {
            boolean bl = ((Object)objectReference).equals(object);
            serializable = Boolean.valueOf(bl);
            boolean bl2 = bl;
            return bl2;
        }
        catch (InternalException internalException) {
            serializable = internalException;
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            serializable = vMDisconnectedException;
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
        catch (ObjectCollectedException objectCollectedException) {
            serializable = objectCollectedException;
            throw new ObjectCollectedExceptionWrapper(objectCollectedException);
        }
        catch (Error error) {
            serializable = error;
            throw error;
        }
        catch (RuntimeException runtimeException) {
            serializable = runtimeException;
            throw runtimeException;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ObjectReference", "equals", serializable);
            }
        }
    }

    public static Value getValue(ObjectReference objectReference, Field field) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ObjectReference", "getValue", "JDI CALL: com.sun.jdi.ObjectReference({0}).getValue({1})", new Object[]{objectReference, field});
        }
        Object object = null;
        try {
            Value value = objectReference.getValue(field);
            object = value;
            Value value2 = value;
            return value2;
        }
        catch (InternalException internalException) {
            object = internalException;
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            object = vMDisconnectedException;
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
        catch (ObjectCollectedException objectCollectedException) {
            object = objectCollectedException;
            throw new ObjectCollectedExceptionWrapper(objectCollectedException);
        }
        catch (Error error) {
            object = error;
            throw error;
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            throw runtimeException;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ObjectReference", "getValue", object);
            }
        }
    }

    public static Map<Field, Value> getValues0(ObjectReference objectReference, List<? extends Field> list) {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ObjectReference", "getValues", "JDI CALL: com.sun.jdi.ObjectReference({0}).getValues({1})", new Object[]{objectReference, list});
        }
        Object object = null;
        try {
            Map<Field, Value> map = objectReference.getValues(list);
            object = map;
            Map<Field, Value> map2 = map;
            return map2;
        }
        catch (InternalException internalException) {
            object = internalException;
            JDIExceptionReporter.report(internalException);
            Map<Field, Value> map = Collections.emptyMap();
            return map;
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            object = vMDisconnectedException;
            Map<Field, Value> map = Collections.emptyMap();
            return map;
        }
        catch (ObjectCollectedException objectCollectedException) {
            object = objectCollectedException;
            Map<Field, Value> map = Collections.emptyMap();
            return map;
        }
        catch (Error error) {
            object = error;
            throw error;
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            throw runtimeException;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ObjectReference", "getValues", object);
            }
        }
    }

    public static Map<Field, Value> getValues(ObjectReference objectReference, List<? extends Field> list) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ObjectReference", "getValues", "JDI CALL: com.sun.jdi.ObjectReference({0}).getValues({1})", new Object[]{objectReference, list});
        }
        Object object = null;
        try {
            Map<Field, Value> map = objectReference.getValues(list);
            object = map;
            Map<Field, Value> map2 = map;
            return map2;
        }
        catch (InternalException internalException) {
            object = internalException;
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            object = vMDisconnectedException;
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
        catch (ObjectCollectedException objectCollectedException) {
            object = objectCollectedException;
            throw new ObjectCollectedExceptionWrapper(objectCollectedException);
        }
        catch (Error error) {
            object = error;
            throw error;
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            throw runtimeException;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ObjectReference", "getValues", object);
            }
        }
    }

    public static int hashCode0(ObjectReference objectReference) {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ObjectReference", "hashCode", "JDI CALL: com.sun.jdi.ObjectReference({0}).hashCode()", new Object[]{objectReference});
        }
        Serializable serializable = null;
        try {
            int n = ((Object)objectReference).hashCode();
            serializable = Integer.valueOf(n);
            int n2 = n;
            return n2;
        }
        catch (InternalException internalException) {
            serializable = internalException;
            JDIExceptionReporter.report(internalException);
            int n = 0;
            return n;
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            serializable = vMDisconnectedException;
            int n = 0;
            return n;
        }
        catch (ObjectCollectedException objectCollectedException) {
            serializable = objectCollectedException;
            int n = 0;
            return n;
        }
        catch (Error error) {
            serializable = error;
            throw error;
        }
        catch (RuntimeException runtimeException) {
            serializable = runtimeException;
            throw runtimeException;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ObjectReference", "hashCode", serializable);
            }
        }
    }

    public static int hashCode(ObjectReference objectReference) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ObjectReference", "hashCode", "JDI CALL: com.sun.jdi.ObjectReference({0}).hashCode()", new Object[]{objectReference});
        }
        Serializable serializable = null;
        try {
            int n = ((Object)objectReference).hashCode();
            serializable = Integer.valueOf(n);
            int n2 = n;
            return n2;
        }
        catch (InternalException internalException) {
            serializable = internalException;
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            serializable = vMDisconnectedException;
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
        catch (ObjectCollectedException objectCollectedException) {
            serializable = objectCollectedException;
            throw new ObjectCollectedExceptionWrapper(objectCollectedException);
        }
        catch (Error error) {
            serializable = error;
            throw error;
        }
        catch (RuntimeException runtimeException) {
            serializable = runtimeException;
            throw runtimeException;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ObjectReference", "hashCode", serializable);
            }
        }
    }

    public static Value invokeMethod(ObjectReference objectReference, ThreadReference threadReference, Method method, List<? extends Value> list, int n) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ObjectReference", "invokeMethod", "JDI CALL: com.sun.jdi.ObjectReference({0}).invokeMethod({1}, {2}, {3}, {4})", new Object[]{objectReference, threadReference, method, list, n});
        }
        Object object = null;
        try {
            Value value = objectReference.invokeMethod(threadReference, method, list, n);
            object = value;
            Value value2 = value;
            return value2;
        }
        catch (InternalException internalException) {
            if (internalException.errorCode() == 502) {
                InternalException internalException2 = (InternalException)Exceptions.attachLocalizedMessage((Throwable)internalException, (String)NbBundle.getMessage(JPDADebuggerImpl.class, (String)"JDWPError502"));
                Exceptions.printStackTrace((Throwable)internalException2);
                Value value = null;
                return value;
            }
            try {
                throw internalException;
            }
            catch (InternalException internalException3) {
                object = internalException3;
                JDIExceptionReporter.report(internalException3);
                throw new InternalExceptionWrapper(internalException3);
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                object = vMDisconnectedException;
                throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
            }
            catch (ObjectCollectedException objectCollectedException) {
                object = objectCollectedException;
                throw new ObjectCollectedExceptionWrapper(objectCollectedException);
            }
            catch (InvalidTypeException invalidTypeException) {
                object = invalidTypeException;
                throw invalidTypeException;
            }
            catch (ClassNotLoadedException classNotLoadedException) {
                object = classNotLoadedException;
                throw classNotLoadedException;
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                object = incompatibleThreadStateException;
                throw incompatibleThreadStateException;
            }
            catch (InvocationException invocationException) {
                object = invocationException;
                throw invocationException;
            }
            catch (Error error) {
                object = error;
                throw error;
            }
            catch (RuntimeException runtimeException) {
                object = runtimeException;
                throw runtimeException;
            }
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ObjectReference", "invokeMethod", object);
            }
        }
    }

    public static boolean isCollected0(ObjectReference objectReference) {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ObjectReference", "isCollected", "JDI CALL: com.sun.jdi.ObjectReference({0}).isCollected()", new Object[]{objectReference});
        }
        Serializable serializable = null;
        try {
            boolean bl = objectReference.isCollected();
            serializable = Boolean.valueOf(bl);
            boolean bl2 = bl;
            return bl2;
        }
        catch (InternalException internalException) {
            serializable = internalException;
            JDIExceptionReporter.report(internalException);
            boolean bl = false;
            return bl;
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            serializable = vMDisconnectedException;
            boolean bl = false;
            return bl;
        }
        catch (ObjectCollectedException objectCollectedException) {
            serializable = objectCollectedException;
            boolean bl = false;
            return bl;
        }
        catch (Error error) {
            serializable = error;
            throw error;
        }
        catch (RuntimeException runtimeException) {
            serializable = runtimeException;
            throw runtimeException;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ObjectReference", "isCollected", serializable);
            }
        }
    }

    public static boolean isCollected(ObjectReference objectReference) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ObjectReference", "isCollected", "JDI CALL: com.sun.jdi.ObjectReference({0}).isCollected()", new Object[]{objectReference});
        }
        Serializable serializable = null;
        try {
            boolean bl = objectReference.isCollected();
            serializable = Boolean.valueOf(bl);
            boolean bl2 = bl;
            return bl2;
        }
        catch (InternalException internalException) {
            serializable = internalException;
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            serializable = vMDisconnectedException;
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
        catch (ObjectCollectedException objectCollectedException) {
            serializable = objectCollectedException;
            throw new ObjectCollectedExceptionWrapper(objectCollectedException);
        }
        catch (Error error) {
            serializable = error;
            throw error;
        }
        catch (RuntimeException runtimeException) {
            serializable = runtimeException;
            throw runtimeException;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ObjectReference", "isCollected", serializable);
            }
        }
    }

    public static ThreadReference owningThread(ObjectReference objectReference) throws IncompatibleThreadStateException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ObjectReference", "owningThread", "JDI CALL: com.sun.jdi.ObjectReference({0}).owningThread()", new Object[]{objectReference});
        }
        Object object = null;
        try {
            ThreadReference threadReference = objectReference.owningThread();
            object = threadReference;
            ThreadReference threadReference2 = threadReference;
            return threadReference2;
        }
        catch (InternalException internalException) {
            object = internalException;
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            object = vMDisconnectedException;
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
        catch (ObjectCollectedException objectCollectedException) {
            object = objectCollectedException;
            throw new ObjectCollectedExceptionWrapper(objectCollectedException);
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            object = incompatibleThreadStateException;
            throw incompatibleThreadStateException;
        }
        catch (Error error) {
            object = error;
            throw error;
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            throw runtimeException;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ObjectReference", "owningThread", object);
            }
        }
    }

    public static ReferenceType referenceType(ObjectReference objectReference) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ObjectReference", "referenceType", "JDI CALL: com.sun.jdi.ObjectReference({0}).referenceType()", new Object[]{objectReference});
        }
        Object object = null;
        try {
            ReferenceType referenceType = objectReference.referenceType();
            object = referenceType;
            ReferenceType referenceType2 = referenceType;
            return referenceType2;
        }
        catch (InternalException internalException) {
            object = internalException;
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            object = vMDisconnectedException;
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
        catch (ObjectCollectedException objectCollectedException) {
            object = objectCollectedException;
            throw new ObjectCollectedExceptionWrapper(objectCollectedException);
        }
        catch (Error error) {
            object = error;
            throw error;
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            throw runtimeException;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ObjectReference", "referenceType", object);
            }
        }
    }

    public static List<ObjectReference> referringObjects0(ObjectReference objectReference, long l) {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ObjectReference", "referringObjects", "JDI CALL: com.sun.jdi.ObjectReference({0}).referringObjects({1})", new Object[]{objectReference, l});
        }
        Object object = null;
        try {
            List<ObjectReference> list = objectReference.referringObjects(l);
            object = list;
            List<ObjectReference> list2 = list;
            return list2;
        }
        catch (InternalException internalException) {
            object = internalException;
            JDIExceptionReporter.report(internalException);
            List<ObjectReference> list = Collections.emptyList();
            return list;
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            object = vMDisconnectedException;
            List<ObjectReference> list = Collections.emptyList();
            return list;
        }
        catch (ObjectCollectedException objectCollectedException) {
            object = objectCollectedException;
            List<ObjectReference> list = Collections.emptyList();
            return list;
        }
        catch (Error error) {
            object = error;
            throw error;
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            throw runtimeException;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ObjectReference", "referringObjects", object);
            }
        }
    }

    public static List<ObjectReference> referringObjects(ObjectReference objectReference, long l) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ObjectReference", "referringObjects", "JDI CALL: com.sun.jdi.ObjectReference({0}).referringObjects({1})", new Object[]{objectReference, l});
        }
        Object object = null;
        try {
            List<ObjectReference> list = objectReference.referringObjects(l);
            object = list;
            List<ObjectReference> list2 = list;
            return list2;
        }
        catch (InternalException internalException) {
            object = internalException;
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            object = vMDisconnectedException;
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
        catch (ObjectCollectedException objectCollectedException) {
            object = objectCollectedException;
            throw new ObjectCollectedExceptionWrapper(objectCollectedException);
        }
        catch (Error error) {
            object = error;
            throw error;
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            throw runtimeException;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ObjectReference", "referringObjects", object);
            }
        }
    }

    public static void setValue(ObjectReference objectReference, Field field, Value value) throws InvalidTypeException, ClassNotLoadedException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, IllegalArgumentExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ObjectReference", "setValue", "JDI CALL: com.sun.jdi.ObjectReference({0}).setValue({1}, {2})", new Object[]{objectReference, field, value});
        }
        try {
            objectReference.setValue(field, value);
        }
        catch (InternalException internalException) {
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
        catch (ObjectCollectedException objectCollectedException) {
            throw new ObjectCollectedExceptionWrapper(objectCollectedException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentExceptionWrapper(illegalArgumentException);
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ObjectReference", "setValue", JDIExceptionReporter.RET_VOID);
            }
        }
    }

    public static long uniqueID(ObjectReference objectReference) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ObjectReference", "uniqueID", "JDI CALL: com.sun.jdi.ObjectReference({0}).uniqueID()", new Object[]{objectReference});
        }
        Serializable serializable = null;
        try {
            long l = objectReference.uniqueID();
            serializable = Long.valueOf(l);
            long l2 = l;
            return l2;
        }
        catch (InternalException internalException) {
            serializable = internalException;
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            serializable = vMDisconnectedException;
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
        catch (ObjectCollectedException objectCollectedException) {
            serializable = objectCollectedException;
            throw new ObjectCollectedExceptionWrapper(objectCollectedException);
        }
        catch (Error error) {
            serializable = error;
            throw error;
        }
        catch (RuntimeException runtimeException) {
            serializable = runtimeException;
            throw runtimeException;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ObjectReference", "uniqueID", serializable);
            }
        }
    }

    public static List<ThreadReference> waitingThreads0(ObjectReference objectReference) throws IncompatibleThreadStateException {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ObjectReference", "waitingThreads", "JDI CALL: com.sun.jdi.ObjectReference({0}).waitingThreads()", new Object[]{objectReference});
        }
        Object object = null;
        try {
            List<ThreadReference> list = objectReference.waitingThreads();
            object = list;
            List<ThreadReference> list2 = list;
            return list2;
        }
        catch (InternalException internalException) {
            object = internalException;
            JDIExceptionReporter.report(internalException);
            List<ThreadReference> list = Collections.emptyList();
            return list;
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            object = vMDisconnectedException;
            List<ThreadReference> list = Collections.emptyList();
            return list;
        }
        catch (ObjectCollectedException objectCollectedException) {
            object = objectCollectedException;
            List<ThreadReference> list = Collections.emptyList();
            return list;
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            object = incompatibleThreadStateException;
            throw incompatibleThreadStateException;
        }
        catch (Error error) {
            object = error;
            throw error;
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            throw runtimeException;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ObjectReference", "waitingThreads", object);
            }
        }
    }

    public static List<ThreadReference> waitingThreads(ObjectReference objectReference) throws IncompatibleThreadStateException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ObjectReference", "waitingThreads", "JDI CALL: com.sun.jdi.ObjectReference({0}).waitingThreads()", new Object[]{objectReference});
        }
        Object object = null;
        try {
            List<ThreadReference> list = objectReference.waitingThreads();
            object = list;
            List<ThreadReference> list2 = list;
            return list2;
        }
        catch (InternalException internalException) {
            object = internalException;
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            object = vMDisconnectedException;
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
        catch (ObjectCollectedException objectCollectedException) {
            object = objectCollectedException;
            throw new ObjectCollectedExceptionWrapper(objectCollectedException);
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            object = incompatibleThreadStateException;
            throw incompatibleThreadStateException;
        }
        catch (Error error) {
            object = error;
            throw error;
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            throw runtimeException;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ObjectReference", "waitingThreads", object);
            }
        }
    }
}

