/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import com.sun.jdi.Mirror;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.ThreadDeathRequest;
import com.sun.jdi.request.ThreadStartRequest;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.ThreadBreakpoint;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.BreakpointImpl;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidRequestStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.ThreadDeathEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.ThreadStartEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestManagerWrapper;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.openide.util.Exceptions;

public class ThreadBreakpointImpl
extends BreakpointImpl
implements Executor {
    private ThreadBreakpoint breakpoint;

    public ThreadBreakpointImpl(ThreadBreakpoint threadBreakpoint, JPDADebuggerImpl jPDADebuggerImpl, Session session) {
        super((JPDABreakpoint)threadBreakpoint, null, jPDADebuggerImpl, session);
        this.breakpoint = threadBreakpoint;
        this.set();
    }

    @Override
    protected void setRequests() {
        try {
            Mirror mirror;
            if ((this.breakpoint.getBreakpointType() & 1) != 0) {
                mirror = EventRequestManagerWrapper.createThreadStartRequest(this.getEventRequestManager());
                this.addEventRequest((EventRequest)mirror);
            }
            if ((this.breakpoint.getBreakpointType() & 2) != 0 && (mirror = this.getVirtualMachine()) != null) {
                ThreadDeathRequest threadDeathRequest = EventRequestManagerWrapper.createThreadDeathRequest(VirtualMachineWrapper.eventRequestManager((VirtualMachine)mirror));
                this.addEventRequest(threadDeathRequest);
            }
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
        }
        catch (InvalidRequestStateExceptionWrapper invalidRequestStateExceptionWrapper) {
            Exceptions.printStackTrace((Throwable)invalidRequestStateExceptionWrapper);
        }
    }

    @Override
    protected EventRequest createEventRequest(EventRequest eventRequest) throws VMDisconnectedExceptionWrapper, InternalExceptionWrapper {
        if (eventRequest instanceof ThreadStartRequest) {
            return EventRequestManagerWrapper.createThreadStartRequest(this.getEventRequestManager());
        }
        if (eventRequest instanceof ThreadDeathRequest) {
            return EventRequestManagerWrapper.createThreadDeathRequest(this.getEventRequestManager());
        }
        return null;
    }

    @Override
    public boolean processCondition(Event event) {
        return true;
    }

    @Override
    public boolean exec(Event event) {
        ThreadReference threadReference = null;
        try {
            if (event instanceof ThreadStartEvent) {
                threadReference = ThreadStartEventWrapper.thread((ThreadStartEvent)event);
            } else if (event instanceof ThreadDeathEvent) {
                threadReference = ThreadDeathEventWrapper.thread((ThreadDeathEvent)event);
            }
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return true;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return true;
        }
        return this.perform(event, threadReference, null, event instanceof ThreadDeathEvent ? null : threadReference);
    }

    @Override
    public void removed(EventRequest eventRequest) {
    }
}

