/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.java.lexer;

import org.netbeans.api.java.lexer.JavadocTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;

public class JavadocLexer
implements Lexer<JavadocTokenId> {
    private static final int EOF = -1;
    private LexerInput input;
    private TokenFactory<JavadocTokenId> tokenFactory;

    public JavadocLexer(LexerRestartInfo<JavadocTokenId> info) {
        this.input = info.input();
        this.tokenFactory = info.tokenFactory();
        assert (info.state() == null);
    }

    public Object state() {
        return null;
    }

    public Token<JavadocTokenId> nextToken() {
        int ch = this.input.read();
        if (ch == -1) {
            return null;
        }
        if (Character.isJavaIdentifierStart(ch)) {
            while (Character.isJavaIdentifierPart(this.input.read())) {
            }
            this.input.backup(1);
            return this.token(JavadocTokenId.IDENT);
        }
        if ("@<.#".indexOf(ch) == -1) {
            ch = this.input.read();
            while (!Character.isJavaIdentifierStart(ch) && "@<.#".indexOf(ch) == -1 && ch != -1) {
                ch = this.input.read();
            }
            if (ch != -1) {
                this.input.backup(1);
            }
            return this.token(JavadocTokenId.OTHER_TEXT);
        }
        switch (ch) {
            case 64: {
                while (Character.isLetter(ch = this.input.read())) {
                }
                this.input.backup(1);
                return this.tokenFactory.createToken((TokenId)JavadocTokenId.TAG, this.input.readLength());
            }
            case 60: {
                int backupCounter = 0;
                boolean newline = false;
                boolean asterisk = false;
                while (true) {
                    ch = this.input.read();
                    ++backupCounter;
                    if (ch == 62 || ch == -1) {
                        return this.token(JavadocTokenId.HTML_TAG);
                    }
                    if (ch == 60) {
                        this.input.backup(1);
                        return this.token(JavadocTokenId.HTML_TAG);
                    }
                    if (ch == 10) {
                        backupCounter = 1;
                        newline = true;
                        asterisk = false;
                        continue;
                    }
                    if (newline && ch == 64) {
                        this.input.backup(backupCounter);
                        return this.token(JavadocTokenId.HTML_TAG);
                    }
                    if (newline && !asterisk && ch == 42) {
                        asterisk = true;
                        continue;
                    }
                    if (!newline || Character.isWhitespace(ch)) continue;
                    newline = false;
                }
            }
            case 46: {
                return this.token(JavadocTokenId.DOT);
            }
            case 35: {
                return this.token(JavadocTokenId.HASH);
            }
        }
        assert (false);
        return null;
    }

    private Token<JavadocTokenId> token(JavadocTokenId id) {
        return this.tokenFactory.createToken((TokenId)id);
    }

    public void release() {
    }
}

