/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.cldcplatform.startup;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.netbeans.modules.mobility.cldcplatform.startup.SolarisRoutines;
import org.netbeans.modules.mobility.cldcplatform.startup.Util;
import org.openide.util.Utilities;

public class RunCommand {
    private final Runtime runTime = Runtime.getRuntime();
    protected boolean interrupted = false;
    protected Process thisProcess = null;
    protected String cmdString;
    private BufferedReader inputReader = null;
    private BufferedReader errorReader = null;
    protected OutputStream out = null;

    public void execute(String command) {
        this.execute(command, null, null);
    }

    public void execute(String command, String[] envp, File dir) {
        this.cmdString = command;
        try {
            this.thisProcess = this.runTime.exec(command, envp, dir);
            this.initIOStreams();
        }
        catch (Exception ex) {
            System.out.println(ex.getLocalizedMessage());
            ex.printStackTrace();
        }
    }

    public void execute(String[] cmdArray, String[] envp, File dir) {
        this.cmdString = Util.arrayToString(cmdArray, " ");
        try {
            this.thisProcess = this.runTime.exec(cmdArray, envp, dir);
            this.initIOStreams();
        }
        catch (Exception ex) {
            System.out.println(ex.getLocalizedMessage());
            ex.printStackTrace();
        }
    }

    public void initIOStreams() {
        this.interrupted = false;
        try {
            InputStream in = this.thisProcess.getInputStream();
            InputStream err = this.thisProcess.getErrorStream();
            this.out = this.thisProcess.getOutputStream();
            this.inputReader = new BufferedReader(new InputStreamReader(in));
            this.errorReader = new BufferedReader(new InputStreamReader(err));
        }
        catch (Exception ex) {
            System.out.println(ex.getLocalizedMessage());
            ex.printStackTrace();
        }
    }

    public void interrupt() {
        this.interrupted = true;
        if (Utilities.getOperatingSystem() == 256) {
            try {
                SolarisRoutines.killProcess(this.cmdString);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.thisProcess.destroy();
        this.thisProcess = null;
    }

    public int getReturnStatus() {
        if (this.interrupted) {
            return -1;
        }
        try {
            this.thisProcess.waitFor();
        }
        catch (Exception ex) {
            System.out.println(ex.getLocalizedMessage());
            ex.printStackTrace();
            return -2;
        }
        if (this.thisProcess != null) {
            return this.thisProcess.exitValue();
        }
        return -3;
    }

    public boolean isRunning() {
        try {
            this.thisProcess.exitValue();
        }
        catch (IllegalThreadStateException ie) {
            return true;
        }
        catch (Exception ie) {
            return false;
        }
        return false;
    }

    public BufferedReader getErrorReader() {
        return this.errorReader;
    }

    public BufferedReader getInputReader() {
        return this.inputReader;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public void flush() {
        try {
            if (!this.interrupted) {
                if (this.inputReader.ready()) {
                    while (this.inputReader.read() != -1) {
                    }
                }
                if (this.errorReader != null && this.errorReader.ready()) {
                    while (this.errorReader.read() != -1) {
                    }
                }
            }
        }
        catch (IOException ex) {
            System.out.println(ex.getLocalizedMessage());
            ex.printStackTrace();
        }
    }

    public String getOutputLine() {
        String ret = null;
        try {
            ret = this.inputReader.readLine();
            if (ret != null) {
                ret = ret + "\n";
            }
        }
        catch (IOException ex) {
            System.out.println(ex.getLocalizedMessage());
            ex.printStackTrace();
        }
        return ret;
    }

    public String getErrorLine() {
        String ret = null;
        try {
            ret = this.errorReader.readLine();
            if (ret != null) {
                ret = ret + "\n";
            }
        }
        catch (IOException ex) {
            System.out.println(ex.getLocalizedMessage());
            ex.printStackTrace();
        }
        return ret;
    }

    public void print() {
        String line = null;
        System.out.println("------------------------------  Command Print  -----------------------");
        System.out.println(" command: ");
        System.out.println("    " + this.cmdString);
        System.out.println(" Command Output:");
        while ((line = this.getOutputLine()) != null) {
            System.out.println("    " + line);
        }
        System.out.println(" Command Error:");
        while ((line = this.getErrorLine()) != null) {
            System.out.println("    " + line);
        }
        System.out.println(" Return Status: " + this.getReturnStatus());
        System.out.println("------------------------------------------------------------------------");
    }
}

