/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.util;

import com.sun.star.lib.util.StringHelper;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;

public final class UrlToFileMapper {
    private static Method urlEncoderEncode;
    private static Constructor<?> uriConstructor;
    private static Constructor<File> fileConstructor;

    public static File mapUrlToFile(URL uRL) {
        if (uRL == null) {
            return null;
        }
        if (fileConstructor == null) {
            return uRL.getProtocol().equalsIgnoreCase("file") && uRL.getAuthority() == null && uRL.getQuery() == null && uRL.getRef() == null ? new File(URLDecoder.decode(StringHelper.replace(uRL.getPath(), '+', "%2B"))) : null;
        }
        String string = UrlToFileMapper.encode(uRL.toString());
        try {
            Object obj = uriConstructor.newInstance(string);
            try {
                return fileConstructor.newInstance(obj);
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getTargetException() instanceof IllegalArgumentException) {
                    return null;
                }
                throw invocationTargetException;
            }
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException("This cannot happen: " + instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("This cannot happen: " + illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof Error) {
                throw (Error)invocationTargetException.getTargetException();
            }
            if (invocationTargetException.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)invocationTargetException.getTargetException();
            }
            throw new RuntimeException("This cannot happen: " + invocationTargetException);
        }
    }

    private static String encode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            String string2;
            char c = string.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= '?' && c <= '[' || c >= '$' && c <= ';' || c == '!' || c == '=' || c == ']' || c == '_' || c == '~') {
                stringBuffer.append(c);
                continue;
            }
            if (c == ' ') {
                stringBuffer.append("%20");
                continue;
            }
            try {
                string2 = (String)urlEncoderEncode.invoke(null, Character.toString(c), "UTF-8");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException("This cannot happen: " + illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException("This cannot happen: " + invocationTargetException);
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private UrlToFileMapper() {
    }

    static {
        try {
            urlEncoderEncode = URLEncoder.class.getMethod("encode", String.class, String.class);
            Class<?> clazz = Class.forName("java.net.URI");
            uriConstructor = clazz.getConstructor(String.class);
            fileConstructor = File.class.getConstructor(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

