/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc.pexcel.records;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.BIFFRecord;
import org.openoffice.xmerge.util.Debug;
import org.openoffice.xmerge.util.EndianConverter;

public class StringValue
implements BIFFRecord {
    private byte[] cch = new byte[2];
    private byte[] rgch;

    public StringValue(String string) throws IOException {
        this.cch = EndianConverter.writeShort((short)string.length());
        this.rgch = new byte[string.length()];
        this.rgch = string.getBytes("UTF-16LE");
    }

    public StringValue(InputStream inputStream) throws IOException {
        this.read(inputStream);
    }

    public short getBiffType() {
        return 7;
    }

    public int read(InputStream inputStream) throws IOException {
        this.cch[0] = (byte)inputStream.read();
        this.cch[1] = (byte)inputStream.read();
        int n = 1;
        int n2 = EndianConverter.readShort(this.cch) * 2;
        this.rgch = new byte[n2];
        Debug.log(4, "\tcch : " + this.cch + " rgch : " + this.rgch);
        return n += inputStream.read(this.rgch, 0, n2);
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.getBiffType());
        outputStream.write(this.cch);
        outputStream.write(this.rgch);
        Debug.log(4, "Writing StringValue record");
    }

    public String getString() throws IOException {
        String string;
        try {
            string = new String(this.rgch, "UTF-16LE");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = "unknown";
        }
        return string;
    }
}

