/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.text;

import com.sun.star.awt.Size;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameAccess;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.style.XStyleFamiliesSupplier;
import com.sun.star.style.XStyleLoader;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.common.PropertyNames;

public class TextStyleHandler {
    public XStyleFamiliesSupplier xStyleFamiliesSupplier;
    private XMultiServiceFactory xMSFDoc;
    private XTextDocument xTextDocument;

    public TextStyleHandler(XMultiServiceFactory xMultiServiceFactory, XTextDocument xTextDocument) {
        this.xMSFDoc = xMultiServiceFactory;
        this.xTextDocument = xTextDocument;
        this.xStyleFamiliesSupplier = (XStyleFamiliesSupplier)UnoRuntime.queryInterface(XStyleFamiliesSupplier.class, (Object)xTextDocument);
    }

    public void loadStyleTemplates(String string, String string2) {
        try {
            XStyleLoader xStyleLoader = (XStyleLoader)UnoRuntime.queryInterface(XStyleLoader.class, (Object)this.xStyleFamiliesSupplier.getStyleFamilies());
            PropertyValue[] propertyValueArray = xStyleLoader.getStyleLoaderOptions();
            String string3 = PropertyNames.EMPTY_STRING;
            int n = propertyValueArray.length;
            for (int i = 0; i < n; ++i) {
                string3 = propertyValueArray[i].Name;
                propertyValueArray[i].Value = string3.compareTo(string2) == 0 || string3.compareTo("OverwriteStyles") == 0;
            }
            xStyleLoader.loadStylesFromURL(string, propertyValueArray);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public XPropertySet getStyleByName(String string, String string2) {
        try {
            XPropertySet xPropertySet = null;
            Object object = this.xStyleFamiliesSupplier.getStyleFamilies().getByName(string);
            XNameAccess xNameAccess = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)object);
            if (xNameAccess.hasByName(string2)) {
                xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xNameAccess.getByName(string2));
            }
            return xPropertySet;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public Size changePageAlignment(XPropertySet xPropertySet, boolean bl) {
        try {
            xPropertySet.setPropertyValue("IsLandscape", (Object)bl);
            Size size = (Size)AnyConverter.toObject(Size.class, (Object)xPropertySet.getPropertyValue("Size"));
            int n = size.Width;
            int n2 = size.Height;
            Size size2 = new Size(n2, n);
            xPropertySet.setPropertyValue("Size", (Object)size2);
            return (Size)AnyConverter.toObject(Size.class, (Object)xPropertySet.getPropertyValue("Size"));
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }
}

