/*
 * Decompiled with CFR 0.152.
 */
package impl.krypt.asn1.parser;

import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CachingInputStream
extends FilterInputStream {
    private final ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private final byte[] singleByte = new byte[1];

    public CachingInputStream(InputStream in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        int read = this.read(this.singleByte, 0, 1);
        if (read != 1) {
            return read;
        }
        return this.singleByte[0] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = super.read(b, off, len);
        if (read != -1) {
            this.baos.write(b, off, read);
        }
        return read;
    }

    public byte[] getCachedBytes() {
        return this.baos.toByteArray();
    }
}

