/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.demo;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.jruby.Ruby;
import org.jruby.RubyEncoding;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.ext.readline.Readline;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.Join;

public class TextAreaReadline
implements KeyListener {
    private static final String EMPTY_LINE = "";
    private JTextComponent area;
    private volatile int startPos;
    private String currentLine;
    public volatile MutableAttributeSet promptStyle;
    public volatile MutableAttributeSet inputStyle;
    public volatile MutableAttributeSet outputStyle;
    public volatile MutableAttributeSet resultStyle;
    private JComboBox completeCombo;
    private BasicComboPopup completePopup;
    private int start;
    private int end;
    private final InputStream inputStream = new Input();
    private final OutputStream outputStream = new Output();
    private static final Join.Spec INPUT_SPEC = new Join.Spec(){
        {
            this.addReaction(new Join.FastReaction((Enum)Channel.SHUTDOWN, new Enum[]{Channel.BUFFER}){

                @Override
                public void react(Join join2, Object[] args2) {
                    join2.send(Channel.FINISHED, null);
                }
            });
            this.addReaction(new Join.FastReaction((Enum)Channel.SHUTDOWN, new Enum[]{Channel.EMPTY}){

                @Override
                public void react(Join join2, Object[] args2) {
                    join2.send(Channel.FINISHED, null);
                }
            });
            this.addReaction(new Join.FastReaction((Enum)Channel.SHUTDOWN, new Enum[]{Channel.FINISHED}){

                @Override
                public void react(Join join2, Object[] args2) {
                    join2.send(Channel.FINISHED, null);
                }
            });
            this.addReaction(new Join.FastReaction((Enum)Channel.FINISHED, new Enum[]{Channel.LINE}){

                @Override
                public void react(Join join2, Object[] args2) {
                    join2.send(Channel.FINISHED, null);
                }
            });
            this.addReaction(new Join.SyncReaction((Enum)Channel.AVAILABLE, new Enum[]{Channel.BUFFER}){

                @Override
                public Object react(Join join2, Object[] args2) {
                    InputBuffer buffer = (InputBuffer)args2[1];
                    join2.send(Channel.BUFFER, (Object)buffer);
                    return buffer.bytes.length - buffer.offset;
                }
            });
            this.addReaction(new Join.SyncReaction((Enum)Channel.AVAILABLE, new Enum[]{Channel.EMPTY}){

                @Override
                public Object react(Join join2, Object[] args2) {
                    join2.send(Channel.EMPTY, null);
                    return 0;
                }
            });
            this.addReaction(new Join.SyncReaction((Enum)Channel.AVAILABLE, new Enum[]{Channel.FINISHED}){

                @Override
                public Object react(Join join2, Object[] args2) {
                    join2.send(Channel.FINISHED, null);
                    return 0;
                }
            });
            this.addReaction(new Join.SyncReaction((Enum)Channel.READ, new Enum[]{Channel.BUFFER}){

                @Override
                public Object react(Join join2, Object[] args2) {
                    return ((ReadRequest)args2[0]).perform(join2, (InputBuffer)args2[1]);
                }
            });
            this.addReaction(new Join.SyncReaction((Enum)Channel.READ, new Enum[]{Channel.EMPTY, Channel.LINE}){

                @Override
                public Object react(Join join2, Object[] args2) {
                    ReadRequest request = (ReadRequest)args2[0];
                    String line = (String)args2[2];
                    if (line.length() != 0) {
                        byte[] bytes2 = RubyEncoding.encodeUTF8(line);
                        return request.perform(join2, new InputBuffer(bytes2));
                    }
                    return -1;
                }
            });
            this.addReaction(new Join.SyncReaction((Enum)Channel.READ, new Enum[]{Channel.FINISHED}){

                @Override
                public Object react(Join join2, Object[] args2) {
                    join2.send(Channel.FINISHED, null);
                    return -1;
                }
            });
            this.addReaction(new Join.SyncReaction((Enum)Channel.GET_LINE, new Enum[]{Channel.LINE}){

                @Override
                public Object react(Join join2, Object[] args2) {
                    return args2[1];
                }
            });
            this.addReaction(new Join.SyncReaction((Enum)Channel.GET_LINE, new Enum[]{Channel.FINISHED}){

                @Override
                public Object react(Join join2, Object[] args2) {
                    join2.send(Channel.FINISHED, null);
                    return TextAreaReadline.EMPTY_LINE;
                }
            });
        }
    };
    private static final int MAX_DOC_SIZE = 100000;
    private final Join inputJoin = INPUT_SPEC.createJoin();
    private Ruby runtime;

    public TextAreaReadline(JTextComponent area) {
        this(area, null);
    }

    public TextAreaReadline(JTextComponent area, String message2) {
        this.area = area;
        this.inputJoin.send(Channel.EMPTY, null);
        area.addKeyListener(this);
        if (area.getDocument() instanceof AbstractDocument) {
            ((AbstractDocument)area.getDocument()).setDocumentFilter(new DocumentFilter(){

                @Override
                public void insertString(DocumentFilter.FilterBypass fb, int offset2, String string2, AttributeSet attr2) throws BadLocationException {
                    if (offset2 >= TextAreaReadline.this.startPos) {
                        super.insertString(fb, offset2, string2, attr2);
                    }
                }

                @Override
                public void remove(DocumentFilter.FilterBypass fb, int offset2, int length2) throws BadLocationException {
                    if (offset2 >= TextAreaReadline.this.startPos || offset2 == 0) {
                        super.remove(fb, offset2, length2);
                    }
                }

                @Override
                public void replace(DocumentFilter.FilterBypass fb, int offset2, int length2, String text, AttributeSet attrs) throws BadLocationException {
                    if (offset2 >= TextAreaReadline.this.startPos) {
                        super.replace(fb, offset2, length2, text, attrs);
                    }
                }
            });
        }
        this.promptStyle = new SimpleAttributeSet();
        StyleConstants.setForeground(this.promptStyle, new Color(164, 0, 0));
        this.inputStyle = new SimpleAttributeSet();
        StyleConstants.setForeground(this.inputStyle, new Color(32, 74, 135));
        this.outputStyle = new SimpleAttributeSet();
        StyleConstants.setForeground(this.outputStyle, Color.darkGray);
        this.resultStyle = new SimpleAttributeSet();
        StyleConstants.setItalic(this.resultStyle, true);
        StyleConstants.setForeground(this.resultStyle, new Color(32, 74, 135));
        this.completeCombo = new JComboBox();
        this.completeCombo.setRenderer(new DefaultListCellRenderer());
        this.completePopup = new BasicComboPopup(this.completeCombo);
        if (message2 != null) {
            SimpleAttributeSet messageStyle = new SimpleAttributeSet();
            StyleConstants.setBackground(messageStyle, area.getForeground());
            StyleConstants.setForeground(messageStyle, area.getBackground());
            this.append(message2, messageStyle);
        }
        this.startPos = area.getDocument().getLength();
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void hookIntoRuntime(final Ruby runtime) {
        this.runtime = runtime;
        runtime.getLoadService().require("readline");
        RubyModule readlineM = runtime.getModule("Readline");
        JavaMethod.JavaMethodTwo readlineMethod = new JavaMethod.JavaMethodTwo(readlineM, Visibility.PUBLIC){

            @Override
            public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1) {
                String line = TextAreaReadline.this.readLine(arg0.toString());
                if (line != null) {
                    return RubyString.newUnicodeString(runtime, line);
                }
                return runtime.getNil();
            }
        };
        readlineM.addMethod("readline", readlineMethod);
        readlineM.getSingletonClass().addMethod("readline", readlineMethod);
    }

    public void hookIntoRuntimeWithStreams(Ruby runtime) {
        this.hookIntoRuntime(runtime);
        RubyIO in = new RubyIO(runtime, this.getInputStream());
        runtime.getGlobalVariables().set("$stdin", in);
        RubyIO out = new RubyIO(runtime, this.getOutputStream());
        runtime.getGlobalVariables().set("$stdout", out);
        runtime.getGlobalVariables().set("$stderr", out);
    }

    /*
     * WARNING - void declaration
     */
    protected void completeAction(KeyEvent event2) {
        if (Readline.getCompletor(Readline.getHolder(this.runtime)) == null) {
            return;
        }
        event2.consume();
        if (this.completePopup.isVisible()) {
            return;
        }
        LinkedList<CharSequence> candidates = new LinkedList<CharSequence>();
        String bufstr = null;
        try {
            bufstr = this.area.getText(this.startPos, this.area.getCaretPosition() - this.startPos);
        }
        catch (BadLocationException e) {
            return;
        }
        int cursor = this.area.getCaretPosition() - this.startPos;
        int position = Readline.getCompletor(Readline.getHolder(this.runtime)).complete(bufstr, cursor, candidates);
        if (candidates.isEmpty()) {
            return;
        }
        if (candidates.size() == 1) {
            this.replaceText(this.startPos + position, this.area.getCaretPosition(), (String)candidates.get(0));
            return;
        }
        this.start = this.startPos + position;
        this.end = this.area.getCaretPosition();
        Point pos2 = this.area.getCaret().getMagicCaretPosition();
        int cutoff = bufstr.substring(position).lastIndexOf(46) + 1;
        this.start += cutoff;
        if (candidates.size() < 10) {
            this.completePopup.getList().setVisibleRowCount(candidates.size());
        } else {
            this.completePopup.getList().setVisibleRowCount(10);
        }
        this.completeCombo.removeAllItems();
        for (String string2 : candidates) {
            void var9_10;
            if (cutoff != 0) {
                String string3 = string2.substring(cutoff);
            }
            this.completeCombo.addItem(var9_10);
        }
        this.completePopup.show(this.area, pos2.x, pos2.y + this.area.getFontMetrics(this.area.getFont()).getHeight());
    }

    protected void backAction(KeyEvent event2) {
        if (this.area.getCaretPosition() <= this.startPos) {
            event2.consume();
        }
    }

    protected void upAction(KeyEvent event2) {
        event2.consume();
        if (this.completePopup.isVisible()) {
            int selected = this.completeCombo.getSelectedIndex() - 1;
            if (selected < 0) {
                return;
            }
            this.completeCombo.setSelectedIndex(selected);
            return;
        }
        if (!Readline.getHistory(Readline.getHolder(this.runtime)).next()) {
            this.currentLine = this.getLine();
        } else {
            Readline.getHistory(Readline.getHolder(this.runtime)).previous();
        }
        if (!Readline.getHistory(Readline.getHolder(this.runtime)).previous()) {
            return;
        }
        String oldLine = Readline.getHistory(Readline.getHolder(this.runtime)).current().toString().trim();
        this.replaceText(this.startPos, this.area.getDocument().getLength(), oldLine);
    }

    protected void downAction(KeyEvent event2) {
        String oldLine;
        event2.consume();
        if (this.completePopup.isVisible()) {
            int selected = this.completeCombo.getSelectedIndex() + 1;
            if (selected == this.completeCombo.getItemCount()) {
                return;
            }
            this.completeCombo.setSelectedIndex(selected);
            return;
        }
        if (!Readline.getHistory(Readline.getHolder(this.runtime)).next()) {
            return;
        }
        if (!Readline.getHistory(Readline.getHolder(this.runtime)).next()) {
            oldLine = this.currentLine;
        } else {
            Readline.getHistory(Readline.getHolder(this.runtime)).previous();
            oldLine = Readline.getHistory(Readline.getHolder(this.runtime)).current().toString().trim();
        }
        this.replaceText(this.startPos, this.area.getDocument().getLength(), oldLine);
    }

    protected void replaceText(int start2, int end2, String replacement2) {
        try {
            this.area.getDocument().remove(start2, end2 - start2);
            this.area.getDocument().insertString(start2, replacement2, this.inputStyle);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    protected String getLine() {
        try {
            return this.area.getText(this.startPos, this.area.getDocument().getLength() - this.startPos);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void enterAction(KeyEvent event2) {
        event2.consume();
        if (this.completePopup.isVisible()) {
            if (this.completeCombo.getSelectedItem() != null) {
                this.replaceText(this.start, this.end, (String)this.completeCombo.getSelectedItem());
            }
            this.completePopup.setVisible(false);
            return;
        }
        this.append("\n", null);
        String line = this.getLine();
        this.startPos = this.area.getDocument().getLength();
        this.inputJoin.send(Channel.LINE, (Object)line);
    }

    public String readLine(final String prompt) {
        if (EventQueue.isDispatchThread()) {
            throw this.runtime.newThreadError("Cannot call readline from event dispatch thread");
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                TextAreaReadline.this.append(prompt.trim(), TextAreaReadline.this.promptStyle);
                TextAreaReadline.this.append(" ", TextAreaReadline.this.inputStyle);
                TextAreaReadline.this.area.setCaretPosition(TextAreaReadline.this.area.getDocument().getLength());
                TextAreaReadline.this.startPos = TextAreaReadline.this.area.getDocument().getLength();
                Readline.getHistory(Readline.getHolder(TextAreaReadline.this.runtime)).moveToEnd();
            }
        });
        String line = (String)this.inputJoin.call(Channel.GET_LINE, null);
        if (line.length() > 0) {
            return line.trim();
        }
        return null;
    }

    @Override
    public void keyPressed(KeyEvent event2) {
        int code = event2.getKeyCode();
        switch (code) {
            case 9: {
                this.completeAction(event2);
                break;
            }
            case 8: 
            case 37: {
                this.backAction(event2);
                break;
            }
            case 38: {
                this.upAction(event2);
                break;
            }
            case 40: {
                this.downAction(event2);
                break;
            }
            case 10: {
                this.enterAction(event2);
                break;
            }
            case 65: {
                if (!event2.isControlDown()) break;
            }
            case 36: {
                event2.consume();
                this.area.setCaretPosition(this.startPos);
                break;
            }
            case 68: {
                if ((event2.getModifiersEx() & 0x80) == 0) break;
                event2.consume();
                this.inputJoin.send(Channel.LINE, (Object)EMPTY_LINE);
            }
        }
        if (this.completePopup.isVisible() && code != 9 && code != 38 && code != 40) {
            this.completePopup.setVisible(false);
        }
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    public void shutdown() {
        this.inputJoin.send(Channel.SHUTDOWN, null);
    }

    protected void append(String toAppend, AttributeSet style) {
        try {
            Document doc = this.area.getDocument();
            doc.insertString(doc.getLength(), toAppend, style);
            int extra = doc.getLength() - 100000;
            if (extra > 0) {
                int removeBytes = extra + 10000;
                doc.remove(0, removeBytes);
                this.startPos -= removeBytes;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void writeLineUnsafe(String line) {
        if (line.startsWith("=>")) {
            this.append(line, this.resultStyle);
        } else {
            this.append(line, this.outputStyle);
        }
        this.startPos = this.area.getDocument().getLength();
    }

    private void writeLine(final String line) {
        if (EventQueue.isDispatchThread()) {
            this.writeLineUnsafe(line);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TextAreaReadline.this.writeLineUnsafe(line);
                }
            });
        }
    }

    private class Output
    extends OutputStream {
        private Output() {
        }

        @Override
        public void write(int b) throws IOException {
            TextAreaReadline.this.writeLine(TextAreaReadline.EMPTY_LINE + b);
        }

        @Override
        public void write(byte[] b, int off, int len) {
            TextAreaReadline.this.writeLine(RubyEncoding.decodeUTF8(b, off, len));
        }

        @Override
        public void write(byte[] b) {
            TextAreaReadline.this.writeLine(RubyEncoding.decodeUTF8(b));
        }
    }

    private class Input
    extends InputStream {
        private volatile boolean closed = false;

        private Input() {
        }

        @Override
        public int available() throws IOException {
            if (this.closed) {
                throw new IOException("Stream is closed");
            }
            return (Integer)TextAreaReadline.this.inputJoin.call(Channel.AVAILABLE, null);
        }

        @Override
        public int read() throws IOException {
            byte[] b = new byte[1];
            if (this.read(b, 0, 1) == 1) {
                return b[0];
            }
            return -1;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.closed) {
                throw new IOException("Stream is closed");
            }
            if (EventQueue.isDispatchThread()) {
                throw new IOException("Cannot call read from event dispatch thread");
            }
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || off + len > b.length) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            ReadRequest request = new ReadRequest(b, off, len);
            return (Integer)TextAreaReadline.this.inputJoin.call(Channel.READ, (Object)request);
        }

        @Override
        public void close() {
            this.closed = true;
            TextAreaReadline.this.inputJoin.send(Channel.SHUTDOWN, null);
        }
    }

    private static class ReadRequest {
        public final byte[] b;
        public final int off;
        public final int len;

        public ReadRequest(byte[] b, int off, int len) {
            this.b = b;
            this.off = off;
            this.len = len;
        }

        public int perform(Join join2, InputBuffer buffer) {
            int len = this.len;
            int available = buffer.bytes.length - buffer.offset;
            if (len > available) {
                len = available;
            }
            if (len == available) {
                join2.send(Channel.EMPTY, null);
            } else {
                buffer.offset += len;
                join2.send(Channel.BUFFER, (Object)buffer);
            }
            System.arraycopy(buffer.bytes, buffer.offset, this.b, this.off, len);
            return len;
        }
    }

    public static enum Channel {
        AVAILABLE,
        READ,
        BUFFER,
        EMPTY,
        LINE,
        GET_LINE,
        SHUTDOWN,
        FINISHED;

    }

    private static class InputBuffer {
        public final byte[] bytes;
        public int offset = 0;

        public InputBuffer(byte[] bytes2) {
            this.bytes = bytes2;
        }
    }
}

