/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.builtin.IRubyObject;

public class Utils {
    private Utils() {
    }

    public static String toHex(byte[] val) {
        StringBuffer out = new StringBuffer();
        int j = val.length;
        for (int i2 = 0; i2 < j; ++i2) {
            String ve = Integer.toString((char)val[i2] & 0xFF, 16);
            if (ve.length() == 1) {
                ve = "0" + ve;
            }
            out.append(ve);
        }
        return out.toString();
    }

    public static String toHex(byte[] val, char sep) {
        StringBuffer out = new StringBuffer();
        String sap = "";
        int j = val.length;
        for (int i2 = 0; i2 < j; ++i2) {
            String ve = Integer.toString((char)val[i2] & 0xFF, 16);
            if (ve.length() == 1) {
                ve = "0" + ve;
            }
            out.append(sap).append(ve);
            sap = "" + sep;
        }
        return out.toString().toUpperCase();
    }

    public static void checkKind(Ruby rt, IRubyObject obj, String path) {
        if (((RubyObject)obj).kind_of_p(rt.getCurrentContext(), (IRubyObject)rt.getClassFromPath(path)).isFalse()) {
            throw rt.newTypeError(String.format("wrong argument (%s)! (Expected kind of %s)", obj.getMetaClass().getName(), path));
        }
    }

    public static RubyClass getClassFromPath(Ruby rt, String path) {
        return (RubyClass)rt.getClassFromPath(path);
    }

    public static RaiseException newError(Ruby rt, String path, String message) {
        return new RaiseException(rt, Utils.getClassFromPath(rt, path), message, true);
    }

    public static RaiseException newError(Ruby rt, String path, String message, boolean nativeException) {
        return new RaiseException(rt, Utils.getClassFromPath(rt, path), message, nativeException);
    }

    public static IRubyObject newRubyInstance(Ruby rt, String path) {
        return rt.getClassFromPath(path).callMethod(rt.getCurrentContext(), "new");
    }

    public static IRubyObject newRubyInstance(Ruby rt, String path, IRubyObject arg) {
        return rt.getClassFromPath(path).callMethod(rt.getCurrentContext(), "new", arg);
    }

    public static IRubyObject newRubyInstance(Ruby rt, String path, IRubyObject[] args) {
        return rt.getClassFromPath(path).callMethod(rt.getCurrentContext(), "new", args);
    }
}

