/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.Digest;
import org.jruby.ext.openssl.OpenSSLImpl;
import org.jruby.ext.openssl.OpenSSLReal;
import org.jruby.ext.openssl.SimpleSecretKey;
import org.jruby.ext.openssl.Utils;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class Cipher
extends RubyObject {
    private static final long serialVersionUID = 7727377435222646536L;
    private static final boolean DEBUG = false;
    private static ObjectAllocator CIPHER_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new Cipher(runtime, klass);
        }
    };
    private javax.crypto.Cipher ciph;
    private String name;
    private String cryptoBase;
    private String cryptoVersion;
    private String cryptoMode;
    private String padding_type;
    private String realName;
    private int keyLen = -1;
    private int generateKeyLen = -1;
    private int ivLen = -1;
    private boolean encryptMode = true;
    private boolean ciphInited = false;
    private byte[] key;
    private byte[] realIV;
    private byte[] orgIV;
    private String padding;
    private byte[] lastIv = null;

    public static void createCipher(Ruby runtime, RubyModule mOSSL) {
        RubyClass cCipher = mOSSL.defineClassUnder("Cipher", runtime.getObject(), CIPHER_ALLOCATOR);
        cCipher.defineAnnotatedMethods(Cipher.class);
        cCipher.defineAnnotatedMethods(CipherModule.class);
        RubyClass openSSLError = mOSSL.getClass("OpenSSLError");
        cCipher.defineClassUnder("CipherError", openSSLError, openSSLError.getAllocator());
    }

    private static boolean tryCipher(String rubyName) {
        String cryptoMode = Algorithm.osslToJsse(rubyName, null)[3];
        try {
            javax.crypto.Cipher.getInstance(cryptoMode);
            return true;
        }
        catch (NoSuchAlgorithmException nsae) {
            try {
                OpenSSLReal.getCipherBC(cryptoMode);
                return true;
            }
            catch (GeneralSecurityException gse) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
    }

    public Cipher(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    void dumpVars() {
        System.out.println("***** Cipher instance vars ****");
        System.out.println("name = " + this.name);
        System.out.println("cryptoBase = " + this.cryptoBase);
        System.out.println("cryptoVersion = " + this.cryptoVersion);
        System.out.println("cryptoMode = " + this.cryptoMode);
        System.out.println("padding_type = " + this.padding_type);
        System.out.println("realName = " + this.realName);
        System.out.println("keyLen = " + this.keyLen);
        System.out.println("ivLen = " + this.ivLen);
        System.out.println("ciph block size = " + this.ciph.getBlockSize());
        System.out.println("encryptMode = " + this.encryptMode);
        System.out.println("ciphInited = " + this.ciphInited);
        System.out.println("key.length = " + (this.key == null ? 0 : this.key.length));
        System.out.println("iv.length = " + (this.realIV == null ? 0 : this.realIV.length));
        System.out.println("padding = " + this.padding);
        System.out.println("ciphAlgo = " + this.ciph.getAlgorithm());
        System.out.println("*******************************");
    }

    @JRubyMethod(required=1)
    public IRubyObject initialize(IRubyObject str) {
        this.name = str.toString();
        if (!CipherModule.isSupportedCipher(this.name)) {
            throw Cipher.newCipherError(this.getRuntime(), String.format("unsupported cipher algorithm (%s)", this.name));
        }
        if (this.ciph != null) {
            throw this.getRuntime().newRuntimeError("Cipher already inititalized!");
        }
        this.updateCipher(this.name, this.padding);
        return this;
    }

    @JRubyMethod(required=1)
    public IRubyObject initialize_copy(IRubyObject obj) {
        if (this == obj) {
            return this;
        }
        this.checkFrozen();
        this.cryptoBase = ((Cipher)obj).cryptoBase;
        this.cryptoVersion = ((Cipher)obj).cryptoVersion;
        this.cryptoMode = ((Cipher)obj).cryptoMode;
        this.padding_type = ((Cipher)obj).padding_type;
        this.realName = ((Cipher)obj).realName;
        this.name = ((Cipher)obj).name;
        this.keyLen = ((Cipher)obj).keyLen;
        this.ivLen = ((Cipher)obj).ivLen;
        this.encryptMode = ((Cipher)obj).encryptMode;
        this.ciphInited = false;
        if (((Cipher)obj).key != null) {
            this.key = new byte[((Cipher)obj).key.length];
            System.arraycopy(((Cipher)obj).key, 0, this.key, 0, this.key.length);
        } else {
            this.key = null;
        }
        if (((Cipher)obj).realIV != null) {
            this.realIV = new byte[((Cipher)obj).realIV.length];
            System.arraycopy(((Cipher)obj).realIV, 0, this.realIV, 0, this.realIV.length);
        } else {
            this.realIV = null;
        }
        this.orgIV = this.realIV;
        this.padding = ((Cipher)obj).padding;
        this.ciph = this.getCipher();
        return this;
    }

    @JRubyMethod
    public IRubyObject name() {
        return this.getRuntime().newString(this.name);
    }

    @JRubyMethod
    public IRubyObject key_len() {
        return this.getRuntime().newFixnum(this.keyLen);
    }

    @JRubyMethod
    public IRubyObject iv_len() {
        return this.getRuntime().newFixnum(this.ivLen);
    }

    @JRubyMethod(name={"key_len="}, required=1)
    public IRubyObject set_key_len(IRubyObject len) {
        this.keyLen = RubyNumeric.fix2int((IRubyObject)len);
        return len;
    }

    @JRubyMethod(name={"key="}, required=1)
    public IRubyObject set_key(IRubyObject key) {
        byte[] keyBytes;
        try {
            keyBytes = key.convertToString().getBytes();
        }
        catch (Exception e) {
            throw Cipher.newCipherError(this.getRuntime(), e.getMessage());
        }
        if (keyBytes.length < this.keyLen) {
            throw Cipher.newCipherError(this.getRuntime(), "key length to short");
        }
        if (keyBytes.length > this.keyLen) {
            byte[] keys = new byte[this.keyLen];
            System.arraycopy(keyBytes, 0, keys, 0, this.keyLen);
            keyBytes = keys;
        }
        this.key = keyBytes;
        return key;
    }

    @JRubyMethod(name={"iv="}, required=1)
    public IRubyObject set_iv(IRubyObject iv) {
        byte[] ivBytes;
        try {
            ivBytes = iv.convertToString().getBytes();
        }
        catch (Exception e) {
            throw Cipher.newCipherError(this.getRuntime(), e.getMessage());
        }
        if (ivBytes.length < this.ivLen) {
            throw Cipher.newCipherError(this.getRuntime(), "iv length to short");
        }
        byte[] iv2 = new byte[this.ivLen];
        System.arraycopy(ivBytes, 0, iv2, 0, this.ivLen);
        this.realIV = iv2;
        this.orgIV = this.realIV;
        if (!this.isStreamCipher()) {
            this.ciphInited = false;
        }
        return iv;
    }

    @JRubyMethod
    public IRubyObject block_size() {
        this.checkInitialized();
        if (this.isStreamCipher()) {
            return this.getRuntime().newFixnum(1);
        }
        return this.getRuntime().newFixnum(this.ciph.getBlockSize());
    }

    protected void init(IRubyObject[] args, boolean encrypt2) {
        Arity.checkArgumentCount((Ruby)this.getRuntime(), (IRubyObject[])args, (int)0, (int)2);
        this.encryptMode = encrypt2;
        this.ciphInited = false;
        if (args.length > 0) {
            byte[] iv2;
            byte[] pass = args[0].convertToString().getBytes();
            byte[] iv = null;
            try {
                iv = "OpenSSL for Ruby rulez!".getBytes("ISO8859-1");
                iv2 = new byte[this.ivLen];
                System.arraycopy(iv, 0, iv2, 0, this.ivLen);
                iv = iv2;
            }
            catch (Exception e) {
                // empty catch block
            }
            if (args.length > 1 && !args[1].isNil()) {
                this.getRuntime().getWarnings().warning(IRubyWarnings.ID.MISCELLANEOUS, "key derivation by " + this.getMetaClass().getRealClass().getName() + "#encrypt is deprecated; use " + this.getMetaClass().getRealClass().getName() + "::pkcs5_keyivgen instead");
                iv = args[1].convertToString().getBytes();
                if (iv.length > this.ivLen) {
                    iv2 = new byte[this.ivLen];
                    System.arraycopy(iv, 0, iv2, 0, this.ivLen);
                    iv = iv2;
                }
            }
            MessageDigest digest2 = Digest.getDigest("MD5", this.getRuntime());
            OpenSSLImpl.KeyAndIv result = OpenSSLImpl.EVP_BytesToKey(this.keyLen, this.ivLen, digest2, iv, pass, 2048);
            this.key = result.getKey();
            this.realIV = iv;
            this.orgIV = this.realIV;
        }
    }

    @JRubyMethod(optional=2)
    public IRubyObject encrypt(IRubyObject[] args) {
        this.realIV = this.orgIV;
        this.init(args, true);
        return this;
    }

    @JRubyMethod(optional=2)
    public IRubyObject decrypt(IRubyObject[] args) {
        this.realIV = this.orgIV;
        this.init(args, false);
        return this;
    }

    @JRubyMethod
    public IRubyObject reset() {
        this.checkInitialized();
        if (!this.isStreamCipher()) {
            this.realIV = this.orgIV;
            this.doInitialize();
        }
        return this;
    }

    private void updateCipher(String name2, String padding) {
        this.name = name2.toUpperCase();
        this.padding = padding;
        String[] values = Algorithm.osslToJsse(name2, padding);
        this.cryptoBase = values[0];
        this.cryptoVersion = values[1];
        this.cryptoMode = values[2];
        this.realName = values[3];
        this.padding_type = values[4];
        int[] lengths = Algorithm.osslKeyIvLength(name2);
        this.keyLen = lengths[0];
        this.ivLen = lengths[1];
        if ("DES".equalsIgnoreCase(this.cryptoBase)) {
            this.generateKeyLen = this.keyLen / 8 * 7;
        }
        this.ciph = this.getCipher();
    }

    javax.crypto.Cipher getCipher() {
        try {
            return javax.crypto.Cipher.getInstance(this.realName);
        }
        catch (NoSuchAlgorithmException e) {
            try {
                return OpenSSLReal.getCipherBC(this.realName);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw Cipher.newCipherError(this.getRuntime(), "unsupported cipher algorithm (" + this.realName + ")");
            }
        }
        catch (NoSuchPaddingException e) {
            throw Cipher.newCipherError(this.getRuntime(), "unsupported cipher padding (" + this.realName + ")");
        }
    }

    @JRubyMethod(required=1, optional=3)
    public IRubyObject pkcs5_keyivgen(IRubyObject[] args) {
        Arity.checkArgumentCount((Ruby)this.getRuntime(), (IRubyObject[])args, (int)1, (int)4);
        byte[] pass = args[0].convertToString().getBytes();
        byte[] salt = null;
        int iter = 2048;
        IRubyObject vdigest = this.getRuntime().getNil();
        if (args.length > 1) {
            if (!args[1].isNil()) {
                salt = args[1].convertToString().getBytes();
            }
            if (args.length > 2) {
                if (!args[2].isNil()) {
                    iter = RubyNumeric.fix2int((IRubyObject)args[2]);
                }
                if (args.length > 3) {
                    vdigest = args[3];
                }
            }
        }
        if (null != salt && salt.length != 8) {
            throw Cipher.newCipherError(this.getRuntime(), "salt must be an 8-octet string");
        }
        String algorithm = vdigest.isNil() ? "MD5" : ((Digest)vdigest).getAlgorithm();
        MessageDigest digest2 = Digest.getDigest(algorithm, this.getRuntime());
        OpenSSLImpl.KeyAndIv result = OpenSSLImpl.EVP_BytesToKey(this.keyLen, this.ivLen, digest2, salt, pass, iter);
        this.key = result.getKey();
        this.realIV = result.getIv();
        this.orgIV = this.realIV;
        this.doInitialize();
        return this.getRuntime().getNil();
    }

    private void doInitialize() {
        this.checkInitialized();
        if (this.key == null) {
            throw Cipher.newCipherError(this.getRuntime(), "key not specified");
        }
        try {
            if (!"ECB".equalsIgnoreCase(this.cryptoMode)) {
                if (this.realIV == null) {
                    this.realIV = new byte[this.ivLen];
                }
                if ("RC2".equalsIgnoreCase(this.cryptoBase)) {
                    this.ciph.init(this.encryptMode ? 1 : 2, (Key)new SimpleSecretKey("RC2", this.key), new RC2ParameterSpec(this.key.length * 8, this.realIV));
                } else if ("RC4".equalsIgnoreCase(this.cryptoBase)) {
                    this.ciph.init(this.encryptMode ? 1 : 2, new SimpleSecretKey("RC4", this.key));
                } else {
                    this.ciph.init(this.encryptMode ? 1 : 2, (Key)new SimpleSecretKey(this.realName.split("/")[0], this.key), new IvParameterSpec(this.realIV));
                }
            } else {
                this.ciph.init(this.encryptMode ? 1 : 2, new SimpleSecretKey(this.realName.split("/")[0], this.key));
            }
        }
        catch (InvalidKeyException ike) {
            throw Cipher.newCipherError(this.getRuntime(), ike.getMessage() + ": possibly you need to install Java Cryptography Extension (JCE) Unlimited Strength Jurisdiction Policy Files for your JRE");
        }
        catch (Exception e) {
            throw Cipher.newCipherError(this.getRuntime(), e.getMessage());
        }
        this.ciphInited = true;
    }

    @JRubyMethod
    public IRubyObject update(IRubyObject data) {
        this.checkInitialized();
        byte[] val = data.convertToString().getBytes();
        if (val.length == 0) {
            throw this.getRuntime().newArgumentError("data must not be empty");
        }
        if (!this.ciphInited) {
            this.doInitialize();
        }
        byte[] str = new byte[]{};
        try {
            byte[] out = this.ciph.update(val);
            if (out != null) {
                str = out;
                if (this.realIV != null) {
                    byte[] tmpIv;
                    if (this.lastIv == null) {
                        this.lastIv = new byte[this.ivLen];
                    }
                    byte[] byArray = tmpIv = this.encryptMode ? out : val;
                    if (tmpIv.length >= this.ivLen) {
                        System.arraycopy(tmpIv, tmpIv.length - this.ivLen, this.lastIv, 0, this.ivLen);
                    }
                }
            }
        }
        catch (Exception e) {
            throw Cipher.newCipherError(this.getRuntime(), e.getMessage());
        }
        return this.getRuntime().newString(new ByteList(str, false));
    }

    @JRubyMethod(name={"<<"})
    public IRubyObject update_deprecated(IRubyObject data) {
        this.getRuntime().getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, "" + this.getMetaClass().getRealClass().getName() + "#<< is deprecated; use " + this.getMetaClass().getRealClass().getName() + "#update instead");
        return this.update(data);
    }

    @JRubyMethod(name={"final"})
    public IRubyObject _final() {
        this.checkInitialized();
        if (!this.ciphInited) {
            this.doInitialize();
        }
        if ("RC4".equalsIgnoreCase(this.cryptoBase)) {
            return this.getRuntime().newString("");
        }
        ByteList str = new ByteList(ByteList.NULL_ARRAY);
        try {
            byte[] out = this.ciph.doFinal();
            if (out != null) {
                str = new ByteList(out, false);
                if (this.realIV != null) {
                    byte[] tmpIv;
                    if (this.lastIv == null) {
                        this.lastIv = new byte[this.ivLen];
                    }
                    if ((tmpIv = out).length >= this.ivLen) {
                        System.arraycopy(tmpIv, tmpIv.length - this.ivLen, this.lastIv, 0, this.ivLen);
                    }
                }
            }
            if (this.realIV != null) {
                this.realIV = this.lastIv;
                this.doInitialize();
            }
        }
        catch (Exception e) {
            throw Cipher.newCipherError(this.getRuntime(), e.getMessage());
        }
        return this.getRuntime().newString(str);
    }

    @JRubyMethod(name={"padding="})
    public IRubyObject set_padding(IRubyObject padding) {
        this.updateCipher(this.name, padding.toString());
        return padding;
    }

    String getAlgorithm() {
        return this.ciph.getAlgorithm();
    }

    String getName() {
        return this.name;
    }

    String getCryptoBase() {
        return this.cryptoBase;
    }

    String getCryptoMode() {
        return this.cryptoMode;
    }

    int getKeyLen() {
        return this.keyLen;
    }

    int getGenerateKeyLen() {
        return this.generateKeyLen == -1 ? this.keyLen : this.generateKeyLen;
    }

    private void checkInitialized() {
        if (this.ciph == null) {
            throw this.getRuntime().newRuntimeError("Cipher not inititalized!");
        }
    }

    private boolean isStreamCipher() {
        return this.ciph.getBlockSize() == 0;
    }

    private static RaiseException newCipherError(Ruby runtime, String message) {
        return Utils.newError(runtime, "OpenSSL::Cipher::CipherError", message);
    }

    public static class Algorithm {
        private static final Set<String> BLOCK_MODES = new HashSet<String>();

        public static String jsseToOssl(String inName, int keyLen) {
            String cryptoBase = null;
            String cryptoVersion = null;
            String cryptoMode = null;
            String[] parts = inName.split("/");
            if (parts.length != 1 && parts.length != 3) {
                return null;
            }
            cryptoBase = parts[0];
            if (parts.length > 2) {
                cryptoMode = parts[1];
            }
            if (!BLOCK_MODES.contains(cryptoMode)) {
                cryptoVersion = cryptoMode;
                cryptoMode = "CBC";
            }
            if (cryptoMode == null) {
                cryptoMode = "CBC";
            }
            if (cryptoBase.equals("DESede")) {
                cryptoBase = "DES";
                cryptoVersion = "EDE3";
            } else if (cryptoBase.equals("Blowfish")) {
                cryptoBase = "BF";
            }
            if (cryptoVersion == null) {
                cryptoVersion = String.valueOf(keyLen);
            }
            return cryptoBase + "-" + cryptoVersion + "-" + cryptoMode;
        }

        public static String getAlgorithmBase(javax.crypto.Cipher cipher2) {
            String algoBase = cipher2.getAlgorithm();
            if (algoBase.indexOf(47) != -1) {
                algoBase = algoBase.split("/")[0];
            }
            return algoBase;
        }

        public static String[] osslToJsse(String inName) {
            return Algorithm.osslToJsse(inName, null);
        }

        public static String[] osslToJsse(String inName, String padding) {
            String[] split = inName.split("-");
            String cryptoBase = split[0];
            String cryptoVersion = null;
            String cryptoMode = null;
            String realName = null;
            String paddingType = padding == null || padding.equalsIgnoreCase("PKCS5Padding") ? "PKCS5Padding" : (padding.equals("0") || padding.equalsIgnoreCase("NoPadding") ? "NoPadding" : (padding.equalsIgnoreCase("ISO10126Padding") ? "ISO10126Padding" : "PKCS5Padding"));
            if ("bf".equalsIgnoreCase(cryptoBase)) {
                cryptoBase = "Blowfish";
            }
            if (split.length == 3) {
                cryptoVersion = split[1];
                cryptoMode = split[2];
            } else {
                cryptoMode = split.length == 2 ? split[1] : "CBC";
            }
            realName = cryptoBase.equalsIgnoreCase("CAST") ? "CAST5" : (cryptoBase.equalsIgnoreCase("DES") && "EDE3".equalsIgnoreCase(cryptoVersion) ? "DESede" : cryptoBase);
            if (!BLOCK_MODES.contains(cryptoMode.toUpperCase())) {
                cryptoVersion = cryptoMode;
                cryptoMode = "CBC";
            } else if (cryptoMode.equalsIgnoreCase("CFB1")) {
                cryptoMode = "CFB";
            }
            if (realName.equalsIgnoreCase("RC4")) {
                realName = "RC4";
                cryptoMode = "NONE";
                paddingType = "NoPadding";
            } else {
                realName = realName + "/" + cryptoMode + "/" + paddingType;
            }
            return new String[]{cryptoBase, cryptoVersion, cryptoMode, realName, paddingType};
        }

        public static int[] osslKeyIvLength(String name2) {
            String[] values = Algorithm.osslToJsse(name2);
            String cryptoBase = values[0];
            String cryptoVersion = values[1];
            String cryptoMode = values[2];
            String realName = values[3];
            int keyLen = -1;
            int ivLen = -1;
            if (Algorithm.hasLen(cryptoBase) && null != cryptoVersion) {
                try {
                    keyLen = Integer.parseInt(cryptoVersion) / 8;
                }
                catch (NumberFormatException e) {
                    keyLen = -1;
                }
            }
            if (keyLen == -1) {
                if ("DES".equalsIgnoreCase(cryptoBase)) {
                    ivLen = 8;
                    keyLen = "EDE3".equalsIgnoreCase(cryptoVersion) ? 24 : 8;
                } else if ("RC4".equalsIgnoreCase(cryptoBase)) {
                    ivLen = 0;
                    keyLen = 16;
                } else {
                    keyLen = 16;
                    try {
                        if (javax.crypto.Cipher.getMaxAllowedKeyLength(name2) / 8 < keyLen) {
                            keyLen = javax.crypto.Cipher.getMaxAllowedKeyLength(name2) / 8;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            if (ivLen == -1) {
                ivLen = "AES".equalsIgnoreCase(cryptoBase) ? 16 : 8;
            }
            return new int[]{keyLen, ivLen};
        }

        public static boolean hasLen(String cryptoBase) {
            return "AES".equalsIgnoreCase(cryptoBase) || "RC2".equalsIgnoreCase(cryptoBase) || "RC4".equalsIgnoreCase(cryptoBase);
        }

        static {
            BLOCK_MODES.add("CBC");
            BLOCK_MODES.add("CFB");
            BLOCK_MODES.add("CFB1");
            BLOCK_MODES.add("CFB8");
            BLOCK_MODES.add("ECB");
            BLOCK_MODES.add("OFB");
        }
    }

    @JRubyModule(name={"OpenSSL::Cipher"})
    public static class CipherModule {
        private static boolean initialized = false;
        private static final List<String> CIPHERS = new ArrayList<String>();

        @JRubyMethod(meta=true)
        public static IRubyObject ciphers(IRubyObject recv) {
            CipherModule.initializeCiphers();
            ArrayList<RubyString> result = new ArrayList<RubyString>();
            for (String cipher2 : CIPHERS) {
                result.add(recv.getRuntime().newString(cipher2));
                result.add(recv.getRuntime().newString(cipher2.toLowerCase()));
            }
            return recv.getRuntime().newArray(result);
        }

        public static boolean isSupportedCipher(String name2) {
            CipherModule.initializeCiphers();
            return CIPHERS.indexOf(name2.toUpperCase()) != -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void initializeCiphers() {
            List<String> list = CIPHERS;
            synchronized (list) {
                int i2;
                if (initialized) {
                    return;
                }
                String[] other = new String[]{"AES128", "AES192", "AES256", "BLOWFISH", "RC2-40-CBC", "RC2-64-CBC", "RC4", "RC4-40", "CAST", "CAST-CBC"};
                String[] bases = new String[]{"AES-128", "AES-192", "AES-256", "BF", "DES", "DES-EDE", "DES-EDE3", "RC2", "CAST5"};
                String[] suffixes = new String[]{"", "-CBC", "-CFB", "-CFB1", "-CFB8", "-ECB", "-OFB"};
                int j = bases.length;
                for (i2 = 0; i2 < j; ++i2) {
                    int l = suffixes.length;
                    for (int k = 0; k < l; ++k) {
                        String val = bases[i2] + suffixes[k];
                        if (!Cipher.tryCipher(val)) continue;
                        CIPHERS.add(val.toUpperCase());
                    }
                }
                j = other.length;
                for (i2 = 0; i2 < j; ++i2) {
                    if (!Cipher.tryCipher(other[i2])) continue;
                    CIPHERS.add(other[i2].toUpperCase());
                }
                initialized = true;
            }
        }
    }
}

