/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import com.apple.laf.ClientPropertyApplicator;
import com.sun.awt.AWTUtilities;
import java.awt.BufferCapabilities;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MenuBar;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.awt.peer.WindowPeer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import sun.awt.CGraphicsEnvironment;
import sun.awt.CausedFocusEvent;
import sun.awt.SunToolkit;
import sun.java2d.SurfaceData;
import sun.java2d.opengl.CGLSurfaceData;
import sun.lwawt.LWToolkit;
import sun.lwawt.LWWindowPeer;
import sun.lwawt.PlatformWindow;
import sun.lwawt.macosx.CFRetainedResource;
import sun.lwawt.macosx.CImage;
import sun.lwawt.macosx.CMenuBar;
import sun.lwawt.macosx.CPlatformResponder;
import sun.lwawt.macosx.CPlatformView;
import sun.lwawt.macosx.CThreading;
import sun.lwawt.macosx.CWrapper;
import sun.lwawt.macosx.LWCToolkit;
import sun.util.logging.PlatformLogger;

public class CPlatformWindow
extends CFRetainedResource
implements PlatformWindow {
    private static final PlatformLogger logger = PlatformLogger.getLogger("sun.lwawt.macosx.CPlatformWindow");
    private static final PlatformLogger focusLogger = PlatformLogger.getLogger("sun.lwawt.macosx.focus.CPlatformWindow");
    public static final String WINDOW_BRUSH_METAL_LOOK = "apple.awt.brushMetalLook";
    public static final String WINDOW_DRAGGABLE_BACKGROUND = "apple.awt.draggableWindowBackground";
    public static final String WINDOW_ALPHA = "Window.alpha";
    public static final String WINDOW_SHADOW = "Window.shadow";
    public static final String WINDOW_STYLE = "Window.style";
    public static final String WINDOW_SHADOW_REVALIDATE_NOW = "apple.awt.windowShadow.revalidateNow";
    public static final String WINDOW_DOCUMENT_MODIFIED = "Window.documentModified";
    public static final String WINDOW_DOCUMENT_FILE = "Window.documentFile";
    public static final String WINDOW_CLOSEABLE = "Window.closeable";
    public static final String WINDOW_MINIMIZABLE = "Window.minimizable";
    public static final String WINDOW_ZOOMABLE = "Window.zoomable";
    public static final String WINDOW_HIDES_ON_DEACTIVATE = "Window.hidesOnDeactivate";
    public static final String WINDOW_DOC_MODAL_SHEET = "apple.awt.documentModalSheet";
    public static final String WINDOW_FADE_DELEGATE = "apple.awt._windowFadeDelegate";
    public static final String WINDOW_FADE_IN = "apple.awt._windowFadeIn";
    public static final String WINDOW_FADE_OUT = "apple.awt._windowFadeOut";
    public static final String WINDOW_FULLSCREENABLE = "apple.awt.fullscreenable";
    static final int MODELESS = 0;
    static final int DOCUMENT_MODAL = 1;
    static final int APPLICATION_MODAL = 2;
    static final int TOOLKIT_MODAL = 3;
    static final int _RESERVED_FOR_DATA = 1;
    static final int DECORATED = 2;
    static final int TEXTURED = 4;
    static final int UNIFIED = 8;
    static final int UTILITY = 16;
    static final int HUD = 32;
    static final int SHEET = 64;
    static final int CLOSEABLE = 128;
    static final int MINIMIZABLE = 256;
    static final int RESIZABLE = 512;
    static final int NONACTIVATING = 0x1000000;
    static final int _STYLE_PROP_BITMASK = 1022;
    static final int HAS_SHADOW = 1024;
    static final int ZOOMABLE = 2048;
    static final int ALWAYS_ON_TOP = 32768;
    static final int HIDES_ON_DEACTIVATE = 131072;
    static final int DRAGGABLE_BACKGROUND = 524288;
    static final int DOCUMENT_MODIFIED = 0x200000;
    static final int FULLSCREENABLE = 0x800000;
    static final int _METHOD_PROP_BITMASK = 11177472;
    static final int SHOULD_BECOME_KEY = 4096;
    static final int SHOULD_BECOME_MAIN = 8192;
    static final int MODAL_EXCLUDED = 65536;
    static final int _CALLBACK_PROP_BITMASK = 77824;
    static ClientPropertyApplicator<JRootPane, CPlatformWindow> CLIENT_PROPERTY_APPLICATOR = new ClientPropertyApplicator<JRootPane, CPlatformWindow>(new ClientPropertyApplicator.Property[]{new ClientPropertyApplicator.Property<CPlatformWindow>("Window.documentModified"){

        @Override
        public void applyProperty(CPlatformWindow cPlatformWindow, Object object) {
            cPlatformWindow.setStyleBits(0x200000, object == null ? false : Boolean.parseBoolean(object.toString()));
        }
    }, new ClientPropertyApplicator.Property<CPlatformWindow>("apple.awt.brushMetalLook"){

        @Override
        public void applyProperty(CPlatformWindow cPlatformWindow, Object object) {
            cPlatformWindow.setStyleBits(4, Boolean.parseBoolean(object.toString()));
        }
    }, new ClientPropertyApplicator.Property<CPlatformWindow>("Window.alpha"){

        @Override
        public void applyProperty(CPlatformWindow cPlatformWindow, Object object) {
            AWTUtilities.setWindowOpacity(cPlatformWindow.target, object == null ? 1.0f : Float.parseFloat(object.toString()));
        }
    }, new ClientPropertyApplicator.Property<CPlatformWindow>("Window.shadow"){

        @Override
        public void applyProperty(CPlatformWindow cPlatformWindow, Object object) {
            cPlatformWindow.setStyleBits(1024, object == null ? true : Boolean.parseBoolean(object.toString()));
        }
    }, new ClientPropertyApplicator.Property<CPlatformWindow>("Window.minimizable"){

        @Override
        public void applyProperty(CPlatformWindow cPlatformWindow, Object object) {
            cPlatformWindow.setStyleBits(256, Boolean.parseBoolean(object.toString()));
        }
    }, new ClientPropertyApplicator.Property<CPlatformWindow>("Window.closeable"){

        @Override
        public void applyProperty(CPlatformWindow cPlatformWindow, Object object) {
            cPlatformWindow.setStyleBits(128, Boolean.parseBoolean(object.toString()));
        }
    }, new ClientPropertyApplicator.Property<CPlatformWindow>("Window.zoomable"){

        @Override
        public void applyProperty(CPlatformWindow cPlatformWindow, Object object) {
            cPlatformWindow.setStyleBits(2048, Boolean.parseBoolean(object.toString()));
        }
    }, new ClientPropertyApplicator.Property<CPlatformWindow>("apple.awt.fullscreenable"){

        @Override
        public void applyProperty(CPlatformWindow cPlatformWindow, Object object) {
            cPlatformWindow.setStyleBits(0x800000, Boolean.parseBoolean(object.toString()));
        }
    }, new ClientPropertyApplicator.Property<CPlatformWindow>("apple.awt.windowShadow.revalidateNow"){

        @Override
        public void applyProperty(CPlatformWindow cPlatformWindow, Object object) {
            CPlatformWindow.nativeRevalidateNSWindowShadow(cPlatformWindow.getNSWindowPtr());
        }
    }, new ClientPropertyApplicator.Property<CPlatformWindow>("Window.documentFile"){

        @Override
        public void applyProperty(CPlatformWindow cPlatformWindow, Object object) {
            if (object == null || !(object instanceof File)) {
                CPlatformWindow.nativeSetNSWindowRepresentedFilename(cPlatformWindow.getNSWindowPtr(), null);
                return;
            }
            String string = ((File)object).getAbsolutePath();
            CPlatformWindow.nativeSetNSWindowRepresentedFilename(cPlatformWindow.getNSWindowPtr(), string);
        }
    }}){

        @Override
        public CPlatformWindow convertJComponentToTarget(JRootPane jRootPane) {
            Component component = SwingUtilities.getRoot(jRootPane);
            if (component == null || (LWWindowPeer)component.getPeer() == null) {
                return null;
            }
            return (CPlatformWindow)((LWWindowPeer)component.getPeer()).getPlatformWindow();
        }
    };
    private Rectangle nativeBounds;
    private volatile boolean isFullScreenMode = false;
    private Window target;
    private LWWindowPeer peer;
    private CPlatformView contentView;
    private CPlatformWindow owner;
    private boolean visible = false;
    private boolean undecorated;
    private Rectangle normalBounds = null;
    private CPlatformResponder responder;
    private volatile boolean zoomed = false;

    private native long nativeCreateNSWindow(long var1, long var3, double var5, double var7, double var9, double var11);

    private static native void nativeSetNSWindowStyleBits(long var0, int var2, int var3);

    private static native void nativeSetNSWindowMenuBar(long var0, long var2);

    private static native Insets nativeGetNSWindowInsets(long var0);

    private static native void nativeSetNSWindowBounds(long var0, double var2, double var4, double var6, double var8);

    private static native void nativeSetNSWindowMinMax(long var0, double var2, double var4, double var6, double var8);

    private static native void nativePushNSWindowToBack(long var0);

    private static native void nativePushNSWindowToFront(long var0);

    private static native void nativeSetNSWindowTitle(long var0, String var2);

    private static native void nativeRevalidateNSWindowShadow(long var0);

    private static native void nativeSetNSWindowMinimizedIcon(long var0, long var2);

    private static native void nativeSetNSWindowRepresentedFilename(long var0, String var2);

    private static native void nativeSetNSWindowSecurityWarningPositioning(long var0, double var2, double var4, float var6, float var7);

    private static native void nativeSetEnabled(long var0, boolean var2);

    private static native void nativeSynthesizeMouseEnteredExitedEvents(long var0);

    private static native void nativeDispose(long var0);

    private static native int nativeGetNSWindowDisplayID_AppKitThread(long var0);

    static int SET(int n, int n2, boolean bl) {
        if (bl) {
            return n | n2;
        }
        return n & ~n2;
    }

    static boolean IS(int n, int n2) {
        return (n & n2) != 0;
    }

    public CPlatformWindow(LWWindowPeer.PeerType peerType) {
        super(0L, true);
        assert (peerType == LWWindowPeer.PeerType.SIMPLEWINDOW || peerType == LWWindowPeer.PeerType.DIALOG || peerType == LWWindowPeer.PeerType.FRAME);
    }

    @Override
    public void initialize(Window window, LWWindowPeer lWWindowPeer, PlatformWindow platformWindow) {
        JRootPane jRootPane;
        this.peer = lWWindowPeer;
        this.target = window;
        if (platformWindow instanceof CPlatformWindow) {
            this.owner = (CPlatformWindow)platformWindow;
        }
        int n = this.getInitialStyleBits();
        long l = this.owner != null ? this.owner.getNSWindowPtr() : 0L;
        String string = this.target.getWarningString();
        this.responder = new CPlatformResponder(this.peer, false);
        this.contentView = new CPlatformView();
        this.contentView.initialize(this.peer, this.responder);
        long l2 = this.nativeCreateNSWindow(this.contentView.getAWTView(), n, 0.0, 0.0, 0.0, 0.0);
        this.setPtr(l2);
        if (this.target instanceof RootPaneContainer && (jRootPane = ((RootPaneContainer)((Object)this.target)).getRootPane()) != null) {
            jRootPane.addPropertyChangeListener("ancestor", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    CLIENT_PROPERTY_APPLICATOR.attachAndApplyClientProperties(jRootPane);
                    jRootPane.removePropertyChangeListener("ancestor", this);
                }
            });
        }
        this.validateSurface();
    }

    protected int getInitialStyleBits() {
        boolean bl;
        int n = 3970;
        if (this.isNativelyFocusableWindow()) {
            n = CPlatformWindow.SET(n, 4096, true);
            n = CPlatformWindow.SET(n, 8192, true);
        }
        boolean bl2 = this.target instanceof Frame;
        boolean bl3 = this.target instanceof Dialog;
        boolean bl4 = bl = this.target.getType() == Window.Type.POPUP;
        if (bl3) {
            n = CPlatformWindow.SET(n, 256, false);
        }
        boolean bl5 = bl2 ? ((Frame)this.target).isUndecorated() : (this.undecorated = bl3 ? ((Dialog)this.target).isUndecorated() : true);
        if (this.undecorated) {
            n = CPlatformWindow.SET(n, 2, false);
        }
        boolean bl6 = bl2 ? ((Frame)this.target).isResizable() : (bl3 ? ((Dialog)this.target).isResizable() : false);
        n = CPlatformWindow.SET(n, 512, bl6);
        if (!bl6) {
            n = CPlatformWindow.SET(n, 512, false);
            n = CPlatformWindow.SET(n, 2048, false);
        }
        if (this.target.isAlwaysOnTop()) {
            n = CPlatformWindow.SET(n, 32768, true);
        }
        if (this.target.getModalExclusionType() == Dialog.ModalExclusionType.APPLICATION_EXCLUDE) {
            n = CPlatformWindow.SET(n, 65536, true);
        }
        if (bl) {
            n = CPlatformWindow.SET(n, 4, true);
            n = CPlatformWindow.SET(n, 0x1000000, true);
        }
        if (Window.Type.UTILITY.equals((Object)this.target.getType())) {
            n = CPlatformWindow.SET(n, 16, true);
        }
        if (this.target instanceof RootPaneContainer) {
            JRootPane jRootPane = ((RootPaneContainer)((Object)this.target)).getRootPane();
            Object object = null;
            object = jRootPane.getClientProperty(WINDOW_BRUSH_METAL_LOOK);
            if (object != null) {
                n = CPlatformWindow.SET(n, 4, Boolean.parseBoolean(object.toString()));
            }
            if (bl3 && ((Dialog)this.target).getModalityType() == Dialog.ModalityType.DOCUMENT_MODAL && (object = jRootPane.getClientProperty(WINDOW_DOC_MODAL_SHEET)) != null) {
                n = CPlatformWindow.SET(n, 64, Boolean.parseBoolean(object.toString()));
            }
            if ((object = jRootPane.getClientProperty(WINDOW_STYLE)) != null) {
                if ("small".equals(object)) {
                    n = CPlatformWindow.SET(n, 16, true);
                    if (this.target.isAlwaysOnTop() && jRootPane.getClientProperty(WINDOW_HIDES_ON_DEACTIVATE) == null) {
                        n = CPlatformWindow.SET(n, 131072, true);
                    }
                }
                if ("textured".equals(object)) {
                    n = CPlatformWindow.SET(n, 4, true);
                }
                if ("unified".equals(object)) {
                    n = CPlatformWindow.SET(n, 8, true);
                }
                if ("hud".equals(object)) {
                    n = CPlatformWindow.SET(n, 32, true);
                }
            }
            if ((object = jRootPane.getClientProperty(WINDOW_HIDES_ON_DEACTIVATE)) != null) {
                n = CPlatformWindow.SET(n, 131072, Boolean.parseBoolean(object.toString()));
            }
            if ((object = jRootPane.getClientProperty(WINDOW_CLOSEABLE)) != null) {
                n = CPlatformWindow.SET(n, 128, Boolean.parseBoolean(object.toString()));
            }
            if ((object = jRootPane.getClientProperty(WINDOW_MINIMIZABLE)) != null) {
                n = CPlatformWindow.SET(n, 256, Boolean.parseBoolean(object.toString()));
            }
            if ((object = jRootPane.getClientProperty(WINDOW_ZOOMABLE)) != null) {
                n = CPlatformWindow.SET(n, 2048, Boolean.parseBoolean(object.toString()));
            }
            if ((object = jRootPane.getClientProperty(WINDOW_FULLSCREENABLE)) != null) {
                n = CPlatformWindow.SET(n, 0x800000, Boolean.parseBoolean(object.toString()));
            }
            if ((object = jRootPane.getClientProperty(WINDOW_SHADOW)) != null) {
                n = CPlatformWindow.SET(n, 1024, Boolean.parseBoolean(object.toString()));
            }
            if ((object = jRootPane.getClientProperty(WINDOW_DRAGGABLE_BACKGROUND)) != null) {
                n = CPlatformWindow.SET(n, 524288, Boolean.parseBoolean(object.toString()));
            }
        }
        return n;
    }

    protected void setStyleBits(int n, boolean bl) {
        CPlatformWindow.nativeSetNSWindowStyleBits(this.getNSWindowPtr(), n, bl ? n : 0);
    }

    private native void _toggleFullScreenMode(long var1);

    public void toggleFullScreen() {
        this._toggleFullScreenMode(this.getNSWindowPtr());
    }

    @Override
    public void setMenuBar(MenuBar menuBar) {
        long l = this.getNSWindowPtr();
        CMenuBar cMenuBar = (CMenuBar)LWToolkit.targetToPeer(menuBar);
        if (cMenuBar != null) {
            CPlatformWindow.nativeSetNSWindowMenuBar(l, cMenuBar.getModel());
        } else {
            CPlatformWindow.nativeSetNSWindowMenuBar(l, 0L);
        }
    }

    @Override
    public Image createBackBuffer() {
        return this.contentView.createBackBuffer();
    }

    @Override
    public void dispose() {
        if (this.owner != null) {
            CWrapper.NSWindow.removeChildWindow(this.owner.getNSWindowPtr(), this.getNSWindowPtr());
        }
        this.contentView.dispose();
        CPlatformWindow.nativeDispose(this.getNSWindowPtr());
        CPlatformWindow.super.dispose();
    }

    @Override
    public void flip(int n, int n2, int n3, int n4, BufferCapabilities.FlipContents flipContents) {
        new RuntimeException("unimplemented").printStackTrace();
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        new RuntimeException("unimplemented").printStackTrace();
        return null;
    }

    @Override
    public Insets getInsets() {
        Insets insets = CPlatformWindow.nativeGetNSWindowInsets(this.getNSWindowPtr());
        return insets;
    }

    @Override
    public Point getLocationOnScreen() {
        return new Point(this.nativeBounds.x, this.nativeBounds.y);
    }

    @Override
    public GraphicsDevice getGraphicsDevice() {
        int n;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        CGraphicsEnvironment cGraphicsEnvironment = (CGraphicsEnvironment)graphicsEnvironment;
        GraphicsDevice graphicsDevice = cGraphicsEnvironment.getScreenDevice(n = CPlatformWindow.nativeGetNSWindowDisplayID_AppKitThread(this.getNSWindowPtr()));
        if (graphicsDevice == null) {
            graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        }
        return graphicsDevice;
    }

    @Override
    public SurfaceData getScreenSurface() {
        return null;
    }

    @Override
    public SurfaceData replaceSurfaceData() {
        return this.contentView.replaceSurfaceData();
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        CPlatformWindow.nativeSetNSWindowBounds(this.getNSWindowPtr(), n, n2, n3, n4);
    }

    private boolean isVisible() {
        return this.visible;
    }

    private boolean isMaximized() {
        return this.undecorated ? this.normalBounds != null : this.zoomed;
    }

    private void maximize() {
        if (this.isMaximized()) {
            return;
        }
        if (!this.undecorated) {
            this.zoomed = true;
            CWrapper.NSWindow.zoom(this.getNSWindowPtr());
        } else {
            this.deliverZoom(true);
            this.normalBounds = this.peer.getBounds();
            long l = CWrapper.NSWindow.screen(this.getNSWindowPtr());
            Rectangle rectangle = CWrapper.NSScreen.visibleFrame(l).getBounds();
            Rectangle rectangle2 = CWrapper.NSScreen.frame(l).getBounds();
            rectangle.y = rectangle2.height - rectangle.y - rectangle.height;
            this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    private void unmaximize() {
        if (!this.isMaximized()) {
            return;
        }
        if (!this.undecorated) {
            this.zoomed = false;
            CWrapper.NSWindow.zoom(this.getNSWindowPtr());
        } else {
            this.deliverZoom(false);
            Rectangle rectangle = this.normalBounds;
            this.normalBounds = null;
            this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        Object object;
        long l = this.getNSWindowPtr();
        if (!bl) {
            for (Window window : this.target.getOwnedWindows()) {
                WindowPeer object2 = (WindowPeer)window.getPeer();
                if (!(object2 instanceof LWWindowPeer) || (object = (CPlatformWindow)((LWWindowPeer)object2).getPlatformWindow()) == null || !((CPlatformWindow)object).isVisible()) continue;
                CWrapper.NSWindow.removeChildWindow(l, ((CPlatformWindow)object).getNSWindowPtr());
            }
            if (this.owner != null && this.owner.isVisible()) {
                CWrapper.NSWindow.removeChildWindow(this.owner.getNSWindowPtr(), l);
            }
        }
        this.updateIconImages();
        this.updateFocusabilityForAutoRequestFocus(false);
        LWWindowPeer lWWindowPeer = this.peer.getBlocker();
        if (lWWindowPeer == null || !bl) {
            if (bl) {
                int n;
                CWrapper.NSWindow.makeFirstResponder(l, this.contentView.getAWTView());
                int n2 = n = this.target.getType() == Window.Type.POPUP ? 1 : 0;
                if (n != 0) {
                    CWrapper.NSWindow.orderFrontRegardless(l);
                } else {
                    CWrapper.NSWindow.orderFront(l);
                }
                int n3 = CWrapper.NSWindow.isKeyWindow(l) ? 1 : 0;
                if (n3 == 0) {
                    CWrapper.NSWindow.makeKeyWindow(l);
                }
            } else {
                CWrapper.NSWindow.orderOut(l);
            }
        } else {
            CWrapper.NSWindow.orderWindow(l, -1, ((CPlatformWindow)lWWindowPeer.getPlatformWindow()).getNSWindowPtr());
        }
        this.visible = bl;
        if (bl && this.target instanceof Frame) {
            switch (((Frame)this.target).getExtendedState()) {
                case 1: {
                    CWrapper.NSWindow.miniaturize(l);
                    break;
                }
                case 6: {
                    this.maximize();
                    break;
                }
                default: {
                    this.unmaximize();
                }
            }
        }
        CPlatformWindow.nativeSynthesizeMouseEnteredExitedEvents(l);
        this.updateFocusabilityForAutoRequestFocus(true);
        if (bl) {
            if (this.owner != null && this.owner.isVisible()) {
                CWrapper.NSWindow.addChildWindow(this.owner.getNSWindowPtr(), l, 1);
                if (this.target.isAlwaysOnTop()) {
                    CWrapper.NSWindow.setLevel(l, 1);
                }
            }
            for (Window window : this.target.getOwnedWindows()) {
                CPlatformWindow cPlatformWindow;
                object = (WindowPeer)window.getPeer();
                if (!(object instanceof LWWindowPeer) || (cPlatformWindow = (CPlatformWindow)((LWWindowPeer)object).getPlatformWindow()) == null || !cPlatformWindow.isVisible()) continue;
                CWrapper.NSWindow.addChildWindow(l, cPlatformWindow.getNSWindowPtr(), 1);
                if (!window.isAlwaysOnTop()) continue;
                CWrapper.NSWindow.setLevel(cPlatformWindow.getNSWindowPtr(), 1);
            }
        }
        if (lWWindowPeer != null && bl) {
            ((CPlatformWindow)lWWindowPeer.getPlatformWindow()).orderAboveSiblings();
        }
    }

    @Override
    public void setTitle(String string) {
        CPlatformWindow.nativeSetNSWindowTitle(this.getNSWindowPtr(), string);
    }

    @Override
    public void updateIconImages() {
        long l = this.getNSWindowPtr();
        CImage cImage = this.getImageForTarget();
        CPlatformWindow.nativeSetNSWindowMinimizedIcon(l, cImage == null ? 0L : cImage.ptr);
    }

    public long getNSWindowPtr() {
        long l = this.ptr;
        if (l == 0L && logger.isLoggable(500)) {
            logger.fine("NSWindow already disposed?", new Exception("Pointer to native NSWindow is invalid."));
        }
        return l;
    }

    public SurfaceData getSurfaceData() {
        return this.contentView.getSurfaceData();
    }

    @Override
    public void toBack() {
        long l = this.getNSWindowPtr();
        CPlatformWindow.nativePushNSWindowToBack(l);
    }

    @Override
    public void toFront() {
        long l = this.getNSWindowPtr();
        this.updateFocusabilityForAutoRequestFocus(false);
        CPlatformWindow.nativePushNSWindowToFront(l);
        this.updateFocusabilityForAutoRequestFocus(true);
    }

    @Override
    public void setResizable(boolean bl) {
        this.setStyleBits(512, bl);
        this.peer.updateMinimumSize();
        Rectangle rectangle = this.peer.getBounds();
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public void setSizeConstraints(int n, int n2, int n3, int n4) {
        CPlatformWindow.nativeSetNSWindowMinMax(this.getNSWindowPtr(), n, n2, n3, n4);
    }

    @Override
    public boolean rejectFocusRequest(CausedFocusEvent.Cause cause) {
        if (cause != CausedFocusEvent.Cause.MOUSE_EVENT && !((LWCToolkit)Toolkit.getDefaultToolkit()).isApplicationActive()) {
            focusLogger.fine("the app is inactive, so the request is rejected");
            return true;
        }
        return false;
    }

    @Override
    public boolean requestWindowFocus() {
        long l = this.getNSWindowPtr();
        if (CWrapper.NSWindow.canBecomeMainWindow(l)) {
            CWrapper.NSWindow.makeMainWindow(l);
        }
        CWrapper.NSWindow.makeKeyAndOrderFront(l);
        return true;
    }

    @Override
    public boolean isActive() {
        long l = this.getNSWindowPtr();
        return CWrapper.NSWindow.isKeyWindow(l);
    }

    @Override
    public void updateFocusableWindowState() {
        boolean bl = this.isNativelyFocusableWindow();
        this.setStyleBits(12288, bl);
    }

    @Override
    public Graphics transformGraphics(Graphics graphics) {
        return graphics;
    }

    @Override
    public void setAlwaysOnTop(boolean bl) {
        this.setStyleBits(32768, bl);
    }

    @Override
    public void setOpacity(float f) {
        CWrapper.NSWindow.setAlphaValue(this.getNSWindowPtr(), f);
    }

    @Override
    public void setOpaque(boolean bl) {
        CWrapper.NSWindow.setOpaque(this.getNSWindowPtr(), bl);
        if (!bl) {
            long l = CWrapper.NSColor.clearColor();
            CWrapper.NSWindow.setBackgroundColor(this.getNSWindowPtr(), l);
        }
    }

    @Override
    public void enterFullScreenMode() {
        this.isFullScreenMode = true;
        this.contentView.enterFullScreenMode(this.getNSWindowPtr());
    }

    @Override
    public void exitFullScreenMode() {
        this.contentView.exitFullScreenMode();
        this.isFullScreenMode = false;
    }

    @Override
    public void setWindowState(int n) {
        if (!this.peer.isVisible()) {
            return;
        }
        int n2 = this.peer.getState();
        if (n2 == n) {
            return;
        }
        long l = this.getNSWindowPtr();
        switch (n) {
            case 1: {
                if (n2 == 6) {
                    this.unmaximize();
                }
                CWrapper.NSWindow.miniaturize(l);
                break;
            }
            case 6: {
                if (n2 == 1) {
                    CWrapper.NSWindow.deminiaturize(l);
                }
                this.maximize();
                break;
            }
            case 0: {
                if (n2 == 1) {
                    CWrapper.NSWindow.deminiaturize(l);
                    break;
                }
                if (n2 != 6) break;
                this.unmaximize();
                break;
            }
            default: {
                throw new RuntimeException("Unknown window state: " + n);
            }
        }
        CPlatformWindow.nativeSynthesizeMouseEnteredExitedEvents(l);
    }

    @Override
    public void setModalBlocked(boolean bl) {
        if (this.target.getModalExclusionType() == Dialog.ModalExclusionType.APPLICATION_EXCLUDE) {
            return;
        }
        CPlatformWindow.nativeSetEnabled(this.getNSWindowPtr(), !bl);
    }

    private CImage getImageForTarget() {
        List<Image> list = this.target.getIconImages();
        if (list == null || list.size() == 0) {
            return null;
        }
        Image image = list.get(0);
        int n = image.getWidth(null);
        for (Image image2 : list) {
            int n2 = image2.getWidth(null);
            if (n2 <= n) continue;
            image = image2;
            n = n2;
        }
        return CImage.getCreator().createFromImage(image);
    }

    @Override
    public LWWindowPeer getPeer() {
        return this.peer;
    }

    public CPlatformView getContentView() {
        return this.contentView;
    }

    @Override
    public long getLayerPtr() {
        return this.contentView.getWindowLayerPtr();
    }

    private void validateSurface() {
        SurfaceData surfaceData = this.getSurfaceData();
        if (surfaceData instanceof CGLSurfaceData) {
            ((CGLSurfaceData)surfaceData).validate();
        }
    }

    private void deliverWindowFocusEvent(boolean bl) {
        if (bl && !((LWCToolkit)Toolkit.getDefaultToolkit()).isApplicationActive()) {
            focusLogger.fine("the app is inactive, so the notification is ignored");
            return;
        }
        this.responder.handleWindowFocusEvent(bl);
    }

    private void deliverMoveResizeEvent(int n, int n2, int n3, int n4) {
        if (this.isFullScreenMode) {
            return;
        }
        this.nativeBounds = new Rectangle(n, n2, n3, n4);
        this.peer.notifyReshape(n, n2, n3, n4);
        this.validateSurface();
    }

    private void deliverWindowClosingEvent() {
        if (this.peer.getBlocker() == null) {
            this.peer.postEvent(new WindowEvent(this.target, 201));
        }
    }

    private void deliverIconify(boolean bl) {
        this.peer.notifyIconify(bl);
    }

    private void deliverZoom(boolean bl) {
        this.peer.notifyZoom(bl);
    }

    private void deliverNCMouseDown() {
        this.peer.notifyNCMouseDown();
    }

    private boolean isNativelyFocusableWindow() {
        return !this.peer.isSimpleWindow() && this.target.getFocusableWindowState();
    }

    private void updateFocusabilityForAutoRequestFocus(boolean bl) {
        if (this.target.isAutoRequestFocus() || !this.isNativelyFocusableWindow()) {
            return;
        }
        this.setStyleBits(12288, bl);
    }

    private boolean checkBlocking() {
        LWWindowPeer lWWindowPeer = this.peer.getBlocker();
        if (lWWindowPeer == null) {
            return false;
        }
        CPlatformWindow cPlatformWindow = (CPlatformWindow)lWWindowPeer.getPlatformWindow();
        cPlatformWindow.orderAboveSiblings();
        long l = cPlatformWindow.getNSWindowPtr();
        CWrapper.NSWindow.orderFrontRegardless(l);
        CWrapper.NSWindow.makeKeyAndOrderFront(l);
        CWrapper.NSWindow.makeMainWindow(l);
        return true;
    }

    private void orderAboveSiblings() {
        if (this.owner == null) {
            return;
        }
        if (this.owner.isVisible()) {
            this.owner.orderAboveSiblings();
            long l = this.getNSWindowPtr();
            long l2 = this.owner.getNSWindowPtr();
            CWrapper.NSWindow.removeChildWindow(l2, l);
            CWrapper.NSWindow.addChildWindow(l2, l, 1);
        }
        if (this.target.isAlwaysOnTop()) {
            CWrapper.NSWindow.setLevel(this.getNSWindowPtr(), 1);
        }
    }

    private void windowDidBecomeMain() {
        assert (CThreading.assertAppKit());
        if (this.checkBlocking()) {
            return;
        }
        this.orderAboveSiblings();
    }

    private void updateDisplay() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CPlatformWindow.this.validateSurface();
            }
        });
    }

    private void updateWindowContent() {
        ComponentEvent componentEvent = new ComponentEvent(this.target, 101);
        SunToolkit.postEvent(SunToolkit.targetToAppContext(this.target), componentEvent);
    }

    private void windowWillEnterFullScreen() {
        this.updateWindowContent();
    }

    private void windowDidEnterFullScreen() {
        this.updateDisplay();
    }

    private void windowWillExitFullScreen() {
        this.updateWindowContent();
    }

    private void windowDidExitFullScreen() {
    }
}

