/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.text.spi.DateFormatSymbolsProvider;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import sun.util.LocaleServiceProviderPool;
import sun.util.TimeZoneNameUtility;
import sun.util.resources.LocaleData;

public class DateFormatSymbols
implements Serializable,
Cloneable {
    String[] eras = null;
    String[] months = null;
    String[] shortMonths = null;
    String[] weekdays = null;
    String[] shortWeekdays = null;
    String[] ampms = null;
    String[][] zoneStrings = null;
    transient boolean isZoneStringsSet = false;
    static final String patternChars = "GyMdkHmsSEDFwWahKzZ";
    String localPatternChars = null;
    Locale locale = null;
    static final long serialVersionUID = -5987973545549424702L;
    static final int millisPerHour = 3600000;
    private static Hashtable cachedLocaleData = new Hashtable(3);

    public DateFormatSymbols() {
        this.initializeData(Locale.getDefault());
    }

    public DateFormatSymbols(Locale locale) {
        this.initializeData(locale);
    }

    public static Locale[] getAvailableLocales() {
        LocaleServiceProviderPool localeServiceProviderPool = LocaleServiceProviderPool.getPool(DateFormatSymbolsProvider.class);
        return localeServiceProviderPool.getAvailableLocales();
    }

    public static final DateFormatSymbols getInstance() {
        return DateFormatSymbols.getInstance(Locale.getDefault());
    }

    public static final DateFormatSymbols getInstance(Locale locale) {
        DateFormatSymbols dateFormatSymbols;
        LocaleServiceProviderPool localeServiceProviderPool = LocaleServiceProviderPool.getPool(DateFormatSymbolsProvider.class);
        if (localeServiceProviderPool.hasProviders() && (dateFormatSymbols = localeServiceProviderPool.getLocalizedObject(DateFormatSymbolsGetter.INSTANCE, locale, new Object[0])) != null) {
            return dateFormatSymbols;
        }
        return new DateFormatSymbols(locale);
    }

    public String[] getEras() {
        return this.duplicate(this.eras);
    }

    public void setEras(String[] stringArray) {
        this.eras = this.duplicate(stringArray);
    }

    public String[] getMonths() {
        return this.duplicate(this.months);
    }

    public void setMonths(String[] stringArray) {
        this.months = this.duplicate(stringArray);
    }

    public String[] getShortMonths() {
        return this.duplicate(this.shortMonths);
    }

    public void setShortMonths(String[] stringArray) {
        this.shortMonths = this.duplicate(stringArray);
    }

    public String[] getWeekdays() {
        return this.duplicate(this.weekdays);
    }

    public void setWeekdays(String[] stringArray) {
        this.weekdays = this.duplicate(stringArray);
    }

    public String[] getShortWeekdays() {
        return this.duplicate(this.shortWeekdays);
    }

    public void setShortWeekdays(String[] stringArray) {
        this.shortWeekdays = this.duplicate(stringArray);
    }

    public String[] getAmPmStrings() {
        return this.duplicate(this.ampms);
    }

    public void setAmPmStrings(String[] stringArray) {
        this.ampms = this.duplicate(stringArray);
    }

    public String[][] getZoneStrings() {
        return this.getZoneStringsImpl(true);
    }

    public void setZoneStrings(String[][] stringArray) {
        String[][] stringArrayArray = new String[stringArray.length][];
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length < 5) {
                throw new IllegalArgumentException();
            }
            stringArrayArray[i] = this.duplicate(stringArray[i]);
        }
        this.zoneStrings = stringArrayArray;
        this.isZoneStringsSet = true;
    }

    public String getLocalPatternChars() {
        return new String(this.localPatternChars);
    }

    public void setLocalPatternChars(String string) {
        this.localPatternChars = new String(string);
    }

    public Object clone() {
        try {
            DateFormatSymbols dateFormatSymbols = (DateFormatSymbols)super.clone();
            this.copyMembers(this, dateFormatSymbols);
            return dateFormatSymbols;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public int hashCode() {
        int n = 0;
        String[][] stringArray = this.getZoneStringsWrapper();
        for (int i = 0; i < stringArray[0].length; ++i) {
            n ^= stringArray[0][i].hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DateFormatSymbols dateFormatSymbols = (DateFormatSymbols)object;
        return Arrays.equals(this.eras, dateFormatSymbols.eras) && Arrays.equals(this.months, dateFormatSymbols.months) && Arrays.equals(this.shortMonths, dateFormatSymbols.shortMonths) && Arrays.equals(this.weekdays, dateFormatSymbols.weekdays) && Arrays.equals(this.shortWeekdays, dateFormatSymbols.shortWeekdays) && Arrays.equals(this.ampms, dateFormatSymbols.ampms) && Arrays.deepEquals((Object[])this.getZoneStringsWrapper(), (Object[])dateFormatSymbols.getZoneStringsWrapper()) && (this.localPatternChars != null && this.localPatternChars.equals(dateFormatSymbols.localPatternChars) || this.localPatternChars == null && dateFormatSymbols.localPatternChars == null);
    }

    private static ResourceBundle cacheLookup(Locale locale) {
        ResourceBundle resourceBundle;
        SoftReference<ResourceBundle> softReference = (SoftReference<ResourceBundle>)cachedLocaleData.get(locale);
        if (softReference == null) {
            resourceBundle = LocaleData.getDateFormatData(locale);
            softReference = new SoftReference<ResourceBundle>(resourceBundle);
            cachedLocaleData.put(locale, softReference);
        } else {
            resourceBundle = (ResourceBundle)softReference.get();
            if (resourceBundle == null) {
                resourceBundle = LocaleData.getDateFormatData(locale);
                softReference = new SoftReference<ResourceBundle>(resourceBundle);
            }
        }
        return resourceBundle;
    }

    private void initializeData(Locale locale) {
        int n;
        ResourceBundle resourceBundle = DateFormatSymbols.cacheLookup(locale);
        this.eras = (String[])resourceBundle.getObject("Eras");
        this.months = resourceBundle.getStringArray("MonthNames");
        this.shortMonths = resourceBundle.getStringArray("MonthAbbreviations");
        String[] stringArray = resourceBundle.getStringArray("DayNames");
        this.weekdays = new String[8];
        this.weekdays[0] = "";
        for (n = 0; n < stringArray.length; ++n) {
            this.weekdays[n + 1] = stringArray[n];
        }
        String[] stringArray2 = resourceBundle.getStringArray("DayAbbreviations");
        this.shortWeekdays = new String[8];
        this.shortWeekdays[0] = "";
        for (n = 0; n < stringArray2.length; ++n) {
            this.shortWeekdays[n + 1] = stringArray2[n];
        }
        this.ampms = resourceBundle.getStringArray("AmPmMarkers");
        this.localPatternChars = resourceBundle.getString("DateTimePatternChars");
        this.locale = locale;
    }

    final int getZoneIndex(String string) {
        String[][] stringArray = this.getZoneStringsWrapper();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equalsIgnoreCase(stringArray[i][0])) continue;
            return i;
        }
        return -1;
    }

    final String[][] getZoneStringsWrapper() {
        if (this.isSubclassObject()) {
            return this.getZoneStrings();
        }
        return this.getZoneStringsImpl(false);
    }

    private final String[][] getZoneStringsImpl(boolean bl) {
        if (this.zoneStrings == null) {
            this.zoneStrings = TimeZoneNameUtility.getZoneStrings(this.locale);
        }
        if (bl) {
            String[][] stringArray = new String[this.zoneStrings.length][];
            for (int i = 0; i < this.zoneStrings.length; ++i) {
                stringArray[i] = this.duplicate(this.zoneStrings[i]);
            }
            return stringArray;
        }
        return this.zoneStrings;
    }

    private final boolean isSubclassObject() {
        return !this.getClass().getName().equals("java.text.DateFormatSymbols");
    }

    private final String[] duplicate(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        return stringArray2;
    }

    private final void copyMembers(DateFormatSymbols dateFormatSymbols, DateFormatSymbols dateFormatSymbols2) {
        dateFormatSymbols2.eras = this.duplicate(dateFormatSymbols.eras);
        dateFormatSymbols2.months = this.duplicate(dateFormatSymbols.months);
        dateFormatSymbols2.shortMonths = this.duplicate(dateFormatSymbols.shortMonths);
        dateFormatSymbols2.weekdays = this.duplicate(dateFormatSymbols.weekdays);
        dateFormatSymbols2.shortWeekdays = this.duplicate(dateFormatSymbols.shortWeekdays);
        dateFormatSymbols2.ampms = this.duplicate(dateFormatSymbols.ampms);
        if (dateFormatSymbols.zoneStrings != null) {
            if (dateFormatSymbols2.zoneStrings == null) {
                dateFormatSymbols2.zoneStrings = new String[dateFormatSymbols.zoneStrings.length][];
            }
            for (int i = 0; i < dateFormatSymbols2.zoneStrings.length; ++i) {
                dateFormatSymbols2.zoneStrings[i] = this.duplicate(dateFormatSymbols.zoneStrings[i]);
            }
        } else {
            dateFormatSymbols2.zoneStrings = null;
        }
        dateFormatSymbols2.localPatternChars = new String(dateFormatSymbols.localPatternChars);
    }

    private final boolean equals(String[] stringArray, String[] stringArray2) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (stringArray[i].equals(stringArray2[i])) continue;
            return false;
        }
        return true;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.zoneStrings == null) {
            this.zoneStrings = TimeZoneNameUtility.getZoneStrings(this.locale);
        }
        objectOutputStream.defaultWriteObject();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DateFormatSymbolsGetter
    implements LocaleServiceProviderPool.LocalizedObjectGetter<DateFormatSymbolsProvider, DateFormatSymbols> {
        private static final DateFormatSymbolsGetter INSTANCE = new DateFormatSymbolsGetter();

        private DateFormatSymbolsGetter() {
        }

        @Override
        public DateFormatSymbols getObject(DateFormatSymbolsProvider dateFormatSymbolsProvider, Locale locale, String string, Object ... objectArray) {
            assert (objectArray.length == 0);
            return dateFormatSymbolsProvider.getInstance(locale);
        }
    }
}

