/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.ChangeListenerMap;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeListenerProxy;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Map;

public class VetoableChangeSupport
implements Serializable {
    private VetoableChangeListenerMap map = new VetoableChangeListenerMap();
    private Object source;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("children", Hashtable.class), new ObjectStreamField("source", Object.class), new ObjectStreamField("vetoableChangeSupportSerializedDataVersion", Integer.TYPE)};
    static final long serialVersionUID = -5090210921595982017L;

    public VetoableChangeSupport(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        this.source = object;
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            return;
        }
        if (vetoableChangeListener instanceof VetoableChangeListenerProxy) {
            VetoableChangeListenerProxy vetoableChangeListenerProxy = (VetoableChangeListenerProxy)vetoableChangeListener;
            this.addVetoableChangeListener(vetoableChangeListenerProxy.getPropertyName(), (VetoableChangeListener)vetoableChangeListenerProxy.getListener());
        } else {
            this.map.add(null, vetoableChangeListener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            return;
        }
        if (vetoableChangeListener instanceof VetoableChangeListenerProxy) {
            VetoableChangeListenerProxy vetoableChangeListenerProxy = (VetoableChangeListenerProxy)vetoableChangeListener;
            this.removeVetoableChangeListener(vetoableChangeListenerProxy.getPropertyName(), (VetoableChangeListener)vetoableChangeListenerProxy.getListener());
        } else {
            this.map.remove(null, vetoableChangeListener);
        }
    }

    public VetoableChangeListener[] getVetoableChangeListeners() {
        return (VetoableChangeListener[])this.map.getListeners();
    }

    public void addVetoableChangeListener(String string, VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null || string == null) {
            return;
        }
        if ((vetoableChangeListener = this.map.extract(vetoableChangeListener)) != null) {
            this.map.add(string, vetoableChangeListener);
        }
    }

    public void removeVetoableChangeListener(String string, VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null || string == null) {
            return;
        }
        if ((vetoableChangeListener = this.map.extract(vetoableChangeListener)) != null) {
            this.map.remove(string, vetoableChangeListener);
        }
    }

    public VetoableChangeListener[] getVetoableChangeListeners(String string) {
        return (VetoableChangeListener[])this.map.getListeners(string);
    }

    public void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        if (object != null && object2 != null && object.equals(object2)) {
            return;
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this.source, string, object, object2);
        this.fireVetoableChange(propertyChangeEvent);
    }

    public void fireVetoableChange(String string, int n, int n2) throws PropertyVetoException {
        if (n == n2) {
            return;
        }
        this.fireVetoableChange(string, (Object)n, (Object)n2);
    }

    public void fireVetoableChange(String string, boolean bl, boolean bl2) throws PropertyVetoException {
        if (bl == bl2) {
            return;
        }
        this.fireVetoableChange(string, (Object)bl, (Object)bl2);
    }

    public void fireVetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        Object object = propertyChangeEvent.getOldValue();
        Object object2 = propertyChangeEvent.getNewValue();
        String string = propertyChangeEvent.getPropertyName();
        if (object != null && object2 != null && object.equals(object2)) {
            return;
        }
        VetoableChangeListener[] vetoableChangeListenerArray = (VetoableChangeListener[])this.map.get(null);
        VetoableChangeListener[] vetoableChangeListenerArray2 = string != null ? (VetoableChangeListener[])this.map.get(string) : null;
        this.fire(vetoableChangeListenerArray, propertyChangeEvent);
        this.fire(vetoableChangeListenerArray2, propertyChangeEvent);
    }

    private void fire(VetoableChangeListener[] vetoableChangeListenerArray, PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        if (vetoableChangeListenerArray != null) {
            VetoableChangeListener vetoableChangeListener = null;
            try {
                VetoableChangeListener[] vetoableChangeListenerArray2 = vetoableChangeListenerArray;
                int n = vetoableChangeListenerArray2.length;
                for (int i = 0; i < n; ++i) {
                    VetoableChangeListener vetoableChangeListener2;
                    vetoableChangeListener = vetoableChangeListener2 = vetoableChangeListenerArray2[i];
                    vetoableChangeListener2.vetoableChange(propertyChangeEvent);
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                propertyChangeEvent = new PropertyChangeEvent(this.source, propertyChangeEvent.getPropertyName(), propertyChangeEvent.getNewValue(), propertyChangeEvent.getOldValue());
                for (VetoableChangeListener vetoableChangeListener3 : vetoableChangeListenerArray) {
                    try {
                        vetoableChangeListener3.vetoableChange(propertyChangeEvent);
                    }
                    catch (PropertyVetoException propertyVetoException2) {
                        // empty catch block
                    }
                }
                throw propertyVetoException;
            }
        }
    }

    public boolean hasListeners(String string) {
        return this.map.hasListeners(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Hashtable<String, VetoableChangeSupport> hashtable = null;
        VetoableChangeListener[] vetoableChangeListenerArray = null;
        Object object = this.map;
        synchronized (object) {
            for (Map.Entry<String, L[]> entry : this.map.getEntries()) {
                String string = entry.getKey();
                if (string == null) {
                    vetoableChangeListenerArray = (VetoableChangeListener[])entry.getValue();
                    continue;
                }
                if (hashtable == null) {
                    hashtable = new Hashtable<String, VetoableChangeSupport>();
                }
                VetoableChangeSupport object2 = new VetoableChangeSupport(this.source);
                object2.map.set(null, (EventListener[])entry.getValue());
                hashtable.put(string, object2);
            }
        }
        object = objectOutputStream.putFields();
        ((ObjectOutputStream.PutField)object).put("children", hashtable);
        ((ObjectOutputStream.PutField)object).put("source", this.source);
        ((ObjectOutputStream.PutField)object).put("vetoableChangeSupportSerializedDataVersion", 2);
        objectOutputStream.writeFields();
        if (vetoableChangeListenerArray != null) {
            for (VetoableChangeListener vetoableChangeListener : vetoableChangeListenerArray) {
                if (!(vetoableChangeListener instanceof Serializable)) continue;
                objectOutputStream.writeObject(vetoableChangeListener);
            }
        }
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        Object object;
        this.map = new VetoableChangeListenerMap();
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        Hashtable hashtable = (Hashtable)getField.get("children", null);
        this.source = getField.get("source", null);
        getField.get("vetoableChangeSupportSerializedDataVersion", 2);
        while (null != (object = objectInputStream.readObject())) {
            this.map.add(null, (VetoableChangeListener)object);
        }
        if (hashtable != null) {
            for (Map.Entry entry : hashtable.entrySet()) {
                for (VetoableChangeListener vetoableChangeListener : ((VetoableChangeSupport)entry.getValue()).getVetoableChangeListeners()) {
                    this.map.add((String)entry.getKey(), vetoableChangeListener);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class VetoableChangeListenerMap
    extends ChangeListenerMap<VetoableChangeListener> {
        private static final VetoableChangeListener[] EMPTY = new VetoableChangeListener[0];

        private VetoableChangeListenerMap() {
        }

        protected VetoableChangeListener[] newArray(int n) {
            return 0 < n ? new VetoableChangeListener[n] : EMPTY;
        }

        @Override
        protected VetoableChangeListener newProxy(String string, VetoableChangeListener vetoableChangeListener) {
            return new VetoableChangeListenerProxy(string, vetoableChangeListener);
        }
    }
}

