/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.AWTException;
import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.BufferCapabilities;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.EventQueue;
import java.awt.FocusManager;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import java.awt.im.InputContext;
import java.awt.image.BufferStrategy;
import java.awt.peer.WindowPeer;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import sun.awt.AWTAccessor;
import sun.awt.AppContext;
import sun.awt.CausedFocusEvent;
import sun.awt.SunToolkit;
import sun.awt.util.IdentityArrayList;
import sun.java2d.Disposer;
import sun.java2d.DisposerRecord;
import sun.java2d.pipe.Region;
import sun.security.action.GetPropertyAction;
import sun.security.util.SecurityConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Window
extends Container
implements Accessible {
    String warningString;
    transient List<Image> icons;
    private transient Component temporaryLostComponent;
    static boolean systemSyncLWRequests;
    boolean syncLWRequests = false;
    transient boolean beforeFirstShow = true;
    static final int OPENED = 1;
    int state;
    private boolean alwaysOnTop;
    private static final IdentityArrayList<Window> allWindows;
    transient Vector<WeakReference<Window>> ownedWindowList = new Vector();
    private transient WeakReference<Window> weakThis;
    transient boolean showWithParent;
    transient Dialog modalBlocker;
    Dialog.ModalExclusionType modalExclusionType;
    transient WindowListener windowListener;
    transient WindowStateListener windowStateListener;
    transient WindowFocusListener windowFocusListener;
    transient InputContext inputContext;
    private transient Object inputContextLock = new Object();
    private FocusManager focusMgr;
    private boolean focusableWindowState = true;
    private volatile transient boolean autoRequestFocus = true;
    transient boolean isInShow = false;
    private static final String base = "win";
    private static int nameCounter;
    private static final long serialVersionUID = 4497834738069338734L;
    private static final Logger log;
    private static final boolean locationByPlatformProp;
    transient boolean isTrayIconWindow = false;
    transient Object anchor = new Object();
    private static final AtomicBoolean beforeFirstWindowShown;
    private int windowSerializedDataVersion = 2;
    private boolean locationByPlatform = locationByPlatformProp;

    private static native void initIDs();

    Window(GraphicsConfiguration graphicsConfiguration) {
        this.init(graphicsConfiguration);
    }

    private void init(GraphicsConfiguration graphicsConfiguration) {
        GraphicsEnvironment.checkHeadless();
        this.syncLWRequests = systemSyncLWRequests;
        this.weakThis = new WeakReference<Window>(this);
        this.addToWindowList();
        this.setWarningString();
        this.cursor = Cursor.getPredefinedCursor(0);
        this.visible = false;
        this.graphicsConfig = graphicsConfiguration == null ? GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration() : graphicsConfiguration;
        if (this.graphicsConfig.getDevice().getType() != 0) {
            throw new IllegalArgumentException("not a screen device");
        }
        this.setLayout(new BorderLayout());
        Rectangle rectangle = this.graphicsConfig.getBounds();
        Insets insets = this.getToolkit().getScreenInsets(this.graphicsConfig);
        int n = this.getX() + rectangle.x + insets.left;
        int n2 = this.getY() + rectangle.y + insets.top;
        if (n != this.x || n2 != this.y) {
            this.setLocation(n, n2);
            this.setLocationByPlatform(locationByPlatformProp);
        }
        this.modalExclusionType = Dialog.ModalExclusionType.NO_EXCLUDE;
        Disposer.addRecord(this.anchor, new WindowDisposerRecord(this.appContext, this));
    }

    Window() throws HeadlessException {
        GraphicsEnvironment.checkHeadless();
        this.init(null);
    }

    public Window(Frame frame) {
        this(frame == null ? (GraphicsConfiguration)null : frame.getGraphicsConfiguration());
        this.ownedInit(frame);
    }

    public Window(Window window) {
        this(window == null ? (GraphicsConfiguration)null : window.getGraphicsConfiguration());
        this.ownedInit(window);
    }

    public Window(Window window, GraphicsConfiguration graphicsConfiguration) {
        this(graphicsConfiguration);
        this.ownedInit(window);
    }

    private void ownedInit(Window window) {
        this.parent = window;
        if (window != null) {
            window.addOwnedWindow(this.weakThis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String constructComponentName() {
        Class<Window> clazz = Window.class;
        synchronized (Window.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return base + nameCounter++;
        }
    }

    public List<Image> getIconImages() {
        List<Image> list = this.icons;
        if (list == null || list.size() == 0) {
            return new ArrayList<Image>();
        }
        return new ArrayList<Image>(list);
    }

    public synchronized void setIconImages(List<? extends Image> list) {
        this.icons = list == null ? new ArrayList<Image>() : new ArrayList<Image>(list);
        WindowPeer windowPeer = (WindowPeer)this.peer;
        if (windowPeer != null) {
            windowPeer.updateIconImages();
        }
        this.firePropertyChange("iconImage", null, null);
    }

    public void setIconImage(Image image) {
        ArrayList<Image> arrayList = new ArrayList<Image>();
        if (image != null) {
            arrayList.add(image);
        }
        this.setIconImages(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Container container = this.parent;
            if (container != null && container.getPeer() == null) {
                container.addNotify();
            }
            if (this.peer == null) {
                this.peer = this.getToolkit().createWindow(this);
            }
            IdentityArrayList<Window> identityArrayList = allWindows;
            synchronized (identityArrayList) {
                allWindows.add(this);
            }
            super.addNotify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            IdentityArrayList<Window> identityArrayList = allWindows;
            synchronized (identityArrayList) {
                allWindows.remove(this);
            }
            super.removeNotify();
        }
    }

    public void pack() {
        Container container = this.parent;
        if (container != null && container.getPeer() == null) {
            container.addNotify();
        }
        if (this.peer == null) {
            this.addNotify();
        }
        Dimension dimension = this.getPreferredSize();
        if (this.peer != null) {
            this.setClientSize(dimension.width, dimension.height);
        }
        if (this.beforeFirstShow) {
            this.isPacked = true;
        }
        this.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMinimumSize(Dimension dimension) {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.setMinimumSize(dimension);
            Dimension dimension2 = this.getSize();
            if (this.isMinimumSizeSet() && (dimension2.width < dimension.width || dimension2.height < dimension.height)) {
                int n = Math.max(this.width, dimension.width);
                int n2 = Math.max(this.height, dimension.height);
                this.setSize(n, n2);
            }
            if (this.peer != null) {
                ((WindowPeer)this.peer).updateMinimumSize();
            }
        }
    }

    @Override
    public void setSize(Dimension dimension) {
        super.setSize(dimension);
    }

    @Override
    public void setSize(int n, int n2) {
        super.setSize(n, n2);
    }

    @Override
    @Deprecated
    public void reshape(int n, int n2, int n3, int n4) {
        if (this.isMinimumSizeSet()) {
            Dimension dimension = this.getMinimumSize();
            if (n3 < dimension.width) {
                n3 = dimension.width;
            }
            if (n4 < dimension.height) {
                n4 = dimension.height;
            }
        }
        super.reshape(n, n2, n3, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setClientSize(int n, int n2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.setBoundsOp(4);
            this.setBounds(this.x, this.y, n, n2);
        }
    }

    static final void closeSplashScreen() {
        if (beforeFirstWindowShown.getAndSet(false)) {
            SunToolkit.closeSplashScreen();
        }
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    @Override
    @Deprecated
    public void show() {
        if (this.peer == null) {
            this.addNotify();
        }
        this.validate();
        this.isInShow = true;
        if (this.visible) {
            this.toFront();
        } else {
            this.beforeFirstShow = false;
            Window.closeSplashScreen();
            Dialog.checkShouldBeBlocked(this);
            super.show();
            this.locationByPlatform = false;
            for (int i = 0; i < this.ownedWindowList.size(); ++i) {
                Window window = (Window)this.ownedWindowList.elementAt(i).get();
                if (window == null || !window.showWithParent) continue;
                window.show();
                window.showWithParent = false;
            }
            if (!this.isModalBlocked()) {
                this.updateChildrenBlocking();
            } else {
                this.modalBlocker.toFront_NoClientCode();
            }
            if (this instanceof Frame || this instanceof Dialog) {
                Window.updateChildFocusableWindowState(this);
            }
        }
        this.isInShow = false;
        if ((this.state & 1) == 0) {
            this.postWindowEvent(200);
            this.state |= 1;
        }
    }

    static void updateChildFocusableWindowState(Window window) {
        if (window.getPeer() != null && window.isShowing()) {
            ((WindowPeer)window.getPeer()).updateFocusableWindowState();
        }
        for (int i = 0; i < window.ownedWindowList.size(); ++i) {
            Window window2 = (Window)window.ownedWindowList.elementAt(i).get();
            if (window2 == null) continue;
            Window.updateChildFocusableWindowState(window2);
        }
    }

    synchronized void postWindowEvent(int n) {
        if (this.windowListener != null || (this.eventMask & 0x40L) != 0L || Toolkit.enabledOnToolkit(64L)) {
            WindowEvent windowEvent = new WindowEvent(this, n);
            Toolkit.getEventQueue().postEvent(windowEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void hide() {
        Vector<WeakReference<Window>> vector = this.ownedWindowList;
        synchronized (vector) {
            for (int i = 0; i < this.ownedWindowList.size(); ++i) {
                Window window = (Window)this.ownedWindowList.elementAt(i).get();
                if (window == null || !window.visible) continue;
                window.hide();
                window.showWithParent = true;
            }
        }
        if (this.isModalBlocked()) {
            this.modalBlocker.unblockWindow(this);
        }
        super.hide();
    }

    @Override
    final void clearMostRecentFocusOwnerOnHide() {
    }

    public void dispose() {
        this.doDispose();
    }

    void disposeImpl() {
        this.dispose();
        if (this.getPeer() != null) {
            this.doDispose();
        }
    }

    void doDispose() {
        class DisposeAction
        implements Runnable {
            DisposeAction() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object[] objectArray;
                GraphicsDevice graphicsDevice = Window.this.getGraphicsConfiguration().getDevice();
                if (graphicsDevice.getFullScreenWindow() == Window.this) {
                    graphicsDevice.setFullScreenWindow(null);
                }
                Vector<WeakReference<Window>> vector = Window.this.ownedWindowList;
                synchronized (vector) {
                    objectArray = new Object[Window.this.ownedWindowList.size()];
                    Window.this.ownedWindowList.copyInto(objectArray);
                }
                for (int i = 0; i < objectArray.length; ++i) {
                    Window window = (Window)((WeakReference)objectArray[i]).get();
                    if (window == null) continue;
                    window.disposeImpl();
                }
                Window.this.hide();
                Window.this.beforeFirstShow = true;
                Window.this.removeNotify();
                Object object = Window.this.inputContextLock;
                synchronized (object) {
                    if (Window.this.inputContext != null) {
                        Window.this.inputContext.dispose();
                        Window.this.inputContext = null;
                    }
                }
                Window.this.clearCurrentFocusCycleRootOnHide();
            }
        }
        DisposeAction disposeAction = new DisposeAction();
        if (EventQueue.isDispatchThread()) {
            disposeAction.run();
        } else {
            try {
                EventQueue.invokeAndWait(disposeAction);
            }
            catch (InterruptedException interruptedException) {
                System.err.println("Disposal was interrupted:");
                interruptedException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                System.err.println("Exception during disposal:");
                invocationTargetException.printStackTrace();
            }
        }
        this.postWindowEvent(202);
    }

    @Override
    void adjustListeningChildrenOnParent(long l, int n) {
    }

    @Override
    void adjustDecendantsOnParent(int n) {
    }

    public void toFront() {
        this.toFront_NoClientCode();
    }

    final void toFront_NoClientCode() {
        if (this.visible) {
            WindowPeer windowPeer = (WindowPeer)this.peer;
            if (windowPeer != null) {
                windowPeer.toFront();
            }
            if (this.isModalBlocked()) {
                this.modalBlocker.toFront_NoClientCode();
            }
        }
    }

    public void toBack() {
        this.toBack_NoClientCode();
    }

    final void toBack_NoClientCode() {
        WindowPeer windowPeer;
        if (this.isAlwaysOnTop()) {
            try {
                this.setAlwaysOnTop(false);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (this.visible && (windowPeer = (WindowPeer)this.peer) != null) {
            windowPeer.toBack();
        }
    }

    @Override
    public Toolkit getToolkit() {
        return Toolkit.getDefaultToolkit();
    }

    public final String getWarningString() {
        return this.warningString;
    }

    private void setWarningString() {
        this.warningString = null;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && !securityManager.checkTopLevelWindow(this)) {
            this.warningString = AccessController.doPrivileged(new GetPropertyAction("awt.appletWarning", "Java Applet Window"));
        }
    }

    @Override
    public Locale getLocale() {
        if (this.locale == null) {
            return Locale.getDefault();
        }
        return this.locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputContext getInputContext() {
        Object object = this.inputContextLock;
        synchronized (object) {
            if (this.inputContext == null) {
                this.inputContext = InputContext.getInstance();
            }
        }
        return this.inputContext;
    }

    @Override
    public void setCursor(Cursor cursor) {
        if (cursor == null) {
            cursor = Cursor.getPredefinedCursor(0);
        }
        super.setCursor(cursor);
    }

    public Window getOwner() {
        return this.getOwner_NoClientCode();
    }

    final Window getOwner_NoClientCode() {
        return (Window)this.parent;
    }

    public Window[] getOwnedWindows() {
        return this.getOwnedWindows_NoClientCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Window[] getOwnedWindows_NoClientCode() {
        Window[] windowArray;
        Vector<WeakReference<Window>> vector = this.ownedWindowList;
        synchronized (vector) {
            int n = this.ownedWindowList.size();
            int n2 = 0;
            Window[] windowArray2 = new Window[n];
            for (int i = 0; i < n; ++i) {
                windowArray2[n2] = (Window)this.ownedWindowList.elementAt(i).get();
                if (windowArray2[n2] == null) continue;
                ++n2;
            }
            windowArray = n != n2 ? Arrays.copyOf(windowArray2, n2) : windowArray2;
        }
        return windowArray;
    }

    boolean isModalBlocked() {
        return this.modalBlocker != null;
    }

    void setModalBlocked(Dialog dialog, boolean bl, boolean bl2) {
        WindowPeer windowPeer;
        Dialog dialog2 = this.modalBlocker = bl ? dialog : null;
        if (bl2 && (windowPeer = (WindowPeer)this.peer) != null) {
            windowPeer.setModalBlocked(dialog, bl);
        }
    }

    Dialog getModalBlocker() {
        return this.modalBlocker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IdentityArrayList<Window> getAllWindows() {
        IdentityArrayList<Window> identityArrayList = allWindows;
        synchronized (identityArrayList) {
            IdentityArrayList<Window> identityArrayList2 = new IdentityArrayList<Window>();
            identityArrayList2.addAll(allWindows);
            return identityArrayList2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IdentityArrayList<Window> getAllUnblockedWindows() {
        IdentityArrayList<Window> identityArrayList = allWindows;
        synchronized (identityArrayList) {
            IdentityArrayList<Window> identityArrayList2 = new IdentityArrayList<Window>();
            for (int i = 0; i < allWindows.size(); ++i) {
                Window window = allWindows.get(i);
                if (window.isModalBlocked()) continue;
                identityArrayList2.add(window);
            }
            return identityArrayList2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Window[] getWindows(AppContext appContext) {
        Class<Window> clazz = Window.class;
        synchronized (Window.class) {
            Window[] windowArray;
            Vector vector = (Vector)appContext.get(Window.class);
            if (vector != null) {
                int n = vector.size();
                int n2 = 0;
                Window[] windowArray2 = new Window[n];
                for (int i = 0; i < n; ++i) {
                    Window window = (Window)((WeakReference)vector.get(i)).get();
                    if (window == null) continue;
                    windowArray2[n2++] = window;
                }
                windowArray = n != n2 ? Arrays.copyOf(windowArray2, n2) : windowArray2;
            } else {
                windowArray = new Window[]{};
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return windowArray;
        }
    }

    public static Window[] getWindows() {
        return Window.getWindows(AppContext.getAppContext());
    }

    public static Window[] getOwnerlessWindows() {
        Window[] windowArray = Window.getWindows();
        int n = 0;
        for (Window window : windowArray) {
            if (window.getOwner() != null) continue;
            ++n;
        }
        Window[] windowArray2 = new Window[n];
        int n2 = 0;
        for (Window window : windowArray) {
            if (window.getOwner() != null) continue;
            windowArray2[n2++] = window;
        }
        return windowArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Window getDocumentRoot() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Window window = this;
            while (window.getOwner() != null) {
                window = window.getOwner();
            }
            return window;
        }
    }

    public void setModalExclusionType(Dialog.ModalExclusionType modalExclusionType) {
        SecurityManager securityManager;
        if (modalExclusionType == null) {
            modalExclusionType = Dialog.ModalExclusionType.NO_EXCLUDE;
        }
        if (!Toolkit.getDefaultToolkit().isModalExclusionTypeSupported(modalExclusionType)) {
            modalExclusionType = Dialog.ModalExclusionType.NO_EXCLUDE;
        }
        if (this.modalExclusionType == modalExclusionType) {
            return;
        }
        if (modalExclusionType == Dialog.ModalExclusionType.TOOLKIT_EXCLUDE && (securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(SecurityConstants.TOOLKIT_MODALITY_PERMISSION);
        }
        this.modalExclusionType = modalExclusionType;
    }

    public Dialog.ModalExclusionType getModalExclusionType() {
        return this.modalExclusionType;
    }

    boolean isModalExcluded(Dialog.ModalExclusionType modalExclusionType) {
        if (this.modalExclusionType != null && this.modalExclusionType.compareTo(modalExclusionType) >= 0) {
            return true;
        }
        Window window = this.getOwner_NoClientCode();
        return window != null && window.isModalExcluded(modalExclusionType);
    }

    void updateChildrenBlocking() {
        int n;
        Vector<Window> vector = new Vector<Window>();
        Window[] windowArray = this.getOwnedWindows();
        for (n = 0; n < windowArray.length; ++n) {
            vector.add(windowArray[n]);
        }
        for (n = 0; n < vector.size(); ++n) {
            Window[] windowArray2;
            Window window = (Window)vector.get(n);
            if (!window.isVisible()) continue;
            if (window.isModalBlocked()) {
                windowArray2 = window.getModalBlocker();
                windowArray2.unblockWindow(window);
            }
            Dialog.checkShouldBeBlocked(window);
            windowArray2 = window.getOwnedWindows();
            for (int i = 0; i < windowArray2.length; ++i) {
                vector.add(windowArray2[i]);
            }
        }
    }

    public synchronized void addWindowListener(WindowListener windowListener) {
        if (windowListener == null) {
            return;
        }
        this.newEventsOnly = true;
        this.windowListener = AWTEventMulticaster.add(this.windowListener, windowListener);
    }

    public synchronized void addWindowStateListener(WindowStateListener windowStateListener) {
        if (windowStateListener == null) {
            return;
        }
        this.windowStateListener = AWTEventMulticaster.add(this.windowStateListener, windowStateListener);
        this.newEventsOnly = true;
    }

    public synchronized void addWindowFocusListener(WindowFocusListener windowFocusListener) {
        if (windowFocusListener == null) {
            return;
        }
        this.windowFocusListener = AWTEventMulticaster.add(this.windowFocusListener, windowFocusListener);
        this.newEventsOnly = true;
    }

    public synchronized void removeWindowListener(WindowListener windowListener) {
        if (windowListener == null) {
            return;
        }
        this.windowListener = AWTEventMulticaster.remove(this.windowListener, windowListener);
    }

    public synchronized void removeWindowStateListener(WindowStateListener windowStateListener) {
        if (windowStateListener == null) {
            return;
        }
        this.windowStateListener = AWTEventMulticaster.remove(this.windowStateListener, windowStateListener);
    }

    public synchronized void removeWindowFocusListener(WindowFocusListener windowFocusListener) {
        if (windowFocusListener == null) {
            return;
        }
        this.windowFocusListener = AWTEventMulticaster.remove(this.windowFocusListener, windowFocusListener);
    }

    public synchronized WindowListener[] getWindowListeners() {
        return (WindowListener[])this.getListeners(WindowListener.class);
    }

    public synchronized WindowFocusListener[] getWindowFocusListeners() {
        return (WindowFocusListener[])this.getListeners(WindowFocusListener.class);
    }

    public synchronized WindowStateListener[] getWindowStateListeners() {
        return (WindowStateListener[])this.getListeners(WindowStateListener.class);
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        EventListener eventListener = null;
        if (clazz == WindowFocusListener.class) {
            eventListener = this.windowFocusListener;
        } else if (clazz == WindowStateListener.class) {
            eventListener = this.windowStateListener;
        } else if (clazz == WindowListener.class) {
            eventListener = this.windowListener;
        } else {
            return super.getListeners(clazz);
        }
        return AWTEventMulticaster.getListeners((EventListener)eventListener, clazz);
    }

    @Override
    boolean eventEnabled(AWTEvent aWTEvent) {
        switch (aWTEvent.id) {
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: {
                return (this.eventMask & 0x40L) != 0L || this.windowListener != null;
            }
            case 207: 
            case 208: {
                return (this.eventMask & 0x80000L) != 0L || this.windowFocusListener != null;
            }
            case 209: {
                return (this.eventMask & 0x40000L) != 0L || this.windowStateListener != null;
            }
        }
        return super.eventEnabled(aWTEvent);
    }

    @Override
    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof WindowEvent) {
            switch (aWTEvent.getID()) {
                case 200: 
                case 201: 
                case 202: 
                case 203: 
                case 204: 
                case 205: 
                case 206: {
                    this.processWindowEvent((WindowEvent)aWTEvent);
                    break;
                }
                case 207: 
                case 208: {
                    this.processWindowFocusEvent((WindowEvent)aWTEvent);
                    break;
                }
                case 209: {
                    this.processWindowStateEvent((WindowEvent)aWTEvent);
                }
            }
            return;
        }
        super.processEvent(aWTEvent);
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        WindowListener windowListener = this.windowListener;
        if (windowListener != null) {
            switch (windowEvent.getID()) {
                case 200: {
                    windowListener.windowOpened(windowEvent);
                    break;
                }
                case 201: {
                    windowListener.windowClosing(windowEvent);
                    break;
                }
                case 202: {
                    windowListener.windowClosed(windowEvent);
                    break;
                }
                case 203: {
                    windowListener.windowIconified(windowEvent);
                    break;
                }
                case 204: {
                    windowListener.windowDeiconified(windowEvent);
                    break;
                }
                case 205: {
                    windowListener.windowActivated(windowEvent);
                    break;
                }
                case 206: {
                    windowListener.windowDeactivated(windowEvent);
                    break;
                }
            }
        }
    }

    protected void processWindowFocusEvent(WindowEvent windowEvent) {
        WindowFocusListener windowFocusListener = this.windowFocusListener;
        if (windowFocusListener != null) {
            switch (windowEvent.getID()) {
                case 207: {
                    windowFocusListener.windowGainedFocus(windowEvent);
                    break;
                }
                case 208: {
                    windowFocusListener.windowLostFocus(windowEvent);
                    break;
                }
            }
        }
    }

    protected void processWindowStateEvent(WindowEvent windowEvent) {
        WindowStateListener windowStateListener = this.windowStateListener;
        if (windowStateListener != null) {
            switch (windowEvent.getID()) {
                case 209: {
                    windowStateListener.windowStateChanged(windowEvent);
                    break;
                }
            }
        }
    }

    @Override
    void preProcessKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.isActionKey() && keyEvent.getKeyCode() == 112 && keyEvent.isControlDown() && keyEvent.isShiftDown() && keyEvent.getID() == 401) {
            this.list(System.out, 0);
        }
    }

    @Override
    void postProcessKeyEvent(KeyEvent keyEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setAlwaysOnTop(boolean bl) throws SecurityException {
        boolean bl2;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SecurityConstants.SET_WINDOW_ALWAYS_ON_TOP_PERMISSION);
        }
        Object object = this;
        synchronized (object) {
            bl2 = this.alwaysOnTop;
            this.alwaysOnTop = bl;
        }
        if (bl2 != bl) {
            if (this.isAlwaysOnTopSupported()) {
                object = (WindowPeer)this.peer;
                Object object2 = this.getTreeLock();
                synchronized (object2) {
                    if (object != null) {
                        object.setAlwaysOnTop(bl);
                    }
                }
            }
            this.firePropertyChange("alwaysOnTop", bl2, bl);
        }
    }

    public boolean isAlwaysOnTopSupported() {
        return Toolkit.getDefaultToolkit().isAlwaysOnTopSupported();
    }

    public final boolean isAlwaysOnTop() {
        return this.alwaysOnTop;
    }

    public Component getFocusOwner() {
        return this.isFocused() ? KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() : null;
    }

    public Component getMostRecentFocusOwner() {
        if (this.isFocused()) {
            return this.getFocusOwner();
        }
        Component component = KeyboardFocusManager.getMostRecentFocusOwner(this);
        if (component != null) {
            return component;
        }
        return this.isFocusableWindow() ? this.getFocusTraversalPolicy().getInitialComponent(this) : null;
    }

    public boolean isActive() {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow() == this;
    }

    public boolean isFocused() {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getGlobalFocusedWindow() == this;
    }

    @Override
    public Set<AWTKeyStroke> getFocusTraversalKeys(int n) {
        Set set;
        if (n < 0 || n >= 4) {
            throw new IllegalArgumentException("invalid focus traversal key identifier");
        }
        Set set2 = set = this.focusTraversalKeys != null ? this.focusTraversalKeys[n] : null;
        if (set != null) {
            return set;
        }
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(n);
    }

    @Override
    public final void setFocusCycleRoot(boolean bl) {
    }

    @Override
    public final boolean isFocusCycleRoot() {
        return true;
    }

    @Override
    public final Container getFocusCycleRootAncestor() {
        return null;
    }

    public final boolean isFocusableWindow() {
        if (!this.getFocusableWindowState()) {
            return false;
        }
        if (this instanceof Frame || this instanceof Dialog) {
            return true;
        }
        if (this.getFocusTraversalPolicy().getDefaultComponent(this) == null) {
            return false;
        }
        for (Window window = this.getOwner(); window != null; window = window.getOwner()) {
            if (!(window instanceof Frame) && !(window instanceof Dialog)) continue;
            return window.isShowing();
        }
        return false;
    }

    public boolean getFocusableWindowState() {
        return this.focusableWindowState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFocusableWindowState(boolean bl) {
        boolean bl2;
        Object object = this;
        synchronized (object) {
            bl2 = this.focusableWindowState;
            this.focusableWindowState = bl;
        }
        object = (WindowPeer)this.peer;
        if (object != null) {
            object.updateFocusableWindowState();
        }
        this.firePropertyChange("focusableWindowState", bl2, bl);
        if (bl2 && !bl && this.isFocused()) {
            for (Window window = this.getOwner(); window != null; window = window.getOwner()) {
                Component component = KeyboardFocusManager.getMostRecentFocusOwner(window);
                if (component == null || !component.requestFocus(false, CausedFocusEvent.Cause.ACTIVATION)) continue;
                return;
            }
            KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(string, propertyChangeListener);
    }

    @Override
    void dispatchEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent.getID() == 101) {
            this.invalidate();
            this.validate();
        }
        super.dispatchEventImpl(aWTEvent);
    }

    @Override
    @Deprecated
    public boolean postEvent(Event event) {
        if (this.handleEvent(event)) {
            event.consume();
            return true;
        }
        return false;
    }

    @Override
    public boolean isShowing() {
        return this.visible;
    }

    @Deprecated
    public void applyResourceBundle(ResourceBundle resourceBundle) {
        this.applyComponentOrientation(ComponentOrientation.getOrientation(resourceBundle));
    }

    @Deprecated
    public void applyResourceBundle(String string) {
        this.applyResourceBundle(ResourceBundle.getBundle(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addOwnedWindow(WeakReference weakReference) {
        if (weakReference != null) {
            Vector<WeakReference<Window>> vector = this.ownedWindowList;
            synchronized (vector) {
                if (!this.ownedWindowList.contains(weakReference)) {
                    this.ownedWindowList.addElement(weakReference);
                }
            }
        }
    }

    void removeOwnedWindow(WeakReference weakReference) {
        if (weakReference != null) {
            this.ownedWindowList.removeElement(weakReference);
        }
    }

    void connectOwnedWindow(Window window) {
        window.parent = this;
        this.addOwnedWindow(window.weakThis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToWindowList() {
        Class<Window> clazz = Window.class;
        synchronized (Window.class) {
            Vector<WeakReference<Window>> vector = (Vector<WeakReference<Window>>)this.appContext.get(Window.class);
            if (vector == null) {
                vector = new Vector<WeakReference<Window>>();
                this.appContext.put(Window.class, vector);
            }
            vector.add(this.weakThis);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeFromWindowList(AppContext appContext, WeakReference weakReference) {
        Class<Window> clazz = Window.class;
        synchronized (Window.class) {
            Vector vector = (Vector)appContext.get(Window.class);
            if (vector != null) {
                vector.remove(weakReference);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void removeFromWindowList() {
        Window.removeFromWindowList(this.appContext, this.weakThis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Object object = this;
        synchronized (object) {
            this.focusMgr = new FocusManager();
            this.focusMgr.focusRoot = this;
            this.focusMgr.focusOwner = this.getMostRecentFocusOwner();
            objectOutputStream.defaultWriteObject();
            this.focusMgr = null;
            AWTEventMulticaster.save(objectOutputStream, "windowL", this.windowListener);
            AWTEventMulticaster.save(objectOutputStream, "windowFocusL", this.windowFocusListener);
            AWTEventMulticaster.save(objectOutputStream, "windowStateL", this.windowStateListener);
        }
        objectOutputStream.writeObject(null);
        object = this.ownedWindowList;
        synchronized (object) {
            for (int i = 0; i < this.ownedWindowList.size(); ++i) {
                Window window = (Window)this.ownedWindowList.elementAt(i).get();
                if (window == null) continue;
                objectOutputStream.writeObject("ownedL");
                objectOutputStream.writeObject(window);
            }
        }
        objectOutputStream.writeObject(null);
        if (this.icons != null) {
            for (Image image : this.icons) {
                if (!(image instanceof Serializable)) continue;
                objectOutputStream.writeObject(image);
            }
        }
        objectOutputStream.writeObject(null);
    }

    private void initDeserializedWindow() {
        this.setWarningString();
        this.inputContextLock = new Object();
        this.visible = false;
        this.weakThis = new WeakReference<Window>(this);
        this.anchor = new Object();
        Disposer.addRecord(this.anchor, new WindowDisposerRecord(this.appContext, this));
        this.addToWindowList();
    }

    private void deserializeResources(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException, HeadlessException {
        Object object;
        Object object2;
        this.ownedWindowList = new Vector();
        if (this.windowSerializedDataVersion < 2) {
            if (this.focusMgr != null && this.focusMgr.focusOwner != null) {
                KeyboardFocusManager.setMostRecentFocusOwner(this, this.focusMgr.focusOwner);
            }
            this.focusableWindowState = true;
        }
        while (null != (object2 = objectInputStream.readObject())) {
            object = ((String)object2).intern();
            if ("windowL" == object) {
                this.addWindowListener((WindowListener)objectInputStream.readObject());
                continue;
            }
            if ("windowFocusL" == object) {
                this.addWindowFocusListener((WindowFocusListener)objectInputStream.readObject());
                continue;
            }
            if ("windowStateL" == object) {
                this.addWindowStateListener((WindowStateListener)objectInputStream.readObject());
                continue;
            }
            objectInputStream.readObject();
        }
        try {
            while (null != (object2 = objectInputStream.readObject())) {
                object = ((String)object2).intern();
                if ("ownedL" == object) {
                    this.connectOwnedWindow((Window)objectInputStream.readObject());
                    continue;
                }
                objectInputStream.readObject();
            }
            object = objectInputStream.readObject();
            this.icons = new ArrayList<Image>();
            while (object != null) {
                if (object instanceof Image) {
                    this.icons.add((Image)object);
                }
                object = objectInputStream.readObject();
            }
        }
        catch (OptionalDataException optionalDataException) {
            // empty catch block
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException, HeadlessException {
        GraphicsEnvironment.checkHeadless();
        this.initDeserializedWindow();
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        this.syncLWRequests = getField.get("syncLWRequests", systemSyncLWRequests);
        this.state = getField.get("state", 0);
        this.focusableWindowState = getField.get("focusableWindowState", true);
        this.windowSerializedDataVersion = getField.get("windowSerializedDataVersion", 1);
        this.locationByPlatform = getField.get("locationByPlatform", locationByPlatformProp);
        this.focusMgr = (FocusManager)getField.get("focusMgr", null);
        Dialog.ModalExclusionType modalExclusionType = (Dialog.ModalExclusionType)((Object)getField.get("modalExclusionType", (Object)Dialog.ModalExclusionType.NO_EXCLUDE));
        this.setModalExclusionType(modalExclusionType);
        boolean bl = getField.get("alwaysOnTop", false);
        if (bl) {
            this.setAlwaysOnTop(bl);
        }
        this.deserializeResources(objectInputStream);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTWindow();
        }
        return this.accessibleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GraphicsConfiguration getGraphicsConfiguration() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.graphicsConfig == null && !GraphicsEnvironment.isHeadless()) {
                this.graphicsConfig = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            }
            return this.graphicsConfig;
        }
    }

    @Override
    void resetGC() {
        if (!GraphicsEnvironment.isHeadless()) {
            this.setGCFromPeer();
            if (this.graphicsConfig == null) {
                this.graphicsConfig = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            }
            if (log.isLoggable(Level.FINER)) {
                log.finer("+ Window.resetGC(): new GC is \n+ " + this.graphicsConfig + "\n+ this is " + this);
            }
        }
    }

    public void setLocationRelativeTo(Component component) {
        Serializable serializable;
        Serializable serializable2 = null;
        if (component != null) {
            if (component instanceof Window || component instanceof Applet) {
                serializable2 = (Container)component;
            } else {
                for (serializable = component.getParent(); serializable != null; serializable = ((Component)serializable).getParent()) {
                    if (!(serializable instanceof Window) && !(serializable instanceof Applet)) continue;
                    serializable2 = serializable;
                    break;
                }
            }
        }
        if (component != null && !component.isShowing() || serializable2 == null || !((Component)serializable2).isShowing()) {
            serializable = this.getSize();
            Point point = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
            this.setLocation(point.x - ((Dimension)serializable).width / 2, point.y - ((Dimension)serializable).height / 2);
        } else {
            serializable = component.getSize();
            Point point = component.getLocationOnScreen();
            Rectangle rectangle = this.getBounds();
            int n = point.x + (((Dimension)serializable).width - rectangle.width >> 1);
            int n2 = point.y + (((Dimension)serializable).height - rectangle.height >> 1);
            Rectangle rectangle2 = ((Component)serializable2).getGraphicsConfiguration().getBounds();
            if (n2 + rectangle.height > rectangle2.y + rectangle2.height) {
                n2 = rectangle2.y + rectangle2.height - rectangle.height;
                n = point.x - rectangle2.x + ((Dimension)serializable).width / 2 < rectangle2.width / 2 ? point.x + ((Dimension)serializable).width : point.x - rectangle.width;
            }
            if (n + rectangle.width > rectangle2.x + rectangle2.width) {
                n = rectangle2.x + rectangle2.width - rectangle.width;
            }
            if (n < rectangle2.x) {
                n = rectangle2.x;
            }
            if (n2 < rectangle2.y) {
                n2 = rectangle2.y;
            }
            this.setLocation(n, n2);
        }
    }

    void deliverMouseWheelToAncestor(MouseWheelEvent mouseWheelEvent) {
    }

    @Override
    boolean dispatchMouseWheelToAncestor(MouseWheelEvent mouseWheelEvent) {
        return false;
    }

    @Override
    public void createBufferStrategy(int n) {
        super.createBufferStrategy(n);
    }

    @Override
    public void createBufferStrategy(int n, BufferCapabilities bufferCapabilities) throws AWTException {
        super.createBufferStrategy(n, bufferCapabilities);
    }

    @Override
    public BufferStrategy getBufferStrategy() {
        return super.getBufferStrategy();
    }

    Component getTemporaryLostComponent() {
        return this.temporaryLostComponent;
    }

    Component setTemporaryLostComponent(Component component) {
        Component component2 = this.temporaryLostComponent;
        this.temporaryLostComponent = component == null || component.isDisplayable() && component.isVisible() && component.isEnabled() && component.isFocusable() ? component : null;
        return component2;
    }

    @Override
    boolean canContainFocusOwner(Component component) {
        return super.canContainFocusOwner(component) && this.isFocusableWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocationByPlatform(boolean bl) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (bl && this.isShowing()) {
                throw new IllegalComponentStateException("The window is showing on screen.");
            }
            this.locationByPlatform = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocationByPlatform() {
        Object object = this.getTreeLock();
        synchronized (object) {
            return this.locationByPlatform;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.getBoundsOp() == 1 || this.getBoundsOp() == 3) {
                this.locationByPlatform = false;
            }
            super.setBounds(n, n2, n3, n4);
        }
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    boolean isRecursivelyVisible() {
        return this.visible;
    }

    @Override
    final Container getContainer() {
        return null;
    }

    @Override
    final void applyCompoundShape(Region region) {
    }

    @Override
    final void applyCurrentShape() {
    }

    @Override
    final void mixOnReshaping() {
    }

    @Override
    final Point getLocationOnWindow() {
        return new Point(0, 0);
    }

    static {
        String string;
        systemSyncLWRequests = false;
        allWindows = new IdentityArrayList();
        nameCounter = 0;
        log = Logger.getLogger("java.awt.Window");
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            Window.initIDs();
        }
        systemSyncLWRequests = (string = AccessController.doPrivileged(new GetPropertyAction("java.awt.syncLWRequests"))) != null && string.equals("true");
        string = AccessController.doPrivileged(new GetPropertyAction("java.awt.Window.locationByPlatform"));
        locationByPlatformProp = string != null && string.equals("true");
        AWTAccessor.setWindowAccessor(new AWTAccessor.WindowAccessor(){

            public void setLWRequestStatus(Window window, boolean bl) {
                window.syncLWRequests = bl;
            }
        });
        beforeFirstWindowShown = new AtomicBoolean(true);
    }

    protected class AccessibleAWTWindow
    extends Container.AccessibleAWTContainer {
        private static final long serialVersionUID = 4215068635060671780L;

        protected AccessibleAWTWindow() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.WINDOW;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (Window.this.getFocusOwner() != null) {
                accessibleStateSet.add(AccessibleState.ACTIVE);
            }
            return accessibleStateSet;
        }
    }

    static class WindowDisposerRecord
    implements DisposerRecord {
        final WeakReference<Window> owner;
        final WeakReference weakThis;
        final AppContext context;

        WindowDisposerRecord(AppContext appContext, Window window) {
            this.owner = new WeakReference<Window>(window.getOwner());
            this.weakThis = window.weakThis;
            this.context = appContext;
        }

        public void dispose() {
            Window window = (Window)this.owner.get();
            if (window != null) {
                window.removeOwnedWindow(this.weakThis);
            }
            Window.removeFromWindowList(this.context, this.weakThis);
        }
    }
}

