/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.GTKColorChooserPanel;
import com.sun.java.swing.plaf.gtk.GTKColorType;
import com.sun.java.swing.plaf.gtk.GTKConstants;
import com.sun.java.swing.plaf.gtk.GTKEngine;
import com.sun.java.swing.plaf.gtk.GTKFileChooserUI;
import com.sun.java.swing.plaf.gtk.GTKIconFactory;
import com.sun.java.swing.plaf.gtk.GTKPainter;
import com.sun.java.swing.plaf.gtk.GTKStyle;
import com.sun.java.swing.plaf.gtk.GTKStyleFactory;
import com.sun.java.swing.plaf.gtk.PangoFonts;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthLookAndFeel;
import sun.awt.OSInfo;
import sun.awt.SunToolkit;
import sun.awt.UNIXToolkit;
import sun.security.action.GetPropertyAction;
import sun.swing.DefaultLayoutStyle;
import sun.swing.SwingLazyValue;
import sun.swing.SwingUtilities2;

public class GTKLookAndFeel
extends SynthLookAndFeel {
    private static final boolean IS_22;
    static Object aaTextInfo;
    private static boolean isSunCJK;
    private static boolean gtkAAFontSettingsCond;
    private Font fallbackFont;
    private boolean inInitialize;
    private boolean pclInstalled;
    private GTKStyleFactory styleFactory;
    private static String gtkThemeName;
    static ReferenceQueue queue;

    static boolean is2_2() {
        return IS_22;
    }

    static GTKConstants.PositionType SwingOrientationConstantToGTK(int n) {
        switch (n) {
            case 2: {
                return GTKConstants.PositionType.LEFT;
            }
            case 4: {
                return GTKConstants.PositionType.RIGHT;
            }
            case 1: {
                return GTKConstants.PositionType.TOP;
            }
            case 3: {
                return GTKConstants.PositionType.BOTTOM;
            }
        }
        assert (false) : "Unknown orientation: " + n;
        return GTKConstants.PositionType.TOP;
    }

    static GTKConstants.StateType synthStateToGTKStateType(int n) {
        GTKConstants.StateType stateType;
        switch (n) {
            case 4: {
                stateType = GTKConstants.StateType.ACTIVE;
                break;
            }
            case 2: {
                stateType = GTKConstants.StateType.PRELIGHT;
                break;
            }
            case 512: {
                stateType = GTKConstants.StateType.SELECTED;
                break;
            }
            case 8: {
                stateType = GTKConstants.StateType.INSENSITIVE;
                break;
            }
            default: {
                stateType = GTKConstants.StateType.NORMAL;
            }
        }
        return stateType;
    }

    static int synthStateToGTKState(Region region, int n) {
        n = (n & 4) != 0 ? (region == Region.RADIO_BUTTON || region == Region.CHECK_BOX || region == Region.MENU || region == Region.MENU_ITEM || region == Region.RADIO_BUTTON_MENU_ITEM || region == Region.CHECK_BOX_MENU_ITEM || region == Region.SPLIT_PANE ? 2 : 4) : (region == Region.TABBED_PANE_TAB ? ((n & 8) != 0 ? 8 : ((n & 0x200) != 0 ? 1 : 4)) : ((n & 0x200) != 0 ? (region == Region.MENU ? 2 : (region == Region.RADIO_BUTTON || region == Region.TOGGLE_BUTTON || region == Region.RADIO_BUTTON_MENU_ITEM || region == Region.CHECK_BOX_MENU_ITEM || region == Region.CHECK_BOX || region == Region.BUTTON ? ((n & 8) != 0 ? 8 : ((n & 2) != 0 ? 2 : 4)) : 512)) : ((n & 2) != 0 ? 2 : ((n & 8) != 0 ? 8 : (region == Region.SLIDER_TRACK ? 4 : 1)))));
        return n;
    }

    static boolean isText(Region region) {
        return region == Region.TEXT_FIELD || region == Region.FORMATTED_TEXT_FIELD || region == Region.LIST || region == Region.PASSWORD_FIELD || region == Region.SPINNER || region == Region.TABLE || region == Region.TEXT_AREA || region == Region.TEXT_FIELD || region == Region.TEXT_PANE || region == Region.TREE;
    }

    @Override
    public UIDefaults getDefaults() {
        UIDefaults uIDefaults = super.getDefaults();
        uIDefaults.put("TabbedPane.isTabRollover", Boolean.FALSE);
        uIDefaults.put("Synth.doNotSetTextAA", (Object)true);
        this.initResourceBundle(uIDefaults);
        this.initSystemColorDefaults(uIDefaults);
        this.initComponentDefaults(uIDefaults);
        this.installPropertyChangeListeners();
        return uIDefaults;
    }

    private void installPropertyChangeListeners() {
        if (!this.pclInstalled) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            WeakPCL weakPCL = new WeakPCL(this, toolkit, "gnome.Net/ThemeName");
            toolkit.addPropertyChangeListener(weakPCL.getKey(), weakPCL);
            weakPCL = new WeakPCL(this, toolkit, "gnome.Gtk/FontName");
            toolkit.addPropertyChangeListener(weakPCL.getKey(), weakPCL);
            weakPCL = new WeakPCL(this, toolkit, "gnome.Xft/DPI");
            toolkit.addPropertyChangeListener(weakPCL.getKey(), weakPCL);
            GTKLookAndFeel.flushUnreferenced();
            this.pclInstalled = true;
        }
    }

    private void initResourceBundle(UIDefaults uIDefaults) {
        uIDefaults.addResourceBundle("com.sun.java.swing.plaf.gtk.resources.gtk");
    }

    @Override
    protected void initComponentDefaults(UIDefaults uIDefaults) {
        super.initComponentDefaults(uIDefaults);
        Integer n = new Integer(0);
        SwingLazyValue swingLazyValue = new SwingLazyValue("javax.swing.plaf.BorderUIResource$EmptyBorderUIResource", new Object[]{n, n, n, n});
        GTKStyle.GTKLazyValue gTKLazyValue = new GTKStyle.GTKLazyValue("com.sun.java.swing.plaf.gtk.GTKPainter$ListTableFocusBorder", "getUnselectedCellBorder");
        GTKStyle.GTKLazyValue gTKLazyValue2 = new GTKStyle.GTKLazyValue("com.sun.java.swing.plaf.gtk.GTKPainter$ListTableFocusBorder", "getSelectedCellBorder");
        GTKStyle.GTKLazyValue gTKLazyValue3 = new GTKStyle.GTKLazyValue("com.sun.java.swing.plaf.gtk.GTKPainter$ListTableFocusBorder", "getNoFocusCellBorder");
        GTKStyleFactory gTKStyleFactory = (GTKStyleFactory)GTKLookAndFeel.getStyleFactory();
        GTKStyle gTKStyle = (GTKStyle)gTKStyleFactory.getStyle(null, Region.TREE);
        Color color = gTKStyle.getGTKColor(1, GTKColorType.TEXT_BACKGROUND);
        Color color2 = gTKStyle.getGTKColor(1, GTKColorType.BACKGROUND);
        Color color3 = gTKStyle.getGTKColor(1, GTKColorType.FOREGROUND);
        GTKStyle gTKStyle2 = (GTKStyle)gTKStyleFactory.getStyle(null, Region.PROGRESS_BAR);
        int n2 = gTKStyle2.getXThickness();
        int n3 = gTKStyle2.getYThickness();
        int n4 = 150 - n2 * 2;
        int n5 = 20 - n3 * 2;
        int n6 = 22 - n2 * 2;
        int n7 = 80 - n3 * 2;
        Integer n8 = new Integer(500);
        InsetsUIResource insetsUIResource = new InsetsUIResource(0, 0, 0, 0);
        Double d = new Double(0.025);
        Color color4 = uIDefaults.getColor("caretColor");
        Color color5 = uIDefaults.getColor("controlText");
        UIDefaults.LazyInputMap lazyInputMap = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "control INSERT", "copy-to-clipboard", "shift INSERT", "paste-from-clipboard", "shift DELETE", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "BACK_SPACE", "delete-previous", "shift BACK_SPACE", "delete-previous", "ctrl H", "delete-previous", "DELETE", "delete-next", "ctrl DELETE", "delete-next-word", "ctrl BACK_SPACE", "delete-previous-word", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "ctrl BACK_SLASH", "unselect", "control shift O", "toggle-componentOrientation"});
        UIDefaults.LazyInputMap lazyInputMap2 = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "control INSERT", "copy-to-clipboard", "shift INSERT", "paste-from-clipboard", "shift DELETE", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-begin-line", "ctrl KP_LEFT", "caret-begin-line", "ctrl RIGHT", "caret-end-line", "ctrl KP_RIGHT", "caret-end-line", "ctrl shift LEFT", "selection-begin-line", "ctrl shift KP_LEFT", "selection-begin-line", "ctrl shift RIGHT", "selection-end-line", "ctrl shift KP_RIGHT", "selection-end-line", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "BACK_SPACE", "delete-previous", "shift BACK_SPACE", "delete-previous", "ctrl H", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "ctrl BACK_SLASH", "unselect", "control shift O", "toggle-componentOrientation"});
        InsetsUIResource insetsUIResource2 = new InsetsUIResource(3, 3, 3, 3);
        UIDefaults.LazyInputMap lazyInputMap3 = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "control INSERT", "copy-to-clipboard", "shift INSERT", "paste-from-clipboard", "shift DELETE", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "UP", "caret-up", "KP_UP", "caret-up", "DOWN", "caret-down", "KP_DOWN", "caret-down", "PAGE_UP", "page-up", "PAGE_DOWN", "page-down", "shift PAGE_UP", "selection-page-up", "shift PAGE_DOWN", "selection-page-down", "ctrl shift PAGE_UP", "selection-page-left", "ctrl shift PAGE_DOWN", "selection-page-right", "shift UP", "selection-up", "shift KP_UP", "selection-up", "shift DOWN", "selection-down", "shift KP_DOWN", "selection-down", "ENTER", "insert-break", "BACK_SPACE", "delete-previous", "shift BACK_SPACE", "delete-previous", "ctrl H", "delete-previous", "DELETE", "delete-next", "ctrl DELETE", "delete-next-word", "ctrl BACK_SPACE", "delete-previous-word", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "TAB", "insert-tab", "ctrl BACK_SLASH", "unselect", "ctrl HOME", "caret-begin", "ctrl END", "caret-end", "ctrl shift HOME", "selection-begin", "ctrl shift END", "selection-end", "ctrl T", "next-link-action", "ctrl shift T", "previous-link-action", "ctrl SPACE", "activate-link-action", "control shift O", "toggle-componentOrientation"});
        class FontLazyValue
        implements UIDefaults.LazyValue {
            private Region region;

            FontLazyValue(Region region) {
                this.region = region;
            }

            @Override
            public Object createValue(UIDefaults uIDefaults) {
                GTKStyleFactory gTKStyleFactory = (GTKStyleFactory)SynthLookAndFeel.getStyleFactory();
                GTKStyle gTKStyle = (GTKStyle)gTKStyleFactory.getStyle(null, this.region);
                return gTKStyle.getFontForState(null);
            }
        }
        Object[] objectArray = new Object[]{"ArrowButton.size", new Integer(13), "Button.defaultButtonFollowsFocus", Boolean.FALSE, "Button.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released", "ENTER", "pressed", "released ENTER", "released"}), "Button.font", new FontLazyValue(Region.BUTTON), "Button.margin", insetsUIResource, "CheckBox.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released"}), "CheckBox.icon", new GTKStyle.GTKLazyValue("com.sun.java.swing.plaf.gtk.GTKIconFactory", "getCheckBoxIcon"), "CheckBox.font", new FontLazyValue(Region.CHECK_BOX), "CheckBox.margin", insetsUIResource, "CheckBoxMenuItem.arrowIcon", null, "CheckBoxMenuItem.checkIcon", new GTKStyle.GTKLazyValue("com.sun.java.swing.plaf.gtk.GTKIconFactory", "getCheckBoxMenuItemCheckIcon"), "CheckBoxMenuItem.font", new FontLazyValue(Region.CHECK_BOX_MENU_ITEM), "CheckBoxMenuItem.margin", insetsUIResource, "CheckBoxMenuItem.alignAcceleratorText", Boolean.FALSE, "ColorChooser.showPreviewPanelText", Boolean.FALSE, "ColorChooser.panels", new UIDefaults.ActiveValue(){

            @Override
            public Object createValue(UIDefaults uIDefaults) {
                return new AbstractColorChooserPanel[]{new GTKColorChooserPanel()};
            }
        }, "ColorChooser.font", new FontLazyValue(Region.COLOR_CHOOSER), "ComboBox.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "hidePopup", "PAGE_UP", "pageUpPassThrough", "PAGE_DOWN", "pageDownPassThrough", "HOME", "homePassThrough", "END", "endPassThrough", "DOWN", "selectNext", "KP_DOWN", "selectNext", "alt DOWN", "togglePopup", "alt KP_DOWN", "togglePopup", "alt UP", "togglePopup", "alt KP_UP", "togglePopup", "SPACE", "spacePopup", "ENTER", "enterPressed", "UP", "selectPrevious", "KP_UP", "selectPrevious"}), "ComboBox.font", new FontLazyValue(Region.COMBO_BOX), "ComboBox.isEnterSelectablePopup", Boolean.TRUE, "EditorPane.caretForeground", color4, "EditorPane.caretAspectRatio", d, "EditorPane.caretBlinkRate", n8, "EditorPane.margin", insetsUIResource2, "EditorPane.focusInputMap", lazyInputMap3, "EditorPane.font", new FontLazyValue(Region.EDITOR_PANE), "FileChooser.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "cancelSelection", "ctrl ENTER", "approveSelection"}), "FileChooserUI", "com.sun.java.swing.plaf.gtk.GTKLookAndFeel", "FormattedTextField.caretForeground", color4, "FormattedTextField.caretAspectRatio", d, "FormattedTextField.caretBlinkRate", n8, "FormattedTextField.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "control INSERT", "copy-to-clipboard", "shift INSERT", "paste-from-clipboard", "shift DELETE", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "BACK_SPACE", "delete-previous", "shift BACK_SPACE", "delete-previous", "ctrl H", "delete-previous", "DELETE", "delete-next", "ctrl DELETE", "delete-next-word", "ctrl BACK_SPACE", "delete-previous-word", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "ctrl BACK_SLASH", "unselect", "control shift O", "toggle-componentOrientation", "ESCAPE", "reset-field-edit", "UP", "increment", "KP_UP", "increment", "DOWN", "decrement", "KP_DOWN", "decrement"}), "FormattedTextField.font", new FontLazyValue(Region.FORMATTED_TEXT_FIELD), "InternalFrameTitlePane.titlePaneLayout", new GTKStyle.GTKLazyValue("com.sun.java.swing.plaf.gtk.Metacity", "getTitlePaneLayout"), "InternalFrame.windowBindings", new Object[]{"shift ESCAPE", "showSystemMenu", "ctrl SPACE", "showSystemMenu", "ESCAPE", "hideSystemMenu"}, "InternalFrame.layoutTitlePaneAtOrigin", Boolean.TRUE, "InternalFrame.useTaskBar", Boolean.TRUE, "InternalFrameTitlePane.iconifyButtonOpacity", null, "InternalFrameTitlePane.maximizeButtonOpacity", null, "InternalFrameTitlePane.closeButtonOpacity", null, "Label.font", new FontLazyValue(Region.LABEL), "List.background", color, "List.focusCellHighlightBorder", gTKLazyValue, "List.focusSelectedCellHighlightBorder", gTKLazyValue2, "List.noFocusBorder", gTKLazyValue3, "List.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy", "ctrl V", "paste", "ctrl X", "cut", "COPY", "copy", "PASTE", "paste", "CUT", "cut", "control INSERT", "copy", "shift INSERT", "paste", "shift DELETE", "cut", "UP", "selectPreviousRow", "KP_UP", "selectPreviousRow", "shift UP", "selectPreviousRowExtendSelection", "shift KP_UP", "selectPreviousRowExtendSelection", "ctrl shift UP", "selectPreviousRowExtendSelection", "ctrl shift KP_UP", "selectPreviousRowExtendSelection", "ctrl UP", "selectPreviousRowChangeLead", "ctrl KP_UP", "selectPreviousRowChangeLead", "DOWN", "selectNextRow", "KP_DOWN", "selectNextRow", "shift DOWN", "selectNextRowExtendSelection", "shift KP_DOWN", "selectNextRowExtendSelection", "ctrl shift DOWN", "selectNextRowExtendSelection", "ctrl shift KP_DOWN", "selectNextRowExtendSelection", "ctrl DOWN", "selectNextRowChangeLead", "ctrl KP_DOWN", "selectNextRowChangeLead", "LEFT", "selectPreviousColumn", "KP_LEFT", "selectPreviousColumn", "shift LEFT", "selectPreviousColumnExtendSelection", "shift KP_LEFT", "selectPreviousColumnExtendSelection", "ctrl shift LEFT", "selectPreviousColumnExtendSelection", "ctrl shift KP_LEFT", "selectPreviousColumnExtendSelection", "ctrl LEFT", "selectPreviousColumnChangeLead", "ctrl KP_LEFT", "selectPreviousColumnChangeLead", "RIGHT", "selectNextColumn", "KP_RIGHT", "selectNextColumn", "shift RIGHT", "selectNextColumnExtendSelection", "shift KP_RIGHT", "selectNextColumnExtendSelection", "ctrl shift RIGHT", "selectNextColumnExtendSelection", "ctrl shift KP_RIGHT", "selectNextColumnExtendSelection", "ctrl RIGHT", "selectNextColumnChangeLead", "ctrl KP_RIGHT", "selectNextColumnChangeLead", "HOME", "selectFirstRow", "shift HOME", "selectFirstRowExtendSelection", "ctrl shift HOME", "selectFirstRowExtendSelection", "ctrl HOME", "selectFirstRowChangeLead", "END", "selectLastRow", "shift END", "selectLastRowExtendSelection", "ctrl shift END", "selectLastRowExtendSelection", "ctrl END", "selectLastRowChangeLead", "PAGE_UP", "scrollUp", "shift PAGE_UP", "scrollUpExtendSelection", "ctrl shift PAGE_UP", "scrollUpExtendSelection", "ctrl PAGE_UP", "scrollUpChangeLead", "PAGE_DOWN", "scrollDown", "shift PAGE_DOWN", "scrollDownExtendSelection", "ctrl shift PAGE_DOWN", "scrollDownExtendSelection", "ctrl PAGE_DOWN", "scrollDownChangeLead", "ctrl A", "selectAll", "ctrl SLASH", "selectAll", "ctrl BACK_SLASH", "clearSelection", "SPACE", "addToSelection", "ctrl SPACE", "toggleAndAnchor", "shift SPACE", "extendTo", "ctrl shift SPACE", "moveSelectionTo"}), "List.focusInputMap.RightToLeft", new UIDefaults.LazyInputMap(new Object[]{"LEFT", "selectNextColumn", "KP_LEFT", "selectNextColumn", "shift LEFT", "selectNextColumnExtendSelection", "shift KP_LEFT", "selectNextColumnExtendSelection", "ctrl shift LEFT", "selectNextColumnExtendSelection", "ctrl shift KP_LEFT", "selectNextColumnExtendSelection", "ctrl LEFT", "selectNextColumnChangeLead", "ctrl KP_LEFT", "selectNextColumnChangeLead", "RIGHT", "selectPreviousColumn", "KP_RIGHT", "selectPreviousColumn", "shift RIGHT", "selectPreviousColumnExtendSelection", "shift KP_RIGHT", "selectPreviousColumnExtendSelection", "ctrl shift RIGHT", "selectPreviousColumnExtendSelection", "ctrl shift KP_RIGHT", "selectPreviousColumnExtendSelection", "ctrl RIGHT", "selectPreviousColumnChangeLead", "ctrl KP_RIGHT", "selectPreviousColumnChangeLead"}), "List.font", new FontLazyValue(Region.LIST), "List.rendererUseUIBorder", Boolean.FALSE, "Menu.shortcutKeys", new int[]{8}, "Menu.arrowIcon", new GTKStyle.GTKLazyValue("com.sun.java.swing.plaf.gtk.GTKIconFactory", "getMenuArrowIcon"), "Menu.checkIcon", null, "Menu.font", new FontLazyValue(Region.MENU), "Menu.margin", insetsUIResource, "Menu.cancelMode", "hideMenuTree", "Menu.alignAcceleratorText", Boolean.FALSE, "MenuBar.windowBindings", new Object[]{"F10", "takeFocus"}, "MenuBar.font", new FontLazyValue(Region.MENU_BAR), "MenuItem.arrowIcon", null, "MenuItem.checkIcon", null, "MenuItem.font", new FontLazyValue(Region.MENU_ITEM), "MenuItem.margin", insetsUIResource, "MenuItem.alignAcceleratorText", Boolean.FALSE, "OptionPane.setButtonMargin", Boolean.FALSE, "OptionPane.sameSizeButtons", Boolean.TRUE, "OptionPane.buttonOrientation", new Integer(4), "OptionPane.minimumSize", new DimensionUIResource(262, 90), "OptionPane.buttonPadding", new Integer(10), "OptionPane.windowBindings", new Object[]{"ESCAPE", "close"}, "OptionPane.buttonClickThreshhold", new Integer(500), "OptionPane.isYesLast", Boolean.TRUE, "OptionPane.font", new FontLazyValue(Region.OPTION_PANE), "Panel.font", new FontLazyValue(Region.PANEL), "PasswordField.caretForeground", color4, "PasswordField.caretAspectRatio", d, "PasswordField.caretBlinkRate", n8, "PasswordField.margin", insetsUIResource, "PasswordField.focusInputMap", lazyInputMap2, "PasswordField.font", new FontLazyValue(Region.PASSWORD_FIELD), "PopupMenu.consumeEventOnClose", Boolean.TRUE, "PopupMenu.selectedWindowInputMapBindings", new Object[]{"ESCAPE", "cancel", "DOWN", "selectNext", "KP_DOWN", "selectNext", "UP", "selectPrevious", "KP_UP", "selectPrevious", "LEFT", "selectParent", "KP_LEFT", "selectParent", "RIGHT", "selectChild", "KP_RIGHT", "selectChild", "ENTER", "return", "SPACE", "return"}, "PopupMenu.selectedWindowInputMapBindings.RightToLeft", new Object[]{"LEFT", "selectChild", "KP_LEFT", "selectChild", "RIGHT", "selectParent", "KP_RIGHT", "selectParent"}, "PopupMenu.font", new FontLazyValue(Region.POPUP_MENU), "ProgressBar.horizontalSize", new DimensionUIResource(n4, n5), "ProgressBar.verticalSize", new DimensionUIResource(n6, n7), "ProgressBar.font", new FontLazyValue(Region.PROGRESS_BAR), "RadioButton.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released", "RETURN", "pressed"}), "RadioButton.icon", new GTKStyle.GTKLazyValue("com.sun.java.swing.plaf.gtk.GTKIconFactory", "getRadioButtonIcon"), "RadioButton.font", new FontLazyValue(Region.RADIO_BUTTON), "RadioButton.margin", insetsUIResource, "RadioButtonMenuItem.arrowIcon", null, "RadioButtonMenuItem.checkIcon", new GTKStyle.GTKLazyValue("com.sun.java.swing.plaf.gtk.GTKIconFactory", "getRadioButtonMenuItemCheckIcon"), "RadioButtonMenuItem.font", new FontLazyValue(Region.RADIO_BUTTON_MENU_ITEM), "RadioButtonMenuItem.margin", insetsUIResource, "RadioButtonMenuItem.alignAcceleratorText", Boolean.FALSE, "RootPane.defaultButtonWindowKeyBindings", new Object[]{"ENTER", "press", "released ENTER", "release", "ctrl ENTER", "press", "ctrl released ENTER", "release"}, "ScrollBar.squareButtons", Boolean.FALSE, "ScrollBar.thumbHeight", new Integer(14), "ScrollBar.width", new Integer(16), "ScrollBar.minimumThumbSize", new Dimension(8, 8), "ScrollBar.maximumThumbSize", new Dimension(4096, 4096), "ScrollBar.allowsAbsolutePositioning", Boolean.TRUE, "ScrollBar.alwaysShowThumb", Boolean.TRUE, "ScrollBar.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "positiveUnitIncrement", "KP_RIGHT", "positiveUnitIncrement", "DOWN", "positiveUnitIncrement", "KP_DOWN", "positiveUnitIncrement", "PAGE_DOWN", "positiveBlockIncrement", "LEFT", "negativeUnitIncrement", "KP_LEFT", "negativeUnitIncrement", "UP", "negativeUnitIncrement", "KP_UP", "negativeUnitIncrement", "PAGE_UP", "negativeBlockIncrement", "HOME", "minScroll", "END", "maxScroll"}), "ScrollBar.ancestorInputMap.RightToLeft", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "negativeUnitIncrement", "KP_RIGHT", "negativeUnitIncrement", "LEFT", "positiveUnitIncrement", "KP_LEFT", "positiveUnitIncrement"}), "Spinner.disableOnBoundaryValues", Boolean.TRUE, "ScrollPane.fillUpperCorner", Boolean.TRUE, "ScrollPane.fillLowerCorner", Boolean.TRUE, "ScrollPane.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "unitScrollRight", "KP_RIGHT", "unitScrollRight", "DOWN", "unitScrollDown", "KP_DOWN", "unitScrollDown", "LEFT", "unitScrollLeft", "KP_LEFT", "unitScrollLeft", "UP", "unitScrollUp", "KP_UP", "unitScrollUp", "PAGE_UP", "scrollUp", "PAGE_DOWN", "scrollDown", "ctrl PAGE_UP", "scrollLeft", "ctrl PAGE_DOWN", "scrollRight", "ctrl HOME", "scrollHome", "ctrl END", "scrollEnd"}), "ScrollPane.ancestorInputMap.RightToLeft", new UIDefaults.LazyInputMap(new Object[]{"ctrl PAGE_UP", "scrollRight", "ctrl PAGE_DOWN", "scrollLeft"}), "ScrollPane.font", new FontLazyValue(Region.SCROLL_PANE), "Separator.insets", insetsUIResource, "Separator.thickness", new Integer(2), "Slider.paintValue", Boolean.TRUE, "Slider.thumbWidth", new Integer(30), "Slider.thumbHeight", new Integer(14), "Slider.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "positiveUnitIncrement", "KP_RIGHT", "positiveUnitIncrement", "DOWN", "negativeUnitIncrement", "KP_DOWN", "negativeUnitIncrement", "PAGE_DOWN", "negativeBlockIncrement", "LEFT", "negativeUnitIncrement", "KP_LEFT", "negativeUnitIncrement", "UP", "positiveUnitIncrement", "KP_UP", "positiveUnitIncrement", "PAGE_UP", "positiveBlockIncrement", "HOME", "minScroll", "END", "maxScroll"}), "Slider.focusInputMap.RightToLeft", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "negativeUnitIncrement", "KP_RIGHT", "negativeUnitIncrement", "LEFT", "positiveUnitIncrement", "KP_LEFT", "positiveUnitIncrement"}), "Spinner.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"UP", "increment", "KP_UP", "increment", "DOWN", "decrement", "KP_DOWN", "decrement"}), "Spinner.font", new FontLazyValue(Region.SPINNER), "Spinner.editorAlignment", 10, "SplitPane.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"UP", "negativeIncrement", "DOWN", "positiveIncrement", "LEFT", "negativeIncrement", "RIGHT", "positiveIncrement", "KP_UP", "negativeIncrement", "KP_DOWN", "positiveIncrement", "KP_LEFT", "negativeIncrement", "KP_RIGHT", "positiveIncrement", "HOME", "selectMin", "END", "selectMax", "F8", "startResize", "F6", "toggleFocus", "ctrl TAB", "focusOutForward", "ctrl shift TAB", "focusOutBackward"}), "SplitPane.size", new Integer(7), "SplitPane.oneTouchOffset", new Integer(2), "SplitPane.oneTouchButtonSize", new Integer(5), "SplitPane.supportsOneTouchButtons", Boolean.FALSE, "TabbedPane.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "navigateRight", "KP_RIGHT", "navigateRight", "LEFT", "navigateLeft", "KP_LEFT", "navigateLeft", "UP", "navigateUp", "KP_UP", "navigateUp", "DOWN", "navigateDown", "KP_DOWN", "navigateDown", "ctrl DOWN", "requestFocusForVisibleComponent", "ctrl KP_DOWN", "requestFocusForVisibleComponent", "SPACE", "selectTabWithFocus"}), "TabbedPane.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl TAB", "navigateNext", "ctrl shift TAB", "navigatePrevious", "ctrl PAGE_DOWN", "navigatePageDown", "ctrl PAGE_UP", "navigatePageUp", "ctrl UP", "requestFocus", "ctrl KP_UP", "requestFocus"}), "TabbedPane.labelShift", 3, "TabbedPane.selectedLabelShift", 3, "TabbedPane.font", new FontLazyValue(Region.TABBED_PANE), "TabbedPane.selectedTabPadInsets", new InsetsUIResource(2, 2, 0, 1), "Table.scrollPaneBorder", swingLazyValue, "Table.background", color, "Table.focusCellBackground", color2, "Table.focusCellForeground", color3, "Table.focusCellHighlightBorder", gTKLazyValue, "Table.focusSelectedCellHighlightBorder", gTKLazyValue2, "Table.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy", "ctrl V", "paste", "ctrl X", "cut", "COPY", "copy", "PASTE", "paste", "CUT", "cut", "control INSERT", "copy", "shift INSERT", "paste", "shift DELETE", "cut", "RIGHT", "selectNextColumn", "KP_RIGHT", "selectNextColumn", "shift RIGHT", "selectNextColumnExtendSelection", "shift KP_RIGHT", "selectNextColumnExtendSelection", "ctrl shift RIGHT", "selectNextColumnExtendSelection", "ctrl shift KP_RIGHT", "selectNextColumnExtendSelection", "ctrl RIGHT", "selectNextColumnChangeLead", "ctrl KP_RIGHT", "selectNextColumnChangeLead", "LEFT", "selectPreviousColumn", "KP_LEFT", "selectPreviousColumn", "shift LEFT", "selectPreviousColumnExtendSelection", "shift KP_LEFT", "selectPreviousColumnExtendSelection", "ctrl shift LEFT", "selectPreviousColumnExtendSelection", "ctrl shift KP_LEFT", "selectPreviousColumnExtendSelection", "ctrl LEFT", "selectPreviousColumnChangeLead", "ctrl KP_LEFT", "selectPreviousColumnChangeLead", "DOWN", "selectNextRow", "KP_DOWN", "selectNextRow", "shift DOWN", "selectNextRowExtendSelection", "shift KP_DOWN", "selectNextRowExtendSelection", "ctrl shift DOWN", "selectNextRowExtendSelection", "ctrl shift KP_DOWN", "selectNextRowExtendSelection", "ctrl DOWN", "selectNextRowChangeLead", "ctrl KP_DOWN", "selectNextRowChangeLead", "UP", "selectPreviousRow", "KP_UP", "selectPreviousRow", "shift UP", "selectPreviousRowExtendSelection", "shift KP_UP", "selectPreviousRowExtendSelection", "ctrl shift UP", "selectPreviousRowExtendSelection", "ctrl shift KP_UP", "selectPreviousRowExtendSelection", "ctrl UP", "selectPreviousRowChangeLead", "ctrl KP_UP", "selectPreviousRowChangeLead", "HOME", "selectFirstColumn", "shift HOME", "selectFirstColumnExtendSelection", "ctrl shift HOME", "selectFirstRowExtendSelection", "ctrl HOME", "selectFirstRow", "END", "selectLastColumn", "shift END", "selectLastColumnExtendSelection", "ctrl shift END", "selectLastRowExtendSelection", "ctrl END", "selectLastRow", "PAGE_UP", "scrollUpChangeSelection", "shift PAGE_UP", "scrollUpExtendSelection", "ctrl shift PAGE_UP", "scrollLeftExtendSelection", "ctrl PAGE_UP", "scrollLeftChangeSelection", "PAGE_DOWN", "scrollDownChangeSelection", "shift PAGE_DOWN", "scrollDownExtendSelection", "ctrl shift PAGE_DOWN", "scrollRightExtendSelection", "ctrl PAGE_DOWN", "scrollRightChangeSelection", "TAB", "selectNextColumnCell", "shift TAB", "selectPreviousColumnCell", "ENTER", "selectNextRowCell", "shift ENTER", "selectPreviousRowCell", "ctrl A", "selectAll", "ctrl SLASH", "selectAll", "ctrl BACK_SLASH", "clearSelection", "ESCAPE", "cancel", "F2", "startEditing", "SPACE", "addToSelection", "ctrl SPACE", "toggleAndAnchor", "shift SPACE", "extendTo", "ctrl shift SPACE", "moveSelectionTo", "F8", "focusHeader"}), "Table.ancestorInputMap.RightToLeft", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "selectPreviousColumn", "KP_RIGHT", "selectPreviousColumn", "shift RIGHT", "selectPreviousColumnExtendSelection", "shift KP_RIGHT", "selectPreviousColumnExtendSelection", "ctrl shift RIGHT", "selectPreviousColumnExtendSelection", "ctrl shift KP_RIGHT", "selectPreviousColumnExtendSelection", "shift RIGHT", "selectPreviousColumnChangeLead", "shift KP_RIGHT", "selectPreviousColumnChangeLead", "LEFT", "selectNextColumn", "KP_LEFT", "selectNextColumn", "shift LEFT", "selectNextColumnExtendSelection", "shift KP_LEFT", "selectNextColumnExtendSelection", "ctrl shift LEFT", "selectNextColumnExtendSelection", "ctrl shift KP_LEFT", "selectNextColumnExtendSelection", "ctrl LEFT", "selectNextColumnChangeLead", "ctrl KP_LEFT", "selectNextColumnChangeLead", "ctrl PAGE_UP", "scrollRightChangeSelection", "ctrl PAGE_DOWN", "scrollLeftChangeSelection", "ctrl shift PAGE_UP", "scrollRightExtendSelection", "ctrl shift PAGE_DOWN", "scrollLeftExtendSelection"}), "Table.font", new FontLazyValue(Region.TABLE), "Table.ascendingSortIcon", new GTKStyle.GTKLazyValue("com.sun.java.swing.plaf.gtk.GTKIconFactory", "getAscendingSortIcon"), "Table.descendingSortIcon", new GTKStyle.GTKLazyValue("com.sun.java.swing.plaf.gtk.GTKIconFactory", "getDescendingSortIcon"), "TableHeader.font", new FontLazyValue(Region.TABLE_HEADER), "TableHeader.alignSorterArrow", Boolean.TRUE, "TextArea.caretForeground", color4, "TextArea.caretAspectRatio", d, "TextArea.caretBlinkRate", n8, "TextArea.margin", insetsUIResource, "TextArea.focusInputMap", lazyInputMap3, "TextArea.font", new FontLazyValue(Region.TEXT_AREA), "TextField.caretForeground", color4, "TextField.caretAspectRatio", d, "TextField.caretBlinkRate", n8, "TextField.margin", insetsUIResource, "TextField.focusInputMap", lazyInputMap, "TextField.font", new FontLazyValue(Region.TEXT_FIELD), "TextPane.caretForeground", color4, "TextPane.caretAspectRatio", d, "TextPane.caretBlinkRate", n8, "TextPane.margin", insetsUIResource2, "TextPane.focusInputMap", lazyInputMap3, "TextPane.font", new FontLazyValue(Region.TEXT_PANE), "TitledBorder.titleColor", color5, "TitledBorder.border", new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults uIDefaults) {
                return new GTKPainter.TitledBorder();
            }
        }, "ToggleButton.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released"}), "ToggleButton.font", new FontLazyValue(Region.TOGGLE_BUTTON), "ToggleButton.margin", insetsUIResource, "ToolBar.separatorSize", new DimensionUIResource(10, 10), "ToolBar.handleIcon", new UIDefaults.ActiveValue(){

            @Override
            public Object createValue(UIDefaults uIDefaults) {
                return GTKIconFactory.getToolBarHandleIcon();
            }
        }, "ToolBar.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"UP", "navigateUp", "KP_UP", "navigateUp", "DOWN", "navigateDown", "KP_DOWN", "navigateDown", "LEFT", "navigateLeft", "KP_LEFT", "navigateLeft", "RIGHT", "navigateRight", "KP_RIGHT", "navigateRight"}), "ToolBar.font", new FontLazyValue(Region.TOOL_BAR), "ToolTip.font", new FontLazyValue(Region.TOOL_TIP), "Tree.padding", new Integer(4), "Tree.background", color, "Tree.drawHorizontalLines", Boolean.FALSE, "Tree.drawVerticalLines", Boolean.FALSE, "Tree.rowHeight", new Integer(-1), "Tree.scrollsOnExpand", Boolean.FALSE, "Tree.expanderSize", new Integer(10), "Tree.repaintWholeRow", Boolean.TRUE, "Tree.closedIcon", null, "Tree.leafIcon", null, "Tree.openIcon", null, "Tree.expandedIcon", new GTKStyle.GTKLazyValue("com.sun.java.swing.plaf.gtk.GTKIconFactory", "getTreeExpandedIcon"), "Tree.collapsedIcon", new GTKStyle.GTKLazyValue("com.sun.java.swing.plaf.gtk.GTKIconFactory", "getTreeCollapsedIcon"), "Tree.leftChildIndent", new Integer(2), "Tree.rightChildIndent", new Integer(12), "Tree.scrollsHorizontallyAndVertically", Boolean.FALSE, "Tree.drawsFocusBorder", Boolean.TRUE, "Tree.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy", "ctrl V", "paste", "ctrl X", "cut", "COPY", "copy", "PASTE", "paste", "CUT", "cut", "control INSERT", "copy", "shift INSERT", "paste", "shift DELETE", "cut", "UP", "selectPrevious", "KP_UP", "selectPrevious", "shift UP", "selectPreviousExtendSelection", "shift KP_UP", "selectPreviousExtendSelection", "ctrl shift UP", "selectPreviousExtendSelection", "ctrl shift KP_UP", "selectPreviousExtendSelection", "ctrl UP", "selectPreviousChangeLead", "ctrl KP_UP", "selectPreviousChangeLead", "DOWN", "selectNext", "KP_DOWN", "selectNext", "shift DOWN", "selectNextExtendSelection", "shift KP_DOWN", "selectNextExtendSelection", "ctrl shift DOWN", "selectNextExtendSelection", "ctrl shift KP_DOWN", "selectNextExtendSelection", "ctrl DOWN", "selectNextChangeLead", "ctrl KP_DOWN", "selectNextChangeLead", "RIGHT", "selectChild", "KP_RIGHT", "selectChild", "LEFT", "selectParent", "KP_LEFT", "selectParent", "typed +", "expand", "typed -", "collapse", "BACK_SPACE", "moveSelectionToParent", "PAGE_UP", "scrollUpChangeSelection", "shift PAGE_UP", "scrollUpExtendSelection", "ctrl shift PAGE_UP", "scrollUpExtendSelection", "ctrl PAGE_UP", "scrollUpChangeLead", "PAGE_DOWN", "scrollDownChangeSelection", "shift PAGE_DOWN", "scrollDownExtendSelection", "ctrl shift PAGE_DOWN", "scrollDownExtendSelection", "ctrl PAGE_DOWN", "scrollDownChangeLead", "HOME", "selectFirst", "shift HOME", "selectFirstExtendSelection", "ctrl shift HOME", "selectFirstExtendSelection", "ctrl HOME", "selectFirstChangeLead", "END", "selectLast", "shift END", "selectLastExtendSelection", "ctrl shift END", "selectLastExtendSelection", "ctrl END", "selectLastChangeLead", "F2", "startEditing", "ctrl A", "selectAll", "ctrl SLASH", "selectAll", "ctrl BACK_SLASH", "clearSelection", "ctrl LEFT", "scrollLeft", "ctrl KP_LEFT", "scrollLeft", "ctrl RIGHT", "scrollRight", "ctrl KP_RIGHT", "scrollRight", "SPACE", "addToSelection", "ctrl SPACE", "toggleAndAnchor", "shift SPACE", "extendTo", "ctrl shift SPACE", "moveSelectionTo"}), "Tree.focusInputMap.RightToLeft", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "selectParent", "KP_RIGHT", "selectParent", "LEFT", "selectChild", "KP_LEFT", "selectChild"}), "Tree.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "cancel"}), "Tree.font", new FontLazyValue(Region.TREE), "Viewport.font", new FontLazyValue(Region.VIEWPORT)};
        uIDefaults.putDefaults(objectArray);
        if (this.fallbackFont != null) {
            uIDefaults.put("TitledBorder.font", this.fallbackFont);
        }
        uIDefaults.put(SwingUtilities2.AA_TEXT_PROPERTY_KEY, aaTextInfo);
    }

    @Override
    protected void initSystemColorDefaults(UIDefaults uIDefaults) {
        GTKStyleFactory gTKStyleFactory = (GTKStyleFactory)GTKLookAndFeel.getStyleFactory();
        GTKStyle gTKStyle = (GTKStyle)gTKStyleFactory.getStyle(null, Region.INTERNAL_FRAME);
        uIDefaults.put("window", gTKStyle.getGTKColor(1, GTKColorType.BACKGROUND));
        uIDefaults.put("windowText", gTKStyle.getGTKColor(1, GTKColorType.TEXT_FOREGROUND));
        GTKStyle gTKStyle2 = (GTKStyle)gTKStyleFactory.getStyle(null, Region.TEXT_FIELD);
        uIDefaults.put("text", gTKStyle2.getGTKColor(1, GTKColorType.TEXT_BACKGROUND));
        uIDefaults.put("textText", gTKStyle2.getGTKColor(1, GTKColorType.TEXT_FOREGROUND));
        uIDefaults.put("textHighlight", gTKStyle2.getGTKColor(512, GTKColorType.TEXT_BACKGROUND));
        uIDefaults.put("textHighlightText", gTKStyle2.getGTKColor(512, GTKColorType.TEXT_FOREGROUND));
        uIDefaults.put("textInactiveText", gTKStyle2.getGTKColor(8, GTKColorType.TEXT_FOREGROUND));
        Object object = gTKStyle2.getClassSpecificValue("cursor-color");
        if (object == null) {
            object = GTKStyle.BLACK_COLOR;
        }
        uIDefaults.put("caretColor", object);
        GTKStyle gTKStyle3 = (GTKStyle)gTKStyleFactory.getStyle(null, Region.MENU_ITEM);
        uIDefaults.put("menu", gTKStyle3.getGTKColor(1, GTKColorType.BACKGROUND));
        uIDefaults.put("menuText", gTKStyle3.getGTKColor(1, GTKColorType.TEXT_FOREGROUND));
        GTKStyle gTKStyle4 = (GTKStyle)gTKStyleFactory.getStyle(null, Region.SCROLL_BAR);
        uIDefaults.put("scrollbar", gTKStyle4.getGTKColor(1, GTKColorType.BACKGROUND));
        GTKStyle gTKStyle5 = (GTKStyle)gTKStyleFactory.getStyle(null, Region.OPTION_PANE);
        uIDefaults.put("info", gTKStyle5.getGTKColor(1, GTKColorType.BACKGROUND));
        uIDefaults.put("infoText", gTKStyle5.getGTKColor(1, GTKColorType.TEXT_FOREGROUND));
        GTKStyle gTKStyle6 = (GTKStyle)gTKStyleFactory.getStyle(null, Region.DESKTOP_PANE);
        uIDefaults.put("desktop", gTKStyle6.getGTKColor(1, GTKColorType.BACKGROUND));
        GTKStyle gTKStyle7 = (GTKStyle)gTKStyleFactory.getStyle(null, Region.LABEL);
        Color color = gTKStyle7.getGTKColor(1, GTKColorType.BACKGROUND);
        uIDefaults.put("control", color);
        uIDefaults.put("controlHighlight", color);
        uIDefaults.put("controlText", gTKStyle7.getGTKColor(1, GTKColorType.TEXT_FOREGROUND));
        uIDefaults.put("controlLtHighlight", gTKStyle7.getGTKColor(1, GTKColorType.LIGHT));
        uIDefaults.put("controlShadow", gTKStyle7.getGTKColor(1, GTKColorType.DARK));
        uIDefaults.put("controlDkShadow", gTKStyle7.getGTKColor(1, GTKColorType.BLACK));
        uIDefaults.put("light", gTKStyle7.getGTKColor(1, GTKColorType.LIGHT));
        uIDefaults.put("mid", gTKStyle7.getGTKColor(1, GTKColorType.MID));
        uIDefaults.put("dark", gTKStyle7.getGTKColor(1, GTKColorType.DARK));
        uIDefaults.put("black", gTKStyle7.getGTKColor(1, GTKColorType.BLACK));
        uIDefaults.put("white", gTKStyle7.getGTKColor(1, GTKColorType.WHITE));
    }

    public static ComponentUI createUI(JComponent jComponent) {
        String string = jComponent.getUIClassID().intern();
        if (string == "FileChooserUI") {
            return GTKFileChooserUI.createUI(jComponent);
        }
        return SynthLookAndFeel.createUI(jComponent);
    }

    static String getGtkThemeName() {
        return gtkThemeName;
    }

    static boolean isLeftToRight(Component component) {
        return component.getComponentOrientation().isLeftToRight();
    }

    @Override
    public void initialize() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (toolkit instanceof UNIXToolkit && !((UNIXToolkit)toolkit).loadGTK()) {
            throw new InternalError("Unable to load native GTK libraries");
        }
        super.initialize();
        this.inInitialize = true;
        this.loadStyles();
        this.inInitialize = false;
        gtkAAFontSettingsCond = !isSunCJK && SwingUtilities2.isLocalDisplay();
        aaTextInfo = SwingUtilities2.AATextInfo.getAATextInfo(gtkAAFontSettingsCond);
    }

    private static void flushUnreferenced() {
        WeakPCL weakPCL;
        while ((weakPCL = (WeakPCL)queue.poll()) != null) {
            weakPCL.dispose();
        }
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        return toolkit instanceof SunToolkit && ((SunToolkit)toolkit).isNativeGTKAvailable();
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return true;
    }

    @Override
    public String getDescription() {
        return "GTK look and feel";
    }

    @Override
    public String getName() {
        return "GTK look and feel";
    }

    @Override
    public String getID() {
        return "GTK";
    }

    @Override
    protected void loadSystemColors(UIDefaults uIDefaults, String[] stringArray, boolean bl) {
        super.loadSystemColors(uIDefaults, stringArray, false);
    }

    private void loadStyles() {
        gtkThemeName = (String)Toolkit.getDefaultToolkit().getDesktopProperty("gnome.Net/ThemeName");
        GTKLookAndFeel.setStyleFactory(this.getGTKStyleFactory());
        if (!this.inInitialize) {
            UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
            this.initSystemColorDefaults(uIDefaults);
            this.initComponentDefaults(uIDefaults);
        }
    }

    private GTKStyleFactory getGTKStyleFactory() {
        Font font;
        Object object;
        GTKEngine gTKEngine = GTKEngine.INSTANCE;
        Object object2 = gTKEngine.getSetting(GTKEngine.Settings.GTK_ICON_SIZES);
        if (object2 instanceof String && !this.configIconSizes((String)object2)) {
            System.err.println("Error parsing gtk-icon-sizes string: '" + object2 + "'");
        }
        if (!((object = Toolkit.getDefaultToolkit().getDesktopProperty("gnome.Gtk/FontName")) instanceof String) && !((object = gTKEngine.getSetting(GTKEngine.Settings.GTK_FONT_NAME)) instanceof String)) {
            object = "sans 10";
        }
        if (this.styleFactory == null) {
            this.styleFactory = new GTKStyleFactory();
        }
        this.fallbackFont = font = PangoFonts.lookupFont((String)object);
        this.styleFactory.initStyles(font);
        return this.styleFactory;
    }

    private boolean configIconSizes(String string) {
        String[] stringArray = string.split(":");
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            int n2;
            String[] stringArray2 = stringArray[i].split("=");
            if (stringArray2.length != 2) {
                return false;
            }
            String string2 = stringArray2[0].trim().intern();
            if (string2.length() < 1) {
                return false;
            }
            if ((stringArray2 = stringArray2[1].split(",")).length != 2) {
                return false;
            }
            String string3 = stringArray2[0].trim();
            String string4 = stringArray2[1].trim();
            if (string3.length() < 1 || string4.length() < 1) {
                return false;
            }
            try {
                n2 = Integer.parseInt(string3);
                n = Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            if (n2 > 0 && n > 0) {
                int n3 = GTKStyle.GTKStockIconInfo.getIconType(string2);
                GTKStyle.GTKStockIconInfo.setIconSize(n3, n2, n);
                continue;
            }
            System.err.println("Invalid size in gtk-icon-sizes: " + n2 + "," + n);
        }
        return true;
    }

    @Override
    public boolean shouldUpdateStyleOnAncestorChanged() {
        return true;
    }

    @Override
    public LayoutStyle getLayoutStyle() {
        return GnomeLayoutStyle.INSTANCE;
    }

    static {
        boolean bl;
        gtkThemeName = "Default";
        String string = AccessController.doPrivileged(new GetPropertyAction("swing.gtk.version"));
        IS_22 = string != null ? string.equals("2.2") : true;
        String string2 = Locale.getDefault().getLanguage();
        boolean bl2 = bl = Locale.CHINESE.getLanguage().equals(string2) || Locale.JAPANESE.getLanguage().equals(string2) || Locale.KOREAN.getLanguage().equals(string2);
        if (bl) {
            boolean bl3 = false;
            switch (OSInfo.getOSType()) {
                case SOLARIS: {
                    bl3 = true;
                    break;
                }
                case LINUX: {
                    Boolean bl4 = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                        @Override
                        public Boolean run() {
                            File file = new File("/etc/sun-release");
                            return file.exists();
                        }
                    });
                    bl3 = bl4;
                }
            }
            if (bl3) {
                isSunCJK = true;
            }
        }
        queue = new ReferenceQueue();
    }

    private static class GnomeLayoutStyle
    extends DefaultLayoutStyle {
        private static GnomeLayoutStyle INSTANCE = new GnomeLayoutStyle();

        private GnomeLayoutStyle() {
        }

        @Override
        public int getPreferredGap(JComponent jComponent, JComponent jComponent2, LayoutStyle.ComponentPlacement componentPlacement, int n, Container container) {
            super.getPreferredGap(jComponent, jComponent2, componentPlacement, n, container);
            switch (componentPlacement) {
                case INDENT: {
                    if (n == 3 || n == 7) {
                        return 12;
                    }
                }
                case RELATED: {
                    if (this.isLabelAndNonlabel(jComponent, jComponent2, n)) {
                        return 12;
                    }
                    return 6;
                }
                case UNRELATED: {
                    return 12;
                }
            }
            return 0;
        }

        @Override
        public int getContainerGap(JComponent jComponent, int n, Container container) {
            super.getContainerGap(jComponent, n, container);
            return 12;
        }
    }

    static class WeakPCL
    extends WeakReference
    implements PropertyChangeListener {
        private Toolkit kit;
        private String key;

        WeakPCL(Object object, Toolkit toolkit, String string) {
            super(object, queue);
            this.kit = toolkit;
            this.key = string;
        }

        public String getKey() {
            return this.key;
        }

        @Override
        public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
            final GTKLookAndFeel gTKLookAndFeel = (GTKLookAndFeel)this.get();
            if (gTKLookAndFeel == null || UIManager.getLookAndFeel() != gTKLookAndFeel) {
                this.dispose();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String string = propertyChangeEvent.getPropertyName();
                        if ("gnome.Net/ThemeName".equals(string)) {
                            GTKEngine.INSTANCE.themeChanged();
                            GTKIconFactory.resetIcons();
                        }
                        gTKLookAndFeel.loadStyles();
                        Window[] windowArray = Window.getWindows();
                        for (int i = 0; i < windowArray.length; ++i) {
                            SynthLookAndFeel.updateStyles(windowArray[i]);
                        }
                    }
                });
            }
        }

        void dispose() {
            this.kit.removePropertyChangeListener(this.key, this);
        }
    }
}

