/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.TextComponent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.TextEvent;
import java.awt.im.InputMethodRequests;
import java.awt.peer.TextComponentPeer;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import sun.awt.AWTAccessor;
import sun.lwawt.LWComponentPeer;
import sun.lwawt.PlatformComponent;

abstract class LWTextComponentPeer<T extends TextComponent, D extends JComponent>
extends LWComponentPeer<T, D>
implements DocumentListener,
TextComponentPeer,
InputMethodListener {
    protected static final char WIDE_CHAR = 'w';
    private volatile boolean firstChangeSkipped;

    LWTextComponentPeer(T t, PlatformComponent platformComponent) {
        super(t, platformComponent);
        if (!((TextComponent)this.getTarget()).isBackgroundSet()) {
            ((TextComponent)this.getTarget()).setBackground(SystemColor.text);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void initializeImpl() {
        super.initializeImpl();
        Object object = this.getDelegateLock();
        synchronized (object) {
            this.getTextComponent().getDocument().addDocumentListener(this);
        }
        this.setEditable(((TextComponent)this.getTarget()).isEditable());
        this.setText(((TextComponent)this.getTarget()).getText());
        ((TextComponent)this.getTarget()).addInputMethodListener(this);
        int n = ((TextComponent)this.getTarget()).getSelectionStart();
        int n2 = ((TextComponent)this.getTarget()).getSelectionEnd();
        if (n2 > n) {
            this.select(n, n2);
        }
        this.setCaretPosition(((TextComponent)this.getTarget()).getCaretPosition());
        this.firstChangeSkipped = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void disposeImpl() {
        Object object = this.getDelegateLock();
        synchronized (object) {
            this.getTextComponent().getCaret().setVisible(false);
        }
        super.disposeImpl();
    }

    abstract JTextComponent getTextComponent();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getPreferredSize(int n, int n2) {
        Insets insets;
        Object object = this.getDelegateLock();
        synchronized (object) {
            insets = ((JComponent)this.getDelegate()).getInsets();
        }
        int n3 = insets.top + insets.bottom;
        int n4 = insets.left + insets.right;
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n5 = fontMetrics != null ? fontMetrics.charWidth('w') : 10;
        int n6 = fontMetrics != null ? fontMetrics.getHeight() : 10;
        return new Dimension(n2 * n5 + n4, n * n6 + n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setEditable(boolean bl) {
        Object object = this.getDelegateLock();
        synchronized (object) {
            this.getTextComponent().setEditable(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String getText() {
        Object object = this.getDelegateLock();
        synchronized (object) {
            return this.getTextComponent().getText();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setText(String string) {
        Object object = this.getDelegateLock();
        synchronized (object) {
            Document document = this.getTextComponent().getDocument();
            document.removeDocumentListener(this);
            this.getTextComponent().setText(string);
            this.revalidate();
            if (this.firstChangeSkipped) {
                this.postEvent(new TextEvent(this.getTarget(), 900));
            }
            document.addDocumentListener(this);
        }
        this.repaintPeer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getSelectionStart() {
        Object object = this.getDelegateLock();
        synchronized (object) {
            return this.getTextComponent().getSelectionStart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getSelectionEnd() {
        Object object = this.getDelegateLock();
        synchronized (object) {
            return this.getTextComponent().getSelectionEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void select(int n, int n2) {
        Object object = this.getDelegateLock();
        synchronized (object) {
            this.getTextComponent().select(n, n2);
        }
        this.repaintPeer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setCaretPosition(int n) {
        Object object = this.getDelegateLock();
        synchronized (object) {
            this.getTextComponent().setCaretPosition(n);
        }
        this.repaintPeer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getCaretPosition() {
        Object object = this.getDelegateLock();
        synchronized (object) {
            return this.getTextComponent().getCaretPosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final InputMethodRequests getInputMethodRequests() {
        Object object = this.getDelegateLock();
        synchronized (object) {
            return this.getTextComponent().getInputMethodRequests();
        }
    }

    @Override
    public final boolean isFocusable() {
        return ((TextComponent)this.getTarget()).isFocusable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void revalidate() {
        Object object = this.getDelegateLock();
        synchronized (object) {
            this.getTextComponent().invalidate();
            ((Container)this.getDelegate()).validate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void postTextEvent() {
        this.postEvent(new TextEvent(this.getTarget(), 900));
        Object object = this.getDelegateLock();
        synchronized (object) {
            this.revalidate();
        }
    }

    @Override
    public final void changedUpdate(DocumentEvent documentEvent) {
        this.postTextEvent();
    }

    @Override
    public final void insertUpdate(DocumentEvent documentEvent) {
        this.postTextEvent();
    }

    @Override
    public final void removeUpdate(DocumentEvent documentEvent) {
        this.postTextEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inputMethodTextChanged(InputMethodEvent inputMethodEvent) {
        Object object = this.getDelegateLock();
        synchronized (object) {
            AWTAccessor.getComponentAccessor().processEvent(this.getTextComponent(), inputMethodEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void caretPositionChanged(InputMethodEvent inputMethodEvent) {
        Object object = this.getDelegateLock();
        synchronized (object) {
            AWTAccessor.getComponentAccessor().processEvent(this.getTextComponent(), inputMethodEvent);
        }
    }
}

