/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy;

import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.circular.CircularDependencyStrategy;
import fr.jayasoft.ivy.util.MessageImpl;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

public class IvyContext {
    private static ThreadLocal _current = new ThreadLocal();
    private Ivy _defaultIvy;
    private WeakReference _ivy = new WeakReference<Object>(null);
    private File _cache;
    private MessageImpl _messageImpl;
    private Map _contextMap = new HashMap();
    private Thread _operatingThread;

    public static IvyContext getContext() {
        IvyContext cur = (IvyContext)_current.get();
        if (cur == null) {
            cur = new IvyContext();
            _current.set(cur);
        }
        return cur;
    }

    public static void setContext(IvyContext context) {
        _current.set(context);
    }

    public Ivy getIvy() {
        Ivy ivy = (Ivy)this._ivy.get();
        return ivy == null ? this.getDefaultIvy() : ivy;
    }

    private Ivy getDefaultIvy() {
        if (this._defaultIvy == null) {
            this._defaultIvy = new Ivy();
            try {
                this.getDefaultIvy().configureDefault();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this._defaultIvy;
    }

    void setIvy(Ivy ivy) {
        this._ivy = new WeakReference<Ivy>(ivy);
        this._operatingThread = Thread.currentThread();
    }

    public File getCache() {
        return this._cache == null ? this.getIvy().getDefaultCache() : this._cache;
    }

    void setCache(File cache) {
        this._cache = cache;
    }

    public CircularDependencyStrategy getCircularDependencyStrategy() {
        return this.getIvy().getCircularDependencyStrategy();
    }

    public Object get(String key) {
        WeakReference ref = (WeakReference)this._contextMap.get(key);
        return ref == null ? null : ref.get();
    }

    public void set(String key, Object value) {
        this._contextMap.put(key, new WeakReference<Object>(value));
    }

    public Thread getOperatingThread() {
        return this._operatingThread;
    }

    public MessageImpl getMessageImpl() {
        return this._messageImpl;
    }

    public void setMessageImpl(MessageImpl impl) {
        this._messageImpl = impl;
    }
}

