#!/bin/sh
echo 'name: tls
version: 0.8.1
id: tls-0.8.1-03ed8f774ff9b5f49eaad3e3c790319d

license: BSD3
copyright: Vincent Hanquez <vincent@snarc.org>
maintainer: Vincent Hanquez <vincent@snarc.org>
stability: experimental
homepage: http://github.com/vincenthz/hs-tls
package-url:
synopsis: TLS/SSL protocol native implementation (Server and Client)
description: Native Haskell TLS and SSL protocol implementation for server and client.
             .
             This provides a high-level implementation of a sensitive security protocol,
             eliminating a common set of security issues through the use of the advanced
             type system, high level constructions and common Haskell features.
             .
             Currently implement the SSL3.0, TLS1.0, TLS1.1 and TLS1.2 protocol,
             with only RSA supported for Key Exchange.
             .
             Only core protocol available here, have a look at the
             <http://hackage.haskell.org/package/tls-extra/> package for default
             ciphers, compressions and certificates functions.
category: Network
author: Vincent Hanquez <vincent@snarc.org>
pkgpath: security/hs-tls
exposed: True
exposed-modules: Network.TLS Network.TLS.Cipher
                 Network.TLS.Compression Network.TLS.Internal
hidden-modules: Network.TLS.Cap Network.TLS.Struct Network.TLS.MAC
                Network.TLS.Core Network.TLS.Crypto Network.TLS.Packet
                Network.TLS.Record Network.TLS.State Network.TLS.Sending
                Network.TLS.Receiving Network.TLS.Util Network.TLS.Wire
trusted: False
import-dirs: /usr/local/lib/ghc/tls-0.8.1
library-dirs: /usr/local/lib/ghc/tls-0.8.1
hs-libraries: HStls-0.8.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.6.0.1-03845c6da2a0b3b4d0d49cc26c0cd3c0
         bytestring-0.10.0.2-9e8b487747800a4255d6ff7915c5210f
         cereal-0.3.5.2-a9ff0516a3b8fef3d6dca329fe564618
         certificate-0.9.5-e7a96fe9914c761bde1cadb2239ec0de
         crypto-api-0.10.2-83fe1c648ebc87e2da143b149727f764
         cryptocipher-0.2.8-979c0a72e3007a99d08f2eef7758b565
         cryptohash-0.7.0-05377038510116cae3648d206212651d
         mtl-2.1.2-94c72af955e94b8d7b2f359dadd0cb62
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-tls-0.8.1/html/tls.haddock
haddock-html: /usr/local/share/doc/hs-tls-0.8.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
