#!/bin/sh
echo 'name: snap-core
version: 0.9.4.0
id: snap-core-0.9.4.0-2bb23479b37646532a83bdaf7cc06c95

license: BSD3
copyright:
maintainer: snap@snapframework.com
stability:
homepage: http://snapframework.com/
package-url:
synopsis: Snap: A Haskell Web Framework (core interfaces and types)
description: Snap is a simple and fast web development framework and server written in
             Haskell. For more information or to download the latest version, you can
             visit the Snap project website at <http://snapframework.com/>.
             .
             This library contains the core definitions and types for the Snap framework,
             including:
             .
             1. Primitive types and functions for HTTP (requests, responses, cookies,
             post/query parameters, etc)
             .
             2. Type aliases and helper functions for Iteratee I/O
             .
             3. A monad for programming web handlers called \"Snap\", which allows:
             .
             * Stateful access to the HTTP request and response objects
             .
             * Monadic failure (i.e. MonadPlus/Alternative instances) for declining
             to handle requests and chaining handlers together
             .
             * Early termination of the computation if you know early what you want
             to return and want to prevent further monadic processing
             .
             /Quick start/: The '\''Snap'\'' monad and HTTP definitions are in "Snap.Core",
             some iteratee utilities are in "Snap.Iteratee".
category: Web, Snap
author: James Sanders, Shu-yu Guo, Gregory Collins, Doug Beardsley
pkgpath: www/hs-snap-core
exposed: True
exposed-modules: Snap.Core Snap.Types Snap.Iteratee
                 Snap.Internal.Debug Snap.Internal.Exceptions
                 Snap.Internal.Http.Types Snap.Internal.Iteratee.Debug
                 Snap.Internal.Parsing Snap.Test Snap.Types.Headers
                 Snap.Util.FileServe Snap.Util.FileUploads Snap.Util.GZip
                 Snap.Util.Proxy Snap.Util.Readable
hidden-modules: Snap.Internal.Instances
                Snap.Internal.Iteratee.BoyerMooreHorspool
                Snap.Internal.Parsing.FastSet Snap.Internal.Routing
                Snap.Internal.Types Snap.Internal.Test.RequestBuilder
                Snap.Internal.Test.Assertions
trusted: False
import-dirs: /usr/local/lib/ghc/snap-core-0.9.4.0
library-dirs: /usr/local/lib/ghc/snap-core-0.9.4.0
hs-libraries: HSsnap-core-0.9.4.0
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: HUnit-1.2.5.2-6e02ecc15e3cc5ab8ef10df50d05a1a9
         MonadCatchIO-transformers-0.3.0.0-00f5ba39422294066c7f13d4ef6c89a7
         attoparsec-0.10.4.0-d9fd97cfc1a1748b3cde35adf7fd233b
         attoparsec-enumerator-0.3.1-f4fb0a1831d18b63eb3a7ec37a0cda91
         base-4.6.0.1-03845c6da2a0b3b4d0d49cc26c0cd3c0
         blaze-builder-0.3.1.1-71a2ae53eb5daf9e6673db8b47b3b6b5
         blaze-builder-enumerator-0.2.0.5-f74fee72f8b84d91962e5e4025680b57
         bytestring-0.10.0.2-9e8b487747800a4255d6ff7915c5210f
         bytestring-mmap-0.2.2-61f76fbe2e67acc5f4fa1c0dcf7b76d3
         case-insensitive-1.0.0.1-833d4438033d68efab76284bff7688c9
         containers-0.5.0.0-ab1dae9a94cd3cc84e7b2805636ebfa2
         deepseq-1.3.0.1-5cc4cd89bdc2e8f6db1833d95ec36926
         directory-1.2.0.1-ee04c884b72040489d2e2ca6dd62e6ac
         enumerator-0.4.19-13fa8f89bd8effdb12c1bcec44c8658a
         filepath-1.3.0.1-b12cbe18566fe1532a1fda4c85e31cbe
         hashable-1.1.2.5-e0f2541518f84d3123a819112b4ffe20
         mtl-2.1.2-94c72af955e94b8d7b2f359dadd0cb62
         random-1.0.1.1-023a342365721422ffd5a919bc8708bb
         regex-posix-0.95.2-320e6bd67debb5ce05f7a0fda4ec39c1
         text-0.11.3.1-06d227f06409a354e0c77a385328bada
         time-1.4.0.1-10dc4804a19dc0000fab79908f1a9f50
         unix-2.6.0.1-2939d4be83b53d31ca104e0487b1ef98
         unix-compat-0.4.1.1-3ecee737d68c789a8df91c9cd3d2952f
         unordered-containers-0.2.3.0-c7952fe8bed178bdf8ed4d090730c9da
         vector-0.10.0.1-869166d5d49db46ce6c328ea5f8defbf
         zlib-enum-0.2.3-4abb36f979e1a4359612beb4c2bffb0c
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-snap-core-0.9.4.0/html/snap-core.haddock
haddock-html: /usr/local/share/doc/hs-snap-core-0.9.4.0/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
