#!/bin/sh
echo 'name: monad-control
version: 0.3.1.4
id: monad-control-0.3.1.4-82c4d425731905798d4e75256cfd14ef

license: BSD3
copyright: (c) 2011 Bas van Dijk, Anders Kaseorg
maintainer: Bas van Dijk <v.dijk.bas@gmail.com>
stability:
homepage: https://github.com/basvandijk/monad-control
package-url:
synopsis: Lift control operations, like exception catching, through monad transformers
description: This package defines the type class @MonadBaseControl@, a subset of
             @MonadBase@ into which generic control operations such as @catch@ can be
             lifted from @IO@ or any other base monad. Instances are based on monad
             transformers in @MonadTransControl@, which includes all standard monad
             transformers in the @transformers@ library except @ContT@.
             .
             See the @lifted-base@ package which uses @monad-control@ to lift @IO@
             operations from the @base@ library (like @catch@ or @bracket@) into any monad
             that is an instance of @MonadBase@ or @MonadBaseControl@.
             .
             Note that this package is a rewrite of Anders Kaseorg'\''s @monad-peel@
             library. The main difference is that this package provides CPS style operators
             and exploits the @RankNTypes@ and @TypeFamilies@ language extensions to
             simplify and speedup most definitions.
             .
             The following @criterion@ based benchmark shows that @monad-control@ is on
             average about 99% faster than @monad-peel@:
             .
             @git clone <https://github.com/basvandijk/bench-monad-peel-control>@
category: Control
author: Bas van Dijk, Anders Kaseorg
pkgpath: devel/hs-monad-control
exposed: True
exposed-modules: Control.Monad.Trans.Control
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/monad-control-0.3.1.4
library-dirs: /usr/local/lib/ghc/monad-control-0.3.1.4
hs-libraries: HSmonad-control-0.3.1.4
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.6.0.1-03845c6da2a0b3b4d0d49cc26c0cd3c0
         base-unicode-symbols-0.2.2.4-ec1c787160bf91bc92b0b4f99c4199a9
         transformers-0.3.0.0-ff2bb6ac67241ebb987351a3db564af0
         transformers-base-0.4.1-da9c4a03c3accfcef7f09e5e6d753fad
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-monad-control-0.3.1.4/html/monad-control.haddock
haddock-html: /usr/local/share/doc/hs-monad-control-0.3.1.4/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
