#!/bin/sh
echo 'name: hackage-db
version: 1.4
id: hackage-db-1.4-7b674b6b86d3da70cb34e83334833476

license: BSD3
copyright: Peter Simons
maintainer: Peter Simons <simons@cryp.to>
stability:
homepage: http://github.com/peti/hackage-db
package-url:
synopsis: provide access to the Hackage database via Data.Map
description: This module provides simple access to the Hackage database by means
             of @Data.Map@. Suppose you wanted to implement a utility that queries
             the set of available versions for a given package, the following
             program would do the trick:
             .
             > import qualified Distribution.Hackage.DB as DB
             > import Distribution.Text ( display )
             > import System.Environment ( getArgs )
             >
             > main :: IO ()
             > main = do
             >   pkgs <- getArgs
             >   db <- DB.readHackage
             >   let getVersions name = maybe [] DB.keys (DB.lookup name db)
             >   mapM_ (putStrLn . unwords . map display . getVersions) pkgs
             .
             When run, it would produce the following output:
             .
             > ./a.out containers deepseq cabal-install
             > 0.1.0.0 0.1.0.1 0.2.0.0 0.2.0.1 0.3.0.0 0.4.0.0
             > 1.0.0.0 1.1.0.0 1.1.0.1 1.1.0.2
             > 0.4.0 0.5.0 0.5.1 0.5.2 0.6.0 0.6.2 0.6.4 0.8.0 0.8.2 0.10.0 0.10.2
             .
             Note that once the database has been parsed, it can be accessed
             quickly, but the inital cost of reading @00-index.tar@ is fairly
             high.
category: Distribution
author: Peter Simons <simons@cryp.to>
pkgpath: databases/hs-hackage-db
exposed: True
exposed-modules: Distribution.Hackage.DB
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/hackage-db-1.4
library-dirs: /usr/local/lib/ghc/hackage-db-1.4
hs-libraries: HShackage-db-1.4
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: Cabal-1.16.0-b83fea7e2c38c08f5e9fa68736d4e572
         base-4.6.0.1-03845c6da2a0b3b4d0d49cc26c0cd3c0
         bytestring-0.10.0.2-9e8b487747800a4255d6ff7915c5210f
         containers-0.5.0.0-ab1dae9a94cd3cc84e7b2805636ebfa2
         directory-1.2.0.1-ee04c884b72040489d2e2ca6dd62e6ac
         filepath-1.3.0.1-b12cbe18566fe1532a1fda4c85e31cbe
         tar-0.4.0.1-036f178c42958da531b460c41b27fb44
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-hackage-db-1.4/html/hackage-db.haddock
haddock-html: /usr/local/share/doc/hs-hackage-db-1.4/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
