#!/bin/sh
echo 'name: dbus
version: 0.10.4
id: dbus-0.10.4-dcf94bd5fba654e9ba035d074a30df75

license: GPL-3
copyright:
maintainer: John Millikin <jmillikin@gmail.com>
stability: experimental
homepage: https://john-millikin.com/software/haskell-dbus/
package-url:
synopsis: A client library for the D-Bus IPC system.
description: D-Bus is a simple, message-based protocol for inter-process
             communication, which allows applications to interact with other parts of
             the machine and the user'\''s session using remote procedure calls.
             .
             D-Bus is a essential part of the modern Linux desktop, where it replaces
             earlier protocols such as CORBA and DCOP.
             .
             This library is an implementation of the D-Bus protocol in Haskell. It
             can be used to add D-Bus support to Haskell applications, without the
             awkward interfaces common to foreign bindings.
             .
             Example: connect to the session bus, and get a list of active names.
             .
             @
             &#x7b;-\# LANGUAGE OverloadedStrings \#-&#x7d;
             .
             import Data.List (sort)
             import DBus
             import DBus.Client
             .
             main = do
             &#x20;   client <- connectSession
             &#x20;   //
             &#x20;   \-- Request a list of connected clients from the bus
             &#x20;   reply <- call_ client (methodCall \"\/org\/freedesktop\/DBus\" \"org.freedesktop.DBus\" \"ListNames\")
             &#x20;       &#x7b; methodCallDestination = Just \"org.freedesktop.DBus\"
             &#x20;       &#x7d;
             &#x20;   //
             &#x20;   \-- org.freedesktop.DBus.ListNames() returns a single value, which is
             &#x20;   \-- a list of names (here represented as [String])
             &#x20;   let Just names = fromVariant (methodReturnBody reply !! 0)
             &#x20;   //
             &#x20;   \-- Print each name on a line, sorted so reserved names are below
             &#x20;   \-- temporary names.
             &#x20;   mapM_ putStrLn (sort names)
             @
             .
             >$ ghc --make list-names.hs
             >$ ./list-names
             >:1.0
             >:1.1
             >:1.10
             >:1.106
             >:1.109
             >:1.110
             >ca.desrt.dconf
             >org.freedesktop.DBus
             >org.freedesktop.Notifications
             >org.freedesktop.secrets
             >org.gnome.ScreenSaver
category: Network, Desktop
author: John Millikin <jmillikin@gmail.com>
pkgpath: x11/hs-dbus
exposed: True
exposed-modules: DBus DBus.Client DBus.Introspection DBus.Socket
                 DBus.Transport
hidden-modules: DBus.Address DBus.Message DBus.Types DBus.Wire
trusted: False
import-dirs: /usr/local/lib/ghc/dbus-0.10.4
library-dirs: /usr/local/lib/ghc/dbus-0.10.4
hs-libraries: HSdbus-0.10.4
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.6.0.1-03845c6da2a0b3b4d0d49cc26c0cd3c0
         bytestring-0.10.0.2-9e8b487747800a4255d6ff7915c5210f
         cereal-0.3.5.2-a9ff0516a3b8fef3d6dca329fe564618
         containers-0.5.0.0-ab1dae9a94cd3cc84e7b2805636ebfa2
         libxml-sax-0.7.4-3af4b4bb8c2db40402e561632a09eca3
         network-2.4.1.2-2410fd33cfc22dd877d4b24516181434
         parsec-3.1.3-8bc25b86282839a5b5fcb3c428bb3b9c
         random-1.0.1.1-023a342365721422ffd5a919bc8708bb
         text-0.11.3.1-06d227f06409a354e0c77a385328bada
         transformers-0.3.0.0-ff2bb6ac67241ebb987351a3db564af0
         unix-2.6.0.1-2939d4be83b53d31ca104e0487b1ef98
         vector-0.10.0.1-869166d5d49db46ce6c328ea5f8defbf
         xml-types-0.3.3-6406398f6a8a8ee7cc7bf08c1994fef5
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-dbus-0.10.4/html/dbus.haddock
haddock-html: /usr/local/share/doc/hs-dbus-0.10.4/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
