#!/bin/sh
echo 'name: attoparsec-enumerator
version: 0.3.1
id: attoparsec-enumerator-0.3.1-f4fb0a1831d18b63eb3a7ec37a0cda91

license: MIT
copyright:
maintainer: John Millikin <jmillikin@gmail.com>
stability: experimental
homepage: https://john-millikin.com/software/attoparsec-enumerator/
package-url:
synopsis: Pass input from an enumerator to an Attoparsec parser.
description: This library allows an Attoparsec parser to receive input incrementally
             from an enumerator. This could be used for parsing large files, or
             implementing binary network protocols.
             .
             > (-# LANGUAGE OverloadedStrings #-)
             >
             > import Control.Applicative
             > import Data.Attoparsec
             > import Data.Attoparsec.Enumerator
             > import Data.Enumerator
             > import Data.Enumerator.Binary (enumHandle)
             > import Data.Enumerator.List
             > import System.IO
             >
             > parser = string "foo" <|> string "bar"
             >
             > main = do
             >     xy <- run_ (enumHandle 1 stdin $$ do
             >         x <- iterParser parser
             >         y <- iterParser parser
             >         return (x, y))
             >     print xy
category: Text, Parsing, Enumerator
author: John Millikin <jmillikin@gmail.com>
pkgpath: textproc/hs-attoparsec-enumerator
exposed: True
exposed-modules: Data.Attoparsec.Enumerator
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/attoparsec-enumerator-0.3.1
library-dirs: /usr/local/lib/ghc/attoparsec-enumerator-0.3.1
hs-libraries: HSattoparsec-enumerator-0.3.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: attoparsec-0.10.4.0-d9fd97cfc1a1748b3cde35adf7fd233b
         base-4.6.0.1-03845c6da2a0b3b4d0d49cc26c0cd3c0
         bytestring-0.10.0.2-9e8b487747800a4255d6ff7915c5210f
         enumerator-0.4.19-13fa8f89bd8effdb12c1bcec44c8658a
         text-0.11.3.1-06d227f06409a354e0c77a385328bada
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-attoparsec-enumerator-0.3.1/html/attoparsec-enumerator.haddock
haddock-html: /usr/local/share/doc/hs-attoparsec-enumerator-0.3.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
