#!/bin/sh
echo 'name: HDBC
version: 2.3.1.2
id: HDBC-2.3.1.2-03fc4b9f7de79631330534bd55420c6a

license: BSD3
copyright: Copyright (c) 2005-2011 John Goerzen
maintainer: Nicolas Wu <nicolas.wu@gmail.com>
stability: Stable
homepage: https://github.com/hdbc/hdbc
package-url:
synopsis: Haskell Database Connectivity
description: HDBC provides an abstraction layer between Haskell programs and SQL
             relational databases. This lets you write database code once, in
             Haskell, and have it work with any number of backend SQL databases
             (MySQL, Oracle, PostgreSQL, ODBC-compliant databases, etc.)
category: Database
author: John Goerzen
pkgpath: databases/hs-HDBC
exposed: True
exposed-modules: Database.HDBC Database.HDBC.Types
                 Database.HDBC.DriverUtils Database.HDBC.ColTypes
                 Database.HDBC.Statement Database.HDBC.SqlValue Database.HDBC.Locale
hidden-modules: Database.HDBC.Utils
trusted: False
import-dirs: /usr/local/lib/ghc/HDBC-2.3.1.2
library-dirs: /usr/local/lib/ghc/HDBC-2.3.1.2
hs-libraries: HSHDBC-2.3.1.2
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.6.0.1-03845c6da2a0b3b4d0d49cc26c0cd3c0
         bytestring-0.10.0.2-9e8b487747800a4255d6ff7915c5210f
         containers-0.5.0.0-ab1dae9a94cd3cc84e7b2805636ebfa2
         convertible-1.0.11.1-85bfbb574a72addb259cdd913b9ef2ad
         mtl-2.1.2-94c72af955e94b8d7b2f359dadd0cb62
         old-locale-1.0.0.5-6729cb9d9cc62d150655de8fc5401b91
         old-time-1.1.0.1-029c40e673a46f6084b935f654a6fa28
         text-0.11.3.1-06d227f06409a354e0c77a385328bada
         time-1.4.0.1-10dc4804a19dc0000fab79908f1a9f50
         utf8-string-0.3.8-ac107fb901621046f538bc29451f9d70
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-HDBC-2.3.1.2/html/HDBC.haddock
haddock-html: /usr/local/share/doc/hs-HDBC-2.3.1.2/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
