/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.jarsigner;

import gnu.classpath.Configuration;
import gnu.classpath.tools.jarsigner.HashUtils;
import gnu.classpath.tools.jarsigner.Main;
import gnu.classpath.tools.jarsigner.Messages;
import gnu.java.security.OID;
import gnu.java.security.der.DERValue;
import gnu.java.security.pkcs.PKCS7Data;
import gnu.java.security.pkcs.PKCS7SignedData;
import gnu.java.security.pkcs.SignerInfo;
import gnu.java.security.sig.dss.DSSSignature;
import gnu.java.security.sig.dss.DSSSignatureX509Codec;
import gnu.java.security.sig.rsa.RSAPKCS1V1_5Signature;
import gnu.java.security.sig.rsa.RSAPKCS1V1_5SignatureX509Codec;
import gnu.java.security.util.Util;
import gnu.java.util.jar.JarUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import javax.security.auth.x500.X500Principal;

public class SFHelper {
    private static final Logger log = Logger.getLogger(SFHelper.class.getName());
    private static final int READY = 0;
    private static final int STARTED = 1;
    private static final int FINISHED = 2;
    private static final int SF_GENERATED = 3;
    private static final int DSA_GENERATED = 4;
    private static final OID hashAlgorithmIdentifierSHA1 = new OID("1.3.14.3.2.26");
    private int state;
    private JarFile jar;
    private Manifest manifest;
    private Attributes sfMainAttributes;
    private Map<String, Attributes> sfEntries;
    private byte[] sfBytes;
    private HashUtils util;

    public SFHelper(JarFile jar) {
        this.jar = jar;
        this.state = 0;
    }

    void writeSF(JarOutputStream jar) throws IOException {
        if (this.state != 2) {
            throw new IllegalStateException(Messages.getString("SFHelper.1"));
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JarUtils.writeSFManifest((Attributes)this.sfMainAttributes, this.sfEntries, (OutputStream)baos);
        this.sfBytes = baos.toByteArray();
        if (Configuration.DEBUG) {
            log.fine("\n" + Util.dumpString((byte[])this.sfBytes, (String)"+++ sfBytes "));
        }
        jar.write(this.sfBytes);
        jar.flush();
        this.state = 3;
    }

    void writeDSA(JarOutputStream jar, PrivateKey signerKey, Certificate[] certificates, boolean internalSF) throws IOException, CertificateEncodingException, CRLException {
        String subjectName;
        String issuerName;
        OID digestEncryptionAlgorithmOID;
        DSSSignatureX509Codec signatureCodec;
        DSSSignature signatureAlgorithm;
        if (this.state != 3) {
            throw new IllegalStateException(Messages.getString("SFHelper.4"));
        }
        if (Configuration.DEBUG) {
            log.fine("+++ signer private key = " + signerKey);
        }
        if (signerKey instanceof DSAPrivateKey) {
            signatureAlgorithm = new DSSSignature();
            signatureCodec = new DSSSignatureX509Codec();
            digestEncryptionAlgorithmOID = Main.DSA_SIGNATURE_OID;
        } else if (signerKey instanceof RSAPrivateKey) {
            signatureAlgorithm = new RSAPKCS1V1_5Signature("md5");
            signatureCodec = new RSAPKCS1V1_5SignatureX509Codec();
            digestEncryptionAlgorithmOID = Main.RSA_SIGNATURE_OID;
        } else {
            throw new SecurityException(Messages.getString("SFHelper.6"));
        }
        HashMap<String, PrivateKey> signatureAttributes = new HashMap<String, PrivateKey>();
        signatureAttributes.put("gnu.crypto.sig.private.key", signerKey);
        signatureAlgorithm.setupSign(signatureAttributes);
        signatureAlgorithm.update(this.sfBytes, 0, this.sfBytes.length);
        Object signature = signatureAlgorithm.sign();
        byte[] signedSFBytes = signatureCodec.encodeSignature(signature);
        if (Configuration.DEBUG) {
            log.fine("\n" + Util.dumpString((byte[])signedSFBytes, (String)"+++ signedSFBytes "));
        }
        HashSet<DERValue> digestAlgorithms = new HashSet<DERValue>();
        ArrayList<DERValue> digestAlgorithm = new ArrayList<DERValue>(2);
        DERValue derDigestAlgorithmOID = new DERValue(6, (Object)hashAlgorithmIdentifierSHA1);
        DERValue derDigestAlgorithmParams = new DERValue(5, null);
        digestAlgorithm.add(derDigestAlgorithmOID);
        digestAlgorithm.add(derDigestAlgorithmParams);
        DERValue derDigestAlgorithm = new DERValue(48, digestAlgorithm);
        digestAlgorithms.add(derDigestAlgorithm);
        PKCS7Data data = internalSF ? new PKCS7Data(this.sfBytes) : null;
        X509CRL[] crls = null;
        HashSet<SignerInfo> signerInfos = new HashSet<SignerInfo>();
        X509Certificate cert = (X509Certificate)certificates[0];
        try {
            cert.checkValidity();
        }
        catch (CertificateExpiredException certificateExpiredException) {
            issuerName = this.getIssuerName(cert);
            subjectName = this.getSubjectName(cert);
            Date notAfterDate = this.getNotAfterDate(cert);
            System.out.println(Messages.getFormattedString("SFHelper.0", new Object[]{issuerName, subjectName, notAfterDate}));
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            issuerName = this.getIssuerName(cert);
            subjectName = this.getSubjectName(cert);
            Date notBeforeDate = this.getNotBeforeDate(cert);
            System.out.println(Messages.getFormattedString("SFHelper.11", new Object[]{issuerName, subjectName, notBeforeDate}));
        }
        X500Principal issuer = cert.getIssuerX500Principal();
        BigInteger serialNumber = cert.getSerialNumber();
        byte[] authenticatedAttributes = null;
        byte[] encryptedDigest = signedSFBytes;
        byte[] unauthenticatedAttributes = null;
        SignerInfo signerInfo = new SignerInfo(issuer, serialNumber, hashAlgorithmIdentifierSHA1, authenticatedAttributes, digestEncryptionAlgorithmOID, encryptedDigest, unauthenticatedAttributes);
        signerInfos.add(signerInfo);
        PKCS7SignedData dsaContents = new PKCS7SignedData(digestAlgorithms, data, certificates, crls, signerInfos);
        dsaContents.encode((OutputStream)jar);
        jar.flush();
        this.state = 4;
    }

    Manifest getManifest() {
        return this.manifest;
    }

    void startSigning() throws IOException {
        if (this.state != 0) {
            throw new IllegalStateException(Messages.getString("SFHelper.9"));
        }
        Manifest oldManifest = this.jar.getManifest();
        this.manifest = oldManifest == null ? new Manifest() : new Manifest(oldManifest);
        this.sfMainAttributes = new Attributes();
        this.sfEntries = new HashMap<String, Attributes>();
        this.util = new HashUtils();
        this.state = 1;
    }

    void updateEntry(JarEntry entry) throws IOException {
        Attributes mainfestAttributes;
        if (this.state != 1) {
            throw new IllegalStateException(Messages.getString("SFHelper.10"));
        }
        String name = entry.getName();
        InputStream jeis = this.jar.getInputStream(entry);
        String hash = this.util.hashStream(jeis);
        if (Configuration.DEBUG) {
            log.fine("Hash of " + name + " = " + hash);
        }
        if ((mainfestAttributes = this.manifest.getAttributes(name)) == null) {
            mainfestAttributes = new Attributes();
            this.manifest.getEntries().put(name, mainfestAttributes);
        }
        mainfestAttributes.putValue("SHA1-Digest", hash);
        String sfHash = this.util.hashManifestEntry(name, hash);
        Attributes sfAttributes = this.sfEntries.get(name);
        if (sfAttributes == null) {
            sfAttributes = new Attributes();
            this.sfEntries.put(name, sfAttributes);
        }
        sfAttributes.putValue("SHA1-Digest", sfHash);
        if (Configuration.DEBUG) {
            log.fine("Name: " + name);
            log.fine("SHA1-Digest: " + sfHash);
            log.fine("");
        }
    }

    void finishSigning(boolean sectionsOnly) throws IOException {
        if (this.state != 1) {
            throw new IllegalStateException(Messages.getString("SFHelper.10"));
        }
        if (sectionsOnly) {
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.manifest.write(baos);
        baos.flush();
        String manifestHash = this.util.hashByteArray(baos.toByteArray());
        if (Configuration.DEBUG) {
            log.fine("Hashed Manifest " + manifestHash);
        }
        this.sfMainAttributes.putValue("SHA1-Digest-Manifest", manifestHash);
        this.state = 2;
    }

    private String getIssuerName(X509Certificate cert) {
        X500Principal xp = cert.getIssuerX500Principal();
        if (xp == null) {
            if (Configuration.DEBUG) {
                log.fine("Certiticate, with serial number " + cert.getSerialNumber() + ", has null Issuer. Return [unknown]");
            }
            return Messages.getString("SFHelper.14");
        }
        String result = xp.getName();
        if (result == null) {
            if (Configuration.DEBUG) {
                log.fine("Certiticate, with serial number " + cert.getSerialNumber() + ", has an Issuer with null DN. Return [unnamed]");
            }
            return Messages.getString("SFHelper.17");
        }
        return result;
    }

    private String getSubjectName(X509Certificate cert) {
        X500Principal xp = cert.getSubjectX500Principal();
        if (xp == null) {
            if (Configuration.DEBUG) {
                log.fine("Certiticate, with serial number " + cert.getSerialNumber() + ", has null Subject. Return [unknown]");
            }
            return Messages.getString("SFHelper.14");
        }
        String result = xp.getName();
        if (result == null) {
            if (Configuration.DEBUG) {
                log.fine("Certiticate, with serial number " + cert.getSerialNumber() + ", has a Subject with null DN. Return [unnamed]");
            }
            return Messages.getString("SFHelper.17");
        }
        return result;
    }

    private Date getNotAfterDate(X509Certificate cert) {
        Date result = cert.getNotAfter();
        if (result == null) {
            if (Configuration.DEBUG) {
                log.fine("Certiticate, with serial number " + cert.getSerialNumber() + ", has null start-validity date. Return epoch");
            }
            return new Date(0L);
        }
        return result;
    }

    private Date getNotBeforeDate(X509Certificate cert) {
        Date result = cert.getNotBefore();
        if (result == null) {
            if (Configuration.DEBUG) {
                log.fine("Certiticate, with serial number " + cert.getSerialNumber() + ", has null end-validity date. Return epoch");
            }
            return new Date(0L);
        }
        return result;
    }
}

