/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.gjdoc.expr;

import gnu.classpath.tools.gjdoc.expr.BinaryExpression;
import gnu.classpath.tools.gjdoc.expr.ConstantDouble;
import gnu.classpath.tools.gjdoc.expr.ConstantExpression;
import gnu.classpath.tools.gjdoc.expr.ConstantFloat;
import gnu.classpath.tools.gjdoc.expr.ConstantInteger;
import gnu.classpath.tools.gjdoc.expr.ConstantLong;
import gnu.classpath.tools.gjdoc.expr.Context;
import gnu.classpath.tools.gjdoc.expr.Expression;
import gnu.classpath.tools.gjdoc.expr.IllegalExpressionException;
import gnu.classpath.tools.gjdoc.expr.Type;

abstract class BinaryComputationExpression
extends BinaryExpression {
    protected BinaryComputationExpression(Expression left, Expression right) {
        super(left, right);
    }

    public ConstantExpression evaluate(Context context) throws IllegalExpressionException {
        ConstantExpression leftValue = this.left.evaluate(context);
        ConstantExpression rightValue = this.right.evaluate(context);
        return this.evaluate(leftValue, rightValue);
    }

    protected ConstantExpression evaluate(ConstantExpression leftValue, ConstantExpression rightValue) throws IllegalExpressionException {
        if (Type.DOUBLE == leftValue.getType() || Type.DOUBLE == rightValue.getType()) {
            return new ConstantDouble(this.compute(leftValue.asNumber().doubleValue(), rightValue.asNumber().doubleValue()));
        }
        if (Type.FLOAT == leftValue.getType() || Type.FLOAT == rightValue.getType()) {
            return new ConstantFloat(this.compute(leftValue.asNumber().floatValue(), rightValue.asNumber().floatValue()));
        }
        if (Type.LONG == leftValue.getType() || Type.LONG == rightValue.getType()) {
            return new ConstantLong(this.compute(leftValue.asNumber().longValue(), rightValue.asNumber().longValue()));
        }
        if (leftValue.isNumber() && rightValue.isNumber()) {
            return new ConstantInteger(this.compute(leftValue.asNumber().intValue(), rightValue.asNumber().intValue()));
        }
        throw new IllegalExpressionException("Operator ? cannot be applied to " + leftValue.getType() + "," + rightValue.getType());
    }

    protected abstract double compute(double var1, double var3);

    protected abstract float compute(float var1, float var2);

    protected abstract long compute(long var1, long var3);

    protected abstract int compute(int var1, int var2);
}

