/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.doclets.xmldoclet;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.MemberDoc;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public final class HtmlRepairer {
    private DocErrorReporter warningReporter;
    private boolean noWarn;
    private boolean noEmailWarn;
    private ClassDoc contextClass;
    private MemberDoc contextMember;
    private StringBuffer output = new StringBuffer();
    private Stack tagStack = new Stack();
    private boolean isLeadingTag = true;
    private boolean throwAwayLeadingPara = false;
    private static Map tagInfoMap = new HashMap();
    private static Set noTextParentTags;

    static {
        tagInfoMap.put("li", new TagInfo(new String[]{"ul", "ol", "nl", "menu", "dir"}));
        tagInfoMap.put("td", new TagInfo(new String[]{"tr"}));
        tagInfoMap.put("th", new TagInfo(new String[]{"tr"}));
        tagInfoMap.put("tr", new TagInfo(new String[]{"table"}));
        tagInfoMap.put("dt", new TagInfo(new String[]{"dl"}));
        tagInfoMap.put("dd", new TagInfo(new String[]{"dl"}));
        tagInfoMap.put("param", new TagInfo(new String[]{"applet"}));
        String[] noTextParentTagArr = new String[]{"area", "base", "body", "br", "dd", "dt", "head", "hr", "html", "img", "input", "link", "map", "meta", "ol", "optgroup", "param", "select", "table", "tbody", "tfoot", "thead", "tr", "ul"};
        noTextParentTags = new HashSet();
        int i = 0;
        while (i < noTextParentTagArr.length) {
            noTextParentTags.add(noTextParentTagArr[i]);
            ++i;
        }
    }

    public HtmlRepairer(DocErrorReporter warningReporter, boolean noWarn, boolean noEmailWarn, ClassDoc contextClass, MemberDoc contextMember, boolean throwAwayLeadingPara) {
        this.warningReporter = warningReporter;
        this.noWarn = noWarn;
        this.noEmailWarn = noEmailWarn;
        this.contextClass = contextClass;
        this.contextMember = contextMember;
        this.throwAwayLeadingPara = throwAwayLeadingPara;
    }

    private static String replaceStr(String haystack, String needle, String replacement) {
        int ndx = haystack.indexOf(needle);
        if (ndx < 0) {
            return haystack;
        }
        return String.valueOf(haystack.substring(0, ndx)) + replacement + HtmlRepairer.replaceStr(haystack.substring(ndx + needle.length()), needle, replacement);
    }

    private void haveText(String text) {
        if (this.isLeadingTag && this.throwAwayLeadingPara && text.trim().length() != 0) {
            this.isLeadingTag = false;
        }
        if (this.tagStack.isEmpty() || !noTextParentTags.contains(this.tagStack.peek())) {
            text = HtmlRepairer.replaceStr(text, "&lt1", "&lt;1");
            text = HtmlRepairer.replaceStr(text, "&&", "&amp;&amp;");
            text = HtmlRepairer.replaceStr(text, "& ", "&amp; ");
            text = HtmlRepairer.replaceStr(text, "&\t", "&amp;\t");
            text = HtmlRepairer.replaceStr(text, "&\r", "&amp;\r");
            text = HtmlRepairer.replaceStr(text, "&\n", "&amp;\n");
            char c = '0';
            while (c <= '9') {
                text = HtmlRepairer.replaceStr(text, "&" + c, "&amp;" + c);
                c = (char)(c + '\u0001');
            }
            text = HtmlRepairer.replaceStr(text, "\u00a7", "&sect;");
            this.output.append(text);
        } else {
            this.printWarning("Discarded text in <" + this.tagStack.peek() + "> element");
        }
    }

    private void haveStartOrEndTag(String tag) {
        boolean _isLeadingTag = this.isLeadingTag;
        this.isLeadingTag = false;
        tag = tag.trim();
        boolean isEndTag = tag.startsWith("/");
        boolean isAtomTag = tag.endsWith("/");
        if (isEndTag && isAtomTag) {
            tag = tag.substring(0, tag.length() - 1);
        }
        if (tag.length() < 1) {
            this.printWarning("Deleting broken tag");
            return;
        }
        String tagName = tag.substring(isEndTag ? 1 : 0, isAtomTag ? tag.length() - 1 : tag.length());
        String tagAttributes = "";
        int i = 0;
        while (i < tagName.length()) {
            if (" \t\r\n".indexOf(tagName.charAt(i)) >= 0) {
                tagAttributes = tagName.substring(i).trim();
                tagName = tagName.substring(0, i);
                break;
            }
            ++i;
        }
        if (!isEndTag && tagName.indexOf(64) > 0) {
            if (!this.noEmailWarn) {
                this.printWarning("Tag looks like email address: <" + tagName + ">");
            }
            this.output.append("&lt;" + tag + "&gt;");
            return;
        }
        tagName = tagName.toLowerCase();
        if (_isLeadingTag && "p".equals(tagName) && !isEndTag && this.throwAwayLeadingPara) {
            return;
        }
        if ("p".equals(tagName) || "br".equals(tagName) || "hr".equals(tagName)) {
            if (isEndTag) {
                return;
            }
            if (!isAtomTag) {
                tag = String.valueOf(tag) + "/";
                isAtomTag = true;
            }
        }
        if (isEndTag) {
            if (this.tagStack.contains(tagName)) {
                String popped;
                do {
                    if (!(popped = (String)this.tagStack.pop()).equals(tagName)) {
                        this.printWarning("Inserting '</" + popped + ">");
                    }
                    this.output.append("</" + popped + ">");
                } while (!popped.equals(tagName));
            } else {
                this.printWarning("Deleting <" + tag + ">");
            }
        } else {
            int state = 1;
            String newAttributes = "";
            String attributeName = null;
            StringBuffer buf = new StringBuffer();
            char[] attrsAsChars = tagAttributes.toCharArray();
            int i2 = 0;
            int ilim = attrsAsChars.length + 1;
            while (i2 < ilim) {
                int c = i2 < attrsAsChars.length ? attrsAsChars[i2] : -1;
                switch (state) {
                    case 1: {
                        if (" \t\r\n".indexOf(c) >= 0 || -1 == c) break;
                        state = 2;
                        buf.append((char)c);
                        break;
                    }
                    case 2: {
                        if (61 == c) {
                            attributeName = buf.toString();
                            buf.setLength(0);
                            state = 6;
                            break;
                        }
                        if (-1 == c) {
                            attributeName = buf.toString();
                            buf.setLength(0);
                            this.printWarning("In Tag '" + tag + "':\nAttribute name without a value, inserting value =\"" + attributeName + "\"");
                            break;
                        }
                        if (" \t\r\n".indexOf(c) >= 0) {
                            state = 7;
                            break;
                        }
                        buf.append((char)c);
                        break;
                    }
                    case 7: {
                        if (" \t\r\n".indexOf(c) >= 0) break;
                        if (61 == c) {
                            state = 6;
                            attributeName = buf.toString();
                            buf.setLength(0);
                            break;
                        }
                        attributeName = buf.toString();
                        buf.setLength(0);
                        this.printWarning("In Tag '" + tag + "':\nAttribute name without a value, inserting value =\"" + attributeName + "\"");
                        newAttributes = String.valueOf(newAttributes) + " " + attributeName + "=\"" + attributeName + "\"";
                        buf.append((char)c);
                        state = 2;
                        break;
                    }
                    case 6: {
                        if (" \t\r\n".indexOf(c) >= 0) break;
                        if (34 == c) {
                            state = 5;
                            break;
                        }
                        if (39 == c) {
                            state = 4;
                            break;
                        }
                        state = 3;
                        buf.append((char)c);
                        break;
                    }
                    case 3: {
                        if (-1 == c || " \t\r\n".indexOf(c) >= 0) {
                            state = 1;
                            newAttributes = String.valueOf(newAttributes) + " " + attributeName + "=\"" + buf.toString() + "\"";
                            buf.setLength(0);
                            break;
                        }
                        buf.append((char)c);
                        break;
                    }
                    case 4: {
                        if (39 == c) {
                            state = 1;
                            newAttributes = String.valueOf(newAttributes) + " " + attributeName + "=\"" + buf.toString() + "\"";
                            buf.setLength(0);
                            break;
                        }
                        buf.append((char)c);
                        break;
                    }
                    case 5: {
                        if (34 == c) {
                            state = 1;
                            newAttributes = String.valueOf(newAttributes) + " " + attributeName + "=\"" + buf.toString() + "\"";
                            buf.setLength(0);
                            break;
                        }
                        buf.append((char)c);
                    }
                }
                ++i2;
            }
            if (!isAtomTag) {
                if (!this.tagStack.isEmpty() && this.tagStack.peek().equals(tagName)) {
                    this.printWarning("Inserting </" + tagName + ">");
                    this.output.append("</" + tagName + ">");
                    this.tagStack.pop();
                } else {
                    this.processKnownChildTags(tagName, this.tagStack, this.output);
                }
                this.tagStack.push(tagName);
                this.output.append("<" + tagName + newAttributes + ">");
            } else {
                this.output.append("<" + tagName + newAttributes + "/>");
            }
        }
    }

    private boolean processKnownChildTags(String tagName, Stack tagStack, StringBuffer output) {
        TagInfo tagInfo = (TagInfo)tagInfoMap.get(tagName);
        if (tagInfo != null) {
            String parentTag = null;
            Enumeration en = tagStack.elements();
            while (en.hasMoreElements()) {
                String tag = (String)en.nextElement();
                if (!tagInfo.isLegalParentTag(tag)) continue;
                parentTag = tag;
                break;
            }
            if (parentTag != null) {
                while ((String)tagStack.peek() != parentTag) {
                    String poppedTagName = (String)tagStack.pop();
                    output.append("</" + poppedTagName + ">");
                    this.printWarning("Inserting </" + poppedTagName + ">");
                }
                return true;
            }
        }
        return false;
    }

    private void flush() {
        while (!this.tagStack.isEmpty()) {
            String tagName = (String)this.tagStack.pop();
            this.printWarning("Inserting </" + tagName + ">");
            this.output.append("</" + tagName + ">");
        }
    }

    public String getWellformedHTML(String text) {
        int state = 1;
        this.output.setLength(0);
        StringBuffer buf = new StringBuffer();
        char[] textAsChars = text.toCharArray();
        int i = 0;
        int ilim = textAsChars.length + 1;
        while (i < ilim) {
            int c = i < textAsChars.length ? textAsChars[i] : -1;
            block0 : switch (state) {
                case 1: {
                    if (60 == c) {
                        state = 2;
                        if (buf.length() <= 0) break;
                        this.haveText(buf.toString());
                        buf.setLength(0);
                        break;
                    }
                    if (62 == c) {
                        buf.append("&gt;");
                        break;
                    }
                    if (38 == c) {
                        state = 6;
                        break;
                    }
                    if (-1 == c) {
                        if (buf.length() <= 0) break;
                        this.haveText(buf.toString());
                        buf.setLength(0);
                        break;
                    }
                    buf.append((char)c);
                    break;
                }
                case 6: {
                    if (60 == c) {
                        buf.append("&amp;");
                        state = 2;
                        if (buf.length() <= 0) break;
                        this.haveText(buf.toString());
                        buf.setLength(0);
                        break;
                    }
                    if (62 == c) {
                        buf.append("&amp;");
                        buf.append("&gt;");
                        state = 1;
                        break;
                    }
                    if (38 == c) {
                        buf.append("&amp;");
                        buf.append("&amp;");
                        state = 1;
                        break;
                    }
                    if (-1 == c) {
                        buf.append("&amp;");
                        this.haveText(buf.toString());
                        buf.setLength(0);
                        state = 1;
                        break;
                    }
                    if (35 == c) {
                        buf.append("&");
                        buf.append((char)c);
                        state = 1;
                        break;
                    }
                    if (Character.isLetter((char)c)) {
                        int i2 = i + 1;
                        while (i2 < ilim - 1) {
                            if (';' == textAsChars[i2]) {
                                buf.append("&");
                                buf.append((char)c);
                                state = 1;
                                break block0;
                            }
                            if (!Character.isLetter((char)c) && !Character.isDigit((char)c) && ".-_:".indexOf((char)c) < 0) break;
                            ++i2;
                        }
                    }
                    buf.append("&amp;");
                    buf.append((char)c);
                    state = 1;
                    break;
                }
                case 2: {
                    if (" \t\r\n".indexOf(c) >= 0) {
                        this.haveText("&lt;" + c);
                        state = 1;
                        break;
                    }
                    if (47 == c) {
                        buf.append((char)c);
                        state = 3;
                        break;
                    }
                    if (60 == c) {
                        this.haveText("&lt;&lt;");
                        state = 1;
                        break;
                    }
                    if (62 == c) {
                        this.haveText("&lt;&gt;");
                        state = 1;
                        break;
                    }
                    if (!Character.isLetter((char)c)) {
                        this.haveText("&lt;" + (char)c);
                        state = 1;
                        break;
                    }
                    buf.append((char)c);
                    state = 3;
                    break;
                }
                case 3: {
                    if (34 == c) {
                        buf.append((char)c);
                        state = 4;
                        break;
                    }
                    if (39 == c) {
                        buf.append((char)c);
                        state = 5;
                        break;
                    }
                    if (62 == c) {
                        state = 1;
                        this.haveStartOrEndTag(buf.toString());
                        buf.setLength(0);
                        break;
                    }
                    if (60 == c) {
                        this.haveStartOrEndTag(buf.toString());
                        buf.setLength(0);
                        break;
                    }
                    if (-1 == c) {
                        this.printWarning("Unclosed tag at end-of-comment: <" + buf);
                        this.haveStartOrEndTag(buf.toString());
                        buf.setLength(0);
                        break;
                    }
                    buf.append((char)c);
                    break;
                }
                case 4: {
                    if (34 == c) {
                        buf.append((char)c);
                        state = 3;
                        break;
                    }
                    if (-1 == c) {
                        this.printWarning("Unclosed attribute value at end-of-comment.");
                        this.haveStartOrEndTag(String.valueOf(buf.toString()) + "\"");
                        break;
                    }
                    buf.append((char)c);
                    break;
                }
                case 5: {
                    if (39 == c) {
                        buf.append((char)c);
                        state = 3;
                        break;
                    }
                    if (-1 == c) {
                        this.printWarning("Unclosed attribute value at end-of-comment.");
                        this.haveStartOrEndTag(String.valueOf(buf.toString()) + "'");
                        break;
                    }
                    buf.append((char)c);
                }
            }
            ++i;
        }
        return this.output.toString();
    }

    private String getContext() {
        if (this.contextClass != null) {
            StringBuffer rc = new StringBuffer();
            rc.append(this.contextClass.qualifiedTypeName());
            if (this.contextMember != null) {
                rc.append("." + this.contextMember.toString());
            }
            return rc.toString();
        }
        return null;
    }

    private void printWarning(String msg) {
        if (this.warningReporter != null && !this.noWarn) {
            String context = this.getContext();
            if (context != null) {
                this.warningReporter.printWarning("In " + this.getContext() + ": " + msg);
            } else {
                this.warningReporter.printWarning("In overview page: " + msg);
            }
        }
    }

    public String terminateText() {
        this.output.setLength(0);
        this.flush();
        return this.output.toString();
    }

    private static class TagInfo {
        private Set parentTags = new HashSet();

        public TagInfo(String parentTag) {
            this.parentTags.add(parentTag);
        }

        public TagInfo(String[] parentTagArr) {
            int i = 0;
            while (i < parentTagArr.length) {
                this.parentTags.add(parentTagArr[i]);
                ++i;
            }
        }

        public boolean isLegalParentTag(String tag) {
            return this.parentTags.contains(tag);
        }
    }
}

