/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import gnu.javax.swing.text.html.css.BorderStyle;
import gnu.javax.swing.text.html.css.BorderWidth;
import gnu.javax.swing.text.html.css.CSSColor;
import gnu.javax.swing.text.html.css.FontSize;
import gnu.javax.swing.text.html.css.FontStyle;
import gnu.javax.swing.text.html.css.FontWeight;
import gnu.javax.swing.text.html.css.Length;
import java.io.Serializable;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.text.MutableAttributeSet;

public class CSS
implements Serializable {
    public static Attribute[] getAllAttributeKeys() {
        Object[] src = Attribute.attributeMap.values().toArray();
        Attribute[] dst = new Attribute[src.length];
        System.arraycopy(src, 0, dst, 0, src.length);
        return dst;
    }

    public static Attribute getAttribute(String name) {
        return (Attribute)Attribute.attributeMap.get(name);
    }

    static Object getValue(Attribute att, String v) {
        Object o = att == Attribute.FONT_SIZE ? new FontSize(v) : (att == Attribute.FONT_WEIGHT ? new FontWeight(v) : (att == Attribute.FONT_STYLE ? new FontStyle(v) : (att == Attribute.COLOR || att == Attribute.BACKGROUND_COLOR || att == Attribute.BORDER_COLOR || att == Attribute.BORDER_TOP_COLOR || att == Attribute.BORDER_BOTTOM_COLOR || att == Attribute.BORDER_LEFT_COLOR || att == Attribute.BORDER_RIGHT_COLOR ? new CSSColor(v) : (att == Attribute.MARGIN || att == Attribute.MARGIN_BOTTOM || att == Attribute.MARGIN_LEFT || att == Attribute.MARGIN_RIGHT || att == Attribute.MARGIN_TOP || att == Attribute.WIDTH || att == Attribute.HEIGHT || att == Attribute.PADDING || att == Attribute.PADDING_BOTTOM || att == Attribute.PADDING_LEFT || att == Attribute.PADDING_RIGHT || att == Attribute.PADDING_TOP || att == Attribute.LEFT || att == Attribute.RIGHT || att == Attribute.TOP || att == Attribute.BOTTOM ? new Length(v) : (att == Attribute.BORDER_WIDTH || att == Attribute.BORDER_TOP_WIDTH || att == Attribute.BORDER_LEFT_WIDTH || att == Attribute.BORDER_RIGHT_WIDTH || att == Attribute.BORDER_BOTTOM_WIDTH ? new BorderWidth(v) : v)))));
        return o;
    }

    static void addInternal(MutableAttributeSet atts, Attribute a, String v) {
        if (a == Attribute.BACKGROUND) {
            CSS.parseBackgroundShorthand(atts, v);
        } else if (a == Attribute.PADDING) {
            CSS.parsePaddingShorthand(atts, v);
        } else if (a == Attribute.MARGIN) {
            CSS.parseMarginShorthand(atts, v);
        } else if (a == Attribute.BORDER || a == Attribute.BORDER_LEFT || a == Attribute.BORDER_RIGHT || a == Attribute.BORDER_TOP || a == Attribute.BORDER_BOTTOM) {
            CSS.parseBorderShorthand(atts, v, a);
        }
    }

    private static void parseBackgroundShorthand(MutableAttributeSet atts, String v) {
        StringTokenizer tokens = new StringTokenizer(v, " ");
        while (tokens.hasMoreElements()) {
            String token = tokens.nextToken();
            if (!CSSColor.isValidColor(token)) continue;
            atts.addAttribute(Attribute.BACKGROUND_COLOR, new CSSColor(token));
        }
    }

    private static void parsePaddingShorthand(MutableAttributeSet atts, String v) {
        StringTokenizer tokens = new StringTokenizer(v, " ");
        int numTokens = tokens.countTokens();
        if (numTokens == 1) {
            Length l = new Length(tokens.nextToken());
            atts.addAttribute(Attribute.PADDING_BOTTOM, l);
            atts.addAttribute(Attribute.PADDING_LEFT, l);
            atts.addAttribute(Attribute.PADDING_RIGHT, l);
            atts.addAttribute(Attribute.PADDING_TOP, l);
        } else if (numTokens == 2) {
            Length l1 = new Length(tokens.nextToken());
            Length l2 = new Length(tokens.nextToken());
            atts.addAttribute(Attribute.PADDING_BOTTOM, l1);
            atts.addAttribute(Attribute.PADDING_TOP, l1);
            atts.addAttribute(Attribute.PADDING_LEFT, l2);
            atts.addAttribute(Attribute.PADDING_RIGHT, l2);
        } else if (numTokens == 3) {
            Length l1 = new Length(tokens.nextToken());
            Length l2 = new Length(tokens.nextToken());
            Length l3 = new Length(tokens.nextToken());
            atts.addAttribute(Attribute.PADDING_TOP, l1);
            atts.addAttribute(Attribute.PADDING_LEFT, l2);
            atts.addAttribute(Attribute.PADDING_RIGHT, l2);
            atts.addAttribute(Attribute.PADDING_BOTTOM, l3);
        } else {
            Length l1 = new Length(tokens.nextToken());
            Length l2 = new Length(tokens.nextToken());
            Length l3 = new Length(tokens.nextToken());
            Length l4 = new Length(tokens.nextToken());
            atts.addAttribute(Attribute.PADDING_TOP, l1);
            atts.addAttribute(Attribute.PADDING_RIGHT, l2);
            atts.addAttribute(Attribute.PADDING_BOTTOM, l3);
            atts.addAttribute(Attribute.PADDING_LEFT, l4);
        }
    }

    private static void parseMarginShorthand(MutableAttributeSet atts, String v) {
        StringTokenizer tokens = new StringTokenizer(v, " ");
        int numTokens = tokens.countTokens();
        if (numTokens == 1) {
            Length l = new Length(tokens.nextToken());
            atts.addAttribute(Attribute.MARGIN_BOTTOM, l);
            atts.addAttribute(Attribute.MARGIN_LEFT, l);
            atts.addAttribute(Attribute.MARGIN_RIGHT, l);
            atts.addAttribute(Attribute.MARGIN_TOP, l);
        } else if (numTokens == 2) {
            Length l1 = new Length(tokens.nextToken());
            Length l2 = new Length(tokens.nextToken());
            atts.addAttribute(Attribute.MARGIN_BOTTOM, l1);
            atts.addAttribute(Attribute.MARGIN_TOP, l1);
            atts.addAttribute(Attribute.MARGIN_LEFT, l2);
            atts.addAttribute(Attribute.MARGIN_RIGHT, l2);
        } else if (numTokens == 3) {
            Length l1 = new Length(tokens.nextToken());
            Length l2 = new Length(tokens.nextToken());
            Length l3 = new Length(tokens.nextToken());
            atts.addAttribute(Attribute.MARGIN_TOP, l1);
            atts.addAttribute(Attribute.MARGIN_LEFT, l2);
            atts.addAttribute(Attribute.MARGIN_RIGHT, l2);
            atts.addAttribute(Attribute.MARGIN_BOTTOM, l3);
        } else {
            Length l1 = new Length(tokens.nextToken());
            Length l2 = new Length(tokens.nextToken());
            Length l3 = new Length(tokens.nextToken());
            Length l4 = new Length(tokens.nextToken());
            atts.addAttribute(Attribute.MARGIN_TOP, l1);
            atts.addAttribute(Attribute.MARGIN_RIGHT, l2);
            atts.addAttribute(Attribute.MARGIN_BOTTOM, l3);
            atts.addAttribute(Attribute.MARGIN_LEFT, l4);
        }
    }

    private static void parseBorderShorthand(MutableAttributeSet atts, String value, Attribute cssAtt) {
        StringTokenizer tokens = new StringTokenizer(value, " ");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (BorderStyle.isValidStyle(token)) {
                if (cssAtt == Attribute.BORDER_LEFT || cssAtt == Attribute.BORDER) {
                    atts.addAttribute(Attribute.BORDER_LEFT_STYLE, token);
                }
                if (cssAtt == Attribute.BORDER_RIGHT || cssAtt == Attribute.BORDER) {
                    atts.addAttribute(Attribute.BORDER_RIGHT_STYLE, token);
                }
                if (cssAtt == Attribute.BORDER_BOTTOM || cssAtt == Attribute.BORDER) {
                    atts.addAttribute(Attribute.BORDER_BOTTOM_STYLE, token);
                }
                if (cssAtt != Attribute.BORDER_TOP && cssAtt != Attribute.BORDER) continue;
                atts.addAttribute(Attribute.BORDER_TOP_STYLE, token);
                continue;
            }
            if (BorderWidth.isValid(token)) {
                BorderWidth w = new BorderWidth(token);
                if (cssAtt == Attribute.BORDER_LEFT || cssAtt == Attribute.BORDER) {
                    atts.addAttribute(Attribute.BORDER_LEFT_WIDTH, w);
                }
                if (cssAtt == Attribute.BORDER_RIGHT || cssAtt == Attribute.BORDER) {
                    atts.addAttribute(Attribute.BORDER_RIGHT_WIDTH, w);
                }
                if (cssAtt == Attribute.BORDER_BOTTOM || cssAtt == Attribute.BORDER) {
                    atts.addAttribute(Attribute.BORDER_BOTTOM_WIDTH, w);
                }
                if (cssAtt != Attribute.BORDER_TOP && cssAtt != Attribute.BORDER) continue;
                atts.addAttribute(Attribute.BORDER_TOP_WIDTH, w);
                continue;
            }
            if (!CSSColor.isValidColor(token)) continue;
            CSSColor c = new CSSColor(token);
            if (cssAtt == Attribute.BORDER_LEFT || cssAtt == Attribute.BORDER) {
                atts.addAttribute(Attribute.BORDER_LEFT_COLOR, c);
            }
            if (cssAtt == Attribute.BORDER_RIGHT || cssAtt == Attribute.BORDER) {
                atts.addAttribute(Attribute.BORDER_RIGHT_COLOR, c);
            }
            if (cssAtt == Attribute.BORDER_BOTTOM || cssAtt == Attribute.BORDER) {
                atts.addAttribute(Attribute.BORDER_BOTTOM_COLOR, c);
            }
            if (cssAtt != Attribute.BORDER_TOP && cssAtt != Attribute.BORDER) continue;
            atts.addAttribute(Attribute.BORDER_TOP_COLOR, c);
        }
    }

    public static final class Attribute {
        public static final Attribute BACKGROUND = new Attribute("background", false, null);
        public static final Attribute BACKGROUND_ATTACHMENT = new Attribute("background-attachment", false, "scroll");
        public static final Attribute BACKGROUND_COLOR = new Attribute("background-color", false, "transparent");
        public static final Attribute BACKGROUND_IMAGE = new Attribute("background-image", false, "none");
        public static final Attribute BACKGROUND_POSITION = new Attribute("background-position", false, null);
        public static final Attribute BACKGROUND_REPEAT = new Attribute("background-repeat", false, "repeat");
        public static final Attribute BORDER = new Attribute("border", false, null);
        public static final Attribute BORDER_BOTTOM = new Attribute("border-bottom", false, null);
        public static final Attribute BORDER_BOTTOM_WIDTH = new Attribute("border-bottom-width", false, "medium");
        public static final Attribute BORDER_COLOR = new Attribute("border-color", false, "black");
        public static final Attribute BORDER_LEFT = new Attribute("border-left", false, null);
        public static final Attribute BORDER_LEFT_WIDTH = new Attribute("border-left-width", false, "medium");
        public static final Attribute BORDER_RIGHT = new Attribute("border-right", false, null);
        public static final Attribute BORDER_RIGHT_WIDTH = new Attribute("border-right-width", false, "medium");
        public static final Attribute BORDER_STYLE = new Attribute("border-style", false, "none");
        public static final Attribute BORDER_TOP = new Attribute("border-top", false, null);
        public static final Attribute BORDER_TOP_WIDTH = new Attribute("border-top-width", false, "medium");
        public static final Attribute BORDER_WIDTH = new Attribute("border-width", false, "medium");
        public static final Attribute CLEAR = new Attribute("clear", false, "none");
        public static final Attribute COLOR = new Attribute("color", true, "black");
        public static final Attribute DISPLAY = new Attribute("display", false, "block");
        public static final Attribute FLOAT = new Attribute("float", false, "none");
        public static final Attribute FONT = new Attribute("font", true, null);
        public static final Attribute FONT_FAMILY = new Attribute("font-family", true, null);
        public static final Attribute FONT_SIZE = new Attribute("font-size", true, "medium");
        public static final Attribute FONT_STYLE = new Attribute("font-style", true, "normal");
        public static final Attribute FONT_VARIANT = new Attribute("font-variant", true, "normal");
        public static final Attribute FONT_WEIGHT = new Attribute("font-weight", true, "normal");
        public static final Attribute HEIGHT = new Attribute("height", false, "auto");
        public static final Attribute LETTER_SPACING = new Attribute("letter-spacing", true, "normal");
        public static final Attribute LINE_HEIGHT = new Attribute("line-height", true, "normal");
        public static final Attribute LIST_STYLE = new Attribute("list-style", true, null);
        public static final Attribute LIST_STYLE_IMAGE = new Attribute("list-style-image", true, "none");
        public static final Attribute LIST_STYLE_POSITION = new Attribute("list-style-position", true, "outside");
        public static final Attribute LIST_STYLE_TYPE = new Attribute("list-style-type", true, "disc");
        public static final Attribute MARGIN = new Attribute("margin", false, null);
        public static final Attribute MARGIN_BOTTOM = new Attribute("margin-bottom", false, "0");
        public static final Attribute MARGIN_LEFT = new Attribute("margin-left", false, "0");
        public static final Attribute MARGIN_RIGHT = new Attribute("margin-right", false, "0");
        public static final Attribute MARGIN_TOP = new Attribute("margin-top", false, "0");
        public static final Attribute PADDING = new Attribute("padding", false, null);
        public static final Attribute PADDING_BOTTOM = new Attribute("padding-bottom", false, "0");
        public static final Attribute PADDING_LEFT = new Attribute("padding-left", false, "0");
        public static final Attribute PADDING_RIGHT = new Attribute("padding-right", false, "0");
        public static final Attribute PADDING_TOP = new Attribute("padding-top", false, "0");
        public static final Attribute TEXT_ALIGN = new Attribute("text-align", true, null);
        public static final Attribute TEXT_DECORATION = new Attribute("text-decoration", true, "none");
        public static final Attribute TEXT_INDENT = new Attribute("text-indent", true, "0");
        public static final Attribute TEXT_TRANSFORM = new Attribute("text-transform", true, "none");
        public static final Attribute VERTICAL_ALIGN = new Attribute("vertical-align", false, "baseline");
        public static final Attribute WHITE_SPACE = new Attribute("white-space", true, "normal");
        public static final Attribute WIDTH = new Attribute("width", false, "auto");
        public static final Attribute WORD_SPACING = new Attribute("word-spacing", true, "normal");
        static final Attribute BORDER_TOP_STYLE = new Attribute("border-top-style", false, null);
        static final Attribute BORDER_BOTTOM_STYLE = new Attribute("border-bottom-style", false, null);
        static final Attribute BORDER_LEFT_STYLE = new Attribute("border-left-style", false, null);
        static final Attribute BORDER_RIGHT_STYLE = new Attribute("border-right-style", false, null);
        static final Attribute BORDER_TOP_COLOR = new Attribute("border-top-color", false, null);
        static final Attribute BORDER_BOTTOM_COLOR = new Attribute("border-bottom-color", false, null);
        static final Attribute BORDER_LEFT_COLOR = new Attribute("border-left-color", false, null);
        static final Attribute BORDER_RIGHT_COLOR = new Attribute("border-right-color", false, null);
        static final Attribute BORDER_SPACING = new Attribute("border-spacing", false, null);
        static final Attribute POSITION = new Attribute("position", false, null);
        static final Attribute LEFT = new Attribute("left", false, null);
        static final Attribute RIGHT = new Attribute("right", false, null);
        static final Attribute TOP = new Attribute("top", false, null);
        static final Attribute BOTTOM = new Attribute("bottom", false, null);
        String attStr;
        boolean isInherited;
        String defaultValue;
        static HashMap attributeMap;

        Attribute(String attr, boolean inherited, String def) {
            this.attStr = attr;
            this.isInherited = inherited;
            this.defaultValue = def;
            if (attributeMap == null) {
                attributeMap = new HashMap();
            }
            attributeMap.put(attr, this);
        }

        public String toString() {
            return this.attStr;
        }

        public boolean isInherited() {
            return this.isInherited;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

