/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import gnu.classpath.SystemProperties;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabExpander;
import javax.swing.text.TabableView;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class GlyphView
extends View
implements TabableView,
Cloneable {
    GlyphPainter glyphPainter;
    private int offset = 0;
    private int length = 0;
    private float tabX;
    private TabExpander tabExpander;
    private Segment cached = new Segment();

    public GlyphView(Element element) {
        super(element);
    }

    public GlyphPainter getGlyphPainter() {
        return this.glyphPainter;
    }

    public void setGlyphPainter(GlyphPainter painter) {
        this.glyphPainter = painter;
    }

    protected void checkPainter() {
        if (this.glyphPainter == null) {
            if ("true".equals(SystemProperties.getProperty("gnu.javax.swing.noGraphics2D"))) {
                this.glyphPainter = new DefaultGlyphPainter();
            } else {
                Segment s = this.getText(this.getStartOffset(), this.getEndOffset());
                this.glyphPainter = new J2DGlyphPainter(s.toString(), this.getFont(), new FontRenderContext(null, false, false));
            }
        }
    }

    public void paint(Graphics g, Shape a) {
        Highlighter h;
        Color bg;
        this.checkPainter();
        int p0 = this.getStartOffset();
        int p1 = this.getEndOffset();
        Rectangle r = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
        Container c = this.getContainer();
        Color fg = this.getForeground();
        JTextComponent tc = null;
        if (c instanceof JTextComponent && !(tc = (JTextComponent)c).isEnabled()) {
            fg = tc.getDisabledTextColor();
        }
        if ((bg = this.getBackground()) != null) {
            g.setColor(bg);
            g.fillRect(r.x, r.y, r.width, r.height);
        }
        if (tc != null && (h = tc.getHighlighter()) instanceof LayeredHighlighter) {
            LayeredHighlighter lh = (LayeredHighlighter)h;
            lh.paintLayeredHighlights(g, p0, p1, a, tc, this);
        }
        g.setColor(fg);
        this.glyphPainter.paint(this, g, a, p0, p1);
        boolean underline = this.isUnderline();
        boolean striked = this.isStrikeThrough();
        if (underline || striked) {
            int yTmp;
            View parent = this.getParent();
            if (parent != null && parent.getEndOffset() == p1) {
                Segment s = this.getText(p0, p1);
                while (s.count > 0 && Character.isWhitespace(s.array[s.count - 1])) {
                    --p1;
                    --s.count;
                }
            }
            int x0 = r.x;
            int p = this.getStartOffset();
            TabExpander tabEx = this.getTabExpander();
            if (p != p0) {
                x0 += (int)this.glyphPainter.getSpan(this, p, p0, tabEx, x0);
            }
            int x1 = x0 + (int)this.glyphPainter.getSpan(this, p0, p1, tabEx, x0);
            int y = r.y + r.height - (int)this.glyphPainter.getDescent(this);
            if (underline) {
                yTmp = y;
                g.drawLine(x0, ++yTmp, x1, yTmp);
            }
            if (striked) {
                yTmp = y;
                g.drawLine(x0, yTmp -= (int)this.glyphPainter.getAscent(this), x1, yTmp);
            }
        }
    }

    public float getPreferredSpan(int axis) {
        float span = 0.0f;
        this.checkPainter();
        GlyphPainter painter = this.getGlyphPainter();
        switch (axis) {
            case 0: {
                TabExpander tabEx = null;
                View parent = this.getParent();
                if (parent instanceof TabExpander) {
                    tabEx = (TabExpander)((Object)parent);
                }
                span = painter.getSpan(this, this.getStartOffset(), this.getEndOffset(), tabEx, 0.0f);
                break;
            }
            case 1: {
                span = painter.getHeight(this);
                if (!this.isSuperscript()) break;
                span += span / 3.0f;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal axis");
            }
        }
        return span;
    }

    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        GlyphPainter p = this.getGlyphPainter();
        return p.modelToView(this, pos, b, a);
    }

    public int viewToModel(float x, float y, Shape a, Position.Bias[] b) {
        this.checkPainter();
        GlyphPainter painter = this.getGlyphPainter();
        return painter.viewToModel(this, x, y, a, b);
    }

    public TabExpander getTabExpander() {
        return this.tabExpander;
    }

    public float getTabbedSpan(float x, TabExpander te) {
        this.checkPainter();
        TabExpander old = this.tabExpander;
        this.tabExpander = te;
        if (this.tabExpander != old) {
            this.preferenceChanged(null, true, false);
        }
        this.tabX = x;
        return this.getGlyphPainter().getSpan(this, this.getStartOffset(), this.getEndOffset(), this.tabExpander, x);
    }

    public float getPartialSpan(int p0, int p1) {
        this.checkPainter();
        return this.glyphPainter.getSpan(this, p0, p1, this.tabExpander, this.tabX);
    }

    public int getStartOffset() {
        Element el = this.getElement();
        int offs = el.getStartOffset();
        if (this.length > 0) {
            offs += this.offset;
        }
        return offs;
    }

    public int getEndOffset() {
        Element el = this.getElement();
        int offs = this.length > 0 ? el.getStartOffset() + this.offset + this.length : el.getEndOffset();
        return offs;
    }

    public Segment getText(int p0, int p1) {
        try {
            this.getDocument().getText(p0, p1 - p0, this.cached);
        }
        catch (BadLocationException ex) {
            AssertionError ae = new AssertionError((Object)("BadLocationException should not be thrown here. p0 = " + p0 + ", p1 = " + p1));
            ((Throwable)((Object)ae)).initCause(ex);
            throw ae;
        }
        return this.cached;
    }

    public Font getFont() {
        Document doc = this.getDocument();
        Font font = null;
        if (doc instanceof StyledDocument) {
            StyledDocument styledDoc = (StyledDocument)doc;
            font = styledDoc.getFont(this.getAttributes());
        } else {
            Container c = this.getContainer();
            if (c != null) {
                font = c.getFont();
            }
        }
        return font;
    }

    public Color getForeground() {
        Element el = this.getElement();
        AttributeSet atts = el.getAttributes();
        return StyleConstants.getForeground(atts);
    }

    public Color getBackground() {
        Element el = this.getElement();
        AttributeSet atts = el.getAttributes();
        return (Color)atts.getAttribute(StyleConstants.Background);
    }

    public boolean isStrikeThrough() {
        Element el = this.getElement();
        AttributeSet atts = el.getAttributes();
        return StyleConstants.isStrikeThrough(atts);
    }

    public boolean isSubscript() {
        Element el = this.getElement();
        AttributeSet atts = el.getAttributes();
        return StyleConstants.isSubscript(atts);
    }

    public boolean isSuperscript() {
        Element el = this.getElement();
        AttributeSet atts = el.getAttributes();
        return StyleConstants.isSuperscript(atts);
    }

    public boolean isUnderline() {
        Element el = this.getElement();
        AttributeSet atts = el.getAttributes();
        return StyleConstants.isUnderline(atts);
    }

    protected final Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            AssertionError err = new AssertionError((Object)"CloneNotSupportedException must not be thrown here");
            ((Throwable)((Object)err)).initCause(ex);
            throw err;
        }
    }

    public View breakView(int axis, int p0, float pos, float len) {
        View brokenView = this;
        if (axis == 0) {
            this.checkPainter();
            int end = this.glyphPainter.getBoundedPosition(this, p0, pos, len);
            int breakLoc = this.getBreakLocation(p0, end);
            if (breakLoc != -1) {
                end = breakLoc;
            }
            if ((p0 != this.getStartOffset() || end != this.getEndOffset()) && (brokenView = this.createFragment(p0, end)) instanceof GlyphView) {
                brokenView.tabX = pos;
            }
        }
        return brokenView;
    }

    public int getBreakWeight(int axis, float pos, float len) {
        int weight;
        if (axis == 1) {
            weight = super.getBreakWeight(axis, pos, len);
        } else {
            this.checkPainter();
            int start = this.getStartOffset();
            int end = this.glyphPainter.getBoundedPosition(this, start, pos, len);
            weight = end == 0 ? 0 : (this.getBreakLocation(start, end) != -1 ? 2000 : 1000);
        }
        return weight;
    }

    private int getBreakLocation(int start, int end) {
        int loc = -1;
        Segment s = this.getText(start, end);
        char c = s.last();
        while (c != '\uffff' && loc == -1) {
            if (Character.isWhitespace(c)) {
                loc = s.getIndex() - s.getBeginIndex() + 1 + start;
            }
            c = s.previous();
        }
        return loc;
    }

    public void changedUpdate(DocumentEvent e, Shape a, ViewFactory vf) {
        this.preferenceChanged(null, true, true);
    }

    public void insertUpdate(DocumentEvent e, Shape a, ViewFactory vf) {
        this.preferenceChanged(null, true, false);
    }

    public void removeUpdate(DocumentEvent e, Shape a, ViewFactory vf) {
        this.preferenceChanged(null, true, false);
    }

    public View createFragment(int p0, int p1) {
        this.checkPainter();
        Element el = this.getElement();
        GlyphView fragment = (GlyphView)this.clone();
        fragment.offset = p0 - el.getStartOffset();
        fragment.length = p1 - p0;
        fragment.glyphPainter = this.glyphPainter.getPainter(fragment, p0, p1);
        return fragment;
    }

    public float getAlignment(int axis) {
        float align;
        this.checkPainter();
        if (axis == 1) {
            GlyphPainter painter = this.getGlyphPainter();
            float height = painter.getHeight(this);
            float descent = painter.getDescent(this);
            float ascent = painter.getAscent(this);
            align = this.isSuperscript() ? 1.0f : (this.isSubscript() ? (height > 0.0f ? (height - (descent + ascent / 2.0f)) / height : 0.0f) : (height > 0.0f ? (height - descent) / height : 0.0f));
        } else {
            align = super.getAlignment(axis);
        }
        return align;
    }

    public int getNextVisualPositionFrom(int pos, Position.Bias bias, Shape a, int direction, Position.Bias[] biasRet) throws BadLocationException {
        this.checkPainter();
        GlyphPainter painter = this.getGlyphPainter();
        return painter.getNextVisualPositionFrom(this, pos, bias, a, direction, biasRet);
    }

    static class DefaultGlyphPainter
    extends GlyphPainter {
        FontMetrics fontMetrics;

        DefaultGlyphPainter() {
        }

        public float getHeight(GlyphView view) {
            this.updateFontMetrics(view);
            float height = this.fontMetrics.getHeight();
            return height;
        }

        public void paint(GlyphView view, Graphics g, Shape a, int p0, int p1) {
            this.updateFontMetrics(view);
            Rectangle r = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
            TabExpander tabEx = view.getTabExpander();
            Segment txt = view.getText(p0, p1);
            int x = r.x;
            int p = view.getStartOffset();
            if (p != p0) {
                int width = Utilities.getTabbedTextWidth(txt, this.fontMetrics, x, tabEx, p);
                x += width;
            }
            int y = r.y + this.fontMetrics.getHeight() - this.fontMetrics.getDescent();
            g.setFont(this.fontMetrics.getFont());
            Utilities.drawTabbedText(txt, x, y, g, tabEx, p0);
        }

        public Shape modelToView(GlyphView view, int pos, Position.Bias b, Shape a) throws BadLocationException {
            this.updateFontMetrics(view);
            Element el = view.getElement();
            Segment txt = view.getText(el.getStartOffset(), pos);
            Rectangle bounds = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
            TabExpander expander = view.getTabExpander();
            int width = Utilities.getTabbedTextWidth(txt, this.fontMetrics, bounds.x, expander, view.getStartOffset());
            int height = this.fontMetrics.getHeight();
            Rectangle result = new Rectangle(bounds.x + width, bounds.y, 0, height);
            return result;
        }

        public float getSpan(GlyphView view, int p0, int p1, TabExpander te, float x) {
            this.updateFontMetrics(view);
            Segment txt = view.getText(p0, p1);
            int span = Utilities.getTabbedTextWidth(txt, this.fontMetrics, (int)x, te, p0);
            return span;
        }

        public float getAscent(GlyphView v) {
            this.updateFontMetrics(v);
            return this.fontMetrics.getAscent();
        }

        public float getDescent(GlyphView v) {
            this.updateFontMetrics(v);
            return this.fontMetrics.getDescent();
        }

        public int getBoundedPosition(GlyphView v, int p0, float x, float len) {
            this.updateFontMetrics(v);
            TabExpander te = v.getTabExpander();
            Segment txt = v.getText(p0, v.getEndOffset());
            int pos = Utilities.getTabbedTextOffset(txt, this.fontMetrics, (int)x, (int)(x + len), te, p0, false);
            return pos + p0;
        }

        public int viewToModel(GlyphView v, float x, float y, Shape a, Position.Bias[] biasRet) {
            Rectangle r = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
            int p0 = v.getStartOffset();
            int p1 = v.getEndOffset();
            TabExpander te = v.getTabExpander();
            Segment s = v.getText(p0, p1);
            int offset = Utilities.getTabbedTextOffset(s, this.fontMetrics, r.x, (int)x, te, p0);
            int ret = p0 + offset;
            if (ret == p1) {
                --ret;
            }
            biasRet[0] = Position.Bias.Forward;
            return ret;
        }

        private void updateFontMetrics(GlyphView v) {
            Font font = v.getFont();
            if (this.fontMetrics == null || !font.equals(this.fontMetrics.getFont())) {
                Container c = v.getContainer();
                FontMetrics fm = c != null ? c.getFontMetrics(font) : Toolkit.getDefaultToolkit().getFontMetrics(font);
                this.fontMetrics = fm;
            }
        }
    }

    public static abstract class GlyphPainter {
        public abstract float getAscent(GlyphView var1);

        public abstract float getDescent(GlyphView var1);

        public abstract float getHeight(GlyphView var1);

        public abstract int getBoundedPosition(GlyphView var1, int var2, float var3, float var4);

        public abstract void paint(GlyphView var1, Graphics var2, Shape var3, int var4, int var5);

        public abstract Shape modelToView(GlyphView var1, int var2, Position.Bias var3, Shape var4) throws BadLocationException;

        public abstract int viewToModel(GlyphView var1, float var2, float var3, Shape var4, Position.Bias[] var5);

        public abstract float getSpan(GlyphView var1, int var2, int var3, TabExpander var4, float var5);

        public int getNextVisualPositionFrom(GlyphView v, int pos, Position.Bias b, Shape a, int direction, Position.Bias[] biasRet) throws BadLocationException {
            int result = pos;
            switch (direction) {
                case 3: {
                    result = pos + 1;
                    break;
                }
                case 7: {
                    result = pos - 1;
                    break;
                }
            }
            return result;
        }

        public GlyphPainter getPainter(GlyphView v, int p0, int p1) {
            return this;
        }
    }

    private static class J2DGlyphPainter
    extends GlyphPainter {
        TextLayout textLayout;

        J2DGlyphPainter(String str, Font font, FontRenderContext frc) {
            this.textLayout = new TextLayout(str, font, frc);
        }

        public GlyphPainter getPainter(GlyphView v, int p0, int p1) {
            return null;
        }

        public float getAscent(GlyphView v) {
            return this.textLayout.getAscent();
        }

        public int getBoundedPosition(GlyphView v, int p0, float x, float len) {
            int pos;
            TextHitInfo hit = this.textLayout.hitTestChar(len, 0.0f);
            if (hit.getCharIndex() == -1 && !this.textLayout.isLeftToRight()) {
                pos = v.getEndOffset();
            } else {
                pos = hit.isLeadingEdge() ? hit.getInsertionIndex() : hit.getInsertionIndex() - 1;
                pos += v.getStartOffset();
            }
            return pos;
        }

        public float getDescent(GlyphView v) {
            return this.textLayout.getDescent();
        }

        public float getHeight(GlyphView view) {
            return this.textLayout.getAscent() + this.textLayout.getDescent() + this.textLayout.getLeading();
        }

        public float getSpan(GlyphView v, int p0, int p1, TabExpander te, float x) {
            float span;
            if (p0 == v.getStartOffset() && p1 == v.getEndOffset()) {
                span = this.textLayout.getAdvance();
            } else {
                int start = v.getStartOffset();
                int i0 = p0 - start;
                int i1 = p1 - start;
                TextHitInfo hit0 = TextHitInfo.afterOffset(i0);
                TextHitInfo hit1 = TextHitInfo.afterOffset(i1);
                float x0 = this.textLayout.getCaretInfo(hit0)[0];
                float x1 = this.textLayout.getCaretInfo(hit1)[0];
                span = Math.abs(x1 - x0);
            }
            return span;
        }

        public Shape modelToView(GlyphView v, int pos, Position.Bias b, Shape a) throws BadLocationException {
            int offs = pos - v.getStartOffset();
            Rectangle2D bounds = a.getBounds2D();
            TextHitInfo hit = b == Position.Bias.Forward ? TextHitInfo.afterOffset(offs) : TextHitInfo.beforeOffset(offs);
            float[] loc = this.textLayout.getCaretInfo(hit);
            bounds.setRect(bounds.getX() + (double)loc[0], bounds.getY(), 1.0, bounds.getHeight());
            return bounds;
        }

        public void paint(GlyphView view, Graphics g, Shape a, int p0, int p1) {
            if (g instanceof Graphics2D) {
                Graphics2D g2d = (Graphics2D)g;
                Rectangle2D b = a instanceof Rectangle2D ? (Rectangle2D)a : a.getBounds2D();
                float x = (float)b.getX();
                float y = (float)b.getY() + this.textLayout.getAscent() + this.textLayout.getLeading();
                this.textLayout.draw(g2d, x, y);
            }
        }

        public int viewToModel(GlyphView v, float x, float y, Shape a, Position.Bias[] biasRet) {
            Rectangle2D bounds = a instanceof Rectangle2D ? (Rectangle2D)a : a.getBounds2D();
            TextHitInfo hit = this.textLayout.hitTestChar(x - (float)bounds.getX(), 0.0f);
            int pos = hit.getInsertionIndex();
            biasRet[0] = hit.isLeadingEdge() ? Position.Bias.Forward : Position.Bias.Backward;
            return pos + v.getStartOffset();
        }
    }
}

