/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.metal.MetalUtils;

public class MetalButtonUI
extends BasicButtonUI {
    private static MetalButtonUI sharedUI;
    protected Color focusColor;
    protected Color selectColor;
    protected Color disabledTextColor;

    public static ComponentUI createUI(JComponent c) {
        if (sharedUI == null) {
            sharedUI = new MetalButtonUI();
        }
        return sharedUI;
    }

    protected Color getFocusColor() {
        this.focusColor = UIManager.getColor(String.valueOf(this.getPropertyPrefix()) + "focus");
        return this.focusColor;
    }

    protected Color getSelectColor() {
        this.selectColor = UIManager.getColor(String.valueOf(this.getPropertyPrefix()) + "select");
        return this.selectColor;
    }

    protected Color getDisabledTextColor() {
        this.disabledTextColor = UIManager.getColor(String.valueOf(this.getPropertyPrefix()) + "disabledText");
        return this.disabledTextColor;
    }

    public void installDefaults(AbstractButton button) {
        super.installDefaults(button);
    }

    public void uninstallDefaults(AbstractButton button) {
        super.uninstallDefaults(button);
    }

    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        if (b.isContentAreaFilled()) {
            g.setColor(this.getSelectColor());
            g.fillRect(0, 0, b.getWidth(), b.getHeight());
        }
    }

    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        if (b.isEnabled() && b.hasFocus() && b.isFocusPainted()) {
            Color savedColor = g.getColor();
            g.setColor(this.getFocusColor());
            Rectangle focusRect = iconRect.union(textRect);
            g.drawRect(focusRect.x - 1, focusRect.y, focusRect.width + 1, focusRect.height);
            g.setColor(savedColor);
        }
    }

    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        AbstractButton b = (AbstractButton)c;
        Font f = b.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics(f);
        if (b.isEnabled()) {
            g.setColor(b.getForeground());
            g.drawString(text, textRect.x, textRect.y + fm.getAscent());
        } else {
            g.setColor(this.getDisabledTextColor());
            g.drawString(text, textRect.x, textRect.y + fm.getAscent());
        }
    }

    public void update(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        if (b.getBackground() instanceof UIResource && b.isContentAreaFilled() && b.isEnabled()) {
            ButtonModel m = b.getModel();
            String uiKey = "Button.gradient";
            if (!this.isToolbarButton(b)) {
                if (!m.isArmed() && !m.isPressed() && this.isDrawingGradient(uiKey)) {
                    MetalUtils.paintGradient(g, 0, 0, b.getWidth(), b.getHeight(), 1, uiKey);
                    this.paint(g, c);
                    return;
                }
            } else if (m.isRollover() && this.isDrawingGradient(uiKey)) {
                MetalUtils.paintGradient(g, 0, 0, b.getWidth(), b.getHeight(), 1, uiKey);
                this.paint(g, c);
                return;
            }
        }
        super.update(g, c);
    }

    private boolean isToolbarButton(Component b) {
        Container parent = b.getParent();
        return parent instanceof JToolBar;
    }

    private boolean isDrawingGradient(String uiKey) {
        return UIManager.get(uiKey) != null;
    }
}

