/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.MemoryImageSource;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class DefaultHSBChooserPanel
extends AbstractColorChooserPanel {
    transient Image gradientImage;
    private transient JPanel gradientPanel;
    transient Image trackImage;
    private transient JPanel trackPanel;
    transient JSlider slider;
    transient JRadioButton hRadio;
    transient JRadioButton sRadio;
    transient JRadioButton bRadio;
    transient JSpinner hSpinner;
    transient JSpinner sSpinner;
    transient JSpinner bSpinner;
    private static final int imgWidth = 200;
    private static final int imgHeight = 200;
    private static final int trackWidth = 30;
    private static final JLabel R = new JLabel("R");
    private static final JLabel G = new JLabel("G");
    private static final JLabel B = new JLabel("B");
    private transient JLabel rFull;
    private transient JLabel gFull;
    private transient JLabel bFull;
    transient Point gradientPoint = new Point();
    transient boolean internalChange = false;
    transient boolean spinnerTrigger = false;
    transient int locked = -1;
    static final int HLOCKED = 0;
    static final int SLOCKED = 1;
    static final int BLOCKED = 2;
    transient boolean handlingMouse;

    DefaultHSBChooserPanel() {
    }

    public String getDisplayName() {
        return "HSB";
    }

    public void updateChooser() {
        Color c = this.getColorSelectionModel().getSelectedColor();
        float[] hsbVals = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        this.internalChange = true;
        if (!this.spinnerTrigger) {
            this.hSpinner.setValue(new Integer((int)(hsbVals[0] * 360.0f)));
            this.sSpinner.setValue(new Integer((int)(hsbVals[1] * 100.0f)));
            this.bSpinner.setValue(new Integer((int)(hsbVals[2] * 100.0f)));
        }
        switch (this.locked) {
            case 0: {
                if (this.slider != null) {
                    this.slider.setValue(((Number)this.hSpinner.getValue()).intValue());
                }
                if (this.handlingMouse) break;
                this.gradientPoint.x = (int)((1.0f - (float)((Number)this.sSpinner.getValue()).intValue() / 100.0f) * 200.0f);
                this.gradientPoint.y = (int)((1.0f - (float)((Number)this.bSpinner.getValue()).intValue() / 100.0f) * 200.0f);
                break;
            }
            case 1: {
                if (this.slider != null) {
                    this.slider.setValue(((Number)this.sSpinner.getValue()).intValue());
                }
                if (this.handlingMouse) break;
                this.gradientPoint.x = (int)((float)((Number)this.hSpinner.getValue()).intValue() / 360.0f * 200.0f);
                this.gradientPoint.y = (int)((1.0f - (float)((Number)this.bSpinner.getValue()).intValue() / 100.0f) * 200.0f);
                break;
            }
            case 2: {
                if (this.slider != null) {
                    this.slider.setValue(((Number)this.bSpinner.getValue()).intValue());
                }
                if (this.handlingMouse) break;
                this.gradientPoint.x = (int)((float)((Number)this.hSpinner.getValue()).intValue() / 360.0f * 200.0f);
                this.gradientPoint.y = (int)((1.0f - (float)((Number)this.sSpinner.getValue()).intValue() / 100.0f) * 200.0f);
            }
        }
        this.internalChange = false;
        if (!this.handlingMouse && this.slider != null && !this.slider.getValueIsAdjusting()) {
            this.updateImage();
        }
        if (!this.handlingMouse || this.locked != 0) {
            this.updateTrack();
        }
        this.updateTextFields();
    }

    protected void buildChooser() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.buildRightPanel(), "East");
        JPanel container = new JPanel();
        container.setLayout(new BorderLayout());
        this.gradientPanel = new JPanel(){

            public Dimension getPreferredSize() {
                return new Dimension(200, 200);
            }

            public void paint(Graphics g) {
                if (DefaultHSBChooserPanel.this.gradientImage != null) {
                    g.drawImage(DefaultHSBChooserPanel.this.gradientImage, 0, 0, this);
                }
                Color saved = g.getColor();
                g.setColor(Color.WHITE);
                g.drawOval(DefaultHSBChooserPanel.this.gradientPoint.x - 3, DefaultHSBChooserPanel.this.gradientPoint.y - 3, 6, 6);
                g.setColor(saved);
            }
        };
        MainGradientMouseListener ml = new MainGradientMouseListener();
        this.gradientPanel.addMouseListener(ml);
        this.gradientPanel.addMouseMotionListener(ml);
        this.trackPanel = new JPanel(){

            public Dimension getPreferredSize() {
                return new Dimension(30, 200);
            }

            public void paint(Graphics g) {
                if (DefaultHSBChooserPanel.this.trackImage != null) {
                    g.drawImage(DefaultHSBChooserPanel.this.trackImage, 0, 0, this);
                }
            }
        };
        this.slider = new JSlider();
        this.slider.setPaintTrack(false);
        this.slider.setPaintTicks(false);
        this.slider.setOrientation(1);
        this.updateSlider();
        container.add((Component)this.gradientPanel, "West");
        container.add((Component)this.slider, "Center");
        container.add((Component)this.trackPanel, "East");
        this.add((Component)container, "West");
        this.slider.addChangeListener(new SliderChangeListener());
        this.repaint();
    }

    public void uninstallChooserPanel(JColorChooser chooser) {
        this.trackImage = null;
        this.gradientImage = null;
        this.gradientPanel = null;
        this.slider = null;
        this.hSpinner = null;
        this.sSpinner = null;
        this.bSpinner = null;
        this.hRadio = null;
        this.sRadio = null;
        this.bRadio = null;
        this.removeAll();
        super.uninstallChooserPanel(chooser);
    }

    private Container buildRightPanel() {
        JPanel container = new JPanel();
        container.setLayout(new GridLayout(6, 2));
        this.hRadio = new JRadioButton("H");
        this.sRadio = new JRadioButton("S");
        this.bRadio = new JRadioButton("B");
        ButtonGroup group = new ButtonGroup();
        group.add(this.hRadio);
        group.add(this.sRadio);
        group.add(this.bRadio);
        this.hSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 359, 1));
        this.sSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 100, 1));
        this.bSpinner = new JSpinner(new SpinnerNumberModel(100, 0, 100, 1));
        this.hSpinner.setEnabled(false);
        this.sSpinner.setEnabled(false);
        this.bSpinner.setEnabled(false);
        RadioStateListener cl = new RadioStateListener();
        ImageScrollListener scroll = new ImageScrollListener();
        this.hRadio.addChangeListener(cl);
        this.sRadio.addChangeListener(cl);
        this.bRadio.addChangeListener(cl);
        this.hSpinner.addChangeListener(scroll);
        this.sSpinner.addChangeListener(scroll);
        this.bSpinner.addChangeListener(scroll);
        this.hRadio.setSelected(true);
        container.add(this.hRadio);
        container.add(this.hSpinner);
        container.add(this.sRadio);
        container.add(this.sSpinner);
        container.add(this.bRadio);
        container.add(this.bSpinner);
        this.rFull = new JLabel("red full");
        this.gFull = new JLabel("green full");
        this.bFull = new JLabel("blue full");
        container.add(R);
        container.add(this.rFull);
        container.add(G);
        container.add(this.gFull);
        container.add(B);
        container.add(this.bFull);
        return container;
    }

    public Icon getSmallDisplayIcon() {
        return null;
    }

    public Icon getLargeDisplayIcon() {
        return null;
    }

    public void paint(Graphics g) {
        super.paint(g);
    }

    private void updateHLockImage() {
        int index = 0;
        int[] pix = new int[40000];
        float hValue = (float)((Number)this.hSpinner.getValue()).intValue() / 360.0f;
        int j = 0;
        while (j < 200) {
            int i = 0;
            while (i < 200) {
                pix[index++] = Color.HSBtoRGB(hValue, (200.0f - (float)i * 1.0f) / 200.0f, (200.0f - (float)j * 1.0f) / 200.0f) | 0xFF000000;
                ++i;
            }
            ++j;
        }
        this.gradientImage = this.createImage(new MemoryImageSource(200, 200, pix, 0, 200));
    }

    private void updateBLockImage() {
        int[] pix = new int[40000];
        float bValue = (float)((Number)this.bSpinner.getValue()).intValue() / 100.0f;
        int index = 0;
        int j = 0;
        while (j < 200) {
            int i = 0;
            while (i < 200) {
                pix[index++] = Color.HSBtoRGB((float)i * 1.0f / 200.0f, (200.0f - (float)j * 1.0f) / 200.0f, bValue) | 0xFF000000;
                ++i;
            }
            ++j;
        }
        this.gradientImage = this.createImage(new MemoryImageSource(200, 200, pix, 0, 200));
    }

    private void updateSLockImage() {
        int[] pix = new int[40000];
        float sValue = (float)((Number)this.sSpinner.getValue()).intValue() / 100.0f;
        int index = 0;
        int j = 0;
        while (j < 200) {
            int i = 0;
            while (i < 200) {
                pix[index++] = Color.HSBtoRGB((float)i * 1.0f / 200.0f, sValue, (200.0f - (float)j * 1.0f) / 200.0f) | 0xFF000000;
                ++i;
            }
            ++j;
        }
        this.gradientImage = this.createImage(new MemoryImageSource(200, 200, pix, 0, 200));
    }

    void updateImage() {
        switch (this.locked) {
            case 0: {
                this.updateHLockImage();
                break;
            }
            case 1: {
                this.updateSLockImage();
                break;
            }
            case 2: {
                this.updateBLockImage();
            }
        }
    }

    private void updateTextFields() {
        int c = this.getColorSelectionModel().getSelectedColor().getRGB();
        this.rFull.setText("" + (c >> 16 & 0xFF));
        this.gFull.setText("" + (c >> 8 & 0xFF));
        this.bFull.setText("" + (c & 0xFF));
        this.repaint();
    }

    void updateSlider() {
        if (this.slider == null) {
            return;
        }
        this.slider.setMinimum(0);
        if (this.locked == 0) {
            this.slider.setMaximum(359);
            this.slider.setValue(((Number)this.hSpinner.getValue()).intValue());
            this.slider.setInverted(true);
        } else {
            this.slider.setMaximum(100);
            this.slider.setInverted(false);
            if (this.sRadio.isSelected()) {
                this.slider.setValue(((Number)this.sSpinner.getValue()).intValue());
            } else {
                this.slider.setValue(((Number)this.bSpinner.getValue()).intValue());
            }
        }
        this.repaint();
    }

    void updateTrack() {
        switch (this.locked) {
            case 0: {
                this.updateHTrack();
                break;
            }
            case 1: {
                this.updateSTrack();
                break;
            }
            case 2: {
                this.updateBTrack();
            }
        }
    }

    private void updateHTrack() {
        int trackIndex = 0;
        int[] trackPix = new int[6000];
        int j = 0;
        while (j < 200) {
            int i = 0;
            while (i < 30) {
                trackPix[trackIndex++] = Color.HSBtoRGB((float)j * 1.0f / 200.0f, 1.0f, 1.0f) | 0xFF000000;
                ++i;
            }
            ++j;
        }
        this.trackImage = this.createImage(new MemoryImageSource(30, 200, trackPix, 0, 30));
    }

    private void updateSTrack() {
        int[] trackPix = new int[6000];
        float hValue = (float)((Number)this.hSpinner.getValue()).intValue() / 360.0f;
        float bValue = (float)((Number)this.bSpinner.getValue()).intValue() / 100.0f;
        int trackIndex = 0;
        int j = 0;
        while (j < 200) {
            int i = 0;
            while (i < 30) {
                trackPix[trackIndex++] = Color.HSBtoRGB(hValue, (200.0f - (float)j * 1.0f) / 200.0f, bValue) | 0xFF000000;
                ++i;
            }
            ++j;
        }
        this.trackImage = this.createImage(new MemoryImageSource(30, 200, trackPix, 0, 30));
    }

    private void updateBTrack() {
        int[] trackPix = new int[6000];
        float hValue = (float)((Number)this.hSpinner.getValue()).intValue() / 360.0f;
        float sValue = (float)((Number)this.sSpinner.getValue()).intValue() / 100.0f;
        int trackIndex = 0;
        int j = 0;
        while (j < 200) {
            int i = 0;
            while (i < 30) {
                trackPix[trackIndex++] = Color.HSBtoRGB(hValue, sValue, (200.0f - (float)j * 1.0f) / 200.0f) | 0xFF000000;
                ++i;
            }
            ++j;
        }
        this.trackImage = this.createImage(new MemoryImageSource(30, 200, trackPix, 0, 30));
    }

    private float[] getHSBValues() {
        Color c = this.getColorFromModel();
        float[] f = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        return f;
    }

    class ImageScrollListener
    implements ChangeListener {
        ImageScrollListener() {
        }

        public void stateChanged(ChangeEvent e) {
            if (DefaultHSBChooserPanel.this.internalChange) {
                return;
            }
            float h = (float)((Number)DefaultHSBChooserPanel.this.hSpinner.getValue()).intValue() / 360.0f;
            float s = (float)((Number)DefaultHSBChooserPanel.this.sSpinner.getValue()).intValue() / 100.0f;
            float b = (float)((Number)DefaultHSBChooserPanel.this.bSpinner.getValue()).intValue() / 100.0f;
            DefaultHSBChooserPanel.this.spinnerTrigger = true;
            DefaultHSBChooserPanel.this.getColorSelectionModel().setSelectedColor(new Color(Color.HSBtoRGB(h, s, b)));
            DefaultHSBChooserPanel.this.spinnerTrigger = false;
            if (!DefaultHSBChooserPanel.this.handlingMouse && DefaultHSBChooserPanel.this.slider != null && !DefaultHSBChooserPanel.this.slider.getValueIsAdjusting()) {
                DefaultHSBChooserPanel.this.updateImage();
                DefaultHSBChooserPanel.this.updateTrack();
            }
            DefaultHSBChooserPanel.this.repaint();
        }
    }

    class MainGradientMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        MainGradientMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            DefaultHSBChooserPanel.this.gradientPoint = e.getPoint();
            this.update(e.getPoint());
        }

        public void mouseDragged(MouseEvent e) {
            Point p = e.getPoint();
            if (p.x < 0 || p.y < 0 || p.y > 200 || p.x > 200) {
                return;
            }
            DefaultHSBChooserPanel.this.gradientPoint = p;
            this.update(p);
        }

        public void mouseMoved(MouseEvent e) {
        }

        private void update(Point p) {
            DefaultHSBChooserPanel.this.handlingMouse = true;
            if (DefaultHSBChooserPanel.this.hSpinner.isEnabled()) {
                this.updateH(p);
            } else if (DefaultHSBChooserPanel.this.sSpinner.isEnabled()) {
                this.updateS(p);
            } else {
                this.updateB(p);
            }
            DefaultHSBChooserPanel.this.handlingMouse = false;
        }

        private void updateH(Point p) {
            float s = (200.0f - (float)p.x * 1.0f) / 200.0f;
            float b = (200.0f - (float)p.y * 1.0f) / 200.0f;
            DefaultHSBChooserPanel.this.internalChange = true;
            DefaultHSBChooserPanel.this.sSpinner.setValue(new Integer((int)(s * 100.0f)));
            DefaultHSBChooserPanel.this.internalChange = false;
            DefaultHSBChooserPanel.this.bSpinner.setValue(new Integer((int)(b * 100.0f)));
            DefaultHSBChooserPanel.this.revalidate();
        }

        private void updateS(Point p) {
            float h = (float)p.x * 1.0f / 200.0f;
            float b = (200.0f - (float)p.y * 1.0f) / 200.0f;
            DefaultHSBChooserPanel.this.internalChange = true;
            DefaultHSBChooserPanel.this.hSpinner.setValue(new Integer((int)(h * 365.0f)));
            DefaultHSBChooserPanel.this.internalChange = false;
            DefaultHSBChooserPanel.this.bSpinner.setValue(new Integer((int)(b * 100.0f)));
            DefaultHSBChooserPanel.this.revalidate();
        }

        private void updateB(Point p) {
            float h = (float)p.x * 1.0f / 200.0f;
            float s = (200.0f - (float)p.y * 1.0f) / 200.0f;
            DefaultHSBChooserPanel.this.internalChange = true;
            DefaultHSBChooserPanel.this.hSpinner.setValue(new Integer((int)(h * 365.0f)));
            DefaultHSBChooserPanel.this.internalChange = false;
            DefaultHSBChooserPanel.this.sSpinner.setValue(new Integer((int)(s * 100.0f)));
            DefaultHSBChooserPanel.this.revalidate();
        }
    }

    class RadioStateListener
    implements ChangeListener {
        RadioStateListener() {
        }

        public void stateChanged(ChangeEvent e) {
            JSpinner change;
            if (e.getSource() == DefaultHSBChooserPanel.this.hRadio) {
                DefaultHSBChooserPanel.this.locked = 0;
                change = DefaultHSBChooserPanel.this.hSpinner;
            } else if (e.getSource() == DefaultHSBChooserPanel.this.sRadio) {
                DefaultHSBChooserPanel.this.locked = 1;
                change = DefaultHSBChooserPanel.this.sSpinner;
            } else {
                DefaultHSBChooserPanel.this.locked = 2;
                change = DefaultHSBChooserPanel.this.bSpinner;
            }
            change.setEnabled(((AbstractButton)e.getSource()).isSelected());
            DefaultHSBChooserPanel.this.updateSlider();
            DefaultHSBChooserPanel.this.updateTrack();
            DefaultHSBChooserPanel.this.updateImage();
            DefaultHSBChooserPanel.this.repaint();
        }
    }

    class SliderChangeListener
    implements ChangeListener {
        SliderChangeListener() {
        }

        public void stateChanged(ChangeEvent e) {
            if (DefaultHSBChooserPanel.this.internalChange) {
                return;
            }
            Integer value = new Integer(DefaultHSBChooserPanel.this.slider.getValue());
            switch (DefaultHSBChooserPanel.this.locked) {
                case 0: {
                    DefaultHSBChooserPanel.this.hSpinner.setValue(value);
                    break;
                }
                case 1: {
                    DefaultHSBChooserPanel.this.sSpinner.setValue(value);
                    break;
                }
                case 2: {
                    DefaultHSBChooserPanel.this.bSpinner.setValue(value);
                }
            }
        }
    }
}

