/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EventListener;
import javax.swing.BoundedRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBoundedRangeModel
implements BoundedRangeModel,
Serializable {
    private static final long serialVersionUID = 5034068491295259790L;
    protected transient ChangeEvent changeEvent;
    protected EventListenerList listenerList = new EventListenerList();
    private int value;
    private int extent;
    private int minimum;
    private int maximum;
    private boolean isAdjusting;

    public DefaultBoundedRangeModel() {
        this.maximum = 100;
    }

    public DefaultBoundedRangeModel(int value, int extent, int minimum, int maximum) {
        if (minimum > value || extent < 0 || value + extent > maximum) {
            throw new IllegalArgumentException();
        }
        this.value = value;
        this.extent = extent;
        this.minimum = minimum;
        this.maximum = maximum;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[value=" + this.value + ", extent=" + this.extent + ", min=" + this.minimum + ", max=" + this.maximum + ", adj=" + this.isAdjusting + ']';
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public void setValue(int value) {
        if ((value = Math.max(this.minimum, value)) + this.extent > this.maximum) {
            value = this.maximum - this.extent;
        }
        if (value != this.value) {
            this.value = value;
            this.fireStateChanged();
        }
    }

    @Override
    public int getExtent() {
        return this.extent;
    }

    @Override
    public void setExtent(int extent) {
        if (this.value + (extent = Math.max(extent, 0)) > this.maximum) {
            extent = this.maximum - this.value;
        }
        if (extent != this.extent) {
            this.extent = extent;
            this.fireStateChanged();
        }
    }

    @Override
    public int getMinimum() {
        return this.minimum;
    }

    @Override
    public void setMinimum(int minimum) {
        int maximum = Math.max(minimum, this.maximum);
        int value = Math.max(minimum, this.value);
        this.setRangeProperties(value, this.extent, minimum, maximum, this.isAdjusting);
    }

    @Override
    public int getMaximum() {
        return this.maximum;
    }

    @Override
    public void setMaximum(int maximum) {
        int minimum = Math.min(this.minimum, maximum);
        int extent = Math.min(this.extent, maximum - minimum);
        int value = Math.min(this.value, maximum - extent);
        this.setRangeProperties(value, extent, minimum, maximum, this.isAdjusting);
    }

    @Override
    public boolean getValueIsAdjusting() {
        return this.isAdjusting;
    }

    @Override
    public void setValueIsAdjusting(boolean isAdjusting) {
        if (isAdjusting == this.isAdjusting) {
            return;
        }
        this.isAdjusting = isAdjusting;
        this.fireStateChanged();
    }

    @Override
    public void setRangeProperties(int value, int extent, int minimum, int maximum, boolean isAdjusting) {
        minimum = Math.min(Math.min(minimum, maximum), value);
        if (extent + value > (maximum = Math.max(value, maximum))) {
            extent = maximum - value;
        }
        extent = Math.max(0, extent);
        if (value == this.value && extent == this.extent && minimum == this.minimum && maximum == this.maximum && isAdjusting == this.isAdjusting) {
            return;
        }
        this.value = value;
        this.extent = extent;
        this.minimum = minimum;
        this.maximum = maximum;
        this.isAdjusting = isAdjusting;
        this.fireStateChanged();
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(ChangeListener.class, listener);
    }

    protected void fireStateChanged() {
        ChangeListener[] listeners = this.getChangeListeners();
        if (this.changeEvent == null) {
            this.changeEvent = new ChangeEvent(this);
        }
        int i = listeners.length - 1;
        while (i >= 0) {
            listeners[i].stateChanged(this.changeEvent);
            --i;
        }
    }

    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        return this.listenerList.getListeners(listenerType);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.getListeners(ChangeListener.class);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        stream.defaultReadObject();
        this.listenerList = new EventListenerList();
    }
}

