/*
 * Decompiled with CFR 0.152.
 */
package javax.print.attribute.standard;

import javax.print.attribute.Attribute;
import javax.print.attribute.DocAttribute;
import javax.print.attribute.PrintJobAttribute;
import javax.print.attribute.PrintRequestAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MediaPrintableArea
implements DocAttribute,
PrintJobAttribute,
PrintRequestAttribute {
    private static final long serialVersionUID = -1597171464050795793L;
    public static final int INCH = 25400;
    public static final int MM = 1000;
    private int x;
    private int y;
    private int w;
    private int h;

    public MediaPrintableArea(float x, float y, float w, float h, int units) {
        if (x < 0.0f || y < 0.0f || w <= 0.0f || h <= 0.0f) {
            throw new IllegalArgumentException();
        }
        this.x = (int)(x * (float)units + 0.5f);
        this.y = (int)(y * (float)units + 0.5f);
        this.w = (int)(w * (float)units + 0.5f);
        this.h = (int)(h * (float)units + 0.5f);
    }

    public MediaPrintableArea(int x, int y, int w, int h, int units) {
        if (x < 0 || y < 0 || w <= 0 || h <= 0) {
            throw new IllegalArgumentException();
        }
        this.x = x * units;
        this.y = y * units;
        this.w = w * units;
        this.h = h * units;
    }

    @Override
    public Class<? extends Attribute> getCategory() {
        return MediaPrintableArea.class;
    }

    @Override
    public String getName() {
        return "media-printable-area";
    }

    public float getHeight(int units) {
        if (units < 1) {
            throw new IllegalArgumentException("units may not be less than 1");
        }
        return (float)this.h / (float)units;
    }

    public float getWidth(int units) {
        if (units < 1) {
            throw new IllegalArgumentException("units may not be less than 1");
        }
        return (float)this.w / (float)units;
    }

    public float getX(int units) {
        if (units < 1) {
            throw new IllegalArgumentException("units may not be less than 1");
        }
        return (float)this.x / (float)units;
    }

    public float getY(int units) {
        if (units < 1) {
            throw new IllegalArgumentException("units may not be less than 1");
        }
        return (float)this.y / (float)units;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MediaPrintableArea)) {
            return false;
        }
        MediaPrintableArea tmp = (MediaPrintableArea)obj;
        return (float)this.x == tmp.getX(1) && (float)this.y == tmp.getY(1) && (float)this.w == tmp.getWidth(1) && (float)this.h == tmp.getHeight(1);
    }

    public String toString() {
        return this.toString(1000, "mm");
    }

    public int hashCode() {
        return this.x ^ this.y + this.w ^ this.h;
    }

    public String toString(int units, String unitsName) {
        if (units < 1) {
            throw new IllegalArgumentException("units may not be less than 1");
        }
        String tmp = "(" + this.getX(units) + "," + this.getY(units) + ")->(" + this.getWidth(units) + "," + this.getHeight(units) + ")";
        return unitsName == null ? tmp : String.valueOf(tmp) + unitsName;
    }

    public float[] getPrintableArea(int units) {
        return new float[]{this.getX(units), this.getY(units), this.getWidth(units), this.getHeight(units)};
    }
}

