/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import gnu.classpath.SystemProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.JMRuntimeException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerBuilder;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerPermission;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBeanServerFactory {
    private static MBeanServerBuilder builder;
    private static final Map<Object, MBeanServer> servers;

    static {
        servers = new HashMap<Object, MBeanServer>();
    }

    private MBeanServerFactory() {
    }

    public static MBeanServer createMBeanServer() {
        return MBeanServerFactory.createMBeanServer(null);
    }

    public static MBeanServer createMBeanServer(String domain) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new MBeanServerPermission("createMBeanServer"));
        }
        MBeanServer server = MBeanServerFactory.createServer(domain);
        try {
            ObjectName dn = new ObjectName("JMImplementation:type=MBeanServerDelegate");
            servers.put(server.getAttribute(dn, "MBeanServerId"), server);
        }
        catch (MalformedObjectNameException e) {
            throw (Error)new InternalError("Malformed delegate bean name.").initCause(e);
        }
        catch (MBeanException e) {
            throw (Error)new InternalError("Exception in getMBeanServerId().").initCause(e);
        }
        catch (AttributeNotFoundException e) {
            throw (Error)new InternalError("Could not find MBeanServerId attribute.").initCause(e);
        }
        catch (InstanceNotFoundException e) {
            throw (Error)new InternalError("Could not find the delegate bean.").initCause(e);
        }
        catch (ReflectionException e) {
            throw (Error)new InternalError("Could not call getMBeanServerId().").initCause(e);
        }
        return server;
    }

    public static ArrayList<MBeanServer> findMBeanServer(String id) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new MBeanServerPermission("findMBeanServer"));
        }
        if (id == null) {
            return new ArrayList<MBeanServer>(servers.values());
        }
        ArrayList<MBeanServer> list2 = new ArrayList<MBeanServer>();
        MBeanServer server = servers.get(id);
        if (server != null) {
            list2.add(servers.get(id));
        }
        return list2;
    }

    public static ClassLoaderRepository getClassLoaderRepository(MBeanServer server) {
        return server.getClassLoaderRepository();
    }

    public static MBeanServer newMBeanServer() {
        return MBeanServerFactory.newMBeanServer(null);
    }

    public static MBeanServer newMBeanServer(String domain) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new MBeanServerPermission("newMBeanServer"));
        }
        return MBeanServerFactory.createServer(domain);
    }

    private static MBeanServer createServer(String domain) {
        MBeanServerDelegate delegate;
        String builderClass;
        if (domain == null) {
            domain = "DefaultDomain";
        }
        if ((builderClass = SystemProperties.getProperty("javax.management.builder.initial")) == null) {
            if (builder == null || builder.getClass() != MBeanServerBuilder.class) {
                builder = new MBeanServerBuilder();
            }
        } else if (builder == null || !builderClass.equals(builder.getClass().getName())) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = MBeanServerFactory.class.getClassLoader();
            }
            try {
                Class<?> bClass = Class.forName(builderClass, true, cl);
                builder = (MBeanServerBuilder)bClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw (JMRuntimeException)new JMRuntimeException("The builder class, " + builderClass + ", could not be found.").initCause(e);
            }
            catch (InstantiationException e) {
                throw (JMRuntimeException)new JMRuntimeException("The builder class, " + builderClass + ", could not be instantiated.").initCause(e);
            }
            catch (IllegalAccessException e) {
                throw (JMRuntimeException)new JMRuntimeException("The builder class, " + builderClass + ", could not be accessed.").initCause(e);
            }
        }
        if ((delegate = builder.newMBeanServerDelegate()) == null) {
            throw new JMRuntimeException("A delegate could not be created.");
        }
        MBeanServer server = builder.newMBeanServer(domain, null, delegate);
        if (server == null) {
            throw new JMRuntimeException("A server could not be created.");
        }
        return server;
    }

    public static void releaseMBeanServer(MBeanServer server) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new MBeanServerPermission("releaseMBeanServer"));
        }
        Iterator<MBeanServer> i = servers.values().iterator();
        while (i.hasNext()) {
            MBeanServer s = i.next();
            if (server != s) continue;
            i.remove();
            return;
        }
        throw new IllegalArgumentException("The server given is not referenced.");
    }
}

