/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.OutputStream;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;
import javax.activation.UnsupportedDataTypeException;

class ObjectDataContentHandler
implements DataContentHandler {
    private DataContentHandler dch;
    private Object object;
    private String mimeType;
    private DataFlavor[] flavors;

    public ObjectDataContentHandler(DataContentHandler dch, Object object, String mimeType) {
        this.dch = dch;
        this.object = object;
        this.mimeType = mimeType;
    }

    public Object getContent(DataSource ds) {
        return this.object;
    }

    public DataContentHandler getDCH() {
        return this.dch;
    }

    public Object getTransferData(DataFlavor flavor, DataSource ds) throws UnsupportedFlavorException, IOException {
        if (this.dch != null) {
            return this.dch.getTransferData(flavor, ds);
        }
        if (this.flavors == null) {
            this.getTransferDataFlavors();
        }
        if (flavor.equals(this.flavors[0])) {
            return this.object;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        if (this.flavors == null) {
            if (this.dch != null) {
                this.flavors = this.dch.getTransferDataFlavors();
            } else {
                this.flavors = new DataFlavor[1];
                this.flavors[0] = new ActivationDataFlavor(this.object.getClass(), this.mimeType, this.mimeType);
            }
        }
        return this.flavors;
    }

    public void writeTo(Object object, String mimeType, OutputStream out) throws IOException {
        if (this.dch == null) {
            throw new UnsupportedDataTypeException("no object DCH for MIME type " + mimeType);
        }
        this.dch.writeTo(object, mimeType, out);
    }
}

